/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.importtool.ImportCellRenderer;
import com.mathworks.mlwidgets.importtool.TextTable;
import com.mathworks.util.LanguageUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;

public class TextCellRenderer
extends ImportCellRenderer {
    private Font fDefaultFont;
    private boolean fFixedWidth = false;
    private static Color HOVER_SPLITTER_HIGHLIGHT_COLOR;
    protected int fHoverSplitterColumn = -1;
    private String fFixedWidthCompareCharacter = "_";
    private static boolean sIsCJK;
    private boolean fHalfWidthFont = false;
    private boolean fHasHalfWidthChars = false;
    private boolean fHasFullWidthChars = false;
    private boolean fHasMixedWidthChars = false;
    private static final Map<Character, Character> sHalfToFullCharMap;

    public TextCellRenderer() {
        if (Matlab.isMatlabAvailable()) {
            TextCellRenderer.createFormats();
        }
        this.fDefaultFont = this.getFont();
    }

    private static boolean isHalfWidth(char c) {
        return sHalfToFullCharMap.containsKey(Character.valueOf(c));
    }

    private static char getFullWidthCharacter(char c) {
        if (TextCellRenderer.isHalfWidth(c)) {
            return sHalfToFullCharMap.get(Character.valueOf(c)).charValue();
        }
        return c;
    }

    private static void setIsCJK(boolean bl) {
        sIsCJK = bl;
    }

    String getDisplayedText(Object object) {
        String string;
        String string2 = string = object != null ? object.toString() : "";
        if (sIsCJK && this.fFixedWidth && this.fHalfWidthFont && this.fHasMixedWidthChars) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (!TextCellRenderer.isHalfWidth(c)) continue;
                char c2 = TextCellRenderer.getFullWidthCharacter(c);
                string = string.replace(c, c2);
            }
        }
        return string;
    }

    public boolean hasHalfWidthChars() {
        return this.fHasHalfWidthChars;
    }

    public void setHasHalfWidthChars(boolean bl) {
        this.fHasHalfWidthChars = bl;
        this.fHasMixedWidthChars = this.fHasHalfWidthChars && this.fHasFullWidthChars;
    }

    public boolean hasFullWidthChars() {
        return this.fHasFullWidthChars;
    }

    public void setHasFullWidthChars(boolean bl) {
        this.fHasFullWidthChars = bl;
        this.fHasMixedWidthChars = this.fHasHalfWidthChars && this.fHasFullWidthChars;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (this.getOverlayLabel() == null || !(this.fOverlayLabel instanceof OverlayTextLabel)) {
            this.setOverlayLabel(new OverlayTextLabel(jTable));
        }
        OverlayTextLabel overlayTextLabel = (OverlayTextLabel)this.getOverlayLabel();
        String string = this.getDisplayedText(object);
        overlayTextLabel.setText(string);
        overlayTextLabel.setOverlayText(null, false);
        overlayTextLabel.setTable(jTable);
        overlayTextLabel.setFixedWidth(this.fFixedWidth);
        if (this.fFixedWidth) {
            if (n2 == this.fHoverSplitterColumn) {
                overlayTextLabel.setHoverSplitterColumn(true);
            } else {
                overlayTextLabel.setHoverSplitterColumn(false);
            }
            if (n2 == this.fHoverSplitterColumn - 1) {
                overlayTextLabel.setEndHoverSplitterColumn(true);
            } else {
                overlayTextLabel.setEndHoverSplitterColumn(false);
            }
        }
        TextTable textTable = (TextTable)((Object)jTable);
        Component component = super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
        int n3 = jTable.getSelectionModel().getAnchorSelectionIndex();
        int n4 = jTable.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
        if (bl) {
            if (textTable.getFocusedRow() == n && textTable.getFocusedCol() == n2) {
                component.setBackground(Color.white);
            } else if (n3 == n && n4 == n2) {
                component.setBackground(new Color(217, 232, 243));
            }
        } else if (textTable.getFocusedRow() == n && textTable.getFocusedCol() == n2 && jTable.getSelectedColumns().length > 0) {
            ((JComponent)component).setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        }
        return component;
    }

    public Font getRenderedFont() {
        return this.getOverlayLabel().getFont();
    }

    public int getStringWidth(String string, JTable jTable) {
        return this.getFontMetrics(this.getFixedWidthFont()).stringWidth(string);
    }

    private Font getFixedWidthFont() {
        HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
        hashMap.put(TextAttribute.FAMILY, "Monospaced");
        hashMap.put(TextAttribute.SIZE, this.getFont().getSize());
        hashMap.put(TextAttribute.KERNING, TextAttribute.KERNING_ON);
        Font font = Font.getFont(hashMap);
        this.fFixedWidthCompareCharacter = "_";
        int n = this.getFixedWidthCharacterWidth(this.fFixedWidthCompareCharacter);
        if (this.fHasFullWidthChars && this.getFont().canDisplay('\u4e00')) {
            this.fFixedWidthCompareCharacter = "\u4e00";
            int n2 = this.getFixedWidthCharacterWidth(this.fFixedWidthCompareCharacter);
            if (n2 > n) {
                this.fHalfWidthFont = true;
            }
        }
        return font;
    }

    private int getFixedWidthCharacterWidth(String string) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        return fontMetrics.stringWidth(string);
    }

    public int getFixedWidthCharacterWidth() {
        return this.getFixedWidthCharacterWidth(this.fFixedWidthCompareCharacter);
    }

    public boolean isFixedWidth() {
        return this.fFixedWidth;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.fFixedWidth) {
            Font font2 = this.getFixedWidthFont();
            super.setFont(font2);
            if (this.getOverlayLabel() != null) {
                this.getOverlayLabel().setFont(font2);
            }
        }
    }

    public void setFixedWidth(boolean bl) {
        if (this.fFixedWidth == bl) {
            return;
        }
        this.fFixedWidth = bl;
        if (bl) {
            Font font = this.getFixedWidthFont();
            this.setFont(font);
        } else {
            this.setFont(this.fDefaultFont);
        }
    }

    public static void setColor(String string, Color color) {
        if (string.toUpperCase().equals("HOVER_SPLITTER_HIGHLIGHT_COLOR")) {
            HOVER_SPLITTER_HIGHLIGHT_COLOR = color;
        } else {
            ImportCellRenderer.setColor(string, color);
        }
    }

    public static Color getColor(String string) {
        String string2 = string.toUpperCase();
        if (string2.equals("HOVER_SPLITTER_HIGHLIGHT_COLOR")) {
            return HOVER_SPLITTER_HIGHLIGHT_COLOR;
        }
        return null;
    }

    public int getHoverSplitterColumn() {
        return this.fHoverSplitterColumn;
    }

    public void setHoverSplitterColumn(int n) {
        this.fHoverSplitterColumn = n;
    }

    static {
        char c;
        char c2;
        HOVER_SPLITTER_HIGHLIGHT_COLOR = new Color(0, 0, 255, 25);
        sIsCJK = LanguageUtils.isCJK();
        sHalfToFullCharMap = new HashMap<Character, Character>();
        sHalfToFullCharMap.put(Character.valueOf(' '), Character.valueOf('\u3000'));
        for (c2 = '\uff01'; c2 <= '\uff5e'; c2 = (char)(c2 + '\u0001')) {
            c = (char)(c2 - 65248);
            sHalfToFullCharMap.put(Character.valueOf(c), Character.valueOf(c2));
        }
        sHalfToFullCharMap.put(Character.valueOf('\uff5f'), Character.valueOf('\u2985'));
        sHalfToFullCharMap.put(Character.valueOf('\uff60'), Character.valueOf('\u2986'));
        sHalfToFullCharMap.put(Character.valueOf('\uffe0'), Character.valueOf('\u00a2'));
        sHalfToFullCharMap.put(Character.valueOf('\uffe1'), Character.valueOf('\u00a3'));
        sHalfToFullCharMap.put(Character.valueOf('\uffe2'), Character.valueOf('\u00ac'));
        sHalfToFullCharMap.put(Character.valueOf('\uffe3'), Character.valueOf('\u00af'));
        sHalfToFullCharMap.put(Character.valueOf('\uffe4'), Character.valueOf('\u00a6'));
        sHalfToFullCharMap.put(Character.valueOf('\uffe5'), Character.valueOf('\u00a5'));
        sHalfToFullCharMap.put(Character.valueOf('\uffe6'), Character.valueOf('\u20a9'));
        sHalfToFullCharMap.put(Character.valueOf('\uff61'), Character.valueOf('\u3002'));
        sHalfToFullCharMap.put(Character.valueOf('\uff62'), Character.valueOf('\u300c'));
        sHalfToFullCharMap.put(Character.valueOf('\uff63'), Character.valueOf('\u300d'));
        sHalfToFullCharMap.put(Character.valueOf('\uff64'), Character.valueOf('\u3001'));
        sHalfToFullCharMap.put(Character.valueOf('\uff65'), Character.valueOf('\u30fb'));
        sHalfToFullCharMap.put(Character.valueOf('\uff66'), Character.valueOf('\u30f2'));
        sHalfToFullCharMap.put(Character.valueOf('\uff67'), Character.valueOf('\u30a1'));
        sHalfToFullCharMap.put(Character.valueOf('\uff68'), Character.valueOf('\u30a3'));
        sHalfToFullCharMap.put(Character.valueOf('\uff69'), Character.valueOf('\u30a5'));
        sHalfToFullCharMap.put(Character.valueOf('\uff6a'), Character.valueOf('\u30a7'));
        sHalfToFullCharMap.put(Character.valueOf('\uff6b'), Character.valueOf('\u30a9'));
        sHalfToFullCharMap.put(Character.valueOf('\uff6c'), Character.valueOf('\u30e3'));
        sHalfToFullCharMap.put(Character.valueOf('\uff6d'), Character.valueOf('\u30e5'));
        sHalfToFullCharMap.put(Character.valueOf('\uff6e'), Character.valueOf('\u30e7'));
        sHalfToFullCharMap.put(Character.valueOf('\uff6f'), Character.valueOf('\u30c3'));
        sHalfToFullCharMap.put(Character.valueOf('\uff70'), Character.valueOf('\u30fc'));
        sHalfToFullCharMap.put(Character.valueOf('\uff71'), Character.valueOf('\u30a2'));
        sHalfToFullCharMap.put(Character.valueOf('\uff72'), Character.valueOf('\u30a4'));
        sHalfToFullCharMap.put(Character.valueOf('\uff73'), Character.valueOf('\u30a6'));
        sHalfToFullCharMap.put(Character.valueOf('\uff74'), Character.valueOf('\u30a8'));
        sHalfToFullCharMap.put(Character.valueOf('\uff75'), Character.valueOf('\u30aa'));
        sHalfToFullCharMap.put(Character.valueOf('\uff76'), Character.valueOf('\u30ab'));
        sHalfToFullCharMap.put(Character.valueOf('\uff77'), Character.valueOf('\u30ad'));
        sHalfToFullCharMap.put(Character.valueOf('\uff78'), Character.valueOf('\u30af'));
        sHalfToFullCharMap.put(Character.valueOf('\uff79'), Character.valueOf('\u30b1'));
        sHalfToFullCharMap.put(Character.valueOf('\uff7a'), Character.valueOf('\u30b3'));
        sHalfToFullCharMap.put(Character.valueOf('\uff7b'), Character.valueOf('\u30b5'));
        sHalfToFullCharMap.put(Character.valueOf('\uff7c'), Character.valueOf('\u30b7'));
        sHalfToFullCharMap.put(Character.valueOf('\uff7d'), Character.valueOf('\u30b9'));
        sHalfToFullCharMap.put(Character.valueOf('\uff7e'), Character.valueOf('\u30bb'));
        sHalfToFullCharMap.put(Character.valueOf('\uff7f'), Character.valueOf('\u30bd'));
        sHalfToFullCharMap.put(Character.valueOf('\uff80'), Character.valueOf('\u30bf'));
        sHalfToFullCharMap.put(Character.valueOf('\uff81'), Character.valueOf('\u30c1'));
        sHalfToFullCharMap.put(Character.valueOf('\uff82'), Character.valueOf('\u30c4'));
        sHalfToFullCharMap.put(Character.valueOf('\uff83'), Character.valueOf('\u30c6'));
        sHalfToFullCharMap.put(Character.valueOf('\uff84'), Character.valueOf('\u30c8'));
        sHalfToFullCharMap.put(Character.valueOf('\uff85'), Character.valueOf('\u30ca'));
        sHalfToFullCharMap.put(Character.valueOf('\uff86'), Character.valueOf('\u30cb'));
        sHalfToFullCharMap.put(Character.valueOf('\uff87'), Character.valueOf('\u30cc'));
        sHalfToFullCharMap.put(Character.valueOf('\uff88'), Character.valueOf('\u30cd'));
        sHalfToFullCharMap.put(Character.valueOf('\uff89'), Character.valueOf('\u30ce'));
        sHalfToFullCharMap.put(Character.valueOf('\uff8a'), Character.valueOf('\u30cf'));
        sHalfToFullCharMap.put(Character.valueOf('\uff8b'), Character.valueOf('\u30d2'));
        sHalfToFullCharMap.put(Character.valueOf('\uff8c'), Character.valueOf('\u30d5'));
        sHalfToFullCharMap.put(Character.valueOf('\uff8d'), Character.valueOf('\u30d8'));
        sHalfToFullCharMap.put(Character.valueOf('\uff8e'), Character.valueOf('\u30db'));
        sHalfToFullCharMap.put(Character.valueOf('\uff8f'), Character.valueOf('\u30de'));
        sHalfToFullCharMap.put(Character.valueOf('\uff90'), Character.valueOf('\u30df'));
        sHalfToFullCharMap.put(Character.valueOf('\uff91'), Character.valueOf('\u30e0'));
        sHalfToFullCharMap.put(Character.valueOf('\uff92'), Character.valueOf('\u30e1'));
        sHalfToFullCharMap.put(Character.valueOf('\uff93'), Character.valueOf('\u30e2'));
        sHalfToFullCharMap.put(Character.valueOf('\uff94'), Character.valueOf('\u30e4'));
        sHalfToFullCharMap.put(Character.valueOf('\uff95'), Character.valueOf('\u30e6'));
        sHalfToFullCharMap.put(Character.valueOf('\uff96'), Character.valueOf('\u30e8'));
        sHalfToFullCharMap.put(Character.valueOf('\uff97'), Character.valueOf('\u30e9'));
        sHalfToFullCharMap.put(Character.valueOf('\uff98'), Character.valueOf('\u30ea'));
        sHalfToFullCharMap.put(Character.valueOf('\uff99'), Character.valueOf('\u30eb'));
        sHalfToFullCharMap.put(Character.valueOf('\uff9a'), Character.valueOf('\u30ec'));
        sHalfToFullCharMap.put(Character.valueOf('\uff9b'), Character.valueOf('\u30ed'));
        sHalfToFullCharMap.put(Character.valueOf('\uff9c'), Character.valueOf('\u30ef'));
        sHalfToFullCharMap.put(Character.valueOf('\uff9d'), Character.valueOf('\u30f3'));
        sHalfToFullCharMap.put(Character.valueOf('\uff9e'), Character.valueOf('\u3099'));
        sHalfToFullCharMap.put(Character.valueOf('\uff9f'), Character.valueOf('\u309a'));
        sHalfToFullCharMap.put(Character.valueOf('\uffa0'), Character.valueOf('\u3164'));
        for (c2 = '\uffa1'; c2 <= '\uffbe'; c2 = (char)(c2 + '\u0001')) {
            c = (char)(c2 - 52848);
            sHalfToFullCharMap.put(Character.valueOf(c2), Character.valueOf(c));
        }
        for (c2 = '\uffc2'; c2 <= '\uffc7'; c2 = (char)(c2 + '\u0001')) {
            c = (char)(c2 - 52851);
            sHalfToFullCharMap.put(Character.valueOf(c2), Character.valueOf(c));
        }
        for (c2 = '\uffca'; c2 <= '\uffcf'; c2 = (char)(c2 + '\u0001')) {
            c = (char)(c2 - 52853);
            sHalfToFullCharMap.put(Character.valueOf(c2), Character.valueOf(c));
        }
        for (c2 = '\uffd2'; c2 <= '\uffd7'; c2 = (char)(c2 + '\u0001')) {
            c = (char)(c2 - 52855);
            sHalfToFullCharMap.put(Character.valueOf(c2), Character.valueOf(c));
        }
        sHalfToFullCharMap.put(Character.valueOf('\uffda'), Character.valueOf('\u3161'));
        sHalfToFullCharMap.put(Character.valueOf('\uffdb'), Character.valueOf('\u3162'));
        sHalfToFullCharMap.put(Character.valueOf('\uffdc'), Character.valueOf('\u3163'));
        sHalfToFullCharMap.put(Character.valueOf('\uffe8'), Character.valueOf('\u2502'));
        sHalfToFullCharMap.put(Character.valueOf('\uffe9'), Character.valueOf('\u2190'));
        sHalfToFullCharMap.put(Character.valueOf('\uffea'), Character.valueOf('\u2191'));
        sHalfToFullCharMap.put(Character.valueOf('\uffeb'), Character.valueOf('\u2192'));
        sHalfToFullCharMap.put(Character.valueOf('\uffec'), Character.valueOf('\u2193'));
        sHalfToFullCharMap.put(Character.valueOf('\uffed'), Character.valueOf('\u25a0'));
        sHalfToFullCharMap.put(Character.valueOf('\uffee'), Character.valueOf('\u25cb'));
    }

    static class OverlayTextLabel
    extends ImportCellRenderer.OverlayLabel {
        private boolean fFixedWidth = false;
        private boolean fHoverSplitterColumn = false;
        private boolean fEndHoverSplitterColumn = false;

        OverlayTextLabel(JTable jTable) {
            super(jTable);
        }

        public boolean isFixedWidth() {
            return this.fFixedWidth;
        }

        public void setFixedWidth(boolean bl) {
            this.fFixedWidth = bl;
        }

        public boolean isHoverSplitterColumn() {
            return this.fHoverSplitterColumn;
        }

        public boolean isEndHoverSplitterColumn() {
            return this.fEndHoverSplitterColumn;
        }

        public void setEndHoverSplitterColumn(boolean bl) {
            this.fEndHoverSplitterColumn = bl;
        }

        public void setHoverSplitterColumn(boolean bl) {
            this.fHoverSplitterColumn = bl;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            Rectangle rectangle = this.getBounds();
            if (this.fFixedWidth) {
                graphics2D.setColor(this.fLineColor);
                graphics2D.drawLine(rectangle.width - 1, 0, rectangle.width - 1, rectangle.height);
                if (this.fHoverSplitterColumn) {
                    graphics2D.setColor(HOVER_SPLITTER_HIGHLIGHT_COLOR);
                    graphics2D.fillRoundRect(0, 0, 4, rectangle.height, 2, 2);
                }
                if (this.fEndHoverSplitterColumn) {
                    graphics2D.setColor(HOVER_SPLITTER_HIGHLIGHT_COLOR);
                    graphics2D.fillRoundRect(rectangle.width - 4, 0, 4, rectangle.height, 2, 2);
                }
            }
            graphics2D.dispose();
        }
    }
}

