/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.SpreadsheetImportClient;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.widgets.desk.DTGroupAdapter;
import com.mathworks.widgets.desk.DTGroupBase;
import com.mathworks.widgets.desk.DTGroupEvent;
import com.mathworks.widgets.desk.DTGroupListener;
import com.mathworks.widgets.desk.DTProperty;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Hashtable;

public class SpreadsheetImportToolGroup
extends DTGroupBase {
    private static Hashtable<String, SpreadsheetImportToolGroup> sGroups = new Hashtable();
    public static String DEFAULT_GROUP_NAME = "SpreadsheetImportTool";

    private SpreadsheetImportToolGroup(String string) {
        this.setGroupName(string);
        this.setTitle(ImportToolUtils.getResourceString("spreadhseetimport.title"));
        this.setSmallIcon(ImportToolUtils.getResourceIcon("import_16.png"));
        this.setIcon(ImportToolUtils.getResourceIcon("importAction.png"));
        this.setIsGuest(true);
    }

    public static synchronized SpreadsheetImportToolGroup getInstance() {
        return SpreadsheetImportToolGroup.getInstance(DEFAULT_GROUP_NAME);
    }

    public static synchronized SpreadsheetImportToolGroup getInstance(String string) {
        if (!sGroups.contains(string)) {
            sGroups.put(string, new SpreadsheetImportToolGroup(string));
        }
        return sGroups.get(string);
    }

    protected void setParentDesktop(Desktop desktop) {
        super.setParentDesktop(desktop);
        Desktop desktop2 = MatlabDesktopServices.getDesktop();
        String string = (String)this.getGroupProperty(DTProperty.NAME);
        if (desktop2 != null) {
            desktop2.addGroupListener(string, (DTGroupListener)new GroupClosingListener(string));
        }
    }

    static class GroupClosingListener
    extends DTGroupAdapter {
        private String fGroupName;

        GroupClosingListener(String string) {
            this.fGroupName = string;
        }

        public void groupClosing(DTGroupEvent dTGroupEvent) {
            Desktop desktop = MatlabDesktopServices.getDesktop();
            if (desktop != null) {
                ArrayList<SpreadsheetImportClient> arrayList = new ArrayList<SpreadsheetImportClient>();
                for (Component component : desktop.getGroupMembers(this.fGroupName)) {
                    if (!(component instanceof SpreadsheetImportClient)) continue;
                    arrayList.add((SpreadsheetImportClient)((Object)component));
                }
                if (arrayList.size() <= 0) {
                    return;
                }
                if (desktop.isAttemptingClose()) {
                    int n = MJOptionPane.showConfirmDialog((Component)desktop.getMainFrame(), (Object)ImportToolUtils.getResourceString("messages.vetoclose"), (String)ImportToolUtils.getResourceString("error.title"), (int)2, (int)3);
                    if (n == 0) {
                        MatlabDesktopServices.getDesktop().removeGroupListener(this.fGroupName, (DTGroupListener)this);
                        for (SpreadsheetImportClient spreadsheetImportClient : arrayList) {
                            desktop.removeClient((Component)((Object)spreadsheetImportClient));
                            spreadsheetImportClient.cleanup(true);
                        }
                    } else {
                        SpreadsheetImportToolGroup.getInstance(this.fGroupName).vetoClose();
                    }
                }
            }
        }
    }
}

