/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.ImportTable;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.IntervalSelectionModel;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import java.util.ArrayList;
import java.util.List;

public class ImportSelectionManager {
    protected volatile IntervalSelectionModel fRowSelectionModel;
    protected volatile IntervalSelectionModel fColumnSelectionModel;
    protected ImportTable fTable;

    ImportSelectionManager(ImportTable importTable) {
        this.fTable = importTable;
        this.fRowSelectionModel = new IntervalSelectionModel();
        this.fColumnSelectionModel = new IntervalSelectionModel();
    }

    void setSelection(int n, int n2, int n3, int n4) {
        this.fRowSelectionModel.setSelectionInterval(n, n2);
        this.fColumnSelectionModel.setSelectionInterval(n3, n4);
    }

    int getSeletedCellCount() {
        return this.fRowSelectionModel.getSelectionCount() * this.fColumnSelectionModel.getSelectionCount();
    }

    int[] getSelectionSizeAfterExclusion() {
        int n = this.getExcludedRowCount();
        int n2 = n >= 0 ? this.fRowSelectionModel.getSelectionCount() - n : this.fRowSelectionModel.getSelectionCount();
        int n3 = this.getExcludedColumnCount();
        int n4 = n3 >= 0 ? this.fColumnSelectionModel.getSelectionCount() - n3 : this.fColumnSelectionModel.getSelectionCount();
        return new int[]{n2, n4};
    }

    IntervalSelectionModel getRowSelectionModel() {
        return this.fRowSelectionModel;
    }

    IntervalSelectionModel getColumnSelectionModel() {
        return this.fColumnSelectionModel;
    }

    protected int getExcludedColumnCount() {
        List<WorksheetRule> list = this.fTable.getWorksheetTableModel().getWorksheetRules();
        boolean bl = false;
        for (WorksheetRule worksheetRule : list) {
            if (worksheetRule.getType() != WorksheetRule.RuleType.COLUMNEXCLUDE) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return 0;
        }
        return this.fTable.getWorksheetTableModel().getExcludedColumnCount(this.fRowSelectionModel, this.fColumnSelectionModel);
    }

    protected int getExcludedRowCount() {
        List<WorksheetRule> list = this.fTable.getWorksheetTableModel().getWorksheetRules();
        boolean bl = false;
        for (WorksheetRule worksheetRule : list) {
            if (worksheetRule.getType() != WorksheetRule.RuleType.ROWEXCLUDE) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return 0;
        }
        return this.fTable.getWorksheetTableModel().getExcludedRowCount(this.fRowSelectionModel, this.fColumnSelectionModel);
    }

    String getSelectedRange() {
        StringBuilder stringBuilder = new StringBuilder();
        List<String> list = this.getSelectedRanges();
        for (String string : list) {
            stringBuilder.append(string);
            stringBuilder.append(",");
        }
        if (stringBuilder.length() >= 1) {
            return stringBuilder.substring(0, stringBuilder.length() - 1);
        }
        return "";
    }

    List<String> getSelectedRanges() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int[] nArray : this.fRowSelectionModel.getSelectedIntervals()) {
            for (int[] nArray2 : this.fColumnSelectionModel.getSelectedIntervals()) {
                arrayList.add(ImportToolUtils.toExcelRange(nArray[0] + 1, nArray[1] + 1, nArray2[0] + 1, nArray2[1] + 1));
            }
        }
        return arrayList;
    }

    String[][] getSelectedRangeArray() {
        List<int[]> list = this.fTable.getSelectedRowsAfterRules();
        List<int[]> list2 = this.fColumnSelectionModel.getSelectedIntervals();
        String[][] stringArray = new String[list.size()][list2.size()];
        for (int i = 0; i < list.size(); ++i) {
            for (int j = 0; j < list2.size(); ++j) {
                stringArray[i][j] = ImportToolUtils.toExcelRange(list.get(i)[0] + 1, list.get(i)[1] + 1, list2.get(j)[0] + 1, list2.get(j)[1] + 1);
            }
        }
        return stringArray;
    }

    boolean isSelectionEmpty() {
        return this.fRowSelectionModel.getSelectionCount() * this.fColumnSelectionModel.getSelectionCount() == 0;
    }

    void cleanup() {
    }
}

