/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.mlwidgets.html.HTMLRenderer;
import com.mathworks.mlwidgets.html.PageChangedListener;
import com.mathworks.mwswing.MJDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class HTMLWindow {
    private HTMLRenderer fHtmlPanel;
    private MJDialog fDialog;
    private Dimension fSize = new Dimension(400, 400);
    private Point fLocation = new Point(20, 40);

    private HTMLWindow() {
        this.fHtmlPanel = new HTMLRenderer();
        this.fHtmlPanel.addPageChangedListener(new MyPageChangedListener());
        this.createDialog();
    }

    private void createDialog() {
        this.fDialog = new MJDialog();
        this.fDialog.getContentPane().setLayout(new BorderLayout());
        this.fDialog.getContentPane().add((Component)((Object)this.fHtmlPanel), "Center");
        this.fDialog.setSize(this.fSize);
        this.fDialog.setLocation(this.fLocation);
        this.fDialog.setVisible(true);
        this.fDialog.addWindowListener((WindowListener)new MyWindowAdapter());
    }

    public static HTMLWindow createWindow() {
        return new HTMLWindow();
    }

    public void setSize(int n, int n2) {
        if (this.fDialog != null) {
            this.fDialog.setSize(n, n2);
        }
    }

    public void setLocation(int n, int n2) {
        if (this.fDialog != null) {
            this.fDialog.setLocation(n, n2);
        }
    }

    public void setHtmlText(String string) {
        if (this.fDialog == null) {
            this.createDialog();
        } else {
            this.fDialog.toFront();
        }
        this.fHtmlPanel.setHtmlText(string);
    }

    public void setCurrentLocation(String string) {
        if (this.fDialog == null) {
            this.createDialog();
        } else {
            this.fDialog.toFront();
        }
        this.fHtmlPanel.setCurrentLocation(string);
    }

    private class MyWindowAdapter
    extends WindowAdapter {
        private MyWindowAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            super.windowClosing(windowEvent);
            HTMLWindow.this.fSize = HTMLWindow.this.fDialog.getSize();
            HTMLWindow.this.fLocation = HTMLWindow.this.fDialog.getLocation();
            HTMLWindow.this.fDialog = null;
        }
    }

    private class MyPageChangedListener
    implements PageChangedListener {
        private MyPageChangedListener() {
        }

        @Override
        public void pageChanged(PageChangedListener.PageChangedEvent pageChangedEvent) {
            if (HTMLWindow.this.fDialog != null) {
                HTMLWindow.this.fDialog.setTitle(pageChangedEvent.getTitle());
            }
        }
    }
}

