/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.html.SystemBrowserLauncher;
import com.mathworks.html.SystemBrowserStrategy;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.html.MatlabSystemBrowserStrategy;
import com.mathworks.net.transport.MWTransportClientProperties;
import com.mathworks.net.transport.MWTransportClientPropertiesFactory;
import com.mathworks.services.Prefs;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashSet;

public class HTMLPrefs {
    private static final String HTML = "HTML";
    private static final String USEPROXY = "UseProxy";
    private static final String PROXYHOST = "ProxyHost";
    private static final String PROXYPORT = "ProxyPort";
    private static final String USEPROXYAUTHENTICATION = "UseProxyAuthentication";
    private static final String PROXYUSERNAME = "ProxyUsername";
    private static final String PROXYPASSWORD = "ProxyPassword";
    private static final String MAXFILESIZE = "MaxFileSize";
    private static final String SYSTEM_BROWSER = "SystemBrowser";
    private static final String SYSTEM_BROWSER_OPTIONS = "SystemBrowserOptions";
    private static final String BROWSER_TAB_MAXIMUM = "BrowserTabMaximum";
    private static final String EXTERNAL_LINK_IS_OK = "ExternalLinkIsOk";
    private static final String CONNECTOR_AUTOSTART = "MATLAB_CONNECTOR_AUTOSTART_ENABLED";
    private static boolean sUseProxy = HTMLPrefs.getBooleanPref("HTMLUseProxy", false);
    private static String sProxyHost = HTMLPrefs.getStringPref("HTMLProxyHost", "");
    private static String sProxyPort = HTMLPrefs.getStringPref("HTMLProxyPort", "");
    private static boolean sUseProxyAuthentication = HTMLPrefs.getBooleanPref("HTMLUseProxyAuthentication", false);
    private static String sProxyUsername = HTMLPrefs.getStringPref("HTMLProxyUsername", "");
    private static String sProxyPassword = HTMLPrefs.getStringPref("HTMLProxyPassword", "");
    private static Collection<ActionListener> sProxyListeners = new HashSet<ActionListener>();
    private static double sMaxFileSize = HTMLPrefs.getDoublePref("HTMLMaxFileSize", 1500000.0);
    private static String sSystemBrowser = HTMLPrefs.getStringPref("HTMLSystemBrowser", "firefox");
    private static String sSystemBrowserOptions = HTMLPrefs.getStringPref("HTMLSystemBrowserOptions", "");
    private static boolean sExternalLinkIsOk = HTMLPrefs.getBooleanPref("HTMLExternalLinkIsOk", false);

    private HTMLPrefs() {
    }

    public static void setMaxFileSize(double d) {
        HTMLPrefs.setDoublePref("HTMLMaxFileSize", d);
        sMaxFileSize = d;
    }

    public static double getMaxFileSize() {
        return sMaxFileSize;
    }

    public static void setProxySettings() {
        MWTransportClientProperties mWTransportClientProperties = MWTransportClientPropertiesFactory.create();
        if (sUseProxy) {
            mWTransportClientProperties.setProxyHost(sProxyHost);
            mWTransportClientProperties.setProxyPort(sProxyPort);
        } else {
            mWTransportClientProperties.setProxyHost("");
            mWTransportClientProperties.setProxyPort("");
        }
        if (sUseProxy && sUseProxyAuthentication) {
            mWTransportClientProperties.setProxyUser(sProxyUsername);
            mWTransportClientProperties.setProxyPassword(sProxyPassword);
        } else {
            mWTransportClientProperties.setProxyUser("");
            mWTransportClientProperties.setProxyPassword("");
        }
        if (sProxyListeners != null) {
            for (ActionListener actionListener : sProxyListeners) {
                actionListener.actionPerformed(new ActionEvent(sProxyHost, 0, "proxy pref changed"));
            }
        }
    }

    public static void addProxyListener(ActionListener actionListener) {
        sProxyListeners.add(actionListener);
    }

    public static void removeProxyListener(ActionListener actionListener) {
        if (sProxyListeners != null) {
            sProxyListeners.remove(actionListener);
        }
    }

    public static void setUseProxy(boolean bl) {
        if (bl != sUseProxy) {
            sUseProxy = bl;
            HTMLPrefs.setBooleanPref("HTMLUseProxy", sUseProxy);
        }
    }

    public static boolean getUseProxy() {
        return sUseProxy;
    }

    public static void setUseProxyAuthentication(boolean bl) {
        if (bl != sUseProxyAuthentication) {
            sUseProxyAuthentication = bl;
            HTMLPrefs.setBooleanPref("HTMLUseProxyAuthentication", sUseProxyAuthentication);
        }
    }

    public static boolean getUseProxyAuthentication() {
        return sUseProxyAuthentication;
    }

    public static void setProxyUsername(String string) {
        if (!string.equals(sProxyUsername)) {
            sProxyUsername = string;
            HTMLPrefs.setStringPref("HTMLProxyUsername", sProxyUsername);
        }
    }

    public static String getProxyUsername() {
        return sProxyUsername;
    }

    public static void setProxyPassword(String string) {
        if (!string.equals(sProxyPassword)) {
            sProxyPassword = string;
            HTMLPrefs.setStringPref("HTMLProxyPassword", sProxyPassword);
        }
    }

    public static String getProxyPassword() {
        return sProxyPassword;
    }

    public static void setProxyHost(String string) {
        if (!string.equals(sProxyHost)) {
            sProxyHost = string;
            HTMLPrefs.setStringPref("HTMLProxyHost", sProxyHost);
        }
    }

    public static String getProxyHost() {
        return sProxyHost;
    }

    public static void setProxyPort(String string) {
        if (!string.equals(sProxyPort)) {
            sProxyPort = string;
            HTMLPrefs.setStringPref("HTMLProxyPort", sProxyPort);
        }
    }

    public static String getProxyPort() {
        return sProxyPort;
    }

    public static void setSystemBrowser(String string) {
        if (!string.equals(sSystemBrowser)) {
            sSystemBrowser = string;
            HTMLPrefs.setStringPref("HTMLSystemBrowser", sSystemBrowser);
        }
    }

    public static String getSystemBrowser() {
        return sSystemBrowser;
    }

    public static void setSystemBrowserOptions(String string) {
        if (!string.equals(sSystemBrowserOptions)) {
            sSystemBrowserOptions = string;
            HTMLPrefs.setStringPref("HTMLSystemBrowserOptions", sSystemBrowserOptions);
        }
    }

    public static String getSystemBrowserOptions() {
        return sSystemBrowserOptions;
    }

    public static void setBrowserTabMaximum(int n) {
        if (n <= 0) {
            n = 1;
        }
        HTMLPrefs.setIntegerPref("HTMLBrowserTabMaximum", n);
    }

    public static int getBrowserTabMaximum() {
        return HTMLPrefs.getIntegerPref("HTMLBrowserTabMaximum", 30);
    }

    public static boolean isExternalLinkIsOk() {
        return sExternalLinkIsOk;
    }

    public static void setExternalLinkIsOk(boolean bl) {
        if (bl != sExternalLinkIsOk) {
            sExternalLinkIsOk = bl;
            HTMLPrefs.setBooleanPref("HTMLExternalLinkIsOk", sExternalLinkIsOk);
        }
    }

    public static boolean getAutoStartEnabled() {
        return HTMLPrefs.getBooleanPref(CONNECTOR_AUTOSTART, true);
    }

    public static void setAutoStartEnabled(boolean bl) {
        if (bl) {
            HTMLPrefs.removePref(CONNECTOR_AUTOSTART);
        } else {
            HTMLPrefs.setBooleanPref(CONNECTOR_AUTOSTART, false);
        }
    }

    private static void removePref(String string) {
        if (Matlab.isMatlabAvailable() && Prefs.exists((String)string)) {
            Prefs.remove((String)string);
        }
    }

    private static void setDoublePref(String string, double d) {
        if (Matlab.isMatlabAvailable()) {
            Prefs.setDoublePref((String)string, (double)d);
        }
    }

    private static double getDoublePref(String string, double d) {
        return Matlab.isMatlabAvailable() ? Prefs.getDoublePref((String)string, (double)d) : d;
    }

    private static void setBooleanPref(String string, boolean bl) {
        if (Matlab.isMatlabAvailable()) {
            Prefs.setBooleanPref((String)string, (boolean)bl);
        }
    }

    private static boolean getBooleanPref(String string, boolean bl) {
        return Matlab.isMatlabAvailable() ? Prefs.getBooleanPref((String)string, (boolean)bl) : bl;
    }

    private static void setStringPref(String string, String string2) {
        if (Matlab.isMatlabAvailable()) {
            Prefs.setStringPref((String)string, (String)string2);
        }
    }

    private static String getStringPref(String string, String string2) {
        return Matlab.isMatlabAvailable() ? Prefs.getStringPref((String)string, (String)string2) : string2;
    }

    private static void setIntegerPref(String string, int n) {
        if (Matlab.isMatlabAvailable()) {
            Prefs.setIntegerPref((String)string, (int)n);
        }
    }

    private static int getIntegerPref(String string, int n) {
        return Matlab.isMatlabAvailable() ? Prefs.getIntegerPref((String)string, (int)n) : n;
    }

    static {
        HTMLPrefs.setProxySettings();
        SystemBrowserLauncher.setDefaultStrategy((SystemBrowserStrategy)new MatlabSystemBrowserStrategy());
    }
}

