/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.MiscellaneousIcon;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.widgets.LightButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class CommandInfoPanel
extends MJPanel {
    private static final Color WARNING_MESSAGE_COLOR = Color.decode("#002A90");
    private static final String WARNING_MESSAGE = HTMLUtils.sRes.getString("alert.security_warning");
    private static final String CONFIRM_MESSAGE = HTMLUtils.sRes.getString("alert.security_warning_confirm");
    private final MJPanel fTopPanel;
    private final MoreInfoButton fMoreInfoButton;
    private final MJPanel fTextPanel;

    public CommandInfoPanel(String string) {
        FormLayout formLayout = new FormLayout("left:pref:grow", "pref, 4dlu, pref");
        formLayout.setRowGroups((int[][])new int[][]{{1, 3}});
        CellConstraints cellConstraints = new CellConstraints();
        this.fTopPanel = new MJPanel((LayoutManager)formLayout);
        MJMultilineLabel mJMultilineLabel = new MJMultilineLabel(WARNING_MESSAGE);
        Font font = mJMultilineLabel.getFont().deriveFont(1, 15.0f);
        mJMultilineLabel.setFont(font);
        mJMultilineLabel.setForeground(WARNING_MESSAGE_COLOR);
        MJLabel mJLabel = new MJLabel(CONFIRM_MESSAGE);
        this.fTopPanel.add((Component)mJMultilineLabel, (Object)cellConstraints.xy(1, 1));
        this.fTopPanel.add((Component)mJLabel, (Object)cellConstraints.xy(1, 3));
        this.fMoreInfoButton = new MoreInfoButton();
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setRows(4);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea, 22, 31);
        FormLayout formLayout2 = new FormLayout("fill:pref:grow", "pref:grow");
        this.fTextPanel = new MJPanel((LayoutManager)formLayout2);
        CellConstraints cellConstraints2 = new CellConstraints();
        this.fTextPanel.add((Component)jScrollPane, (Object)cellConstraints2.xy(1, 1));
        this.doMyLayout();
    }

    private void doMyLayout() {
        FormLayout formLayout = new FormLayout("fill:pref:grow", "pref, 10dlu, pref, 10dlu, pref");
        CellConstraints cellConstraints = new CellConstraints();
        this.setLayout((LayoutManager)formLayout);
        this.add((Component)this.fTopPanel, cellConstraints.xy(1, 1));
        this.add((Component)((Object)this.fMoreInfoButton), cellConstraints.xy(1, 3));
        this.add((Component)this.fTextPanel, cellConstraints.xy(1, 5));
        this.resetBottomVisibility();
    }

    private void resetBottomVisibility() {
        if (this.fTextPanel == null || this.fMoreInfoButton == null) {
            return;
        }
        this.fTextPanel.setVisible(this.fMoreInfoButton.isOpen());
        this.revalidate();
        if (this.isShowing()) {
            Container container = this.getTopLevelAncestor();
            if (container != null && container instanceof Window) {
                ((Window)container).pack();
            }
            this.repaint();
        }
    }

    public class MoreInfoButton
    extends LightButton {
        boolean open;

        public MoreInfoButton() {
            this.setOpen(false);
            MJAbstractAction mJAbstractAction = new MJAbstractAction(HTMLUtils.sRes.getString("alert.security_warning_command_details")){

                public void actionPerformed(ActionEvent actionEvent) {
                    MoreInfoButton.this.handleClick();
                }
            };
            mJAbstractAction.setButtonOnlyIcon((Icon)(this.open ? MiscellaneousIcon.OPEN_ARROW.getIcon() : MiscellaneousIcon.CLOSE_ARROW.getIcon()));
            this.setAction((Action)mJAbstractAction);
        }

        public void handleClick() {
            this.setOpen(!this.isOpen());
        }

        public boolean isOpen() {
            return this.open;
        }

        public void setOpen(boolean bl) {
            this.open = bl;
            if (this.open) {
                this.setIcon(MiscellaneousIcon.OPEN_ARROW.getIcon());
            } else {
                this.setIcon(MiscellaneousIcon.CLOSE_ARROW.getIcon());
            }
            CommandInfoPanel.this.resetBottomVisibility();
        }
    }
}

