/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocSetItem;
import com.mathworks.helpsearch.reference.RefEntityType;
import com.mathworks.helpsearch.reference.ReferenceEntity;
import com.mathworks.helpsearch.reference.map.ReferenceEntityNode;
import com.mathworks.helpsearch.reference.map.ReferenceMapParser;
import com.mathworks.html.FileUrl;
import com.mathworks.mlwidgets.help.DocCenterDocConfig;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class ReferenceEntityMap {
    private static ReferenceEntityMap sInstance = null;
    private final DocCenterDocConfig<FileUrl> fConfig;
    private ReferenceEntityNode fRootNode;

    private ReferenceEntityMap(DocCenterDocConfig<FileUrl> docCenterDocConfig) {
        this.fConfig = docCenterDocConfig;
    }

    public static synchronized ReferenceEntityMap getInstance() {
        DocCenterDocConfig<FileUrl> docCenterDocConfig = DocCenterDocConfig.getLocalConfig();
        if (sInstance == null || !docCenterDocConfig.equals(ReferenceEntityMap.sInstance.fConfig)) {
            sInstance = new ReferenceEntityMap(docCenterDocConfig);
        }
        return sInstance;
    }

    public synchronized List<ReferenceEntity> mapEntity(String string) {
        if (this.fRootNode == null) {
            this.populate();
        }
        return this.fRootNode.getReferenceEntities(string);
    }

    public synchronized void populate() {
        this.clear();
        Set set = this.fConfig.getProductFilter().getSelectedProducts();
        for (DocProduct docProduct : set) {
            FileUrl fileUrl = (FileUrl)this.fConfig.getDocRoot().buildDocSetItemUrl((DocSetItem)docProduct, "refmap.xml");
            File file = fileUrl.getFile();
            if (!file.exists()) continue;
            try {
                new ReferenceMapParser(file).parse(this.fRootNode);
            }
            catch (Exception exception) {}
        }
    }

    public synchronized void clear() {
        this.fRootNode = new ReferenceEntityNode();
    }

    public synchronized void addMapping(String string, String string2, String string3) {
        RefEntityType refEntityType = RefEntityType.valueOf((String)string3.toUpperCase(Locale.ENGLISH));
        this.fRootNode.add(string, string2, refEntityType);
    }
}

