/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.help.ContentsData;
import com.mathworks.mlwidgets.help.ContentsItem;
import com.mathworks.mlwidgets.help.DemoInfoUtils;
import com.mathworks.mlwidgets.help.DemoTreeItem;
import com.mathworks.mlwidgets.help.DemosData;
import com.mathworks.mlwidgets.help.HelpIcon;
import com.mathworks.mlwidgets.help.HelpTreeItem;
import com.mathworks.mlwidgets.help.HelpTreeItemRegistry;
import com.mathworks.mlwidgets.help.HelpTreeUtils;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mlwidgets.help.ProductHelpTreeItem;
import com.mathworks.mlwidgets.help.ReferenceContainerItem;
import com.mathworks.mlwidgets.help.ReferenceItem;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.mlwidgets.util.productinfo.ProductInfoUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class ContentsDataParser {
    private static final String TOC_ITEM_TAG = "tocitem";
    private static final String TOC_REFERENCE_TAG = "tocreference";
    private static final String DEMOS_XML = "demos.xml";
    private static final String FUNCTIONS_BY_CAT = "helpfuncbycat.xml";
    private static final String BLOCKS_BY_CAT = "helpblockbycat.xml";

    private ContentsDataParser() {
    }

    static void loadProduct(ProductHelpTreeItem productHelpTreeItem) {
        Document document = ContentsDataParser.getDomDocument(productHelpTreeItem.getHelpTocFilename());
        if (document != null) {
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!node.getNodeName().equals(TOC_ITEM_TAG)) continue;
                String string = ContentsDataParser.getTargetFromTocItem(node.getAttributes());
                productHelpTreeItem.setFilename(string);
                ContentsDataParser.registerItem(productHelpTreeItem, productHelpTreeItem.getHelpLoc(), string);
                String string2 = productHelpTreeItem.getHelpLoc();
                ContentsDataParser.addChildrenToProductNode(node, productHelpTreeItem, string2);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document getDomDocument(String string) {
        InputStream inputStream = null;
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException sAXParseException) {
                }

                @Override
                public void error(SAXParseException sAXParseException) throws SAXException {
                    throw sAXParseException;
                }

                @Override
                public void fatalError(SAXParseException sAXParseException) throws SAXException {
                    throw sAXParseException;
                }
            });
            inputStream = new FileInputStream(string);
            document = documentBuilder.parse(new InputSource(inputStream));
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("Warning: In file " + string + ", line " + sAXParseException.getLineNumber() + ", column " + sAXParseException.getColumnNumber() + ": " + sAXParseException.getMessage());
        }
        catch (SAXException sAXException) {
            System.out.println("Warning: Could not parse help table of contents file at " + string);
        }
        catch (IOException iOException) {
            assert (false) : "Could not read helptoc.xml file at " + string;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            assert (false) : "SAX parser for help table of contents misconfigured";
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return document;
    }

    private static void addChildrenToProductNode(Node node, ProductHelpTreeItem productHelpTreeItem, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string2 = node2.getNodeName();
            if (string2.equals(TOC_ITEM_TAG)) {
                ContentsDataParser.parseTocItemTag(node2, productHelpTreeItem, string, null);
                continue;
            }
            if (!string2.equals(TOC_REFERENCE_TAG)) continue;
            ContentsDataParser.parseTocReferenceTag(node2, productHelpTreeItem, string);
        }
    }

    private static void addChildrenToModel(Node node, HelpTreeItem helpTreeItem, String string, String string2) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string3 = node2.getNodeName();
            if (!string3.equals(TOC_ITEM_TAG)) continue;
            ContentsDataParser.parseTocItemTag(node2, helpTreeItem, string, string2);
        }
    }

    private static void parseTocItemTag(Node node, HelpTreeItem helpTreeItem, String string, String string2) {
        NamedNodeMap namedNodeMap;
        String string3 = helpTreeItem.getProduct();
        if (node.getFirstChild() != null && (namedNodeMap = node.getAttributes()) != null) {
            String string4 = node.getFirstChild().getNodeValue().trim();
            String string5 = "";
            Node node2 = namedNodeMap.getNamedItem("target");
            if (node2 != null) {
                string5 = node2.getNodeValue();
                if (string2 != null) {
                    string5 = string2 + "/" + string5;
                }
            }
            Node node3 = namedNodeMap.getNamedItem("image");
            String string6 = null;
            if (node3 != null) {
                string6 = node3.getNodeValue();
            }
            Icon icon = HelpTreeUtils.getIcon(string6);
            ContentsItem contentsItem = new ContentsItem(helpTreeItem.getTreeNode(), string4, icon, string3);
            helpTreeItem.addChild(contentsItem);
            contentsItem.setFilename(string5);
            ContentsDataParser.registerItem(contentsItem, string, string5);
            ContentsDataParser.addChildrenToModel(node, contentsItem, string, string2);
        }
    }

    private static void registerItem(TreeNode treeNode, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(string);
        if (!string.endsWith("/")) {
            stringBuilder.append('/');
        }
        stringBuilder.append(HTMLUtils.getFilenameFromURL(string2));
        String string3 = HTMLUtils.getAnchorFromURL(string2);
        if (string3 != null && string3.length() > 0) {
            stringBuilder.append("#").append(string3);
        }
        HelpTreeItemRegistry.addNode(stringBuilder.toString(), treeNode);
    }

    private static String getTargetFromTocItem(NamedNodeMap namedNodeMap) {
        Node node = namedNodeMap.getNamedItem("target");
        if (node != null) {
            return node.getNodeValue();
        }
        return null;
    }

    private static void parseTocReferenceTag(Node node, ProductHelpTreeItem productHelpTreeItem, String string) {
        Node node2;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null && (node2 = namedNodeMap.getNamedItem("target")) != null) {
            String string2 = node2.getNodeValue();
            if (string2.endsWith(DEMOS_XML)) {
                ContentsDataParser.parseDemoItem(string2, productHelpTreeItem, string);
            } else if (string2.endsWith(FUNCTIONS_BY_CAT)) {
                String string3 = HelpUtils.getLocalizedString("contents.functions");
                Icon icon = HelpIcon.FUNCTION.getIcon();
                ContentsDataParser.parseRefCategoryFile(productHelpTreeItem, string2, string, string3, icon);
            } else if (string2.endsWith(BLOCKS_BY_CAT)) {
                String string4 = HelpUtils.getLocalizedString("contents.blocks");
                Icon icon = HelpIcon.BLOCK.getIcon();
                ContentsDataParser.parseRefCategoryFile(productHelpTreeItem, string2, string, string4, icon);
            } else {
                ContentsDataParser.parseHelpTocReferenceFile(productHelpTreeItem, string, string2);
            }
        }
    }

    private static void parseRefCategoryFile(ProductHelpTreeItem productHelpTreeItem, String string, String string2, String string3, Icon icon) {
        String string4 = new File(string2, string).getAbsolutePath();
        String string5 = HelpUtils.getLocalizedFilename(string4);
        ReferenceContainerItem referenceContainerItem = new ReferenceContainerItem(string3, icon, productHelpTreeItem.getProduct(), string5);
        referenceContainerItem.populate();
        if (referenceContainerItem.getFilename() != null) {
            ContentsDataParser.registerItem(referenceContainerItem, string2, referenceContainerItem.getFilename());
        }
        if (referenceContainerItem.getChildCount() > 0) {
            productHelpTreeItem.addChild(referenceContainerItem);
            referenceContainerItem.setParent(productHelpTreeItem.getTreeNode());
            ContentsDataParser.correctAndRegisterReferenceItems(referenceContainerItem, string2);
        }
    }

    private static void parseHelpTocReferenceFile(HelpTreeItem helpTreeItem, String string, String string2) {
        string2 = string2.replace('\\', '/');
        String string3 = null;
        if (string2.contains("/")) {
            string3 = string2.substring(0, string2.lastIndexOf(47));
        }
        String string4 = new File(string, string2).getAbsolutePath();
        String string5 = HelpUtils.getLocalizedFilename(string4);
        try {
            Document document = ContentsDataParser.getDomDocument(string5);
            Node node = document.getFirstChild();
            if (node.getNodeName().equalsIgnoreCase("toc")) {
                ContentsDataParser.addChildrenToModel(node, helpTreeItem, string, string3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void correctAndRegisterReferenceItems(MutableTreeNode mutableTreeNode, String string) {
        Enumeration<? extends TreeNode> enumeration = mutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            MutableTreeNode mutableTreeNode2 = (MutableTreeNode)enumeration.nextElement();
            if (mutableTreeNode2.getAllowsChildren() && mutableTreeNode2.getChildCount() == 0) {
                mutableTreeNode.remove(mutableTreeNode2);
                continue;
            }
            ReferenceItem referenceItem = (ReferenceItem)HelpTreeUtils.getItemForTreeNode(mutableTreeNode2);
            ContentsDataParser.registerItem(mutableTreeNode2, string, referenceItem.getFilename());
            ContentsDataParser.correctAndRegisterReferenceItems(mutableTreeNode2, string);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void parseDemoItem(String string, ProductHelpTreeItem productHelpTreeItem, String string2) {
        String string3;
        if (string.contains("$")) {
            if (!Matlab.isMatlabAvailable()) return;
            string3 = ProductInfoUtils.getToolboxDirectory(string);
        } else {
            string3 = new File(string2, string).getAbsolutePath();
        }
        DemoTreeItem demoTreeItem = DemosData.getItemForXmlFile(string3);
        if (demoTreeItem == null || !DemoInfoUtils.getDemoProductFullName(demoTreeItem).equals(productHelpTreeItem.getProduct())) return;
        demoTreeItem.setParent(productHelpTreeItem.getTreeNode());
        demoTreeItem.setLabel(HelpUtils.getLocalizedString("contents.demos_node"));
        productHelpTreeItem.addChild(demoTreeItem);
        ContentsData.registerProductDemoItem(demoTreeItem);
    }
}

