/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.html.CharsetDetectionStrategy;
import com.mathworks.html.HtmlActions;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.PageChangedListener;
import com.mathworks.html.StatusTextListener;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.help.CSHelpTopicMap;
import com.mathworks.mlwidgets.help.HelpInfo;
import com.mathworks.mlwidgets.help.HelpInfoItem;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mlwidgets.help.ReferencePageInfo;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.mlwidgets.html.HtmlActionsToolBar;
import com.mathworks.mlwidgets.html.HtmlComponentFactory;
import com.mathworks.mlwidgets.html.HtmlConversionUtils;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.util.FileUtils;
import java.awt.BorderLayout;
import java.io.UnsupportedEncodingException;
import javax.swing.JToolBar;

public class ClassicHelpPanel
extends MJPanel {
    private HtmlComponent fHtmlComponent;
    private JToolBar fToolbar;
    private boolean fSuppressLoadForCurrentLocation = false;

    public ClassicHelpPanel() {
        this(new HtmlComponentFactory.HtmlComponentType[0]);
    }

    public ClassicHelpPanel(HtmlComponentFactory.HtmlComponentType ... htmlComponentTypeArray) {
        this.setLayout(new BorderLayout());
        if (htmlComponentTypeArray.length == 0) {
            htmlComponentTypeArray = new HtmlComponentFactory.HtmlComponentType[]{HtmlComponentFactory.HtmlComponentType.FOLLOW_PREFERENCE, HtmlComponentFactory.HtmlComponentType.CHROMIUM, HtmlComponentFactory.HtmlComponentType.HTMLPANEL, HtmlComponentFactory.HtmlComponentType.HTMLRENDERER};
        }
        this.fHtmlComponent = HtmlComponentFactory.buildHtmlComponent(htmlComponentTypeArray);
        HtmlConversionUtils.useSystemBrowserForExternalLinks(this.fHtmlComponent);
        HtmlConversionUtils.setFileNotFoundTemplate(this.fHtmlComponent, HTMLUtils.getLocalizedClassicDocFilename(Matlab.matlabRoot() + "/toolbox/local/helperr.html"));
        this.add(this.fHtmlComponent.getComponent(), "Center");
    }

    public HtmlComponent getHTMLRenderer() {
        return this.fHtmlComponent;
    }

    public String getTitle() {
        return this.fHtmlComponent.getTitle();
    }

    public void addPageChangedListener(PageChangedListener pageChangedListener) {
        this.fHtmlComponent.addPageChangedListener(pageChangedListener);
    }

    public void removePageChangedListener(PageChangedListener pageChangedListener) {
        this.fHtmlComponent.removePageChangedListener(pageChangedListener);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.fHtmlComponent.getComponent().setVisible(bl);
    }

    public void dispose() {
        this.fHtmlComponent.dispose();
    }

    public void addToolbar() {
        this.addToolbar((JToolBar)((Object)new HtmlActionsToolBar(this.fHtmlComponent.getActions())));
    }

    public void addToolbar(JToolBar jToolBar) {
        if (this.fToolbar != null) {
            this.remove(this.fToolbar);
        }
        this.fToolbar = jToolBar;
        jToolBar.setFloatable(false);
        this.add(jToolBar, "North");
    }

    public void removeToolbar() {
        if (this.fToolbar != null) {
            this.remove(this.fToolbar);
        }
    }

    public void setSuppressLoadForCurrentLocation(boolean bl) {
        this.fSuppressLoadForCurrentLocation = bl;
    }

    public void setCurrentLocation(String string) {
        String string2 = HelpUtils.getPrefixForHtmlPath(string);
        string2 = ClassicHelpPanel.encodeUrlIfNecessary(string2);
        if (this.fSuppressLoadForCurrentLocation && HTMLUtils.compareFiles(string2, this.fHtmlComponent.getCurrentLocation())) {
            return;
        }
        this.fHtmlComponent.setCurrentLocation(string2);
    }

    public void setCurrentLocationAndHighlightKeywords(String string, String[] stringArray) {
        this.setCurrentLocationAndHighlightKeywords(string, CharsetDetectionStrategy.getDefaultCharsetStrategy(), stringArray);
    }

    public void setCurrentLocationAndHighlightKeywords(String string, CharsetDetectionStrategy charsetDetectionStrategy, String[] stringArray) {
        String string2 = HelpUtils.getPrefixForHtmlPath(string);
        if (FileUtils.fileExists((String)string2) && HTMLUtils.needsEncoding(string2)) {
            string2 = "file:///" + string2;
            string2 = string2.replaceAll("\\\\", "/");
        }
        string2 = ClassicHelpPanel.encodeUrlIfNecessary(string2);
        this.fHtmlComponent.setCurrentLocation(string2);
    }

    public boolean showHelpPage(String string, String string2) {
        String string3;
        HelpInfoItem helpInfoItem = HelpInfo.getHelpInfoItemByShortName(string);
        if (helpInfoItem != null && (string3 = HelpUtils.getProductHelpPage(helpInfoItem, string2)) != null) {
            this.setCurrentLocation(string3);
            return true;
        }
        return false;
    }

    public boolean showHelpPageForFullProductName(String string, String string2) {
        String string3;
        HelpInfoItem helpInfoItem = HelpInfo.getHelpInfoItemByName(string);
        if (helpInfoItem != null && (string3 = HelpUtils.getProductHelpPage(helpInfoItem, string2)) != null) {
            this.setCurrentLocation(string3);
            return true;
        }
        return false;
    }

    public void showHelpPageAndHighlightKeywords(String string, String string2, String[] stringArray) {
        this.showHelpPageAndHighlightKeywords(string, string2, CharsetDetectionStrategy.getDefaultCharsetStrategy(), stringArray);
    }

    public void showHelpPageAndHighlightKeywords(String string, String string2, CharsetDetectionStrategy charsetDetectionStrategy, String[] stringArray) {
        HelpInfoItem helpInfoItem = HelpInfo.getHelpInfoItemByShortName(string);
        if (helpInfoItem != null) {
            String string3 = HelpUtils.getProductHelpPage(helpInfoItem, string2);
            this.setCurrentLocationAndHighlightKeywords(string3, charsetDetectionStrategy, stringArray);
        }
    }

    public boolean showProductPage(String string) {
        String string2;
        if (string != null && string.length() != 0 && (string2 = HelpInfo.getProductPageForShortName(string)) != null) {
            this.setCurrentLocation(string2);
            return true;
        }
        return false;
    }

    public boolean showReferencePage(String string) {
        return this.showReferencePage(string, false);
    }

    public boolean showReferencePage(String string, boolean bl) {
        ReferencePageInfo[] referencePageInfoArray = HelpInfo.getAllReferencePageUrls(string, bl);
        if (referencePageInfoArray != null && referencePageInfoArray.length > 0) {
            this.fHtmlComponent.setCurrentLocation(referencePageInfoArray[0].getFullUrl());
            return true;
        }
        return false;
    }

    public void addMouseOverLinkListener(StatusTextListener statusTextListener) {
        this.fHtmlComponent.addStatusTextListener(statusTextListener);
    }

    public void removeMouseOverLinkListener(StatusTextListener statusTextListener) {
        this.fHtmlComponent.removeStatusTextListener(statusTextListener);
    }

    public String getCurrentLocation() {
        return this.fHtmlComponent.getCurrentLocation();
    }

    public void setHtmlText(String string) {
        this.fHtmlComponent.setHtmlText(string);
    }

    public void setHtmlTextAndHighlightKeywords(String string, String[] stringArray) {
        this.fHtmlComponent.setHtmlText(string);
    }

    public String getHtmlText() {
        return this.fHtmlComponent.getHtmlText();
    }

    public void displayTopic(String string, String string2) {
        if (string != null) {
            CSHelpTopicMap cSHelpTopicMap = new CSHelpTopicMap(string);
            this.doDisplayTopic(cSHelpTopicMap, string2);
        }
    }

    private void doDisplayTopic(CSHelpTopicMap cSHelpTopicMap, String string) {
        if (cSHelpTopicMap.exists()) {
            String string2 = cSHelpTopicMap.mapID(string);
            if (string2 != null) {
                this.setCurrentLocation(string2);
            } else {
                HtmlConversionUtils.setFileNotFoundText(this.fHtmlComponent, string + " in " + cSHelpTopicMap.getFilePath());
            }
        } else {
            HtmlConversionUtils.setFileNotFoundText(this.fHtmlComponent, cSHelpTopicMap.getFilePath());
        }
    }

    public boolean placeFocusInBrowser() {
        return this.fHtmlComponent != null && this.fHtmlComponent.getComponent().requestFocusInWindow();
    }

    public boolean canExecuteScripts() {
        return true;
    }

    public boolean canModifyDom() {
        return false;
    }

    public void executeScript(String string) {
        this.fHtmlComponent.executeScript(string);
    }

    public String executeScriptWithReturn(String string) {
        assert (false);
        return null;
    }

    public void setElementText(String string, String string2) {
        assert (false);
    }

    public String getElementText(String string) {
        assert (false);
        return null;
    }

    private static String encodeUrlIfNecessary(String string) {
        block3: {
            if (HTMLUtils.needsEncoding(string)) {
                try {
                    return HTMLUtils.encodeUrl(string, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)"We should always be able to encode URLs using UTF-8");
                }
            }
        }
        return string;
    }

    public HtmlActions getActions() {
        return this.fHtmlComponent.getActions();
    }

    public void clearBrowser() {
        this.fHtmlComponent.setHtmlText("");
    }
}

