/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.help.helpui.DocConfig;
import com.mathworks.help.helpui.DocPage;
import com.mathworks.help.helpui.DocUrlNavigationRule;
import com.mathworks.help.helpui.DocUrlParser;
import com.mathworks.help.helpui.DocUrlType;
import com.mathworks.html.CustomProtocolUrl;
import com.mathworks.html.FileUrl;
import com.mathworks.html.RelativeUrl;
import com.mathworks.html.Url;
import com.mathworks.html.UrlBuilder;
import com.mathworks.html.UrlReplacer;
import com.mathworks.html.WebUrl;
import com.mathworks.mlwidgets.help.DocCenterDocConfig;
import java.net.MalformedURLException;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassicDocConversionDocUrlRule
implements DocUrlNavigationRule {
    private static final Map<String, String> TO_REPLACE = new LinkedHashMap<String, String>();

    public <T extends Url> void apply(UrlBuilder<T> urlBuilder, DocUrlType docUrlType) {
        if (docUrlType == DocUrlType.CONTENT) {
            Url url = new PathConverter().transformUrl(urlBuilder.toUrl());
            urlBuilder.rewrite(url, EnumSet.of(Url.UrlPart.BASE));
        }
    }

    private static <T extends Url> T convertClassicDocPath(DocConfig<T> docConfig, T t) {
        RelativeUrl relativeUrl;
        DocPage docPage = ClassicDocConversionDocUrlRule.toDocPageUnderDocRoot(docConfig, t);
        if (docPage != null && docPage.getDocSetItem() == null && (relativeUrl = docPage.getRelativeUrl()) != null) {
            String string;
            String string2 = string = relativeUrl.getRelativePath();
            for (Map.Entry<String, String> entry : TO_REPLACE.entrySet()) {
                string2 = ClassicDocConversionDocUrlRule.replaceDirectoryNameInPath(string2, entry.getKey(), entry.getValue());
            }
            if (!string2.equals(string)) {
                RelativeUrl relativeUrl2 = new RelativeUrl(string2, t.getParameters(), t.getTarget());
                return (T)docConfig.getDocRoot().buildGlobalPageUrl(relativeUrl2);
            }
        }
        return t;
    }

    protected static <T extends Url> DocPage toDocPageUnderDocRoot(DocConfig<T> docConfig, T t) {
        DocUrlParser docUrlParser = docConfig.getDocUrlParser();
        return docUrlParser.resolveUnderDocRoot(t);
    }

    private static String replaceDirectoryNameInPath(String string, String string2, String string3) {
        String string4 = string.replace('\\', '/');
        Pattern pattern = Pattern.compile("(<=/|^)" + Pattern.quote(string2) + "(?=/|$)");
        Matcher matcher = pattern.matcher(string4);
        if (matcher.find()) {
            String string5 = string3 != null ? string3 : "";
            return matcher.replaceFirst(string5);
        }
        return string;
    }

    public <T extends Url> void remove(UrlBuilder<T> urlBuilder, DocUrlType docUrlType) {
    }

    static {
        TO_REPLACE.put("toolbox", null);
        TO_REPLACE.put("techdoc", "matlab");
        TO_REPLACE.put("base", null);
        TO_REPLACE.put("physmod/drive", "physmod/sdl/drive");
        TO_REPLACE.put("physmod/mech", "physmod/sm/mech");
        TO_REPLACE.put("physmod/powersys", "physmod/sps/powersys");
    }

    private static class PathConverter
    extends UrlReplacer {
        private PathConverter() {
        }

        protected WebUrl transformWebUrl(WebUrl webUrl) {
            try {
                DocCenterDocConfig<WebUrl> docCenterDocConfig = DocCenterDocConfig.getWebConfig();
                return (WebUrl)ClassicDocConversionDocUrlRule.convertClassicDocPath(docCenterDocConfig, (Url)webUrl);
            }
            catch (MalformedURLException malformedURLException) {
                return webUrl;
            }
        }

        protected FileUrl transformFileUrl(FileUrl fileUrl) {
            DocCenterDocConfig<FileUrl> docCenterDocConfig = DocCenterDocConfig.getLocalConfig();
            return (FileUrl)ClassicDocConversionDocUrlRule.convertClassicDocPath(docCenterDocConfig, (Url)fileUrl);
        }

        protected CustomProtocolUrl transformCustomProtocolUrl(CustomProtocolUrl customProtocolUrl) {
            return customProtocolUrl;
        }
    }
}

