/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.widgets.address;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mlwidgets.explorer.widgets.address.AddressBarButton;
import com.mathworks.mlwidgets.explorer.widgets.address.AddressBarButtonState;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.commons.lang.StringUtils;

final class AddressBarButtonPanel {
    private final List<AddressBarButton> fButtons = new ArrayList<AddressBarButton>();
    private final MJPanel fComponent = new MJPanel();
    private final PropertyChangeListener fChangeListener = new StateChangeListener();
    private Timer fUnhoverTimer;
    private int fGapIndex = -1;

    AddressBarButtonPanel() {
    }

    public void add(AddressBarButton addressBarButton) {
        this.fButtons.add(addressBarButton);
        addressBarButton.addPropertyChangeListener(this.fChangeListener);
        this.rebuild();
    }

    public void addGap() {
        if (this.fGapIndex > -1) {
            throw new IllegalStateException();
        }
        this.fGapIndex = this.fButtons.size();
    }

    public void removeAll() {
        for (AddressBarButton addressBarButton : this.fButtons) {
            addressBarButton.removePropertyChangeListener(this.fChangeListener);
        }
        this.fButtons.clear();
        this.fGapIndex = -1;
        this.rebuild();
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    private void rebuild() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.fButtons.size() + (this.fGapIndex == -1 ? 0 : 1); ++i) {
            if (i == this.fGapIndex) {
                arrayList.add("fill:0dlu:grow");
                continue;
            }
            arrayList.add("fill:d");
        }
        this.fComponent.removeAll();
        this.fComponent.setLayout((LayoutManager)new FormLayout(StringUtils.join((Object[])arrayList.toArray(), (String)","), "p"));
        CellConstraints cellConstraints = new CellConstraints();
        for (int i = 0; i < this.fButtons.size(); ++i) {
            this.fComponent.add((Component)this.fButtons.get(i).getComponent(), (Object)cellConstraints.xy(i >= this.fGapIndex && this.fGapIndex > -1 ? i + 2 : i + 1, 1));
        }
        this.fComponent.revalidate();
        this.fComponent.repaint();
    }

    private void setupUnhoverTimer() {
        if (this.fUnhoverTimer == null) {
            this.fUnhoverTimer = new Timer(250, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = false;
                    for (AddressBarButton addressBarButton : AddressBarButtonPanel.this.fButtons) {
                        if (addressBarButton.getState() != AddressBarButtonState.HOVERED) continue;
                        bl = true;
                        Point point = new Point(MouseInfo.getPointerInfo().getLocation());
                        SwingUtilities.convertPointFromScreen(point, addressBarButton.getComponent());
                        if (addressBarButton.getComponent().contains(point)) continue;
                        addressBarButton.setState(AddressBarButtonState.NORMAL);
                    }
                    if (!bl) {
                        AddressBarButtonPanel.this.fUnhoverTimer.stop();
                        AddressBarButtonPanel.this.fUnhoverTimer = null;
                    }
                }
            });
            this.fUnhoverTimer.setRepeats(true);
            this.fUnhoverTimer.start();
        }
    }

    private class StateChangeListener
    implements PropertyChangeListener {
        private boolean fSuppressReaction;

        private StateChangeListener() {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (!StateChangeListener.this.fSuppressReaction) {
                        StateChangeListener.this.fSuppressReaction = true;
                        try {
                            AddressBarButton addressBarButton = (AddressBarButton)propertyChangeEvent.getSource();
                            for (AddressBarButton addressBarButton2 : AddressBarButtonPanel.this.fButtons) {
                                if (addressBarButton2.equals(addressBarButton) || addressBarButton2.getState() != AddressBarButtonState.HOVERED) continue;
                                addressBarButton2.setState(AddressBarButtonState.NORMAL);
                            }
                            if (addressBarButton.getState() == AddressBarButtonState.HOVERED) {
                                AddressBarButtonPanel.this.setupUnhoverTimer();
                            }
                        }
                        finally {
                            StateChangeListener.this.fSuppressReaction = false;
                        }
                    }
                }
            });
        }
    }
}

