/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.util;

import com.mathworks.jmi.AWTUtilities;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.explorer.util.MatlabThreadContext;
import com.mathworks.util.Holder;
import com.mathworks.util.ReturnRunnable;
import java.io.File;
import java.lang.reflect.InvocationTargetException;

public final class MatlabUtils {
    private static MatlabThreadContext sThreadContext = new MatlabThreadContext();
    private static Matlab sMatlab = new Matlab();

    private MatlabUtils() {
    }

    static MatlabThreadContext getMatlabThreadContext() {
        return sThreadContext;
    }

    public static void invokeAndWait(Runnable runnable) {
        try {
            AWTUtilities.invokeAndWait((Runnable)runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalStateException(invocationTargetException);
        }
        catch (Throwable throwable) {
            throw new IllegalStateException(throwable);
        }
    }

    public static <T> T invokeAndWait(final ReturnRunnable<T> returnRunnable) {
        final Holder holder = new Holder();
        MatlabUtils.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                holder.set(returnRunnable.run());
            }
        });
        return (T)holder.get();
    }

    public static void evalAndWaitInLocation(File file, String string) {
        if (string.endsWith(";")) {
            string = string.substring(0, string.length() - 1);
        }
        try {
            sThreadContext.evalAndWait("feval(@(x, y) ( feval(@(v)true, builtin('cd', x)) && feval(@(v)true, " + string + ") " + "&& feval(@(v)true, builtin('cd', y))) " + ", '" + file.getAbsolutePath() + "', pwd); ", 0);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    public static void evalConsoleOutputAndWait(String string) {
        try {
            sThreadContext.evalConsoleOutputAndWait(string);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    public static Object evalAndWait(String string, int n) {
        try {
            return sThreadContext.evalAndWait(string, n);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    public static Object fevalAndWait(String string, int n, Object ... objectArray) {
        try {
            return sThreadContext.fevalAndWait(string, objectArray, n);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    public static Matlab getMatlab() {
        return sMatlab;
    }
}

