/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.table;

import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.services.settings.Setting;
import com.mathworks.services.settings.SettingAccessException;
import com.mathworks.services.settings.SettingNotFoundException;
import com.mathworks.services.settings.SettingTypeException;
import com.mathworks.services.settings.SettingValidationException;
import com.mathworks.util.ShutdownRuntimeException;
import com.mathworks.widgets.grouptable.Group;
import com.mathworks.widgets.grouptable.GroupingMode;
import com.mathworks.widgets.grouptable.GroupingTableColumn;
import com.mathworks.widgets.grouptable.GroupingTableConfiguration;
import com.mathworks.widgets.grouptable.TableConfigurationSerializer;
import com.mathworks.widgets.grouptable.VerticalAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class ExplorerTableConfigurationSerializer
implements TableConfigurationSerializer<FileSystemEntry> {
    private final Setting<String> fGroupColumnPref;
    private final Setting<String> fGroupModePref;
    private final Setting<String> fSortColumnPref;
    private final Setting<Boolean> fSortDescendingPref;
    private final Setting<String[]> fVisibleColumnsPref;
    private final Setting<String[]> fColumnOrderPref;
    private final Setting<String[]> fColumnSizesPref;
    private final Setting<String[]> fExpandedGroupsPref;
    private final Setting<String[]> fCollapsedGroupsPref;

    public ExplorerTableConfigurationSerializer(Setting<String> setting, Setting<String> setting2, Setting<String> setting3, Setting<Boolean> setting4, Setting<String[]> setting5, Setting<String[]> setting6, Setting<String[]> setting7, Setting<String[]> setting8, Setting<String[]> setting9) {
        this.fGroupColumnPref = setting;
        this.fGroupModePref = setting2;
        this.fSortColumnPref = setting3;
        this.fSortDescendingPref = setting4;
        this.fVisibleColumnsPref = setting5;
        this.fColumnOrderPref = setting6;
        this.fColumnSizesPref = setting7;
        this.fExpandedGroupsPref = setting8;
        this.fCollapsedGroupsPref = setting9;
    }

    public void save(GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        this.saveGroupMode(groupingTableConfiguration);
        this.saveSortMode(groupingTableConfiguration);
        this.saveVisibleColumns(groupingTableConfiguration);
        this.saveColumnOrder(groupingTableConfiguration);
        this.saveColumnSizes(groupingTableConfiguration);
        this.saveExpandedGroups(groupingTableConfiguration);
        this.saveCollapsedGroups(groupingTableConfiguration);
    }

    public void load(GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        this.loadGroupMode(groupingTableConfiguration);
        this.loadSortMode(groupingTableConfiguration);
        this.loadVisibleColumns(groupingTableConfiguration);
        this.loadColumnOrder(groupingTableConfiguration);
        this.loadColumnSizes(groupingTableConfiguration);
        this.loadExpandedGroups(groupingTableConfiguration);
        this.loadCollapsedGroups(groupingTableConfiguration);
    }

    private void saveGroupMode(GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        ExplorerTableConfigurationSerializer.setAPrefProperty(this.fGroupColumnPref, ExplorerTableConfigurationSerializer.getKeyToSave(groupingTableConfiguration.getGroupColumn()));
        ExplorerTableConfigurationSerializer.setAPrefProperty(this.fGroupModePref, ExplorerTableConfigurationSerializer.getKeyToSave(groupingTableConfiguration.getGroupMode()));
    }

    private void loadGroupMode(GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        GroupingTableColumn<FileSystemEntry> groupingTableColumn = ExplorerTableConfigurationSerializer.findColumn(groupingTableConfiguration, ExplorerTableConfigurationSerializer.getAPrefProperty(this.fGroupColumnPref));
        GroupingMode<FileSystemEntry> groupingMode = ExplorerTableConfigurationSerializer.findMode(groupingTableColumn, ExplorerTableConfigurationSerializer.getAPrefProperty(this.fGroupModePref));
        groupingTableConfiguration.setGroupMode(groupingTableColumn, groupingMode);
    }

    private void saveSortMode(GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        ExplorerTableConfigurationSerializer.setAPrefProperty(this.fSortColumnPref, ExplorerTableConfigurationSerializer.getKeyToSave(groupingTableConfiguration.getSortColumn()));
        ExplorerTableConfigurationSerializer.setAPrefProperty(this.fSortDescendingPref, groupingTableConfiguration.isSortedDescending());
    }

    private void loadSortMode(GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        GroupingTableColumn<FileSystemEntry> groupingTableColumn = ExplorerTableConfigurationSerializer.findColumn(groupingTableConfiguration, ExplorerTableConfigurationSerializer.getAPrefProperty(this.fSortColumnPref));
        if (groupingTableColumn != null) {
            groupingTableConfiguration.setSortColumnAndDescending(groupingTableColumn, ExplorerTableConfigurationSerializer.getAPrefProperty(this.fSortDescendingPref).booleanValue());
        }
    }

    private void saveVisibleColumns(GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        ArrayList arrayList = new ArrayList();
        for (VerticalAttribute verticalAttribute : groupingTableConfiguration.getAllVerticalAttributes()) {
            if (!groupingTableConfiguration.isVerticalAttributeOrColumnVisible(verticalAttribute)) continue;
            arrayList.add(verticalAttribute);
        }
        ExplorerTableConfigurationSerializer.setAPrefProperty(this.fVisibleColumnsPref, ExplorerTableConfigurationSerializer.getKeys(groupingTableConfiguration.getVisibleColumns(), arrayList));
    }

    private void loadVisibleColumns(GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        HashSet<Object> hashSet = new HashSet<Object>(Arrays.asList((Object[])ExplorerTableConfigurationSerializer.getAPrefProperty(this.fVisibleColumnsPref)));
        if (!hashSet.isEmpty()) {
            for (GroupingTableColumn groupingTableColumn : groupingTableConfiguration.getAllColumns()) {
                groupingTableConfiguration.setColumnVisible(groupingTableColumn, hashSet.contains(groupingTableColumn.getKey()));
            }
            for (GroupingTableColumn groupingTableColumn : groupingTableConfiguration.getAllVerticalAttributes()) {
                groupingTableConfiguration.setVerticalAttributeVisible((VerticalAttribute)groupingTableColumn, hashSet.contains(groupingTableColumn.getKey()));
            }
        }
    }

    private void saveColumnOrder(GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        ExplorerTableConfigurationSerializer.setAPrefProperty(this.fColumnOrderPref, ExplorerTableConfigurationSerializer.getKeys(groupingTableConfiguration.getAllColumns()));
    }

    private void loadColumnOrder(GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        String[] stringArray = ExplorerTableConfigurationSerializer.getAPrefProperty(this.fColumnOrderPref);
        if (stringArray.length > 0) {
            groupingTableConfiguration.setColumnDisplayOrderByKeys(Arrays.asList(stringArray));
        }
    }

    private void saveColumnSizes(GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        ExplorerTableConfigurationSerializer.setAPrefProperty(this.fColumnSizesPref, ExplorerTableConfigurationSerializer.getSizesToSave(groupingTableConfiguration, groupingTableConfiguration.getAllColumns()));
    }

    private void loadColumnSizes(GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        String[] stringArray = ExplorerTableConfigurationSerializer.getAPrefProperty(this.fColumnSizesPref);
        List list = groupingTableConfiguration.getAllColumns();
        HashMap hashMap = new HashMap();
        if (stringArray.length == list.size()) {
            for (int i = 0; i < stringArray.length; ++i) {
                hashMap.put(list.get(i), Integer.parseInt(stringArray[i]));
            }
        }
        groupingTableConfiguration.setColumnSizes(hashMap);
    }

    private void saveExpandedGroups(GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        ExplorerTableConfigurationSerializer.setAPrefProperty(this.fExpandedGroupsPref, ExplorerTableConfigurationSerializer.getGroupKeys(groupingTableConfiguration.getExpandedGroups()));
    }

    private void saveCollapsedGroups(GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        ExplorerTableConfigurationSerializer.setAPrefProperty(this.fCollapsedGroupsPref, ExplorerTableConfigurationSerializer.getGroupKeys(groupingTableConfiguration.getCollapsedGroups()));
    }

    private void loadExpandedGroups(GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        for (String string : ExplorerTableConfigurationSerializer.getAPrefProperty(this.fExpandedGroupsPref)) {
            groupingTableConfiguration.setExpanded(new Group(string, ""), true);
        }
    }

    private void loadCollapsedGroups(GroupingTableConfiguration<FileSystemEntry> groupingTableConfiguration) {
        for (String string : ExplorerTableConfigurationSerializer.getAPrefProperty(this.fCollapsedGroupsPref)) {
            groupingTableConfiguration.setExpanded(new Group(string, ""), false);
        }
    }

    private static <T> GroupingTableColumn<T> findColumn(GroupingTableConfiguration<T> groupingTableConfiguration, String string) {
        return string == null || string.trim().isEmpty() ? null : groupingTableConfiguration.getColumnByKey(string);
    }

    private static <T> GroupingMode<T> findMode(GroupingTableColumn<T> groupingTableColumn, String string) {
        return groupingTableColumn == null || string == null || string.trim().isEmpty() ? null : groupingTableColumn.getGroupingModeByKey(string);
    }

    private static <T> String getKeyToSave(GroupingTableColumn<T> groupingTableColumn) {
        return groupingTableColumn == null ? "" : groupingTableColumn.getKey();
    }

    private static <T> String getKeyToSave(GroupingMode<T> groupingMode) {
        return groupingMode == null ? "" : groupingMode.getKey();
    }

    private static <T> String[] getGroupKeys(Collection<Group<T>> collection) {
        String[] stringArray = new String[collection.size()];
        Iterator<Group<T>> iterator = collection.iterator();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = iterator.next().getKey();
        }
        return stringArray;
    }

    private static <T> String[] getKeys(List<GroupingTableColumn<T>> list) {
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = list.get(i).getKey();
        }
        return stringArray;
    }

    private static <T> String[] getKeys(List<GroupingTableColumn<T>> list, List<VerticalAttribute<T>> list2) {
        String[] stringArray = new String[list.size() + list2.size()];
        int n = 0;
        for (GroupingTableColumn<T> verticalAttribute : list) {
            stringArray[n++] = verticalAttribute.getKey();
        }
        for (VerticalAttribute verticalAttribute : list2) {
            stringArray[n++] = verticalAttribute.getKey();
        }
        return stringArray;
    }

    private static <T> String[] getSizesToSave(GroupingTableConfiguration<T> groupingTableConfiguration, List<GroupingTableColumn<T>> list) {
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            GroupingTableConfiguration.ColumnSize columnSize = groupingTableConfiguration.getColumnSize(list.get(i));
            stringArray[i] = columnSize.isConfigured() ? String.valueOf(columnSize.getSize()) : "0";
        }
        return stringArray;
    }

    public static <T> void setAPrefProperty(Setting<T> setting, T t) {
        try {
            setting.set(t);
        }
        catch (ShutdownRuntimeException | IllegalStateException throwable) {
        }
        catch (SettingAccessException | SettingNotFoundException | SettingTypeException | SettingValidationException throwable) {
            throw new IllegalStateException(throwable);
        }
    }

    public static <T> T getAPrefProperty(Setting<T> setting) {
        try {
            return (T)setting.get();
        }
        catch (ShutdownRuntimeException | IllegalStateException throwable) {
            return null;
        }
        catch (SettingNotFoundException | SettingTypeException throwable) {
            throw new IllegalStateException(throwable);
        }
    }
}

