/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.table;

import com.mathworks.matlab.api.explorer.CoreFileDecoration;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.model.table.FileSystemExpansionProvider;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.widgets.grouptable.VerticalAttribute;
import java.awt.Color;
import java.awt.Font;
import javax.swing.event.ChangeListener;

public final class DescriptionAttribute
implements VerticalAttribute<FileSystemEntry> {
    private static final Color COLOR = MJUtilities.isHighContrast() ? new Color(0x747474) : new Color(0x8B8B8B);
    private final FileSystemExpansionProvider fProvider;

    public DescriptionAttribute(FileSystemExpansionProvider fileSystemExpansionProvider) {
        this.fProvider = fileSystemExpansionProvider;
    }

    public String getKey() {
        return "description";
    }

    public String getName() {
        return ExplorerResources.getString("table.description");
    }

    public String getText(FileSystemEntry fileSystemEntry) {
        String string = (String)this.fProvider.getDecoration(fileSystemEntry, CoreFileDecoration.DESCRIPTION);
        if (string != null && string.length() > 120) {
            return string.substring(0, 119);
        }
        return string;
    }

    public Color getForegroundColor() {
        return COLOR;
    }

    public Font getFont() {
        return null;
    }

    public boolean shouldShowWhenCollapsed(FileSystemEntry fileSystemEntry) {
        return !fileSystemEntry.isFolder();
    }

    public boolean shouldShowInColumnWhenWide() {
        return true;
    }

    public void addDisplayChangeListener(ChangeListener changeListener) {
    }

    public void removeDisplayChangeListener(ChangeListener changeListener) {
    }
}

