/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.matlab;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.mlwidgets.explorer.extensions.matlab.Variable;
import com.mathworks.mlwidgets.explorer.model.ExplorerPrefs;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.util.MatlabThreadContext;
import com.mathworks.mlwidgets.explorer.util.MatlabUtils;
import com.mathworks.mlwidgets.prefs.ConfirmationDialogPrefsPanel;
import com.mathworks.mlwidgets.workspace.WorkspaceCommands;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.FileSystemUtils;
import com.mathworks.util.NativeJava;
import com.mathworks.widgets.Dialogs;
import com.mathworks.widgets.datatransfer.MATFileVariableReference;
import com.mathworks.widgets.datatransfer.SimpleVariableDefinition;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import javax.swing.SwingUtilities;

public final class MATFileUtils {
    private static boolean sNativeLibUnavailable = false;

    private MATFileUtils() {
    }

    public static List<Variable> getVariables(File file) {
        return MATFileUtils.dump(file.getAbsolutePath());
    }

    public static List<Variable> getWorkspaceVariables() {
        return MATFileUtils.dump("global");
    }

    private static List<Variable> dump(String string) {
        Vector<Variable> vector = new Vector<Variable>();
        Object object = MatlabUtils.fevalAndWait("projdumpmat", 1, string);
        if (object instanceof Object[] && ((Object[])object).length == 2 && ((Object[])object)[1] instanceof Object[]) {
            Object[] objectArray;
            for (Object object2 : objectArray = (Object[])((Object[])object)[1]) {
                if (!(object2 instanceof Object[])) continue;
                Object[] objectArray2 = (Object[])object2;
                vector.add(new Variable(objectArray2[0].toString(), objectArray2[2].toString(), objectArray2[1].toString()));
            }
        }
        return vector;
    }

    public static String[] getNames(List<Variable> list) {
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = list.get(i).getName();
        }
        return stringArray;
    }

    public static String[] getReferenceVariableNames(List<MATFileVariableReference> list) {
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = list.get(i).getVariableName();
        }
        return stringArray;
    }

    public static String[] getVariableNames(List<SimpleVariableDefinition> list) {
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = list.get(i).getVariable();
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void read(File file, AsyncReceiver<Variable> asyncReceiver) {
        block7: {
            long l = 0L;
            try {
                Variable variable;
                String string = NativeJava.getNormalizedWindowsPath((File)file);
                if (sNativeLibUnavailable || (l = MATFileUtils.nativeOpen(string)) == 0L) break block7;
                do {
                    if ((variable = MATFileUtils.nativeGetNext(l, new StringFunctionInvoker(){

                        @Override
                        public String invoke(Object object) {
                            try {
                                Object[] objectArray = new Object[]{"num2complex", object};
                                Object object2 = NativeMatlab.nativeIsMatlabThread() ? Matlab.mtFeval((String)"workspacefunc", (Object[])objectArray, (int)1) : new MatlabThreadContext().fevalAndWait("workspacefunc", objectArray, 1);
                                return object2.toString();
                            }
                            catch (Exception exception) {
                                return "";
                            }
                        }
                    })) != null) continue;
                    break;
                } while (asyncReceiver.receive((Object)variable));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            finally {
                if (l != 0L) {
                    MATFileUtils.nativeClose(l);
                }
                asyncReceiver.finished();
            }
        }
    }

    private static native long nativeOpen(String var0);

    private static native long nativeClose(long var0);

    private static native Variable nativeGetNext(long var0, StringFunctionInvoker var2);

    public static void load(File file) {
        WorkspaceCommands.importDataMat(file);
    }

    public static void load(File file, String[] stringArray) {
        WorkspaceCommands.importDataMat(file, stringArray);
    }

    public static void save(Component component, File file) {
        MATFileUtils.save(component, file, null, false);
    }

    public static void save(Component component, File file, String[] stringArray, boolean bl) {
        Refresher refresher = new Refresher(file);
        WorkspaceCommands.saveVariables(stringArray, file, (Frame)SwingUtilities.windowForComponent(component), true, refresher);
        if (bl) {
            try {
                refresher.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static boolean confirmOverwriteFileIfNecessary(Component component, List<SimpleVariableDefinition> list, File file) {
        return MATFileUtils.confirmIfNecessary(component, MATFileUtils.getVariableNames(list), MATFileUtils.getNames(MATFileUtils.getVariables(file)), file, "matconfirm.prompt", "matconfirm.title", ExplorerPrefs.CONFIRM_MAT_REPLACE.getKey());
    }

    public static boolean confirmOverwriteWorkspaceIfNecessary(Component component, MATFileVariableReference[] mATFileVariableReferenceArray) {
        return mATFileVariableReferenceArray.length == 0 || MATFileUtils.confirmIfNecessary(component, MATFileUtils.getNames(MATFileUtils.getWorkspaceVariables()), MATFileUtils.getReferenceVariableNames(Arrays.asList(mATFileVariableReferenceArray)), mATFileVariableReferenceArray[0].getFile(), "matwsconfirm.prompt", "matconfirm.title", ExplorerPrefs.CONFIRM_MAT_WORKSPACE_REPLACE.getKey());
    }

    private static boolean confirmIfNecessary(Component component, String[] stringArray, String[] stringArray2, File file, String string, String string2, String string3) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Arrays.asList(stringArray));
        for (String string4 : stringArray2) {
            if (!hashSet.contains(string4)) continue;
            String string5 = MessageFormat.format(ExplorerResources.getString(string), file.getName());
            int n = Dialogs.showOptionalConfirmDialog((Component)component, (Object)string5, (String)ExplorerResources.getString(string2), (int)2, (int)2, (String)string3, (int)0, (boolean)true);
            return n == 0;
        }
        return true;
    }

    public static ConfirmationDialogPrefsPanel.DialogItem[] getDialogItems() {
        return new ConfirmationDialogPrefsPanel.DialogItem[]{new ConfirmationDialogPrefsPanel.DialogItem(ExplorerResources.getString("matconfirm.desc"), ExplorerPrefs.CONFIRM_MAT_REPLACE.getKey(), ExplorerResources.getString("title"), true), new ConfirmationDialogPrefsPanel.DialogItem(ExplorerResources.getString("matconfirm.ws.desc"), ExplorerPrefs.CONFIRM_MAT_WORKSPACE_REPLACE.getKey(), ExplorerResources.getString("title"), true)};
    }

    static {
        try {
            System.loadLibrary("nativemat");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            sNativeLibUnavailable = true;
        }
    }

    public static class Refresher
    implements MatlabListener {
        private final File fFile;
        private final CountDownLatch fLatch;

        public Refresher(File file) {
            this.fFile = file;
            this.fLatch = new CountDownLatch(1);
        }

        public void matlabEvent(MatlabEvent matlabEvent) {
            if (Matlab.getExecutionStatus((int)matlabEvent.getStatus()) == 0) {
                FileSystemUtils.getFileSystemNotifier().changed(this.fFile);
            }
            this.fLatch.countDown();
        }

        void await() throws InterruptedException {
            this.fLatch.await();
        }
    }

    private static interface StringFunctionInvoker {
        public String invoke(Object var1);
    }
}

