/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.matlab;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.MLFileUtils;
import com.mathworks.jmi.Matlab;
import com.mathworks.matlab.api.explorer.ActionConfiguration;
import com.mathworks.matlab.api.explorer.ActionDefinition;
import com.mathworks.matlab.api.explorer.ActionInput;
import com.mathworks.matlab.api.explorer.ActionProvider;
import com.mathworks.matlab.api.explorer.ActionRegistry;
import com.mathworks.matlab.api.explorer.FileDecorations;
import com.mathworks.matlab.api.explorer.FileDecorators;
import com.mathworks.matlab.api.explorer.FileInfoProvider;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.SelectionMode;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.matlab.api.explorer.StatusRunnable;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.model.actions.ActionPredicates;
import com.mathworks.mlwidgets.explorer.model.actions.CoreMenuSection;
import com.mathworks.mlwidgets.explorer.util.MLFileSystemUtils;
import com.mathworks.util.Predicate;
import java.io.IOException;
import java.util.ArrayList;

public class GUIDEFileInfoProvider
implements FileInfoProvider,
ActionProvider {
    private static final Matlab sMatlab = new Matlab();
    private static final ActionDefinition sOpenInGuideAction = new ActionDefinition("context.openInGuide", CoreMenuSection.OPEN.getSection(), ExplorerResources.getString("context.openInGuide"));

    public boolean isApplicable(FileSystemEntry fileSystemEntry) {
        return !fileSystemEntry.isFolder() && MLFileUtils.isFigFile((String)fileSystemEntry.getLocation().toString());
    }

    public void configureDecorations(FileSystemEntry fileSystemEntry, FileDecorators fileDecorators, FileDecorations fileDecorations) {
    }

    public void configureActions(ActionRegistry actionRegistry) {
        ActionConfiguration actionConfiguration = actionRegistry.defineAction(sOpenInGuideAction);
        actionConfiguration.setEnabled((Predicate)ActionPredicates.ALL_FIGURE_FILES);
        actionConfiguration.setCode(SelectionMode.EXPLICIT_MULTIPLE_FILE_SELECTION, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                ArrayList<Status> arrayList = new ArrayList<Status>();
                for (FileSystemEntry fileSystemEntry : actionInput.getSelection()) {
                    Status status = new Status(ExplorerResources.getString("progress.open.guide"), true);
                    arrayList.add(status);
                    GUIDEFileInfoProvider.openInGuide(fileSystemEntry, status);
                }
                return new Status(arrayList);
            }
        });
    }

    private static void openInGuide(FileSystemEntry fileSystemEntry, final Status status) {
        try {
            fileSystemEntry = fileSystemEntry.getSystem().followShortcutOrLink(fileSystemEntry);
            fileSystemEntry = MLFileSystemUtils.getMatlabAccessibleEntry(fileSystemEntry);
            sMatlab.evalConsoleOutput("guide('" + fileSystemEntry.getLocation().toString() + "')", new CompletionObserver(){

                public void completed(int n, Object object) {
                    status.markCompleted();
                }
            });
        }
        catch (IOException iOException) {
            status.markCompleted();
        }
    }
}

