/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.basic;

import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class ImageFileDetailPanelData {
    private final FileSystemEntry fFile;

    public ImageFileDetailPanelData(FileSystemEntry fileSystemEntry) throws IOException {
        this.fFile = fileSystemEntry;
    }

    FileSystemEntry getFile() {
        return this.fFile;
    }

    private static ImageReader getImageReaderForExtension(FileLocation fileLocation) {
        ImageReader imageReader = null;
        Iterator<ImageReader> iterator = ImageIO.getImageReadersBySuffix(fileLocation.getExtension());
        if (iterator.hasNext()) {
            imageReader = iterator.next();
        }
        return imageReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getOriginalImageDimension() {
        Dimension dimension = null;
        ImageInputStream imageInputStream = null;
        ImageReader imageReader = ImageFileDetailPanelData.getImageReaderForExtension(this.fFile.getLocation());
        try {
            if (imageReader != null) {
                imageInputStream = new MemoryCacheImageInputStream(this.fFile.getSystem().getInputStream(this.fFile.getLocation()));
                imageReader.setInput(imageInputStream);
                dimension = new Dimension(imageReader.getWidth(0), imageReader.getHeight(0));
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (imageInputStream != null) {
                    imageInputStream.close();
                }
            }
            catch (Exception exception) {}
            if (imageReader != null) {
                imageReader.dispose();
            }
        }
        return dimension;
    }

    static class ImageSubSampleReader {
        private Dimension iImageDimension = new Dimension(0, 0);
        private int iSampleRate = 1;
        private BufferedImage iSampledImage;
        private final Dimension iContainerDimension;
        private static final int HEIGHT_BUFFER = 55;
        private static final int WIDTH_BUFFER = 25;
        private static final int MIN_EDGE_LENGTH = 150;

        ImageSubSampleReader(Dimension dimension) {
            this.iContainerDimension = ImageSubSampleReader.processContainerDimension(dimension);
        }

        private static Dimension processContainerDimension(Dimension dimension) {
            dimension.height -= 55;
            dimension.width -= 25;
            return ImageSubSampleReader.returnMinimumDimensionIfNeeded(dimension);
        }

        private static Dimension returnMinimumDimensionIfNeeded(Dimension dimension) {
            if (dimension.getHeight() < 150.0 || dimension.getWidth() < 150.0) {
                int n = dimension.getHeight() < 150.0 ? 150 : (int)dimension.getHeight();
                int n2 = dimension.getWidth() < 150.0 ? 150 : (int)dimension.getWidth();
                return new Dimension(n2, n);
            }
            return dimension;
        }

        public void readSampledImage(FileSystemEntry fileSystemEntry) throws IOException {
            ImageInputStream imageInputStream = null;
            ImageReader imageReader = null;
            try {
                imageReader = ImageFileDetailPanelData.getImageReaderForExtension(fileSystemEntry.getLocation());
                if (imageReader != null) {
                    imageInputStream = new MemoryCacheImageInputStream(fileSystemEntry.getSystem().getInputStream(fileSystemEntry.getLocation()));
                    imageReader.setInput(imageInputStream, true, true);
                    this.setImageDimension(new Dimension(imageReader.getWidth(0), imageReader.getHeight(0)));
                    this.configureSamplingRateBasedOnContainerDimension();
                    ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
                    imageReadParam.setSourceSubsampling(this.getSampleRate(), this.getSampleRate(), 0, 0);
                    this.iSampledImage = imageReader.read(0, imageReadParam);
                }
            }
            catch (RuntimeException runtimeException) {
                throw new IOException(runtimeException);
            }
            finally {
                if (imageInputStream != null) {
                    imageInputStream.close();
                }
                if (imageReader != null) {
                    imageReader.dispose();
                }
            }
        }

        public Dimension getIdealDimension() {
            int n;
            int n2;
            Dimension dimension = this.getContainerDimension();
            Dimension dimension2 = this.getImageDimension();
            int n3 = dimension2.width - dimension.width;
            int n4 = dimension2.height - dimension.height;
            if (n4 <= 0 && n3 <= 0) {
                return dimension2;
            }
            if ((double)dimension2.width / (double)dimension.width > (double)dimension2.height / (double)dimension.height) {
                n2 = dimension.width;
                n = (int)((double)n2 * ((double)dimension2.height / (double)dimension2.width));
            } else {
                n = dimension.height;
                n2 = (int)((double)n * ((double)dimension2.width / (double)dimension2.height));
            }
            return new Dimension(n2, n);
        }

        private int getSampleRate() {
            return this.iSampleRate;
        }

        private void setSampleRate(int n) {
            this.iSampleRate = n;
        }

        private Dimension getImageDimension() {
            return this.iImageDimension;
        }

        private void setImageDimension(Dimension dimension) {
            this.iImageDimension = dimension;
        }

        public BufferedImage getSampledImage() {
            return this.iSampledImage;
        }

        private Dimension getContainerDimension() {
            return this.iContainerDimension;
        }

        public void configureSamplingRateBasedOnContainerDimension() {
            if (!(this.getContainerDimension().getHeight() > (double)this.getImageDimension().height) || !(this.getContainerDimension().getWidth() > (double)this.getImageDimension().width)) {
                double d;
                int n;
                double d2 = this.getImageDimension().getHeight() / Math.abs(this.getContainerDimension().getHeight()) + 0.25;
                this.setSampleRate(n + ((n = (int)Math.round(Math.max(d2, d = this.getImageDimension().getWidth() / Math.abs(this.getContainerDimension().getWidth()) + 0.25)) - 1) <= 1 ? 1 : 0));
            }
        }
    }
}

