/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.examples;

import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.examples.ConfigDependencyProvider;
import com.mathworks.mlwidgets.examples.ExamplePrefs;
import com.mathworks.mlwidgets.examples.Platform;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.product.util.ProductIdentifier;
import com.mathworks.services.lmgr.JNIException;
import com.mathworks.services.lmgr.NativeLmgr;
import java.io.File;
import java.util.Collection;
import java.util.Locale;

public class WebappConfigDependencyProvider
implements ConfigDependencyProvider {
    private static final String ALL_PRODUCTS = "all";

    @Override
    public String getProductList() {
        if (ExamplePrefs.getExampleGalleryShowInstalledPref()) {
            return this.getInstalledProducts();
        }
        return ALL_PRODUCTS;
    }

    @Override
    public String getMatlabRelease() {
        return HelpPrefs.DEFAULT_DOC_RELEASE;
    }

    @Override
    public String getLocale() {
        Locale locale = Locale.getDefault();
        return locale.toLanguageTag();
    }

    @Override
    public String getEntitlementId() {
        if (Matlab.isMatlabAvailable()) {
            File file = new File(Matlab.matlabRoot());
            Platform platform = Platform.getPlatform();
            String string = String.format("bin/%s/", platform.toString().toLowerCase(Locale.ENGLISH));
            File file2 = new File(file, string);
            try {
                NativeLmgr nativeLmgr = new NativeLmgr(file2.getAbsolutePath());
                return nativeLmgr.getEntitlementId();
            }
            catch (JNIException jNIException) {
                // empty catch block
            }
        }
        return "";
    }

    @Override
    public String getExampleGalleryDomain() {
        return ExamplePrefs.getExampleGalleryDomain();
    }

    private String getInstalledProducts() {
        Collection<ProductIdentifier> collection = HelpPrefs.getInstalledProducts();
        StringBuilder stringBuilder = new StringBuilder();
        for (ProductIdentifier productIdentifier : collection) {
            stringBuilder.append(productIdentifier.getBaseCode());
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }
}

