/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.configeditor.data;

import com.jidesoft.grid.Property;
import com.jidesoft.introspector.BeanIntrospector;
import com.mathworks.mlwidgets.configeditor.ConfigurationUtils;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.Validate;

public class PublishOptions {
    private List<Property> fBeanProperties;
    private FileFormat fOutputFileFormat = PlatformFormatSupport.getCrossPlatformDefaultOutputFormat();
    private File fStyleSheet;
    private File fOutputLocation;
    private ImageFormat fImageFormat = ImageFormat.DEFAULT;
    private FigureCaptureMethod fFigureCaptureMethod = FigureCaptureMethod.ENTIREGUIWINDOW;
    private Boolean fUseNewFigure = true;
    private Integer fMaxWidth = -1;
    private Integer fMaxHeight = -1;
    private Boolean fShowCode = true;
    private Boolean fEvaluateCode = true;
    private Boolean fCatchError = true;
    private Boolean fCreateThumbnail = true;
    private Integer fMaxNumberOfOutputLines = -1;
    public static final String OUTPUT_FILE_FORMAT = "outputFileFormat";
    public static final String STYLE_SHEET = "styleSheet";
    public static final String OUTPUT_LOCATION = "outputLocation";
    public static final String IMAGE_FORMAT = "imageFormat";
    public static final String FIGURE_CAPTURE_METHOD = "figureCaptureMethod";
    public static final String USE_NEW_FIGURE = "useNewFigure";
    public static final String MAX_WIDTH = "maxWidth";
    public static final String MAX_HEIGHT = "maxHeight";
    public static final String SHOW_CODE = "showCode";
    public static final String EVALUATE_CODE = "evaluateCode";
    public static final String CATCH_ERROR = "catchError";
    public static final String STOP_ON_ERROR = "stopOnError";
    public static final String CREATE_THUMBNAIL = "createThumbnail";
    public static final String MAX_NUMBER_OF_OUTPUT_LINES = "maxNumberOfOutputLines";
    public static final String CODE_TO_EVALUATE = "codeToEvaluate";
    private PropertyChangeSupport fSupport = new PropertyChangeSupport(this);
    public static final String DEFAULT_IMAGE_TYPE = "default";

    public PublishOptions() {
        this.createBeanProperties();
    }

    private void createBeanProperties() {
        assert (this.fBeanProperties == null) : "The bean properties have already been created.";
        try {
            BeanIntrospector beanIntrospector = new BeanIntrospector(PublishOptions.class, ConfigurationUtils.getPublishPropertiesXMLInputStream());
            this.fBeanProperties = beanIntrospector.createPropertyList((Object)this);
            PublishOptions.setPropertyInternationalizableValues(this.fBeanProperties);
        }
        catch (IntrospectionException introspectionException) {
            Log.logException((Exception)introspectionException);
        }
    }

    private static void setPropertyInternationalizableValues(Collection<Property> collection) {
        for (Property property : collection) {
            String string = ConfigurationUtils.lookup("publish.option." + property.getName());
            property.setDisplayName(string);
            String string2 = ConfigurationUtils.lookup("publish.category." + property.getCategory());
            property.setCategory(string2);
            String string3 = ConfigurationUtils.lookup("publish.option.description." + property.getName());
            property.setDescription(string3);
        }
    }

    public Property getProperty(String string) {
        Property property = null;
        for (Property property2 : this.fBeanProperties) {
            if (!property2.getName().equals(string)) continue;
            property = property2;
            break;
        }
        return property;
    }

    public void setBeanProperties(PublishOptions publishOptions) {
        for (Property property : publishOptions.getBeanProperties()) {
            this.getProperty(property.getName()).setValue(property.getValue());
        }
    }

    public PropertyChangeSupport getSupport() {
        return this.fSupport;
    }

    public static FileFormat[] getSupportedOutputFormats() {
        return PlatformFormatSupport.getSupportedOutputFormats();
    }

    public ImageFormat[] getSupportedImageFormats() {
        if (this.fOutputFileFormat == null) {
            throw new IllegalStateException("Output file format should not be null when getSupportedImageFormats is called.");
        }
        if (this.fFigureCaptureMethod == null) {
            throw new IllegalStateException("Figure capture method should not be null when getSupportedImageFormats is called.");
        }
        return this.fOutputFileFormat.limitImageTypes(this.fFigureCaptureMethod.getSupportedImageTypes());
    }

    public FileFormat getOutputFileFormat() {
        return this.fOutputFileFormat;
    }

    public void setOutputFileFormat(FileFormat fileFormat) {
        FileFormat fileFormat2 = this.fOutputFileFormat;
        this.fOutputFileFormat = fileFormat;
        this.getSupport().firePropertyChange(OUTPUT_FILE_FORMAT, (Object)fileFormat2, (Object)fileFormat);
        this.correctImageFormatIfNecessary();
    }

    public File getStyleSheet() {
        return this.fStyleSheet;
    }

    public void setStyleSheet(File file) {
        File file2 = this.fStyleSheet;
        this.fStyleSheet = file;
        this.getSupport().firePropertyChange(STYLE_SHEET, file2, file);
    }

    public File getOutputLocation() {
        return this.fOutputLocation;
    }

    public void setOutputLocation(File file) {
        File file2 = this.fOutputLocation;
        this.fOutputLocation = file;
        this.getSupport().firePropertyChange(OUTPUT_LOCATION, file2, file);
    }

    public ImageFormat getImageFormat() {
        return this.fImageFormat;
    }

    public void setImageFormat(ImageFormat imageFormat) {
        ImageFormat imageFormat2 = this.fImageFormat;
        this.fImageFormat = imageFormat;
        this.getSupport().firePropertyChange(IMAGE_FORMAT, (Object)imageFormat2, (Object)imageFormat);
    }

    public FigureCaptureMethod getFigureCaptureMethod() {
        return this.fFigureCaptureMethod;
    }

    public void setFigureCaptureMethod(FigureCaptureMethod figureCaptureMethod) {
        FigureCaptureMethod figureCaptureMethod2 = this.fFigureCaptureMethod;
        this.fFigureCaptureMethod = figureCaptureMethod;
        this.getSupport().firePropertyChange(FIGURE_CAPTURE_METHOD, (Object)figureCaptureMethod2, (Object)figureCaptureMethod);
        this.correctImageFormatIfNecessary();
    }

    public Boolean getUseNewFigure() {
        return this.fUseNewFigure;
    }

    public void setUseNewFigure(Boolean bl) {
        Boolean bl2 = this.fUseNewFigure;
        this.fUseNewFigure = bl;
        this.getSupport().firePropertyChange(USE_NEW_FIGURE, bl2, bl);
    }

    public Integer getMaxWidth() {
        return this.fMaxWidth;
    }

    public void setMaxWidth(Integer n) {
        Integer n2 = this.fMaxWidth;
        this.fMaxWidth = n;
        this.getSupport().firePropertyChange(MAX_WIDTH, n2, this.fMaxWidth);
    }

    public Integer getMaxHeight() {
        return this.fMaxHeight;
    }

    public void setMaxHeight(Integer n) {
        Integer n2 = this.fMaxHeight;
        this.fMaxHeight = n;
        this.getSupport().firePropertyChange(MAX_HEIGHT, n2, this.fMaxHeight);
    }

    public Boolean getShowCode() {
        return this.fShowCode;
    }

    public void setShowCode(Boolean bl) {
        Boolean bl2 = this.fShowCode;
        this.fShowCode = bl;
        this.getSupport().firePropertyChange(SHOW_CODE, bl2, this.fShowCode);
    }

    public Boolean getEvaluateCode() {
        return this.fEvaluateCode;
    }

    public void setEvaluateCode(Boolean bl) {
        Boolean bl2 = this.fEvaluateCode;
        this.fEvaluateCode = bl;
        this.getSupport().firePropertyChange(EVALUATE_CODE, bl2, this.fEvaluateCode);
    }

    public Boolean getCatchError() {
        return this.fCatchError;
    }

    public void setCatchError(Boolean bl) {
        Boolean bl2 = this.fCatchError;
        this.fCatchError = bl;
        this.getSupport().firePropertyChange(CATCH_ERROR, bl2, this.fCatchError);
    }

    public Boolean getCreateThumbnail() {
        return this.fCreateThumbnail;
    }

    public void setCreateThumbnail(Boolean bl) {
        Boolean bl2 = this.fCreateThumbnail;
        this.fCreateThumbnail = bl;
        this.getSupport().firePropertyChange(CREATE_THUMBNAIL, bl2, this.fCreateThumbnail);
    }

    public Integer getMaxNumberOfOutputLines() {
        return this.fMaxNumberOfOutputLines;
    }

    public void setMaxNumberOfOutputLines(Integer n) {
        Integer n2 = this.fMaxNumberOfOutputLines;
        this.fMaxNumberOfOutputLines = n;
        this.getSupport().firePropertyChange(MAX_NUMBER_OF_OUTPUT_LINES, n2, this.fMaxNumberOfOutputLines);
    }

    public Collection<Property> getBeanProperties() {
        return Collections.unmodifiableCollection(this.fBeanProperties);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getSupport().addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getSupport().removePropertyChangeListener(propertyChangeListener);
    }

    private void correctImageFormatIfNecessary() {
        if (Arrays.binarySearch((Object[])this.getSupportedImageFormats(), (Object)this.getImageFormat()) < 0) {
            this.setImageFormat(ImageFormat.DEFAULT);
        }
    }

    public static enum FigureCaptureMethod {
        GETFRAME("getframe", ImageFormat.DEFAULT, ImageFormat.PNG, ImageFormat.JPG, ImageFormat.BMP, ImageFormat.TIFF),
        PRINT("print", ImageFormat.DEFAULT, ImageFormat.PNG, ImageFormat.JPG, ImageFormat.BMP, ImageFormat.TIFF, ImageFormat.EPS, ImageFormat.EPSC, ImageFormat.EPS2, ImageFormat.EPSC2, ImageFormat.ILL, ImageFormat.META, ImageFormat.PDF),
        ENTIREGUIWINDOW("entireGUIWindow", ImageFormat.DEFAULT, ImageFormat.PNG, ImageFormat.JPG, ImageFormat.BMP, ImageFormat.TIFF),
        ENTIREFIGUREWINDOW("entireFigureWindow", ImageFormat.DEFAULT, ImageFormat.PNG, ImageFormat.JPG, ImageFormat.BMP, ImageFormat.TIFF);

        private final ImageFormat[] fSupportedImageFormats;
        private String fFunctionName;

        private FigureCaptureMethod(String string2, ImageFormat ... imageFormatArray) {
            this.fFunctionName = string2;
            this.fSupportedImageFormats = imageFormatArray;
        }

        private ImageFormat[] getSupportedImageTypes() {
            return this.fSupportedImageFormats;
        }

        public String getFunctionName() {
            return this.fFunctionName;
        }

        public static FigureCaptureMethod lookupFromFunctionName(String string) {
            for (FigureCaptureMethod figureCaptureMethod : FigureCaptureMethod.values()) {
                if (!figureCaptureMethod.getFunctionName().equals(string)) continue;
                return figureCaptureMethod;
            }
            throw new IllegalArgumentException("No FigureCaptureMethod exists for: " + string);
        }

        public String toString() {
            return this.getFunctionName();
        }
    }

    public static enum ImageFormat {
        DEFAULT("default"),
        PNG("png"),
        JPG("jpeg"),
        BMP("bmp"),
        TIFF("tiff"),
        EPS("eps"),
        EPSC("epsc"),
        EPS2("eps2"),
        EPSC2("epsc2"),
        ILL("ill"),
        META("meta"),
        PDF("pdf");

        private String fFileExtension;

        private ImageFormat(String string2) {
            this.fFileExtension = string2;
        }

        public String toString() {
            return this.getFileExtension();
        }

        public String getFileExtension() {
            return this.fFileExtension;
        }

        public static ImageFormat lookupFromFileExtension(String string) {
            for (ImageFormat imageFormat : ImageFormat.values()) {
                if (!imageFormat.getFileExtension().equals(string)) continue;
                return imageFormat;
            }
            throw new IllegalArgumentException("No FileFormat exists for: " + string);
        }

        public static String getDefaultImageDisplayText(ImageFormat ... imageFormatArray) {
            Validate.isTrue((imageFormatArray != null && imageFormatArray.length >= 1 ? 1 : 0) != 0, (String)"At least one default format must be supplied.");
            String string = "";
            for (int i = 0; i != imageFormatArray.length; ++i) {
                string = string + imageFormatArray[i].toString();
                if (i >= imageFormatArray.length - 1) continue;
                string = string + "/";
            }
            return MessageFormat.format(ConfigurationUtils.lookup("publish.options.defaultImageFormat"), ConfigurationUtils.lookup("publish.imageFormat.default"), string);
        }
    }

    private static enum PlatformFormatSupport {
        WINDOWS(new FileFormat[]{FileFormat.HTML, FileFormat.XML, FileFormat.LATEX, FileFormat.WORD, FileFormat.POWER_POINT, FileFormat.PDF}),
        OTHER(new FileFormat[]{FileFormat.HTML, FileFormat.XML, FileFormat.LATEX, FileFormat.PDF});

        private FileFormat[] fFileFormats;

        private PlatformFormatSupport(FileFormat[] fileFormatArray) {
            this.fFileFormats = fileFormatArray;
        }

        public static FileFormat[] getSupportedOutputFormats() {
            return PlatformInfo.isWindows() ? PlatformFormatSupport.WINDOWS.fFileFormats : PlatformFormatSupport.OTHER.fFileFormats;
        }

        public static FileFormat getCrossPlatformDefaultOutputFormat() {
            return FileFormat.HTML;
        }
    }

    public static enum FileFormat {
        HTML("html", "HTML"),
        XML("xml", "XML"),
        LATEX("latex", "LaTeX"),
        WORD("doc", "Word"),
        POWER_POINT("ppt", "PowerPoint"),
        PDF("pdf", "PDF"){

            @Override
            protected ImageFormat[] limitImageTypes(ImageFormat[] imageFormatArray) {
                ArrayList<ImageFormat> arrayList = new ArrayList<ImageFormat>();
                for (ImageFormat imageFormat : imageFormatArray) {
                    if (imageFormat != ImageFormat.BMP && imageFormat != ImageFormat.JPG && imageFormat != ImageFormat.DEFAULT) continue;
                    arrayList.add(imageFormat);
                }
                return arrayList.toArray(new ImageFormat[arrayList.size()]);
            }
        };

        private String fFileFormatExtension;
        private String fDisplayName;

        private FileFormat(String string2, String string3) {
            this.fFileFormatExtension = string2;
            this.fDisplayName = string3;
        }

        public String getFileExtension() {
            return this.fFileFormatExtension;
        }

        public static FileFormat lookupFromFileExtension(String string) {
            for (FileFormat fileFormat : FileFormat.values()) {
                if (!fileFormat.getFileExtension().equals(string)) continue;
                return fileFormat;
            }
            throw new IllegalArgumentException("No FileFormat exists for: " + string);
        }

        protected ImageFormat[] limitImageTypes(ImageFormat[] imageFormatArray) {
            return imageFormatArray;
        }

        public String toString() {
            return this.fDisplayName;
        }
    }
}

