/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.configeditor.data;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.matchers.Matcher;
import com.mathworks.mlservices.MatlabExecutionErrorHandler;
import com.mathworks.mlwidgets.configeditor.data.AbstractFileConfiguration;
import com.mathworks.mlwidgets.configeditor.data.ConfigurationNameUtils;
import com.mathworks.mlwidgets.configeditor.plugin.ConfigurationPluginUtils;
import com.mathworks.util.Converter;
import com.mathworks.util.FileUtils;
import com.mathworks.widgets.glazedlists.DisposableList;
import com.mathworks.widgets.glazedlists.MappedEventList;
import com.mathworks.widgets.glazedlists.NarrowTypeList;
import java.awt.Component;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Nullable;

public final class ConfigurationManager {
    private static final ConfigurationManager sInstance = new ConfigurationManager();
    private final EventList<AbstractFileConfiguration> fConfigurations = GlazedLists.threadSafeList(ConfigurationPluginUtils.getPluginManager().getConfigurations());
    private final EventList<AbstractFileConfiguration> fLastDeletedConfigurationsList;
    private final MappedEventList<File, AbstractFileConfiguration> fConfigurationsByFile;
    private final TransformedList<AbstractFileConfiguration, AbstractFileConfiguration> fReadOnlyConfigurations;
    private final TransformedList<AbstractFileConfiguration, AbstractFileConfiguration> fReadOnlyObservedConfigurations;
    private final TransformedList<AbstractFileConfiguration, AbstractFileConfiguration> fReadOnlyLastDeletedConfigurations;

    private ConfigurationManager() {
        ObservableElementList.Connector connector = GlazedLists.beanConnector(AbstractFileConfiguration.class);
        ObservableElementList observableElementList = new ObservableElementList(this.fConfigurations, connector);
        this.fLastDeletedConfigurationsList = GlazedLists.threadSafeList((EventList)new BasicEventList());
        this.fConfigurationsByFile = new MappedEventList((EventList)observableElementList, (Converter)new Converter<AbstractFileConfiguration, File>(){

            public File convert(AbstractFileConfiguration abstractFileConfiguration) {
                return FileUtils.absoluteFile((File)abstractFileConfiguration.getAssociatedFile());
            }
        });
        this.fReadOnlyConfigurations = GlazedLists.readOnlyList(this.fConfigurations);
        this.fReadOnlyObservedConfigurations = GlazedLists.readOnlyList((EventList)observableElementList);
        this.fReadOnlyLastDeletedConfigurations = GlazedLists.readOnlyList(this.fLastDeletedConfigurationsList);
    }

    public static ConfigurationManager getInstance() {
        return sInstance;
    }

    public EventList<AbstractFileConfiguration> getConfigurations() {
        return this.fReadOnlyConfigurations;
    }

    public EventList<AbstractFileConfiguration> getObservedConfigurations() {
        return this.fReadOnlyObservedConfigurations;
    }

    public EventList<AbstractFileConfiguration> getUndoableDeletedConfigurations() {
        return this.fReadOnlyLastDeletedConfigurations;
    }

    public void clearUndoableDeletedConfigurations() {
        this.fLastDeletedConfigurationsList.clear();
    }

    public void doConfigurationAction(AbstractFileConfiguration abstractFileConfiguration, Component component) {
        this.doConfigurationAction(abstractFileConfiguration, component, null);
    }

    public void doConfigurationAction(AbstractFileConfiguration abstractFileConfiguration, Component component, @Nullable MatlabExecutionErrorHandler matlabExecutionErrorHandler) {
        ConfigurationPluginUtils.getPluginManager().doConfigurationAction(abstractFileConfiguration, component, matlabExecutionErrorHandler);
    }

    public <E extends AbstractFileConfiguration> E getMostRecentlyActionedConfigurationForFile(File file, AbstractFileConfiguration.Type<E> type) {
        boolean bl;
        Map<File, AbstractFileConfiguration> map = ConfigurationPluginUtils.getPluginManager().getMostRecentlyActionedConfigurations(type);
        AbstractFileConfiguration abstractFileConfiguration = map.get(file);
        boolean bl2 = !this.fConfigurations.contains((Object)abstractFileConfiguration);
        boolean bl3 = bl = abstractFileConfiguration != null && !FileUtils.areFilesTheSame((File)file, (File)abstractFileConfiguration.getAssociatedFile());
        if (bl2 || bl) {
            map.remove(file);
            abstractFileConfiguration = null;
        }
        return (E)abstractFileConfiguration;
    }

    public <E extends AbstractFileConfiguration> E getMostRecentlyActionedConfigurationForFileOrDefault(File file, AbstractFileConfiguration.Type<E> type) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null.");
        }
        return this.getMostRecentlyActionedConfigurationForFileOrDefault(file, type, true, false);
    }

    public <E extends AbstractFileConfiguration> E getMostRecentlyActionedConfigurationForFileOrDefault(File file, AbstractFileConfiguration.Type<E> type, boolean bl, boolean bl2) {
        E e = this.getMostRecentlyActionedConfigurationForFile(file, type);
        if (e == null) {
            e = this.getDefaultConfigurationForFile(file, type, bl);
            if (bl2) {
                this.addConfiguration((AbstractFileConfiguration)e);
            }
        }
        return e;
    }

    public void setMostRecentlyActionedConfigurationForFile(AbstractFileConfiguration abstractFileConfiguration) {
        Map<File, AbstractFileConfiguration> map = ConfigurationPluginUtils.getPluginManager().getMostRecentlyActionedConfigurations(abstractFileConfiguration.getType());
        map.put(abstractFileConfiguration.getAssociatedFile(), abstractFileConfiguration);
        this.persist(false);
    }

    public <E extends AbstractFileConfiguration> E getDefaultConfigurationForFile(File file, AbstractFileConfiguration.Type<E> type, boolean bl) {
        AbstractFileConfiguration abstractFileConfiguration = null;
        DisposableList<E> disposableList = this.getConfigurationsForFile(file, type);
        if (!disposableList.isEmpty()) {
            abstractFileConfiguration = (AbstractFileConfiguration)disposableList.get(0);
        } else if (bl) {
            abstractFileConfiguration = type.create(file);
        }
        disposableList.dispose();
        return (E)abstractFileConfiguration;
    }

    public DisposableList<AbstractFileConfiguration> getConfigurationsForFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null.");
        }
        DisposableList<AbstractFileConfiguration> disposableList = this.getFromMap(file);
        TransformedList transformedList = GlazedLists.readOnlyList(disposableList);
        return new DisposableList(transformedList, new TransformedList[]{disposableList});
    }

    private DisposableList<AbstractFileConfiguration> getFromMap(File file) {
        DisposableList disposableList = this.fConfigurationsByFile.get((Object)file);
        if (disposableList.isEmpty()) {
            disposableList.dispose();
            return this.fConfigurationsByFile.get((Object)FileUtils.absoluteFile((File)file));
        }
        return disposableList;
    }

    public <E extends AbstractFileConfiguration> DisposableList<E> getConfigurationsForType(AbstractFileConfiguration.Type<E> type) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null.");
        }
        Matcher<AbstractFileConfiguration> matcher = ConfigurationManager.getConfigurationTypeMatcher(type);
        FilterList filterList = new FilterList(this.fConfigurations, matcher);
        NarrowTypeList narrowTypeList = new NarrowTypeList((EventList)filterList);
        TransformedList transformedList = GlazedLists.readOnlyList((EventList)narrowTypeList);
        return new DisposableList(transformedList, new TransformedList[]{filterList, narrowTypeList});
    }

    public <E extends AbstractFileConfiguration> DisposableList<E> getConfigurationsForFile(File file, AbstractFileConfiguration.Type<E> type) {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null.");
        }
        DisposableList<AbstractFileConfiguration> disposableList = this.getFromMap(file);
        FilterList filterList = new FilterList(disposableList, ConfigurationManager.getConfigurationTypeMatcher(type));
        NarrowTypeList narrowTypeList = new NarrowTypeList((EventList)filterList);
        TransformedList transformedList = GlazedLists.readOnlyList((EventList)narrowTypeList);
        return new DisposableList(transformedList, new TransformedList[]{disposableList, filterList, narrowTypeList});
    }

    public void addConfiguration(AbstractFileConfiguration abstractFileConfiguration) {
        this.fConfigurations.add((Object)abstractFileConfiguration);
    }

    public void addConfigurations(Collection<AbstractFileConfiguration> collection) {
        this.fConfigurations.addAll(collection);
    }

    public <E extends AbstractFileConfiguration> E createAndAddConfigurationForFile(File file, AbstractFileConfiguration.Type<E> type) {
        E e = type.create(file);
        this.fConfigurations.add(e);
        return e;
    }

    public void removeConfiguration(AbstractFileConfiguration abstractFileConfiguration) {
        BasicEventList basicEventList = new BasicEventList();
        basicEventList.add((Object)abstractFileConfiguration);
        this.removeConfigurations((EventList<AbstractFileConfiguration>)basicEventList);
    }

    public void removeConfigurations(EventList<AbstractFileConfiguration> eventList) {
        EventList eventList2 = GlazedLists.eventList(eventList);
        this.fConfigurations.removeAll((Collection)eventList2);
        this.registerUndoableRemove((EventList<AbstractFileConfiguration>)eventList2);
    }

    public void removeAllConfigurationsForFile(File file) {
        DisposableList<AbstractFileConfiguration> disposableList = this.getConfigurationsForFile(file);
        this.removeConfigurations((EventList<AbstractFileConfiguration>)disposableList);
        disposableList.dispose();
    }

    private void registerUndoableRemove(EventList<AbstractFileConfiguration> eventList) {
        this.fLastDeletedConfigurationsList.clear();
        this.fLastDeletedConfigurationsList.addAll(eventList);
    }

    public EventList<AbstractFileConfiguration> undoLastDelete() {
        EventList eventList = GlazedLists.eventList(this.fLastDeletedConfigurationsList);
        this.fConfigurations.addAll(this.fLastDeletedConfigurationsList);
        this.fLastDeletedConfigurationsList.clear();
        return eventList;
    }

    public void reassociateConfigurations(File file, File file2) {
        String string = FilenameUtils.removeExtension((String)file2.getName());
        DisposableList<AbstractFileConfiguration> disposableList = this.getConfigurationsForFile(file);
        for (AbstractFileConfiguration abstractFileConfiguration : disposableList) {
            ConfigurationNameUtils.renameAutoGeneratedConfiguration(abstractFileConfiguration, string);
            abstractFileConfiguration.setAssociatedFile(file2);
        }
        disposableList.dispose();
    }

    public void persist(boolean bl) {
        ConfigurationPluginUtils.getPluginManager().persist(bl);
    }

    private static Matcher<AbstractFileConfiguration> getConfigurationTypeMatcher(final AbstractFileConfiguration.Type<?> type) {
        return new Matcher<AbstractFileConfiguration>(){

            public boolean matches(AbstractFileConfiguration abstractFileConfiguration) {
                return type.equals(abstractFileConfiguration.getType());
            }
        };
    }
}

