/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array.web;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.bean.UDDListener;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.jmi.mdt.MatlabCallable;
import com.mathworks.jmi.mdt.MatlabEventQueue;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.events.Observer;
import com.mathworks.peermodel.pageddata.ClientPagedData;
import com.mathworks.peermodel.pageddata.DataModelHandler;
import com.mathworks.peermodel.pageddata.PagedDataFactory;
import com.mathworks.peermodel.pageddata.ServerPagedData;
import com.mathworks.util.FactoryUtils;
import com.mathworks.util.Log;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class GridEditorHandler {
    protected PeerNode fGridNode;
    protected ArrayHandler fArrayHandler;
    protected PeerNode fViewModelNode;
    protected UDDObject fViewModelMCOS;
    protected UDDListener fViewModelNodeObserver;
    protected String fVarName;
    protected volatile boolean fAsyncUpdateQueued = false;
    protected volatile int fLastRowRequested = -1;
    protected volatile int fLastColumnRequested = -1;
    protected ServerPagedData fServerPagedData;
    private Object iLastSetCellValue;
    private int iLastSelCellRow = -1;
    private int iLastSelCellColumn = -1;
    public static int sFevalCount = 0;
    protected int fMatlabTimeout = 3000;

    public void init(String string, PeerNode peerNode, UDDObject uDDObject, String[][] stringArray) {
        this.fViewModelNode = peerNode;
        this.fViewModelMCOS = uDDObject;
        this.fArrayHandler = new ArrayHandler();
        if (stringArray != null) {
            this.fArrayHandler.setTempArrayBlock(new ArrayBlock(0, 0, stringArray));
        }
        this.fVarName = string;
        if (this.fViewModelMCOS.isValid()) {
            this.fViewModelNodeObserver = new UDDListener(this.fViewModelMCOS, "DataChange"){

                public void execute(UDDObject uDDObject, UDDObject uDDObject2) {
                    try {
                        if (((MLArrayRef)uDDObject2.getPropertyValue("Range")).getM() == 1) {
                            double[] dArray = (double[])((MLArrayRef)uDDObject2.getPropertyValue("Range")).getData();
                            String string = (String)((MLArrayRef)uDDObject2.getPropertyValue("Values")).getData();
                            GridEditorHandler.this.workspaceCellChange((int)dArray[0] - 1, (int)dArray[1] - 1, string);
                        } else {
                            double[] dArray = (double[])Matlab.mtFeval((String)"getSize", (Object[])new Object[]{GridEditorHandler.this.fViewModelMCOS}, (int)1);
                            GridEditorHandler.this.workspaceChange((int)dArray[0], (int)dArray[1]);
                        }
                    }
                    catch (Exception exception) {
                        GridEditorHandler.this.sendExceptionToClient(exception);
                    }
                }
            };
            if (FactoryUtils.isMatlabThread()) {
                this.getSizeFromMatlab();
            } else {
                Matlab.whenMatlabIdle((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        GridEditorHandler.this.getSizeFromMatlab();
                    }
                });
            }
        }
    }

    private void getSizeFromMatlab() {
        try {
            double[] dArray = (double[])Matlab.mtFeval((String)"getSize", (Object[])new Object[]{this.fViewModelMCOS}, (int)1);
            this.workspaceChange((int)dArray[0], (int)dArray[1]);
        }
        catch (Exception exception) {
            this.sendExceptionToClient(exception);
        }
    }

    public PeerNode getGridNode() {
        return this.fGridNode;
    }

    public ArrayHandler getArrayHandler() {
        return this.fArrayHandler;
    }

    public PeerNode getViewModelPeerNode() {
        return this.fViewModelNode;
    }

    public UDDObject getViewModelMCOS() {
        return this.fViewModelMCOS;
    }

    protected abstract void buildTableProps();

    public void refresh() {
        if (this.fServerPagedData != null) {
            this.fServerPagedData.update();
        }
    }

    public void resetDataModel() {
        if (this.fGridNode.getProperty("dataModel") == null) {
            ClientPagedData clientPagedData = PagedDataFactory.createPagedData((PeerNode)this.fGridNode, (String)"dataModel", (DataModelHandler)this.fArrayHandler);
            this.fGridNode.setProperty("dataModel", (Object)clientPagedData);
        }
        this.refresh();
    }

    public static Class<? extends ClientPagedData> getImpl() {
        return ClientPagedData.class;
    }

    public void workspaceCellChange(int n, int n2, String string) throws Exception {
        if (this.fArrayHandler != null && this.fArrayHandler.iArrayBlock != null) {
            this.fArrayHandler.iArrayBlock.setValueAt(n, n2, string);
        }
        this.refresh();
    }

    public void workspaceChange(int n, int n2) throws Exception {
        boolean bl = n != this.fArrayHandler.getRowCount() || n2 != this.fArrayHandler.getColumnCount();
        this.fArrayHandler.workspaceChange(n, n2);
        if (this.fGridNode == null) {
            this.fGridNode = this.fViewModelNode.addChild("DataGrid", new HashMap());
            this.fGridNode.addEventListener("propertySet", new Observer(){

                public void handle(final Event event) {
                    if (event.getData().get("key").equals("Selection") && GridEditorHandler.this.fViewModelMCOS.isValid()) {
                        Matlab.whenMatlabIdle((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Matlab.mtFeval((String)"handleClientSelection", (Object[])new Object[]{GridEditorHandler.this.fViewModelMCOS, event.getData()}, (int)0);
                                }
                                catch (Exception exception) {
                                    GridEditorHandler.this.sendExceptionToClient(exception);
                                }
                            }
                        });
                    }
                }
            });
            this.fViewModelNode.addEventListener("propertySet", new Observer(){

                public void handle(final Event event) {
                    if (event.getData().get("key").equals("Selection")) {
                        Matlab.whenMatlabIdle((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    GridEditorHandler.this.fGridNode.setProperty("Selection", event.getData().get("newValue"));
                                }
                                catch (Exception exception) {
                                    GridEditorHandler.this.sendExceptionToClient(exception);
                                }
                            }
                        });
                    }
                }
            });
            this.resetDataModel();
            this.buildTableProps();
        } else {
            this.resetDataModel();
            if (bl) {
                this.buildTableProps();
            }
        }
    }

    protected static String[][] reshapeRenderedData(String[] stringArray, double[] dArray) {
        String[][] stringArray2 = new String[(int)dArray[0]][(int)dArray[1]];
        for (int i = 0; i < (int)dArray[0]; ++i) {
            for (int j = 0; j < (int)dArray[1]; ++j) {
                if (i + j * (int)dArray[0] >= stringArray.length) continue;
                stringArray2[i][j] = stringArray[i + j * (int)dArray[0]];
            }
        }
        return stringArray2;
    }

    public void sendExceptionToClient(Exception exception) {
        if (exception == null) {
            return;
        }
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("type", "errormsg");
            hashMap.put("message", GridEditorHandler.getStackTrace(exception));
            this.getGridNode().dispatchPeerEvent("errormsg", this.getGridNode(), hashMap);
            Log.logException((Exception)exception);
        }
        catch (Exception exception2) {
            Log.logException((Exception)exception);
            Log.logException((Exception)exception2);
        }
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        printWriter.write(throwable.getMessage());
        printWriter.write(10);
        throwable.printStackTrace(printWriter);
        return stringWriter.getBuffer().toString();
    }

    public void setDataToMatlab(String string, int n, int n2) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("row", n + 1);
        hashMap.put("column", n2 + 1);
        hashMap.put("data", string);
        if (this.fViewModelMCOS.isValid()) {
            Matlab.mtFeval((String)"handleClientSetData", (Object[])new Object[]{this.fViewModelMCOS, hashMap}, (int)1);
            this.iLastSetCellValue = null;
        }
    }

    public String[][] getRenderedDataFromMatlab(int n, int n2, int n3, int n4) throws Exception {
        String[][] stringArray = null;
        if (this.fViewModelMCOS.isValid()) {
            Matlab.mtFeval((String)"setCurrentPage", (Object[])new Object[]{this.fViewModelMCOS, n + 1, n2 + 1, n3 + 1, n4 + 1}, (int)0);
            Object[] objectArray = (Object[])Matlab.mtFeval((String)"getRenderedData", (Object[])new Object[]{this.fViewModelMCOS, n + 1, n2 + 1, n3 + 1, n4 + 1}, (int)2);
            stringArray = GridEditorHandler.reshapeRenderedData((String[])objectArray[0], (double[])objectArray[1]);
        }
        return stringArray;
    }

    public int getMatlabTimeout() {
        return this.fMatlabTimeout;
    }

    public void setMatlabTimeout(int n) {
        this.fMatlabTimeout = n;
    }

    public static class ArrayBlock {
        public int iStartRow;
        public int iStartColumn;
        public String[][] iArray;

        private ArrayBlock(int n, int n2, String[][] stringArray) {
            this.iStartRow = n;
            this.iStartColumn = n2;
            this.iArray = stringArray;
        }

        public boolean containsCell(int n, int n2) {
            if (this.iArray == null) {
                return false;
            }
            return n >= this.iStartRow && n < this.iStartRow + this.iArray.length && n2 >= this.iStartColumn && n2 < this.iStartColumn + this.iArray[n - this.iStartRow].length;
        }

        public String valueAt(int n, int n2) {
            return this.iArray[n - this.iStartRow][n2 - this.iStartColumn];
        }

        private void setValueAt(int n, int n2, String string) {
            if (this.containsCell(n, n2)) {
                this.iArray[n - this.iStartRow][n2 - this.iStartColumn] = string;
            }
        }
    }

    public class ArrayHandler
    implements DataModelHandler {
        private volatile ArrayBlock iArrayBlock;
        private volatile ArrayBlock iTempArrayBlock;
        private int iRowCount = -1;
        private int iColumnCount = -1;

        public void setTempArrayBlock(ArrayBlock arrayBlock) {
            this.iTempArrayBlock = arrayBlock;
        }

        public void workspaceChange(int n, int n2) throws Exception {
            this.iArrayBlock = null;
            this.iRowCount = n;
            this.iColumnCount = n2;
            GridEditorHandler.this.iLastSetCellValue = null;
            GridEditorHandler.this.iLastSelCellRow = -1;
            GridEditorHandler.this.iLastSelCellColumn = -1;
        }

        public void update(ServerPagedData serverPagedData) {
            GridEditorHandler.this.fServerPagedData = serverPagedData;
        }

        public void destroy() {
            Log.log((String)"destroyed");
        }

        public int getRowCount() {
            return this.iRowCount;
        }

        public int getColumnCount() {
            return this.iColumnCount;
        }

        public boolean is2D() {
            return true;
        }

        public Object getValueAt(int n) {
            return "";
        }

        public <T> T synchronouslyCallMATLAB(final Callable<T> callable) throws Exception {
            if (GridEditorHandler.this.fViewModelMCOS.isValid()) {
                Future future = MatlabEventQueue.invoke((MatlabCallable)new MatlabCallable<T>(){

                    public void callOnEdt(T t, boolean bl) {
                    }

                    public T call() {
                        try {
                            return callable.call();
                        }
                        catch (Exception exception) {
                            GridEditorHandler.this.sendExceptionToClient(exception);
                            return null;
                        }
                    }
                });
                try {
                    Object v = future.get(GridEditorHandler.this.fMatlabTimeout, TimeUnit.MILLISECONDS);
                    return (T)v;
                }
                catch (TimeoutException timeoutException) {
                    GridEditorHandler.this.sendExceptionToClient(timeoutException);
                }
                catch (InterruptedException interruptedException) {
                    GridEditorHandler.this.sendExceptionToClient(interruptedException);
                }
                catch (Exception exception) {
                    GridEditorHandler.this.sendExceptionToClient(exception);
                }
            } else {
                return callable.call();
            }
            return null;
        }

        public Object getValueAt(int n, int n2) {
            if (this.iArrayBlock != null && this.iArrayBlock.containsCell(n, n2)) {
                return this.iArrayBlock.valueAt(n, n2);
            }
            GridEditorHandler.this.fLastRowRequested = n;
            GridEditorHandler.this.fLastColumnRequested = n2;
            this.requestAsyncRefresh();
            String string = "";
            if (this.iTempArrayBlock != null && this.iTempArrayBlock.containsCell(n, n2)) {
                string = this.iTempArrayBlock.valueAt(n, n2);
            } else {
                string = "";
                string = "{\"renderer\":\"MOTW/datatools/variableeditor/views/renderers/VEText\",\"editor\":\"\",\"inplaceeditor\":\"MOTW/datatools/variableeditor/views/editors/VETextEditor\",\"class\":\"char\",\"value\":\"" + string + "\",\"editValue\":\"\",\"isTemporaryValue\":true}";
            }
            return string;
        }

        protected synchronized void requestAsyncRefresh() {
            if (!GridEditorHandler.this.fAsyncUpdateQueued) {
                GridEditorHandler.this.fAsyncUpdateQueued = true;
                try {
                    Matlab.whenMatlabIdle((Runnable)new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                ClientPagedData clientPagedData = (ClientPagedData)GridEditorHandler.this.fGridNode.getProperty("dataModel");
                                int n = clientPagedData.getCurrentStartRow() < 0 ? 0 : clientPagedData.getCurrentStartRow();
                                int n2 = clientPagedData.getCurrentEndRow();
                                int n3 = clientPagedData.getCurrentStartCol() < 0 ? 0 : clientPagedData.getCurrentStartCol();
                                int n4 = clientPagedData.getCurrentEndCol();
                                String[][] stringArray = GridEditorHandler.this.getRenderedDataFromMatlab(n, n2, n3, n4);
                                if (stringArray != null) {
                                    ArrayHandler.this.iArrayBlock = new ArrayBlock(n, n3, stringArray);
                                    GridEditorHandler.this.resetDataModel();
                                    GridEditorHandler.this.refresh();
                                }
                            }
                            catch (Exception exception) {
                                GridEditorHandler.this.sendExceptionToClient(exception);
                            }
                            finally {
                                GridEditorHandler.this.fAsyncUpdateQueued = false;
                            }
                            if (ArrayHandler.this.iArrayBlock != null && !ArrayHandler.this.iArrayBlock.containsCell(GridEditorHandler.this.fLastRowRequested, GridEditorHandler.this.fLastColumnRequested)) {
                                ArrayHandler.this.requestAsyncRefresh();
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    GridEditorHandler.this.sendExceptionToClient(exception);
                }
            }
        }

        public void setValueAt(Object object, int n) {
            Log.log((String)object.toString());
        }

        public void setValueAt(final Object object, final int n, final int n2) {
            if (n == GridEditorHandler.this.iLastSelCellRow && n2 == GridEditorHandler.this.iLastSelCellColumn && object.equals(GridEditorHandler.this.iLastSetCellValue)) {
                return;
            }
            GridEditorHandler.this.iLastSetCellValue = object;
            GridEditorHandler.this.iLastSelCellRow = n;
            GridEditorHandler.this.iLastSelCellColumn = n2;
            try {
                Matlab.whenMatlabIdle((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            GridEditorHandler.this.setDataToMatlab(object.toString(), n, n2);
                        }
                        catch (Exception exception) {
                            String string = "";
                            if (ArrayHandler.this.iArrayBlock != null) {
                                string = ArrayHandler.this.iArrayBlock.valueAt(n, n2);
                            }
                            HashMap<String, Object> hashMap = new HashMap<String, Object>();
                            hashMap.put("status", "error");
                            hashMap.put("message", exception.getMessage());
                            hashMap.put("row", n);
                            hashMap.put("column", n2);
                            GridEditorHandler.this.getGridNode().dispatchPeerEvent("dataChangeStatus", GridEditorHandler.this.getGridNode(), hashMap);
                        }
                    }
                });
            }
            catch (Exception exception) {
                GridEditorHandler.this.sendExceptionToClient(exception);
            }
        }

        public void dispatchCellEvent(int n, int n2, Map<String, Object> map) {
        }

        public ArrayBlock getCurrentArrayBlock() {
            return this.iArrayBlock;
        }
    }
}

