/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui.suggestions;

import com.mathworks.help.helpui.json.JsonArray;
import com.mathworks.help.helpui.suggestions.SuggestionRequest;
import com.mathworks.help.helpui.suggestions.SuggestionUtils;
import com.mathworks.helpsearch.suggestion.DocumentationSuggestionProvider;
import com.mathworks.helpsearch.suggestion.WordSuggestionFinder;
import com.mathworks.search.SearchException;
import com.mathworks.search.SearchHighlight;
import com.mathworks.search.SearchSuggestions;
import java.text.MessageFormat;
import java.util.List;

public class WordSuggestionRequest
implements SuggestionRequest {
    public static final MessageFormat MORE_WORDS_FORMAT = new MessageFormat("suggestionsObj.displayMoreSuggestions(''word'',''wordsuggestion'',{0});");
    private final DocumentationSuggestionProvider fSuggestionProvider;
    private final String fSearchText;
    private final int fStartAt;

    public WordSuggestionRequest(DocumentationSuggestionProvider documentationSuggestionProvider, String string, int n) {
        this.fSuggestionProvider = documentationSuggestionProvider;
        this.fSearchText = string;
        this.fStartAt = n;
    }

    protected WordSuggestionFinder getWordSuggestionFinder() {
        return new WordSuggestionFinder(this.fSuggestionProvider, this.fSearchText, this.fStartAt);
    }

    public List<SearchHighlight> getWordSuggestions() throws SearchException {
        WordSuggestionFinder wordSuggestionFinder = this.getWordSuggestionFinder();
        SearchSuggestions searchSuggestions = wordSuggestionFinder.getWordSuggestions();
        return searchSuggestions.getSuggestions().subList(this.fStartAt, searchSuggestions.getTotal());
    }

    public JsonArray getSuggestions(Iterable<SearchHighlight> iterable) {
        return SuggestionUtils.createWordSuggestionArray(iterable);
    }

    @Override
    public String getJavaScriptCallback() throws SearchException {
        List<SearchHighlight> list = this.getWordSuggestions();
        JsonArray jsonArray = this.getSuggestions(list);
        Object[] objectArray = new Object[]{jsonArray.getJsonString()};
        return MORE_WORDS_FORMAT.format(objectArray);
    }
}

