/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui.search.index;

import com.mathworks.help.helpui.search.index.DocCenterDomAdapter;
import com.mathworks.helpsearch.DocLanguage;
import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.FileHelpPathBuilder;
import com.mathworks.helpsearch.HelpPathBuilder;
import com.mathworks.helpsearch.csh.MapFileIndexDocumentIterator;
import com.mathworks.helpsearch.csh.TopicMapFileIndexDocumentIterator;
import com.mathworks.helpsearch.index.DocCenterIndexDocumentBuilder;
import com.mathworks.helpsearch.index.DocSearchIndexDocumentIterator;
import com.mathworks.helpsearch.index.DocumentBooster;
import com.mathworks.helpsearch.index.DocumentationBooster;
import com.mathworks.helpsearch.index.HtmlToDomAdapter;
import com.mathworks.helpsearch.index.IndexDocumentBuilder;
import com.mathworks.helpsearch.index.IndexDocumentIterator;
import com.mathworks.helpsearch.index.IndexerConfig;
import com.mathworks.helpsearch.index.IndexerObserver;
import com.mathworks.helpsearch.index.LocaleFileLocator;
import com.mathworks.helpsearch.index.LocalizedFileLocator;
import com.mathworks.helpsearch.index.ProductIndexer;
import com.mathworks.helpsearch.index.example.ExampleIndexerObserver;
import com.mathworks.helpsearch.index.example.ExampleMetadataWriter;
import com.mathworks.helpsearch.index.example.XmlExampleMetadataWriter;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocSetItem;
import com.mathworks.search.Indexer;
import java.io.File;
import java.io.IOException;
import java.util.Locale;

abstract class AbstractIndexer {
    private final File fDocRoot;
    private final DocSetItem fDocSetItem;
    private final boolean fWebDoc;

    protected AbstractIndexer(File file, DocSetItem docSetItem, boolean bl) {
        this.fDocRoot = file;
        this.fDocSetItem = docSetItem;
        this.fWebDoc = bl;
    }

    public void index() throws IOException {
        ProductIndexer productIndexer;
        ProductConfig productConfig = new ProductConfig(this.fDocRoot, this.fDocSetItem, this.fDocSetItem.getDocSet().getLanguage());
        Indexer indexer = this.getIndexer(productConfig);
        DocCenterIndexDocumentBuilder docCenterIndexDocumentBuilder = new DocCenterIndexDocumentBuilder(null, (DocumentBooster)new DocumentationBooster());
        DocCenterDomAdapter docCenterDomAdapter = new DocCenterDomAdapter(this.fWebDoc);
        DocSearchIndexDocumentIterator docSearchIndexDocumentIterator = new DocSearchIndexDocumentIterator((IndexerConfig)productConfig, this.fDocSetItem, (HtmlToDomAdapter)docCenterDomAdapter, (IndexDocumentBuilder)docCenterIndexDocumentBuilder);
        this.afterIteratorCreated((DocSearchIndexDocumentIterator<DocumentationSearchField>)docSearchIndexDocumentIterator);
        if (this.fDocSetItem instanceof DocProduct) {
            DocProduct docProduct = (DocProduct)this.fDocSetItem;
            docSearchIndexDocumentIterator.addObserver((IndexerObserver)new ExampleIndexerObserver((ExampleMetadataWriter)new XmlExampleMetadataWriter(this.fDocRoot, docProduct, this.fDocSetItem.getDocSet().getLanguage())));
            MapFileIndexDocumentIterator mapFileIndexDocumentIterator = new MapFileIndexDocumentIterator(this.fDocRoot, docProduct, docProduct.getDocSet().getLanguage());
            TopicMapFileIndexDocumentIterator topicMapFileIndexDocumentIterator = new TopicMapFileIndexDocumentIterator(this.fDocRoot, docProduct, docProduct.getDocSet().getLanguage());
            productIndexer = new ProductIndexer(indexer, new IndexDocumentIterator[]{docSearchIndexDocumentIterator, mapFileIndexDocumentIterator, topicMapFileIndexDocumentIterator});
        } else {
            productIndexer = new ProductIndexer(indexer, new IndexDocumentIterator[]{docSearchIndexDocumentIterator});
        }
        productIndexer.index();
    }

    protected abstract Indexer getIndexer(IndexerConfig var1) throws IOException;

    protected abstract void afterIteratorCreated(DocSearchIndexDocumentIterator<DocumentationSearchField> var1);

    protected File getDocRoot() {
        return this.fDocRoot;
    }

    protected DocSetItem getProduct() {
        return this.fDocSetItem;
    }

    private static class ProductConfig
    implements IndexerConfig {
        private final File fDocRoot;
        private final File fHelpLocation;
        private final DocLanguage fLanguage;

        private ProductConfig(File file, DocSetItem docSetItem, DocLanguage docLanguage) {
            this.fDocRoot = file;
            this.fHelpLocation = (File)docSetItem.getHelpLocation().buildHelpPath((Object)file, (HelpPathBuilder)new FileHelpPathBuilder(), new String[0]);
            this.fLanguage = docLanguage;
        }

        public File getIndexDirectory() {
            return new File(this.fHelpLocation, this.getIndexDirectoryName());
        }

        private String getIndexDirectoryName() {
            String string = "helpsearch";
            if (this.fLanguage != null && this.fLanguage != DocLanguage.ENGLISH) {
                Locale locale = this.fLanguage.getLocale();
                string = string + "_" + locale.getLanguage() + "_" + locale.getCountry();
            }
            return string;
        }

        public File getDocRoot() {
            return this.fDocRoot;
        }

        public LocalizedFileLocator getFileLocator() {
            if (this.fLanguage == null || this.fLanguage == DocLanguage.ENGLISH) {
                return null;
            }
            return new LocaleFileLocator(this.fLanguage.getLocale());
        }
    }
}

