/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui;

import com.mathworks.help.helpui.DocUrlNavigationRule;
import com.mathworks.help.helpui.DocUrlType;
import com.mathworks.html.Url;
import com.mathworks.html.UrlBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class DocUrlNavigationRuleHandler {
    private final Collection<DocUrlNavigationRule> fDocUrlNavigationRules;

    public DocUrlNavigationRuleHandler(Collection<DocUrlNavigationRule> collection) {
        this.fDocUrlNavigationRules = Collections.unmodifiableCollection(collection);
    }

    public DocUrlNavigationRuleHandler copyOf(Collection<DocUrlNavigationRule> collection) {
        ArrayList<DocUrlNavigationRule> arrayList = new ArrayList<DocUrlNavigationRule>(this.fDocUrlNavigationRules);
        arrayList.addAll(collection);
        return new DocUrlNavigationRuleHandler(arrayList);
    }

    public Url removeRules(UrlBuilder<? extends Url> urlBuilder, DocUrlType docUrlType) {
        if (DocUrlNavigationRuleHandler.handleRules(urlBuilder)) {
            for (DocUrlNavigationRule docUrlNavigationRule : this.fDocUrlNavigationRules) {
                docUrlNavigationRule.remove(urlBuilder, docUrlType);
            }
        }
        return urlBuilder.toUrl();
    }

    public Url applyRules(UrlBuilder<? extends Url> urlBuilder, DocUrlType docUrlType) {
        if (DocUrlNavigationRuleHandler.handleRules(urlBuilder)) {
            for (DocUrlNavigationRule docUrlNavigationRule : this.fDocUrlNavigationRules) {
                docUrlNavigationRule.apply(urlBuilder, docUrlType);
            }
        }
        return urlBuilder.toUrl();
    }

    private static boolean handleRules(UrlBuilder<? extends Url> urlBuilder) {
        return urlBuilder.getType() != Url.UrlType.CUSTOM_PROTOCOL;
    }
}

