/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.guiutil;

import com.mathworks.mwswing.MJSpinner;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ICNumberSpinner
extends MJSpinner {
    private static final long serialVersionUID = 1L;
    private static DecimalFormat fSmallNumberFormat = new DecimalFormat("##0.0#######");
    private static DecimalFormat fLargeNumberFormat = new DecimalFormat("##0.000#####E0");
    private ICSpinnerNumberModel fModel;
    private ICNumberEditor fEditor;
    double fMinimum;
    double fMaximum;

    public ICNumberSpinner(double d, double d2, double d3, double d4) {
        this.fMinimum = d2;
        this.fMaximum = d3;
        this.fModel = new ICSpinnerNumberModel(d, d2, d3, d4);
        this.setModel(this.fModel);
        this.fEditor = new ICNumberEditor(this);
        this.setEditor(this.fEditor);
    }

    protected static String stringForValue(double d) {
        double d2 = Math.abs(d);
        if (d2 > 1000.0 || d2 < 0.001 && d2 != 0.0) {
            return fLargeNumberFormat.format(d);
        }
        return fSmallNumberFormat.format(d);
    }

    public class ICNumberEditor
    extends JTextField
    implements ChangeListener,
    FocusListener,
    ActionListener {
        private static final long serialVersionUID = 1L;

        public ICNumberEditor(ICNumberSpinner iCNumberSpinner2) {
            this.setOpaque(true);
            iCNumberSpinner2.addChangeListener(this);
            this.updateToolTipText((JSpinner)((Object)iCNumberSpinner2));
            this.setText(ICNumberSpinner.stringForValue(ICNumberSpinner.this.fModel.getDoubleValue()));
            this.addActionListener(this);
            this.addFocusListener(this);
        }

        protected void updateToolTipText(JSpinner jSpinner) {
            String string = jSpinner.getToolTipText();
            if (string != null && !string.equals(this.getToolTipText())) {
                this.setToolTipText(string);
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JSpinner jSpinner = (JSpinner)changeEvent.getSource();
            this.setText(ICNumberSpinner.stringForValue(ICNumberSpinner.this.fModel.getDoubleValue()));
            this.updateToolTipText(jSpinner);
        }

        protected void valueChanged() {
            double d;
            try {
                NumberFormat numberFormat = NumberFormat.getInstance(Locale.getDefault());
                String string = this.getText();
                if (string.indexOf(101) > -1) {
                    string = string.toUpperCase();
                }
                d = numberFormat.parse(string).doubleValue();
            }
            catch (ParseException parseException) {
                this.setText(ICNumberSpinner.stringForValue(ICNumberSpinner.this.fModel.getDoubleValue()));
                return;
            }
            ICNumberSpinner.this.fModel.setValue(d, true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.valueChanged();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.valueChanged();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }
    }

    public class ICSpinnerNumberModel
    extends SpinnerNumberModel {
        private static final long serialVersionUID = 1L;
        double fLastValue;

        public ICSpinnerNumberModel(double d, double d2, double d3, double d4) {
            super(d, d2, d3, d4);
            this.fLastValue = 0.0;
            this.setLastValue(d);
            this.updateStepSize();
        }

        @Override
        public void setValue(Object object) {
            this.setValue(object, false);
        }

        public void setValue(Object object, boolean bl) {
            double d = ((Number)object).doubleValue();
            this.setValue(d, bl);
        }

        public void setValue(double d, boolean bl) {
            if (!bl) {
                double d2 = this.getLastValue();
                double d3 = this.orderOfMagnitude(d2);
                d3 = Math.abs(d2) > 1.0 ? (d3 += 1.0) : (d3 -= 1.0);
                if (this.fLastValue < 0.0) {
                    if (this.fLastValue / Math.pow(10.0, d3) == -1.0 && d < d2 && (d = d2 - 10.0 * this.getStepSize().doubleValue()) < ((Number)((Object)this.getMinimum())).doubleValue()) {
                        d = ((Number)((Object)this.getMinimum())).doubleValue();
                    }
                } else if (this.fLastValue / Math.pow(10.0, d3) == 1.0 && d > d2 && (d = d2 + 10.0 * this.getStepSize().doubleValue()) > ((Number)((Object)this.getMaximum())).doubleValue()) {
                    d = ((Number)((Object)this.getMaximum())).doubleValue();
                }
            }
            try {
                NumberFormat numberFormat = NumberFormat.getInstance(Locale.getDefault());
                Double d4 = new Double(numberFormat.parse(ICNumberSpinner.stringForValue(d)).doubleValue());
                super.setValue(d4);
                this.setLastValue(d4);
            }
            catch (ParseException parseException) {
                super.setValue(new Double(0.0));
                this.setLastValue(0.0);
            }
            if (d != 0.0) {
                this.updateStepSize();
            }
        }

        protected void updateStepSize() {
            double d = this.orderOfMagnitude(this.getDoubleValue());
            double d2 = Math.pow(10.0, d);
            this.setStepSize(new Double(d2));
        }

        private double orderOfMagnitude(double d) {
            if (d == 0.0) {
                return 0.0;
            }
            double d2 = Math.abs(d);
            if (d2 >= 1.0) {
                return Math.floor(0.4342944819 * Math.log(d2));
            }
            return -(1.0 + Math.floor(0.4342944819 * Math.log(1.0 / d2)));
        }

        public double getDoubleValue() {
            return this.getNumber().doubleValue();
        }

        private double getLastValue() {
            return this.fLastValue;
        }

        private void setLastValue(double d) {
            this.fLastValue = d;
        }
    }
}

