/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.util;

import com.mathworks.toolbox.instrument.device.DeviceClient;
import com.mathworks.toolbox.instrument.device.PropertyInfo;
import com.mathworks.toolbox.instrument.device.util.PropertyUtil;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.util.Vector;

public class Displays {
    private Displays() {
    }

    public static final String invalidDisplay() {
        return TMStringUtil.LINESEP + "   Invalid instrument object." + TMStringUtil.LINESEP + "   This object has been deleted and cannot be" + TMStringUtil.LINESEP + "   connected to the hardware. This object should" + TMStringUtil.LINESEP + "   be removed from your workspace with CLEAR." + TMStringUtil.LINESEP + " " + TMStringUtil.LINESEP;
    }

    public static final String invalidChildDisplay(String string) {
        return TMStringUtil.LINESEP + "   Invalid device " + string + " object." + TMStringUtil.LINESEP + "   This object has been deleted and cannot be" + TMStringUtil.LINESEP + "   connected to the hardware. This object should" + TMStringUtil.LINESEP + "   be removed from your workspace with CLEAR." + TMStringUtil.LINESEP + " " + TMStringUtil.LINESEP;
    }

    public static final String setDisplay(DeviceClient deviceClient) throws TMException {
        String string = "";
        Vector<String> vector = deviceClient.getBasePropertyNames();
        for (int i = 0; i < vector.size(); ++i) {
            PropertyInfo propertyInfo = deviceClient.getPropertyInfo(vector.elementAt(i));
            if (propertyInfo.readOnly.equals("always")) continue;
            string = string + "    " + Displays.createSetDisplayPropertyString(deviceClient, propertyInfo) + TMStringUtil.LINESEP;
        }
        Vector vector2 = deviceClient.getProperties();
        if (vector2 == null) {
            return string + TMStringUtil.LINESEP;
        }
        vector2 = TMStringUtil.stringArray2Vector((String[])TMStringUtil.sort((String[])TMStringUtil.vector2StringArray(vector2)));
        boolean bl = false;
        for (int i = 0; i < vector2.size(); ++i) {
            PropertyInfo propertyInfo = deviceClient.getPropertyInfo((String)vector2.elementAt(i));
            if (propertyInfo.readOnly.equals("always")) continue;
            if (!bl) {
                string = string + TMStringUtil.LINESEP + "    " + deviceClient.getType().toUpperCase() + " specific properties:" + TMStringUtil.LINESEP;
                bl = true;
            }
            string = string + "    " + Displays.createSetDisplayPropertyString(deviceClient, propertyInfo) + TMStringUtil.LINESEP;
        }
        string = string + TMStringUtil.LINESEP;
        return string;
    }

    private static String createSetDisplayPropertyString(DeviceClient deviceClient, PropertyInfo propertyInfo) {
        if (propertyInfo.type.equals("callback")) {
            return propertyInfo.name + ": string -or- function handle -or- cell array";
        }
        return propertyInfo.name + ": " + PropertyUtil.createEnumSetList(deviceClient, propertyInfo);
    }
}

