/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtool.panel;

import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverClient;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverModel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.MIDNode;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.MIDTextField;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.panel.BasePanel;
import com.mathworks.toolbox.instrument.guiutil.FillPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class SummaryPanel
extends BasePanel
implements ActionListener,
ItemListener,
DocumentListener {
    private static final long serialVersionUID = 1L;
    private static final String[] sDefaultInstrumentTypes = new String[]{"DC Power Supply", "Digital Multimeter", "Filter", "Function Generator", "Vector Analyzer", "Oscilloscope", "Switch"};
    private MJComboBox fInstrumentType;
    private MIDTextField fInstrumentManufacturer;
    private MIDTextField fInstrumentModel;
    private MIDTextField fInstrumentDriverVersion;
    private MJTextField fIdentify;
    private MJTextField fReset;
    private MJTextField fSelftest;
    private MJTextField fError;
    private MJPanel fSummaryPanel;
    private MJPanel fInfoPanel;
    private MJPanel fCommandPanel;
    GridBagConstraints fCommandPanelConstraints;
    private Vector<String> fCachedInstrumentTypes;
    private DriverModel fModel;

    public SummaryPanel(DriverClient driverClient) {
        super(driverClient);
        this.layoutPanel();
        this.fCachedInstrumentTypes = new Vector();
        for (int i = 0; i < sDefaultInstrumentTypes.length; ++i) {
            this.fCachedInstrumentTypes.add(sDefaultInstrumentTypes[i]);
        }
    }

    protected void layoutPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createSummaryPanel(), "Center");
    }

    private MJPanel createInfoPanel() {
        this.fInfoPanel = new MJPanel((LayoutManager)new GridBagLayout());
        this.fInfoPanel.setBorder((Border)BorderFactory.createTitledBorder("Driver summary"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0);
        this.fInfoPanel.add((Component)new MJLabel("Manufacturer:"), (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.fInfoPanel.add((Component)new MJLabel("Supported models:"), (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.fInfoPanel.add((Component)new MJLabel("Instrument type:"), (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.fInfoPanel.add((Component)new MJLabel("Driver version:"), (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0);
        this.fInstrumentManufacturer = new MIDTextField();
        this.fInstrumentManufacturer.setOKToBeEmpty(false);
        this.fInstrumentManufacturer.setPropertyName("instrument manufacturer");
        this.fInstrumentManufacturer.setColumns(20);
        this.fInstrumentManufacturer.getDocument().addDocumentListener(this);
        this.fInfoPanel.add((Component)((Object)this.fInstrumentManufacturer), (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        this.fInstrumentModel = new MIDTextField();
        this.fInstrumentModel.setOKToBeEmpty(false);
        this.fInstrumentModel.setPropertyName("instrument model");
        this.fInstrumentModel.getDocument().addDocumentListener(this);
        this.fInfoPanel.add((Component)((Object)this.fInstrumentModel), (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.fInstrumentType = new MJComboBox((Object[])sDefaultInstrumentTypes);
        this.fInstrumentType.setEditable(true);
        this.fInstrumentType.addItemListener((ItemListener)this);
        this.fInstrumentType.addActionListener((ActionListener)this);
        if (this.fInstrumentType.getEditor().getEditorComponent() instanceof JTextField) {
            ((JTextComponent)this.fInstrumentType.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
        }
        this.fInfoPanel.add((Component)this.fInstrumentType, (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.fInstrumentDriverVersion = new MIDTextField();
        this.fInstrumentDriverVersion.setPropertyName("instrument driver version");
        this.fInstrumentDriverVersion.setOKToBeEmpty(false);
        this.fInstrumentDriverVersion.setColumns(4);
        this.fInfoPanel.add((Component)((Object)this.fInstrumentDriverVersion), (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.fInfoPanel.add((Component)((Object)new FillPanel()), (Object)gridBagConstraints);
        return this.fInfoPanel;
    }

    private MJPanel createCommandPanel() {
        this.fCommandPanel = new MJPanel((LayoutManager)new GridBagLayout());
        this.fCommandPanel.setBorder((Border)BorderFactory.createTitledBorder("Common commands"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0);
        this.fCommandPanel.add((Component)new MJLabel("Identify:"), (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.fCommandPanel.add((Component)new MJLabel("Reset:"), (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.fCommandPanel.add((Component)new MJLabel("Self test:"), (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.fCommandPanel.add((Component)new MJLabel("Error:"), (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0);
        this.fIdentify = new MJTextField();
        this.fIdentify.setColumns(25);
        this.fCommandPanel.add((Component)this.fIdentify, (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.fReset = new MJTextField();
        this.fCommandPanel.add((Component)this.fReset, (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.fSelftest = new MJTextField();
        this.fCommandPanel.add((Component)this.fSelftest, (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.fError = new MJTextField();
        this.fCommandPanel.add((Component)this.fError, (Object)gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.fCommandPanel.add((Component)((Object)new FillPanel()), (Object)gridBagConstraints);
        return this.fCommandPanel;
    }

    protected MJPanel createSummaryPanel() {
        this.fSummaryPanel = new MJPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0);
        this.fSummaryPanel.add((Component)this.createInfoPanel(), (Object)gridBagConstraints);
        this.fCommandPanelConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        this.fSummaryPanel.add((Component)this.createCommandPanel(), (Object)this.fCommandPanelConstraints);
        FillPanel.addFillPanelTo((JComponent)this.fSummaryPanel, 2);
        return this.fSummaryPanel;
    }

    @Override
    public void updatePanel(MIDNode mIDNode) {
        this.fModel = this.fDriverClient.getDriverModel();
        this.setIsListening(false);
        this.fInstrumentType.setSelectedItem((Object)this.fModel.getInstrumentType());
        this.fInstrumentManufacturer.setText(this.fModel.getInstrumentManufacturer());
        this.fInstrumentModel.setText(this.fModel.getInstrumentModel());
        this.fInstrumentDriverVersion.setText(this.fModel.getInstrumentVersion());
        this.fIdentify.setText(this.fModel.getIdentifyCommand());
        this.fReset.setText(this.fModel.getResetCommand());
        this.fSelftest.setText(this.fModel.getSelfTestCommand());
        this.fError.setText(this.fModel.getErrorCommand());
        this.setIsListening(true);
    }

    @Override
    public void driverDidLoad(DriverModel driverModel) {
        if (driverModel.getDriverType() == 0) {
            if (this.fCommandPanel.getParent() == null) {
                this.fSummaryPanel.add((Component)this.fCommandPanel, (Object)this.fCommandPanelConstraints);
            }
        } else if (this.fCommandPanel.getParent() != null) {
            this.fSummaryPanel.remove((Component)this.fCommandPanel);
        }
    }

    @Override
    public void updateNode(MIDNode mIDNode) {
        this.fModel.setInstrumentManufacturer(this.fInstrumentManufacturer.getText());
        this.fModel.setInstrumentModel(this.fInstrumentModel.getText());
        this.fModel.setInstrumentType((String)this.fInstrumentType.getSelectedItem());
        this.fModel.setInstrumentVersion(this.fInstrumentDriverVersion.getText());
        this.fModel.setIdentifyCommand(this.fIdentify.getText());
        this.fModel.setResetCommand(this.fReset.getText());
        this.fModel.setSelfTestCommand(this.fSelftest.getText());
        this.fModel.setErrorCommand(this.fError.getText());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 2) {
            return;
        }
        if ((MJComboBox)itemEvent.getSource() == this.fInstrumentType) {
            this.instrumentInfoChanged();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.instrumentInfoChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.instrumentInfoChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.instrumentInfoChanged();
    }

    protected void instrumentInfoChanged() {
        if (!this.isListening()) {
            return;
        }
        this.fModel.setInstrumentManufacturer(this.fInstrumentManufacturer.getText());
        this.fModel.setInstrumentModel(this.fInstrumentModel.getText());
        this.fModel.setInstrumentType((String)this.fInstrumentType.getEditor().getItem());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = (String)this.fInstrumentType.getSelectedItem();
        if (string.length() == 0) {
            MJOptionPane.showMessageDialog((Component)this.fDriverClient.getBrowserFrame(), (Object)"The instrument type cannot be empty.", (String)"Instrument Type", (int)0);
            this.fInstrumentType.setSelectedItem((Object)this.fModel.getInstrumentType());
            return;
        }
        if (!this.fCachedInstrumentTypes.contains(string)) {
            this.fCachedInstrumentTypes.add(string);
            this.fInstrumentType.addItem((Object)string);
        }
        this.fModel.setInstrumentType(string);
    }
}

