/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtool;

import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverDataType;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverFileReader;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverFileWriter;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverFunction;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverGroup;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverModel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverProperty;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.event.DriverModelEvent;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.event.DriverModelListener;
import com.mathworks.toolbox.instrument.device.icdevice.ICDevice;
import com.mathworks.toolbox.instrument.device.icdevice.ICDeviceChild;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.io.File;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Document;

public class DefaultDriverModel
implements DriverModel,
DriverModelListener {
    public static final String sInitCreateMCode = "function init(obj)\n% This function is called after the object is created.\n% OBJ is the device object.\n% End of function definition - DO NOT EDIT\n";
    public static final String sInitConnectMCode = "function init(obj)\n% This function is called after the object is connected.\n% OBJ is the device object.\n% End of function definition - DO NOT EDIT\n";
    public static final String sCleanupMCode = "function cleanup(obj)\n% This function is called before the object is disconnected.\n% OBJ is the device object.\n% End of function definition - DO NOT EDIT\n";
    private File fFile;
    private boolean fIsDirty;
    private boolean fFileReadOrSaved;
    private String fileVersion;
    private String driverName;
    private int driverType;
    private String instrumentType;
    private String instrumentManufacturer;
    private String instrumentModel;
    private String instrumentVersion;
    private String initCreateMCode;
    private Vector<String> initConnectCode;
    private String initConnectMCode;
    private int initConnectType;
    private Vector<String> cleanupCode;
    private String cleanupMCode;
    private int cleanupType;
    private String identify;
    private String reset;
    private String selftest;
    private String error;
    private Hashtable<String, DriverGroup> groups;
    private Vector<String> groupNames;
    private Vector<DriverModelListener> listeners;
    private String getAttributeAccessorGroupName;
    private String setAttributeAccessorGroupName;

    public DefaultDriverModel() {
        this(0);
    }

    public DefaultDriverModel(int n) {
        this.setFile((String)null);
        this.initialize(n);
    }

    public DefaultDriverModel(String string, int n) throws TMException {
        this.setFile(string);
        this.initialize(n);
        if (this.fFile.exists()) {
            this.read();
            this.fFileReadOrSaved = true;
        }
    }

    private void initialize(int n) {
        this.fileVersion = "2.42";
        this.driverName = "";
        this.driverType = n;
        this.instrumentType = "Oscilloscope";
        this.instrumentManufacturer = "Manufacturer";
        this.instrumentModel = "Model";
        this.instrumentVersion = "1.0";
        this.groups = new Hashtable();
        this.groupNames = new Vector();
        this.listeners = new Vector();
        DriverGroup driverGroup = this.createGroup("parent");
        this.add(driverGroup);
        this.initCreateMCode = sInitCreateMCode;
        this.initConnectType = 0;
        this.initConnectCode = new Vector();
        this.initConnectMCode = sInitConnectMCode;
        this.cleanupType = 0;
        this.cleanupCode = new Vector();
        this.cleanupMCode = sCleanupMCode;
        if (this.driverType == 0) {
            this.identify = "*IDN?";
            this.reset = "*RST";
            this.selftest = "*TST?";
            this.error = "System:Error?";
        } else {
            this.identify = "";
            this.reset = "";
            this.selftest = "";
            this.error = "";
        }
        this.fFileReadOrSaved = false;
        this.addDriverModelListener(this);
        this.setDirty(false);
    }

    public File getFile() {
        return this.fFile;
    }

    public void setFile(File file) {
        try {
            this.fFile = new File(file.getAbsolutePath());
        }
        catch (Exception exception) {
            this.fFile = new File(this.getDefaultDocumentName());
        }
    }

    public void setFile(String string) {
        try {
            this.fFile = new File(string);
        }
        catch (NullPointerException nullPointerException) {
            this.fFile = new File(this.getDefaultDocumentName());
        }
    }

    public String getFileName() {
        return this.fFile.getAbsolutePath();
    }

    private void setDirty(boolean bl) {
        this.fIsDirty = bl;
    }

    public boolean isDirty() {
        return this.fIsDirty;
    }

    public void save() {
        this.save(this.fFile.getAbsolutePath());
    }

    public void save(String string) {
        String string2 = this.verifyExtension(string);
        if (!string2.equals(string)) {
            this.setFile(string2);
        }
        DriverFileWriter driverFileWriter = new DriverFileWriter(this);
        try {
            driverFileWriter.writeXML(string2);
        }
        catch (TMException tMException) {
            // empty catch block
        }
        this.setDirty(false);
        this.fFileReadOrSaved = true;
    }

    private void read() throws TMException {
        this.read(this.getFileName());
        this.setDirty(false);
    }

    private void read(String string) throws TMException {
        DriverFileReader driverFileReader = new DriverFileReader(this);
        this.removeDriverModelListener(this);
        driverFileReader.readXML(string);
        this.addDriverModelListener(this);
    }

    public boolean isValid() {
        return this.fFileReadOrSaved && this.fFile.exists();
    }

    private String getDefaultDocumentName() {
        return "untitled.mdd";
    }

    public String getDocumentName(boolean bl) {
        if (bl) {
            return this.fFile.getName();
        }
        return this.removeExtension(this.fFile.getName());
    }

    public String getWindowName() {
        return this.instrumentManufacturer + " " + this.instrumentModel + " " + this.instrumentType;
    }

    public String verifyExtension(String string) {
        if (string == null || string.length() == 0) {
            return "untitled.mdd";
        }
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string + ".mdd";
        }
        return string;
    }

    private String removeExtension(String string) {
        int n = string.lastIndexOf(46);
        String string2 = string.substring(n + 1);
        if (string2.equals("mdd") || string2.equals("xml")) {
            return string.substring(0, n);
        }
        return string;
    }

    @Override
    public void driverStateChanged(DriverModelEvent driverModelEvent) {
        switch (driverModelEvent.getType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                this.setDirty(true);
                break;
            }
            case 6: {
                DriverGroup driverGroup = (DriverGroup)driverModelEvent.getSource();
                String string = (String)driverModelEvent.getTarget();
                this.groups.remove(string);
                this.groups.put(driverGroup.getName(), driverGroup);
                this.groupNames.remove(string);
                int n = -1;
                for (int i = 1; i < this.groupNames.size(); ++i) {
                    String string2 = this.groupNames.get(i);
                    if (driverGroup.getName().compareToIgnoreCase(string2) >= 0) continue;
                    n = i;
                    break;
                }
                if (n < 0) {
                    n = this.groupNames.size();
                }
                this.groupNames.insertElementAt(driverGroup.getName(), n);
            }
            case 10: 
            case 14: {
                this.refireDriverModelChangedEvent(driverModelEvent);
                this.setDirty(true);
            }
        }
    }

    public Document createDocument() {
        DriverFileWriter driverFileWriter = new DriverFileWriter(this);
        return driverFileWriter.createDocument();
    }

    @Override
    public boolean isStandaloneDriver() {
        return this.driverType == 0 || this.driverType == 4;
    }

    @Override
    public boolean isDriverWrapper() {
        return !this.isStandaloneDriver();
    }

    @Override
    public String getFileVersion() {
        return this.fileVersion;
    }

    @Override
    public void setFileVersion(String string) {
        if (this.fileVersion.compareTo(string) != 0) {
            this.fileVersion = string;
        }
    }

    @Override
    public String getDriverName() {
        return this.driverName;
    }

    @Override
    public void setDriverName(String string) {
        if (this.driverName.compareTo(string) != 0) {
            this.driverName = string;
        }
    }

    @Override
    public int getDriverType() {
        return this.driverType;
    }

    @Override
    public void setDriverType(int n) {
        if (this.driverType != n) {
            this.driverType = n;
        }
    }

    @Override
    public String getInstrumentType() {
        return this.instrumentType;
    }

    @Override
    public void setInstrumentType(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.instrumentType.compareTo(string) != 0) {
            this.instrumentType = string;
            this.fireDriverModelChangedEvent(0);
        }
    }

    @Override
    public String getInstrumentManufacturer() {
        return this.instrumentManufacturer;
    }

    @Override
    public void setInstrumentManufacturer(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.instrumentManufacturer.compareTo(string) != 0) {
            this.instrumentManufacturer = string;
            this.fireDriverModelChangedEvent(0);
        }
    }

    @Override
    public String getInstrumentModel() {
        return this.instrumentModel;
    }

    @Override
    public void setInstrumentModel(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.instrumentModel.compareTo(string) != 0) {
            this.instrumentModel = string;
            this.fireDriverModelChangedEvent(0);
        }
    }

    @Override
    public String getInstrumentVersion() {
        return this.instrumentVersion;
    }

    @Override
    public void setInstrumentVersion(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.instrumentVersion.compareTo(string) != 0) {
            this.instrumentVersion = string;
            this.fireDriverModelChangedEvent(0);
        }
    }

    @Override
    public String getIdentifyCommand() {
        return this.identify;
    }

    @Override
    public void setIdentifyCommand(String string) {
        if (this.identify.compareTo(string) != 0) {
            this.identify = string;
            this.fireDriverModelChangedEvent(1);
        }
    }

    @Override
    public String getResetCommand() {
        return this.reset;
    }

    @Override
    public void setResetCommand(String string) {
        if (this.reset.compareTo(string) != 0) {
            this.reset = string;
            this.fireDriverModelChangedEvent(1);
        }
    }

    @Override
    public String getSelfTestCommand() {
        return this.selftest;
    }

    @Override
    public void setSelfTestCommand(String string) {
        if (this.selftest.compareTo(string) != 0) {
            this.selftest = string;
            this.fireDriverModelChangedEvent(1);
        }
    }

    @Override
    public String getErrorCommand() {
        return this.error;
    }

    @Override
    public void setErrorCommand(String string) {
        if (this.error.compareTo(string) != 0) {
            this.error = string;
            this.fireDriverModelChangedEvent(1);
        }
    }

    @Override
    public void setCreateInitMCode(String string) {
        if (string == null || string.length() == 0) {
            this.initCreateMCode = sInitCreateMCode;
            return;
        }
        if (!this.initCreateMCode.equalsIgnoreCase(string)) {
            this.initCreateMCode = string;
            this.fireDriverModelChangedEvent(2);
        }
    }

    @Override
    public String getCreateInitMCode() {
        return this.initCreateMCode;
    }

    @Override
    public void appendCreateInitMCode(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.initCreateMCode = this.initCreateMCode + string;
        this.fireDriverModelChangedEvent(2);
    }

    @Override
    public void setConnectInitCode(Vector<String> vector) {
        if (vector == null || vector.size() == 0) {
            if (this.initConnectCode.size() != 0) {
                this.initConnectCode.clear();
                this.fireDriverModelChangedEvent(2);
            }
            return;
        }
        if (vector.size() != this.initConnectCode.size()) {
            this.initConnectCode = vector;
            this.fireDriverModelChangedEvent(2);
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.get(i).equals(this.initConnectCode.get(i))) continue;
            this.initConnectCode = vector;
            this.fireDriverModelChangedEvent(2);
            return;
        }
    }

    @Override
    public void setConnectInitCode(String string, int n) {
        if (!string.equals(this.initConnectCode.get(n))) {
            this.initConnectCode.setElementAt(string, n);
            this.fireDriverModelChangedEvent(2);
        }
    }

    @Override
    public Vector<String> getConnectInitCode() {
        return this.initConnectCode;
    }

    @Override
    public void appendConnectInitCode(String string) {
        if (string != null && string.length() > 0) {
            this.initConnectCode.add(string);
            this.fireDriverModelChangedEvent(2);
        }
    }

    @Override
    public void removeConnectInitCode(int n) {
        this.initConnectCode.removeElementAt(n);
        this.fireDriverModelChangedEvent(2);
    }

    @Override
    public void setConnectInitMCode(String string) {
        if (string == null || string.length() == 0) {
            this.initConnectMCode = sInitConnectMCode;
            return;
        }
        if (!this.initConnectMCode.equals(string)) {
            this.initConnectMCode = string;
            this.fireDriverModelChangedEvent(2);
        }
    }

    @Override
    public String getConnectInitMCode() {
        return this.initConnectMCode;
    }

    @Override
    public void appendConnectInitMCode(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.initConnectMCode = this.initConnectMCode + string;
        this.fireDriverModelChangedEvent(2);
    }

    public void setConnectInitMCodeForIvi() {
        String string = "\n% NOTE: This code is required to support driver interfaces that are collections.\n%       Deleting or altering this code may prevent device objects using this\n%       driver from operating correctly.\n\ncomobj = get(obj, 'Interface');\n\n";
        this.appendConnectInitMCode(string);
        this.setConnectInitType(1);
    }

    public void appendConnectInitMCodeForIvi(String string, String[] stringArray) {
        if (stringArray == null) {
            this.appendConnectInitMCode(string + "\n");
            return;
        }
        String string2 = "try\n\tcollection = comobj;\n";
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = string2 + "\tcollection = get(collection, '" + stringArray[i] + "');\n";
        }
        string2 = string2 + "\tinstrgate('privateIviComDriverHelper', 'group', obj, collection, '" + string + "');\n";
        string2 = string2 + "catch e\n";
        string2 = string2 + "\terrorMsg = instrgate('privateCOMGetErrorInfo');\n";
        string2 = string2 + "\twarning('%s',errorMsg.Description);\nend\n\n";
        this.appendConnectInitMCode(string2);
    }

    public void appendConnectInitMCodeForIviNested(String string, String[] stringArray) {
        int n;
        String string2 = "collection = comobj;\n";
        for (n = 0; n < stringArray.length; ++n) {
            string2 = string2 + "collection = get(collection, '" + stringArray[n] + "');\n";
        }
        string2 = string2 + "instrgate('privateIviComDriverHelper', 'nestedgroup', obj, collection, '" + stringArray[n - 1] + "' , '" + string + "');\n\n";
        this.appendConnectInitMCode(string2);
    }

    @Override
    public void setConnectInitType(int n) {
        if (this.initConnectType != n) {
            this.initConnectType = n;
            this.fireDriverModelChangedEvent(2);
        }
    }

    @Override
    public int getConnectInitType() {
        return this.initConnectType;
    }

    @Override
    public void setDisconnectCode(Vector<String> vector) {
        if (vector == null || vector.size() == 0) {
            if (this.cleanupCode.size() != 0) {
                this.cleanupCode.clear();
                this.fireDriverModelChangedEvent(2);
            }
            return;
        }
        if (vector.size() != this.cleanupCode.size()) {
            this.cleanupCode = vector;
            this.fireDriverModelChangedEvent(2);
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.get(i).equals(this.cleanupCode.get(i))) continue;
            this.cleanupCode = vector;
            this.fireDriverModelChangedEvent(2);
            return;
        }
    }

    @Override
    public void setDisconnectCode(String string, int n) {
        if (!string.equals(this.cleanupCode.get(n))) {
            this.cleanupCode.setElementAt(string, n);
            this.fireDriverModelChangedEvent(2);
        }
    }

    @Override
    public Vector<String> getDisconnectCode() {
        return this.cleanupCode;
    }

    @Override
    public void appendDisconnectCode(String string) {
        if (string != null && string.length() > 0) {
            this.cleanupCode.add(string);
            this.fireDriverModelChangedEvent(2);
        }
    }

    @Override
    public void removeDisconnectCode(int n) {
        this.cleanupCode.removeElementAt(n);
        this.fireDriverModelChangedEvent(2);
    }

    @Override
    public void setDisconnectMCode(String string) {
        if (string == null || string.length() == 0) {
            this.cleanupMCode = sCleanupMCode;
            return;
        }
        if (!this.cleanupMCode.equalsIgnoreCase(string)) {
            this.cleanupMCode = string;
            this.fireDriverModelChangedEvent(2);
        }
    }

    @Override
    public String getDisconnectMCode() {
        return this.cleanupMCode;
    }

    @Override
    public void setDisconnectType(int n) {
        if (this.cleanupType != n) {
            this.cleanupType = n;
            this.fireDriverModelChangedEvent(2);
        }
    }

    @Override
    public int getDisconnectType() {
        return this.cleanupType;
    }

    @Override
    public DriverGroup[] getGroups() {
        DriverGroup[] driverGroupArray = new DriverGroup[this.groups.size()];
        for (int i = 0; i < this.groupNames.size(); ++i) {
            driverGroupArray[i] = this.groups.get(this.groupNames.get(i));
        }
        return driverGroupArray;
    }

    @Override
    public DriverGroup getGroup(String string) {
        return this.groups.get(string);
    }

    @Override
    public Vector<String> getGroupNames() {
        return this.groupNames;
    }

    @Override
    public DriverGroup createGroup(String string) {
        return new DriverGroup(string);
    }

    @Override
    public int isValidGroupName(String string) {
        for (int i = 0; i < this.groupNames.size(); ++i) {
            if (!this.groupNames.get(i).equalsIgnoreCase(string)) continue;
            return 1;
        }
        Vector<String> vector = this.groups.get("parent").getPropertyNames();
        for (int i = 0; i < vector.size(); ++i) {
            if (!vector.get(i).equalsIgnoreCase(string)) continue;
            return 5;
        }
        if (this.getDriverType() == 0) {
            String[] stringArray = ICDevice.BASE_PROPS;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase(string)) continue;
                return 2;
            }
        }
        if (!TMStringUtil.isvarname((String)string)) {
            return 3;
        }
        return 0;
    }

    @Override
    public void add(DriverGroup driverGroup) {
        int n = -1;
        String string = driverGroup.getName();
        if (!this.groups.containsKey(string)) {
            this.groups.put(string, driverGroup);
            if (!string.equalsIgnoreCase("parent")) {
                for (int i = 1; i < this.groupNames.size(); ++i) {
                    String string2 = this.groupNames.get(i);
                    if (string.compareToIgnoreCase(string2) >= 0) continue;
                    n = i;
                    break;
                }
                if (n < 0) {
                    n = this.groupNames.size();
                }
            } else {
                n = 0;
            }
            this.groupNames.insertElementAt(string, n);
        } else {
            DriverGroup driverGroup2 = this.groups.get(string);
            driverGroup2.merge(driverGroup, true);
        }
        Vector<DriverFunction> vector = driverGroup.getFunctions();
        for (int i = 0; i < vector.size(); ++i) {
            vector.get(i).addDriverModelListener(this);
        }
        driverGroup.addDriverModelListener(this);
        driverGroup.setDriverModel(this);
        if (n >= 0) {
            this.fireDriverModelChangedEvent(3, driverGroup, n - 1);
        }
    }

    @Override
    public void remove(DriverGroup driverGroup) {
        if (this.groups.contains(driverGroup)) {
            this.groupNames.remove(driverGroup.getName());
            this.groups.remove(driverGroup.getName());
            this.fireDriverModelChangedEvent(4, driverGroup);
        }
    }

    @Override
    public Vector<Object> getProperties(String string) {
        DriverGroup driverGroup = this.getGroup(string);
        if (driverGroup != null) {
            return driverGroup.getProperties();
        }
        return null;
    }

    @Override
    public DriverProperty getProperty(String string, String string2) {
        DriverGroup driverGroup = this.getGroup(string2);
        if (driverGroup != null) {
            Vector<Object> vector = driverGroup.getProperties();
            for (int i = 0; i < vector.size(); ++i) {
                if (!((DriverProperty)vector.get(i)).getName().equalsIgnoreCase(string)) continue;
                return (DriverProperty)vector.get(i);
            }
        }
        return null;
    }

    @Override
    public Vector<String> getPropertyNames(String string) {
        DriverGroup driverGroup = this.getGroup(string);
        if (driverGroup != null) {
            return driverGroup.getPropertyNames();
        }
        return null;
    }

    public Vector<DriverProperty> getEnumeratedProperties(String string) {
        DriverGroup driverGroup = this.getGroup(string);
        if (driverGroup == null) {
            return new Vector<DriverProperty>();
        }
        Vector<Object> vector = driverGroup.getProperties();
        Vector<DriverProperty> vector2 = new Vector<DriverProperty>();
        for (int i = 0; i < vector.size(); ++i) {
            DriverProperty driverProperty = (DriverProperty)vector.get(i);
            if (!driverProperty.isEnumeratedProperty()) continue;
            vector2.add(driverProperty);
        }
        return vector2;
    }

    @Override
    public Vector<String> getEnumeratedPropertyNames(String string) {
        Vector<DriverProperty> vector = this.getEnumeratedProperties(string);
        if (vector == null) {
            return new Vector<String>();
        }
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < vector.size(); ++i) {
            DriverProperty driverProperty = vector.get(i);
            vector2.add(new String(driverProperty.getName()));
        }
        return vector2;
    }

    @Override
    public DriverProperty createProperty(String string, DriverGroup driverGroup) {
        DriverProperty driverProperty = new DriverProperty(string, driverGroup);
        driverProperty.setConfigureCommand("");
        driverProperty.setQueryCommand("");
        driverProperty.setDescription("");
        driverProperty.setReadOnly("Never");
        driverProperty.addPropertyType(new DriverDataType());
        return driverProperty;
    }

    @Override
    public int isValidPropertyName(String string, DriverGroup driverGroup) {
        if (this.getDriverType() == 0) {
            int n;
            String[] stringArray = driverGroup.isParentGroup() ? ICDevice.BASE_PROPS : ICDeviceChild.BASE_PROPS;
            for (n = 0; n < stringArray.length; ++n) {
                if (!stringArray[n].equalsIgnoreCase(string)) continue;
                return 2;
            }
            if (driverGroup.isParentGroup()) {
                for (n = 0; n < this.groupNames.size(); ++n) {
                    if (!this.groupNames.get(n).equalsIgnoreCase(string)) continue;
                    return 6;
                }
            }
        }
        if (!TMStringUtil.isvarname((String)string)) {
            return 3;
        }
        if (this.containsGroup(driverGroup)) {
            return driverGroup.isValidPropertyName(string);
        }
        return 4;
    }

    @Override
    public int add(DriverProperty driverProperty) {
        if (driverProperty == null) {
            return -1;
        }
        DriverGroup driverGroup = driverProperty.getGroup();
        if (!this.containsGroup(driverGroup)) {
            this.add(driverGroup);
        } else {
            driverGroup = this.getGroup(driverGroup.getName());
        }
        int n = driverGroup.add(driverProperty);
        this.fireDriverModelChangedEvent(7, driverProperty, n);
        return n;
    }

    @Override
    public void remove(DriverProperty driverProperty) {
        DriverGroup driverGroup = driverProperty.getGroup();
        driverGroup.remove(driverProperty);
        this.fireDriverModelChangedEvent(8, driverProperty);
    }

    @Override
    public Vector<DriverFunction> getFunctions(DriverGroup driverGroup) {
        if (this.containsGroup(driverGroup)) {
            return driverGroup.getFunctions();
        }
        return null;
    }

    @Override
    public DriverFunction getFunction(String string, DriverGroup driverGroup) {
        if (this.containsGroup(driverGroup)) {
            Vector<DriverFunction> vector = driverGroup.getFunctions();
            for (int i = 0; i < vector.size(); ++i) {
                if (!vector.get(i).getName().equalsIgnoreCase(string)) continue;
                return vector.get(i);
            }
        }
        return null;
    }

    @Override
    public Vector<String> getFunctionNames(DriverGroup driverGroup) {
        if (this.containsGroup(driverGroup)) {
            return driverGroup.getFunctionNames();
        }
        return null;
    }

    @Override
    public DriverFunction createFunction(String string, DriverGroup driverGroup) {
        DriverFunction driverFunction = new DriverFunction(string, driverGroup);
        driverFunction.setCodeType(0);
        if (string.equalsIgnoreCase("getattributevistring")) {
            this.setAttributeAccessorGroupName = driverGroup.getName();
        }
        if (string.equalsIgnoreCase("setattributevistring")) {
            this.setAttributeAccessorGroupName = driverGroup.getName();
        }
        return driverFunction;
    }

    public String getSetAttributeAccessorGroupName() {
        return this.getAttributeAccessorGroupName;
    }

    public String getGetAttributeAccessorGroupName() {
        return this.setAttributeAccessorGroupName;
    }

    @Override
    public boolean containsGroup(DriverGroup driverGroup) {
        return this.groups.get(driverGroup.getName()) != null;
    }

    @Override
    public int isValidFunctionName(String string, DriverGroup driverGroup) {
        if (!TMStringUtil.ismethodname((String)string)) {
            return 3;
        }
        if (this.containsGroup(driverGroup)) {
            return driverGroup.isValidFunctionName(string);
        }
        return 4;
    }

    @Override
    public int add(DriverFunction driverFunction) {
        if (driverFunction == null) {
            return -1;
        }
        DriverGroup driverGroup = driverFunction.getGroup();
        if (!this.containsGroup(driverGroup)) {
            this.add(driverGroup);
        } else {
            driverGroup = this.getGroup(driverGroup.getName());
        }
        int n = driverGroup.add(driverFunction);
        this.fireDriverModelChangedEvent(11, driverFunction, n);
        return n;
    }

    @Override
    public void remove(DriverFunction driverFunction) {
        DriverGroup driverGroup = driverFunction.getGroup();
        driverGroup.remove(driverFunction);
        this.fireDriverModelChangedEvent(12, driverFunction);
    }

    @Override
    public void addDriverModelListener(DriverModelListener driverModelListener) {
        if (!this.listeners.contains(driverModelListener)) {
            this.listeners.add(driverModelListener);
        }
    }

    @Override
    public void removeDriverModelListener(DriverModelListener driverModelListener) {
        this.listeners.remove(driverModelListener);
    }

    protected void fireDriverModelChangedEvent(int n) {
        this.fireDriverModelChangedEvent(n, null, 0);
    }

    protected void fireDriverModelChangedEvent(int n, Object object) {
        this.fireDriverModelChangedEvent(n, object, 0);
    }

    protected void fireDriverModelChangedEvent(int n, Object object, int n2) {
        DriverModelEvent driverModelEvent = new DriverModelEvent(this, n, object, n2);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).driverStateChanged(driverModelEvent);
        }
    }

    protected void refireDriverModelChangedEvent(DriverModelEvent driverModelEvent) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (this.listeners.get(i).equals(this)) continue;
            this.listeners.get(i).driverStateChanged(driverModelEvent);
        }
    }

    public static boolean isEqual(Hashtable<Object, Object> hashtable, Hashtable<Object, Object> hashtable2) {
        Set<Object> set;
        if (hashtable == null) {
            return hashtable2 == null;
        }
        if (hashtable2 == null) {
            return false;
        }
        if (hashtable.isEmpty()) {
            return hashtable2.isEmpty();
        }
        if (hashtable2.isEmpty()) {
            return false;
        }
        Set<Object> set2 = hashtable.keySet();
        if (set2.containsAll(set = hashtable2.keySet()) && set.containsAll(set2)) {
            for (Object object : set2) {
                if (hashtable2.get(object).equals(hashtable.get(object))) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }
}

