/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtest;

import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class SaveTestWithDriverDialog
extends JPanel
implements ActionListener,
WindowListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    private static final String ACTION = "ACTION";
    private static final int OK = 0;
    private static final int CANCEL = 1;
    private MJFrame frame;
    private MJDialog dialog;
    private JTextField nameField;
    private JLabel cmdField;
    private JButton okButton;
    private Vector<String> methodNames;
    private boolean dialogCanceled = false;

    public SaveTestWithDriverDialog() {
        this.setLayout(new BorderLayout(0, 4));
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.layoutPanel();
    }

    public void update(Vector<String> vector) {
        this.methodNames = null;
        this.methodNames = vector;
        this.initName();
    }

    private void layoutPanel() {
        this.add((Component)this.createTextPanel(), "North");
        this.add((Component)this.createButtonPanel(), "South");
    }

    private JPanel createTextPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 8));
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 0));
        jPanel2.add((Component)new JLabel("Specify the driver function name:"), "West");
        this.nameField = new JTextField("drivertest");
        this.nameField.addKeyListener(this);
        jPanel2.add((Component)this.nameField, "Center");
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setText("Use the following command to execute this driver function from the MATLAB command line (where deviceObj is the device object):");
        jTextArea.setBackground(jPanel.getBackground());
        jTextArea.setFont(this.nameField.getFont());
        this.cmdField = new JLabel("out = invoke(deviceObj, 'drivertest');");
        JPanel jPanel3 = new JPanel(new BorderLayout(0, 4));
        jPanel3.add((Component)jTextArea, "North");
        jPanel3.add((Component)this.cmdField, "Center");
        jPanel3.setBorder(BorderFactory.createTitledBorder(""));
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "Center");
        return jPanel;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 0));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 4, 0));
        this.okButton = new JButton("OK");
        this.okButton.putClientProperty(ACTION, new Integer(0));
        this.okButton.addActionListener(this);
        this.okButton.setName("OK Button");
        JButton jButton = new JButton("Cancel");
        jButton.putClientProperty(ACTION, new Integer(1));
        jButton.addActionListener(this);
        jButton.setName("Cancel Button");
        jPanel2.add(this.okButton);
        jPanel2.add(jButton);
        jPanel.add(jPanel2);
        return jPanel;
    }

    public void showAsDialog(MJFrame mJFrame) {
        this.frame = mJFrame;
        this.dialogCanceled = false;
        this.dialog = new MJDialog((Frame)this.frame, "Save Test With Driver", true);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.getRootPane().setDefaultButton(this.okButton);
        this.dialog.getContentPane().add(this);
        this.dialog.setSize(400, 155);
        Point point = this.frame.getLocation();
        this.dialog.setLocation(point.x, point.y);
        this.dialog.addWindowListener((WindowListener)this);
        this.dialog.show();
    }

    public boolean isCancelled() {
        return this.dialogCanceled;
    }

    public String getMethodName() {
        return this.nameField.getText();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        int n = (Integer)jComponent.getClientProperty(ACTION);
        switch (n) {
            case 0: {
                this.dialogCanceled = false;
                if (!this.isValidName()) break;
                this.dialog.dispose();
                break;
            }
            case 1: {
                this.dialogCanceled = true;
                this.dialog.dispose();
            }
        }
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.dialogCanceled = true;
        this.dialog.dispose();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.cmdField.setText("out = invoke(deviceObj, '" + this.nameField.getText() + "');");
    }

    private boolean isValidName() {
        String string = this.nameField.getText();
        if (!TMStringUtil.ismethodname((String)string)) {
            TMStringUtil.error((MJFrame)this.frame, (String)"Invalid Function Name", (String)(string + " is not a valid MATLAB function name. A valid function name " + TMStringUtil.LINESEP + "is a character string of letters, digits and underscores, with length <= 63 " + TMStringUtil.LINESEP + "and the first character a letter. MATLAB keywords cannot be used."));
            return false;
        }
        if (this.methodNames == null) {
            return true;
        }
        if (this.methodNames.contains(string)) {
            TMStringUtil.error((MJFrame)this.frame, (String)"Invalid Function Name", (String)"Duplicate function names are not allowed.");
            return false;
        }
        return true;
    }

    private void initName() {
        String string = "drivertest";
        int n = 1;
        if (this.methodNames == null) {
            this.nameField.setText(string);
            this.keyReleased(null);
            return;
        }
        while (this.methodNames.contains(string)) {
            string = "drivertest" + n;
            ++n;
        }
        this.nameField.setText(string);
        this.keyReleased(null);
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }
}

