/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.driver;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTabbedPane;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowser;
import com.mathworks.toolbox.instrument.browser.driver.DriverPage;
import com.mathworks.toolbox.instrument.browser.driver.IVIDriverSessionTab;
import com.mathworks.toolbox.instrument.browser.driver.IVIHardwareAssetTab;
import com.mathworks.toolbox.instrument.browser.driver.IVILogicalNameTab;
import com.mathworks.toolbox.instrument.browser.driver.IVISoftwareModuleTab;
import com.mathworks.toolbox.instrument.browser.driver.IVITab;
import com.mathworks.toolbox.instrument.guiutil.ICSaveDialog;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import com.mathworks.toolbox.testmeas.guiutil.TMFileDialog;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IVIPage
extends DriverPage
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    public Matlab matlab = null;
    private static final int NO_TAB = -1;
    private static final int LOGICAL_NAME = 0;
    private static final int DRIVER_SESSION = 1;
    private static final int SOFTWARE_MODULE = 2;
    private static final int HARDWARE_ASSET = 3;
    private MJTabbedPane tabbedPane;
    private IVILogicalNameTab logicalNameTab;
    private IVIDriverSessionTab driverSessionTab;
    private IVISoftwareModuleTab softwareModuleTab;
    private IVIHardwareAssetTab hardwareAssetTab;
    private MJLabel store;
    private MJLabel version;
    private MJLabel vendor;
    private int lastTab = -1;
    private String fileNameWithPath;
    private InstrumentControlBrowser browser = null;
    private ConfigStoreLoad configStoreLoad = null;
    private ConfigStoreSaver configStoreSaver = null;

    public IVIPage(InstrumentControlBrowser instrumentControlBrowser) {
        this.browser = instrumentControlBrowser;
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.layoutPanel();
    }

    @Override
    public void update(BrowserTreeNode browserTreeNode) {
        IVITab.addNameChangedListener(this.driverSessionTab);
        IVITab.addNameChangedListener(this.logicalNameTab);
        if (this.matlab == null) {
            this.matlab = new Matlab();
            if (this.configStoreLoad == null) {
                this.configStoreLoad = new ConfigStoreLoad();
            }
            this.configStoreLoad.setActiveConfigurationStore("");
            this.browser.postStatusBarUpdateEvent("Loading IVI Configuration Store");
            this.browser.postBlockEventsEvent(true);
            Matlab.whenMatlabReady((Runnable)this.configStoreLoad);
        }
    }

    @Override
    public void cleanup() {
        IVITab.removeNameChangedListener(this.driverSessionTab);
        IVITab.removeNameChangedListener(this.logicalNameTab);
    }

    @Override
    public void dispose() {
        int n;
        if (this.isDirty() && (n = MJOptionPane.showConfirmDialog(null, (Object)"Would you like to save changes to the IVI Configuration Store?", (String)"Test and Measurement Tool", (int)0, (int)3)) == 0) {
            this.saveConfigStore();
        }
        IVITab.removeNameChangedListener(this.driverSessionTab);
        IVITab.removeNameChangedListener(this.logicalNameTab);
        this.matlab = null;
        this.browser = null;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        switch (this.lastTab) {
            case 0: {
                this.logicalNameTab.updateTable();
                break;
            }
            case 1: {
                this.driverSessionTab.updateTable();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.hardwareAssetTab.updateTable();
            }
        }
        switch (this.tabbedPane.getSelectedIndex()) {
            case 0: {
                this.logicalNameTab.setup(this.driverSessionTab.getAllItems());
                break;
            }
            case 1: {
                this.driverSessionTab.setup(this.softwareModuleTab.getAllItems(), this.hardwareAssetTab.getAllItems());
                break;
            }
            case 2: {
                break;
            }
        }
        this.lastTab = this.tabbedPane.getSelectedIndex();
    }

    private void layoutPanel() {
        this.tabbedPane = new MJTabbedPane();
        this.tabbedPane.setPreferredSize(new Dimension(10, 10));
        this.logicalNameTab = new IVILogicalNameTab();
        this.driverSessionTab = new IVIDriverSessionTab();
        this.softwareModuleTab = new IVISoftwareModuleTab();
        this.hardwareAssetTab = new IVIHardwareAssetTab();
        this.tabbedPane.add("Logical Names", (Component)this.logicalNameTab);
        this.tabbedPane.add("Driver Sessions", (Component)this.driverSessionTab);
        this.tabbedPane.add("Software Modules", (Component)this.softwareModuleTab);
        this.tabbedPane.add("Hardware Assets", (Component)this.hardwareAssetTab);
        this.add((Component)this.createHeadingPanel(), "North");
        this.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addChangeListener((ChangeListener)this);
    }

    private MJPanel createHeadingPanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(4, 0));
        mJPanel.setBorder((Border)BorderFactory.createTitledBorder("Configuration store"));
        this.store = new MJLabel("Not loaded.");
        this.version = new MJLabel("");
        this.vendor = new MJLabel("");
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new GridLayout(1, 1, 0, 2));
        mJPanel2.add((Component)this.store);
        mJPanel.add((Component)mJPanel2, (Object)"Center");
        return mJPanel;
    }

    public boolean isDirty() {
        this.stateChanged(null);
        return this.logicalNameTab.isTabDirty() || this.driverSessionTab.isTabDirty() || this.hardwareAssetTab.isTabDirty();
    }

    private void resetDirtyFlag() {
        this.logicalNameTab.resetIsDirtyFlag();
        this.driverSessionTab.resetIsDirtyFlag();
        this.hardwareAssetTab.resetIsDirtyFlag();
    }

    public void startSaveConfigStorer(String string, String string2) {
        if (this.configStoreSaver == null) {
            this.configStoreSaver = new ConfigStoreSaver();
        }
        this.configStoreSaver.setArguments(new Object[]{"privateIVIHelper", string, string2, this.hardwareAssetTab.getInfo(), this.driverSessionTab.getInfo(), this.logicalNameTab.getInfo()});
        this.resetDirtyFlag();
        this.browser.postBlockEventsEvent(true);
        this.browser.postStatusBarUpdateEvent("Saving IVI Configuration Store");
        Matlab.whenMatlabReady((Runnable)this.configStoreSaver);
    }

    public void saveConfigStore() {
        this.startSaveConfigStorer("save", this.store.getText());
    }

    public void saveAsConfigStore() {
        String string = this.getPathForCurrentStore();
        if (string == null) {
            string = "";
        }
        if (!ICSaveDialog.save(".xml", "Save IVI Configuration Store", ".xml", this.getParentFrame(), string)) {
            return;
        }
        this.startSaveConfigStorer("saveas", ICSaveDialog.getFileNameWithPath());
    }

    public void loadNewConfigStore() {
        int n = this.launchDialog(1, "Load IVI Configuration Store");
        if (n != 0) {
            return;
        }
        if (this.configStoreLoad == null) {
            this.configStoreLoad = new ConfigStoreLoad();
        }
        this.configStoreLoad.setActiveConfigurationStore(this.fileNameWithPath);
        this.browser.postBlockEventsEvent(true);
        this.browser.postStatusBarUpdateEvent("Loading IVI Configuration Store");
        Matlab.whenMatlabReady((Runnable)this.configStoreLoad);
    }

    public MJFrame getParentFrame() {
        return (MJFrame)SwingUtilities.windowForComponent((Component)((Object)this));
    }

    private int launchDialog(int n, String string) {
        try {
            TMFileDialog tMFileDialog = new TMFileDialog(string, "xml", "IVI Configuration Store (*.xml)");
            File file = new File(this.getPathForCurrentStore());
            tMFileDialog.setCurrentDirectory(file);
            int n2 = tMFileDialog.showDialog(n, this.getParentFrame());
            if (n2 == 0) {
                this.fileNameWithPath = tMFileDialog.getSelectedFile().getAbsolutePath();
                Instrument.getPreferenceFile().update("SaveDirectory", tMFileDialog.getSelectedFile().getParentFile().getPath());
            }
            return n2;
        }
        catch (Exception exception) {
            return 1;
        }
    }

    private String getPathForCurrentStore() {
        try {
            return new File(this.store.getText()).getParent();
        }
        catch (Exception exception) {
            return Instrument.getPreferenceFile().read("SaveDirectory");
        }
    }

    public class ConfigStoreLoad
    implements Runnable,
    MatlabListener {
        String[] args = new String[]{"privateIVIHelper", "load", ""};

        public void setActiveConfigurationStore(String string) {
            this.args[2] = string;
        }

        @Override
        public void run() {
            try {
                IVIPage.this.matlab.feval("instrgate", (Object[])this.args, 1, (MatlabListener)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void matlabEvent(MatlabEvent matlabEvent) {
            IVIPage.this.softwareModuleTab.removeAllElements();
            IVIPage.this.hardwareAssetTab.removeAllElements();
            IVIPage.this.driverSessionTab.removeAllElements();
            IVIPage.this.logicalNameTab.removeAllElements();
            IVIPage.this.store.setText("");
            IVIPage.this.version.setText("");
            IVIPage.this.vendor.setText("");
            if (matlabEvent.getStatus() != 0) {
                IVIPage.this.browser.postStatusBarUpdateEvent("");
                IVIPage.this.browser.postBlockEventsEvent(false);
                return;
            }
            Object object = matlabEvent.getResult();
            if (object instanceof String) {
                IVIPage.this.tabbedPane.setEnabled(false);
                IVIPage.this.browser.postStatusBarUpdateEvent("");
                IVIPage.this.browser.postBlockEventsEvent(false);
                return;
            }
            IVIPage.this.tabbedPane.setEnabled(true);
            Object[] objectArray = (Object[])object;
            IVIPage.this.store.setText((String)objectArray[0]);
            IVIPage.this.version.setText((String)objectArray[1]);
            IVIPage.this.vendor.setText((String)objectArray[2]);
            IVIPage.this.softwareModuleTab.updateForNewDriver((Object[])objectArray[3]);
            IVIPage.this.hardwareAssetTab.updateForNewDriver((Object[])objectArray[4]);
            IVIPage.this.driverSessionTab.updateForNewDriver((Object[])objectArray[5]);
            IVIPage.this.logicalNameTab.updateForNewDriver((Object[])objectArray[6]);
            IVIPage.this.stateChanged(null);
            IVIPage.this.browser.postStatusBarUpdateEvent("");
            IVIPage.this.browser.postBlockEventsEvent(false);
        }
    }

    public class ConfigStoreSaver
    implements Runnable,
    MatlabListener {
        Object[] args = null;
        Matlab internalMatlab;

        public void setArguments(Object[] objectArray) {
            this.args = objectArray;
            this.internalMatlab = IVIPage.this.matlab;
        }

        @Override
        public void run() {
            try {
                this.internalMatlab.feval("instrgate", this.args, 0, (MatlabListener)this);
            }
            catch (Exception exception) {
                TMStringUtil.error((MJFrame)IVIPage.this.getParentFrame(), (String)"Unexpected Error Saving Configuration Store:", (String)exception.getMessage());
            }
        }

        public void matlabEvent(MatlabEvent matlabEvent) {
            if (matlabEvent.getStatus() != 0) {
                IVIPage.this.browser.postBlockEventsEvent(false);
                TMStringUtil.error((MJFrame)IVIPage.this.getParentFrame(), (String)"Error Saving Configuration Store", (String)"Configuration Stores need a Software Module defined for each Driver Session and a Driver session defined for each Logical Name.");
            }
            if (IVIPage.this.browser != null) {
                IVIPage.this.store.setText((String)this.args[2]);
                IVIPage.this.browser.postStatusBarUpdateEvent("");
                IVIPage.this.browser.postBlockEventsEvent(false);
            }
        }
    }
}

