/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.I2C;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.testmeas.util.TMException;
import java.util.ArrayList;

public class I2CNI845X
extends I2C {
    private String vendorDriverName = "Ni845x" + Instrument.extension();
    private String vendorDriverDescription = "National Instruments NI USB 845x Driver";
    private static final int niVendorIndex = 1;

    public I2CNI845X(String string, String string2, int n, int n2) throws TMException {
        super(string, string2, n, n2);
    }

    public I2CNI845X() throws TMException {
        this.deleteInstrumentObject(this);
    }

    @Override
    protected String HwInfo(int n) {
        switch (n) {
            case 3: {
                return this.vendorDriverName;
            }
            case 4: {
                return this.vendorDriverDescription;
            }
        }
        return null;
    }

    @Override
    protected Integer[][] findAllBoards() throws TMException {
        int[] nArray = this.nativeFindBoards();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        boolean bl = false;
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            try {
                n = this.nativeOpen(i);
                bl = true;
            }
            catch (TMException tMException) {
                arrayList.add(i);
            }
            if (!bl) continue;
            try {
                this.nativeClose(n);
                bl = false;
                arrayList2.add(i);
                continue;
            }
            catch (TMException tMException) {
                arrayList.add(i);
            }
        }
        Integer[][] integerArray = new Integer[][]{arrayList.toArray(new Integer[arrayList.size()]), arrayList2.toArray(new Integer[arrayList.size()])};
        return integerArray;
    }

    @Override
    public boolean hasI2CSlaveReturnedAck() throws TMException {
        boolean bl = true;
        if (this.status == 0) {
            I2CNI845X.displayError(sI2CResources.getString("I2c.opFailed.deviceNotOpen"));
        }
        byte[] byArray = new byte[]{0};
        try {
            this.nativeWriteImpl(this.fId, this.configurationHandle, 0, byArray, 0);
        }
        catch (TMException tMException) {
            bl = false;
        }
        return bl;
    }

    @Override
    protected void updatePropsOnOpen() throws Exception {
        this.setRemoteAddress(this.fRemoteAddress);
        super.updatePropsOnOpen();
    }

    @Override
    public Object[] constructorargs() {
        Object[] objectArray = new Object[]{this.fConstructorArgs};
        return objectArray;
    }

    @Override
    public void openHardware() throws Exception {
        super.openHardware();
        this.configurationHandle = this.nativeConfigurationOpen();
        this.setTimeout(this.timeout);
    }

    @Override
    public void closeHardware() throws Exception {
        this.nativeConfigurationClose(this.configurationHandle);
        super.closeHardware();
    }

    @Override
    protected String getHardwareBoardSerial(int n) {
        String[] stringArray = new String[]{};
        try {
            stringArray = this.nativeFindResourceNames();
        }
        catch (TMException tMException) {
            stringArray = new String[]{};
        }
        if (stringArray.length == 0) {
            return "0";
        }
        String[] stringArray2 = stringArray[this.fBoardIndex].split("::");
        return stringArray2[3];
    }

    @Override
    public double getBitRate() {
        if (this.status == 1) {
            try {
                this.fBitRate = this.nativeGetBitRate(this.fId, this.configurationHandle);
            }
            catch (TMException tMException) {
                I2CNI845X.displayWarning(tMException.getMessage());
            }
        }
        return this.fBitRate;
    }

    @Override
    public void setRemoteAddress(int n) throws TMException {
        if (this.status == 1) {
            this.nativeSetRemoteAddress(this.configurationHandle, n);
        }
        super.setRemoteAddress(n);
    }

    @Override
    public void setRemoteAddress(String string) throws TMException {
        this.setRemoteAddress(Integer.parseInt(string));
    }

    @Override
    public int getRemoteAddress() {
        if (this.status == 1) {
            try {
                return this.nativeGetAddress(this.configurationHandle);
            }
            catch (TMException tMException) {
                I2CNI845X.displayWarning(tMException.getMessage());
            }
        }
        return super.getRemoteAddress();
    }

    @Override
    public String setDisplay() {
        return "    ByteOrder: [ {littleEndian} | bigEndian ] " + LINESEP + "    InputBufferSize" + LINESEP + "    Name" + LINESEP + "    ObjectVisibility: [ {on} | off ] " + LINESEP + "    OutputBufferSize" + LINESEP + "    RecordDetail: [ {compact} | verbose ]" + LINESEP + "    RecordMode: [ {overwrite} | append | index ]" + LINESEP + "    RecordName" + LINESEP + "    Tag" + LINESEP + "    Timeout" + LINESEP + "    TimerFcn: string -or- function handle -or- cell array" + LINESEP + "    TimerPeriod" + LINESEP + "    UserData" + LINESEP + "    " + LINESEP + "    I2C specific properties:" + LINESEP + "    BitRate" + LINESEP + "    BoardIndex" + LINESEP + "    BoardSerial" + LINESEP + "    PullupResistors [ {both} | none ]" + LINESEP + "    RemoteAddress" + LINESEP + "    Vendor" + LINESEP + "       " + LINESEP;
    }

    protected native String[] nativeFindResourceNames() throws TMException;

    @Override
    protected native int nativeOpen(int var1) throws TMException;

    @Override
    protected native int nativeClose(int var1) throws TMException;

    @Override
    protected native String nativeGetErrorMessageFromHardware(int var1);

    @Override
    protected native Object[] nativeReadImpl(int var1, long var2, int var4, int var5) throws TMException;

    @Override
    protected native int nativeWriteImpl(int var1, long var2, int var4, byte[] var5, int var6) throws TMException;

    @Override
    protected native double nativeGetBitRate(int var1, long var2) throws TMException;

    @Override
    protected native double nativeSetBitRate(int var1, long var2, double var4) throws TMException;

    @Override
    protected int nativeGetPullupResistors(int n) throws TMException {
        return this.fPullupResistors;
    }

    @Override
    protected native int nativeSetPullupResistors(int var1, int var2) throws TMException;

    @Override
    protected native int nativeSetHardwareTimeout(int var1, int var2, int var3) throws TMException;

    @Override
    protected int nativeGetHardwareTimeout(int n) {
        return (int)(this.timeout * 1000.0);
    }

    @Override
    protected native int[] nativeFindBoards() throws TMException;

    protected native long nativeConfigurationOpen() throws TMException;

    protected native void nativeConfigurationClose(long var1);

    protected native int nativeSetRemoteAddress(long var1, int var3) throws TMException;

    protected native int nativeGetAddress(long var1) throws TMException;
}

