/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.MimeEnabledImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.AbstractImage;

public class ImageRawStream
extends AbstractImage {
    private ImageFlavor flavor;
    private InputStreamFactory streamFactory;

    public ImageRawStream(ImageInfo imageInfo, ImageFlavor imageFlavor, InputStreamFactory inputStreamFactory) {
        super(imageInfo);
        this.flavor = imageFlavor;
        this.setInputStreamFactory(inputStreamFactory);
    }

    public ImageRawStream(ImageInfo imageInfo, ImageFlavor imageFlavor, InputStream inputStream) {
        this(imageInfo, imageFlavor, new SingleStreamFactory(inputStream));
    }

    public ImageFlavor getFlavor() {
        return this.flavor;
    }

    public String getMimeType() {
        if (this.getFlavor() instanceof MimeEnabledImageFlavor) {
            return this.getFlavor().getMimeType();
        }
        return "application/octet-stream";
    }

    public boolean isCacheable() {
        return !this.streamFactory.isUsedOnceOnly();
    }

    public void setInputStreamFactory(InputStreamFactory inputStreamFactory) {
        if (this.streamFactory != null) {
            this.streamFactory.close();
        }
        this.streamFactory = inputStreamFactory;
    }

    public InputStream createInputStream() {
        return this.streamFactory.createInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream outputStream) throws IOException {
        InputStream inputStream = this.createInputStream();
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            this.writeTo(fileOutputStream);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
        }
    }

    public static class ByteArrayStreamFactory
    implements InputStreamFactory {
        private byte[] data;

        public ByteArrayStreamFactory(byte[] byArray) {
            this.data = byArray;
        }

        public InputStream createInputStream() {
            return new ByteArrayInputStream(this.data);
        }

        public void close() {
        }

        public boolean isUsedOnceOnly() {
            return false;
        }
    }

    private static class SingleStreamFactory
    implements InputStreamFactory {
        private InputStream in;

        public SingleStreamFactory(InputStream inputStream) {
            this.in = inputStream;
        }

        public synchronized InputStream createInputStream() {
            if (this.in != null) {
                InputStream inputStream = this.in;
                this.in = null;
                return inputStream;
            }
            throw new IllegalStateException("Can only create an InputStream once!");
        }

        public synchronized void close() {
            IOUtils.closeQuietly((InputStream)this.in);
            this.in = null;
        }

        public boolean isUsedOnceOnly() {
            return true;
        }

        protected void finalize() {
            this.close();
        }
    }

    public static interface InputStreamFactory {
        public boolean isUsedOnceOnly();

        public InputStream createInputStream();

        public void close();
    }
}

