/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.xmlgraphics.image.loader.ImageContext;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageSessionContext;

public class DefaultImageSessionContext
extends AbstractImageSessionContext {
    private ImageContext context;
    private File baseDir;

    public DefaultImageSessionContext(ImageContext imageContext, File file) {
        this.context = imageContext;
        this.baseDir = file;
    }

    public ImageContext getParentContext() {
        return this.context;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    protected Source resolveURI(String string) {
        try {
            URL uRL = new URL(string);
            return new StreamSource(uRL.openStream(), uRL.toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(this.baseDir, string);
            if (file.isFile()) {
                return new StreamSource(file);
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public float getTargetResolution() {
        return this.getParentContext().getSourceResolution();
    }
}

