/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.norm;

import com.sun.jini.norm.ClientLeaseWrapper;
import com.sun.jini.norm.LRMEventListener;
import com.sun.jini.proxy.ConstrainableProxyUtil;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseMap;
import net.jini.core.lease.LeaseMapException;

class ClientLeaseMapWrapper
extends AbstractMap
implements LeaseMap {
    private static final long serialVersionUID = 1L;
    private static final Method[] leaseToLeaseMapMethods;
    private final LeaseMap clientLeaseMap;
    private final Map wrapperMap = new HashMap();
    private final ClientLeaseWrapper example;

    ClientLeaseMapWrapper(ClientLeaseWrapper clientLeaseWrapper, long l) {
        Lease lease = clientLeaseWrapper.getClientLease();
        if (lease == null) {
            throw new IllegalArgumentException("Wrapper cannot be deformed");
        }
        LeaseMap leaseMap = lease.createLeaseMap(l);
        if (lease instanceof RemoteMethodControl && leaseMap instanceof RemoteMethodControl) {
            leaseMap = (LeaseMap)((RemoteMethodControl)leaseMap).setConstraints(ConstrainableProxyUtil.translateConstraints(((RemoteMethodControl)lease).getConstraints(), leaseToLeaseMapMethods));
        }
        this.clientLeaseMap = leaseMap;
        this.wrapperMap.put(lease, clientLeaseWrapper);
        this.example = clientLeaseWrapper;
    }

    public void cancelAll() {
        throw new UnsupportedOperationException("ClientLeaseMapWrapper.cancelAll: LRS should not being canceling client leases");
    }

    private void applyException(Throwable throwable) {
        Iterator iterator = this.wrapperMap.values().iterator();
        while (iterator.hasNext()) {
            ClientLeaseWrapper clientLeaseWrapper = (ClientLeaseWrapper)iterator.next();
            clientLeaseWrapper.failedRenewal(throwable);
        }
    }

    public void renewAll() throws LeaseMapException, RemoteException {
        Object object;
        Object object2;
        LeaseMapException leaseMapException = null;
        HashMap<ClientLeaseWrapper, Throwable> hashMap = null;
        long l = System.currentTimeMillis();
        Object object3 = this.wrapperMap.values().iterator();
        while (object3.hasNext()) {
            object2 = (ClientLeaseWrapper)object3.next();
            if (((ClientLeaseWrapper)object2).ensureCurrent(l)) continue;
            if (hashMap == null) {
                hashMap = new HashMap<ClientLeaseWrapper, Throwable>(this.wrapperMap.size());
            }
            hashMap.put((ClientLeaseWrapper)object2, (Throwable)LRMEventListener.EXPIRED_SET_EXCEPTION);
            object3.remove();
            this.clientLeaseMap.remove((Object)((ClientLeaseWrapper)object2).getClientLease());
        }
        if (this.clientLeaseMap.isEmpty()) {
            if (hashMap == null) {
                return;
            }
            throw new LeaseMapException("Expired Sets", hashMap);
        }
        try {
            this.clientLeaseMap.renewAll();
        }
        catch (LeaseMapException leaseMapException2) {
            leaseMapException = leaseMapException2;
        }
        catch (RemoteException remoteException) {
            this.applyException(remoteException);
            throw remoteException;
        }
        catch (Error error) {
            this.applyException(error);
            throw error;
        }
        catch (RuntimeException runtimeException) {
            this.applyException(runtimeException);
            throw runtimeException;
        }
        object3 = this.clientLeaseMap.keySet().iterator();
        while (object3.hasNext()) {
            object2 = (Lease)object3.next();
            object = (ClientLeaseWrapper)this.wrapperMap.get(object2);
            ((ClientLeaseWrapper)object).successfulRenewal();
        }
        if (leaseMapException == null && hashMap == null) {
            return;
        }
        if (leaseMapException != null) {
            object3 = leaseMapException.exceptionMap;
            if (hashMap == null) {
                hashMap = new HashMap(object3.size());
            }
            object2 = object3.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                Lease lease = (Lease)object.getKey();
                Throwable throwable = (Throwable)object.getValue();
                ClientLeaseWrapper clientLeaseWrapper = (ClientLeaseWrapper)this.wrapperMap.remove(lease);
                object2.remove();
                clientLeaseWrapper.failedRenewal(throwable);
                hashMap.put(clientLeaseWrapper, throwable);
            }
        }
        if (hashMap != null) {
            throw new LeaseMapException(leaseMapException == null ? "Expired Sets" : leaseMapException.getMessage(), hashMap);
        }
    }

    public boolean canContainKey(Object object) {
        return object instanceof Lease && this.example.canBatch((Lease)object);
    }

    private Lease checkKey(Object object) {
        if (this.canContainKey(object)) {
            return ((ClientLeaseWrapper)object).getClientLease();
        }
        throw new IllegalArgumentException("key is not valid for this LeaseMap");
    }

    private static void checkValue(Object object) {
        if (!(object instanceof Long)) {
            throw new IllegalArgumentException("value is not a Long");
        }
    }

    public boolean containsKey(Object object) {
        Lease lease = this.checkKey(object);
        return this.clientLeaseMap.containsKey((Object)lease);
    }

    public boolean containsValue(Object object) {
        ClientLeaseMapWrapper.checkValue(object);
        return this.clientLeaseMap.containsValue(object);
    }

    public Object get(Object object) {
        Lease lease = this.checkKey(object);
        return this.clientLeaseMap.get((Object)lease);
    }

    public Object put(Object object, Object object2) {
        Lease lease = this.checkKey(object);
        ClientLeaseMapWrapper.checkValue(object2);
        this.wrapperMap.put(lease, object);
        return this.clientLeaseMap.put((Object)lease, object2);
    }

    public Object remove(Object object) {
        Lease lease = this.checkKey(object);
        this.wrapperMap.remove(lease);
        return this.clientLeaseMap.remove((Object)lease);
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        this.clientLeaseMap.clear();
        this.wrapperMap.clear();
    }

    public boolean equals(Object object) {
        return this.clientLeaseMap.equals(object);
    }

    public int hashCode() {
        return this.clientLeaseMap.hashCode();
    }

    public Set entrySet() {
        return new EntrySet();
    }

    static {
        try {
            Method method = Lease.class.getMethod("cancel", new Class[0]);
            Method method2 = LeaseMap.class.getMethod("cancelAll", new Class[0]);
            Method method3 = Lease.class.getMethod("renew", Long.TYPE);
            Method method4 = LeaseMap.class.getMethod("renewAll", new Class[0]);
            leaseToLeaseMapMethods = new Method[]{method, method2, method3, method4};
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new NoSuchMethodError(noSuchMethodException.getMessage());
        }
    }

    private final class EntryIterator
    implements Iterator {
        private final Iterator iter;
        private Lease last;

        public EntryIterator() {
            this.iter = ClientLeaseMapWrapper.this.wrapperMap.values().iterator();
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            Map.Entry entry = (Map.Entry)this.iter.next();
            this.last = (Lease)entry.getKey();
            return new Entry((ClientLeaseWrapper)entry.getValue());
        }

        public void remove() {
            ClientLeaseMapWrapper.this.clientLeaseMap.remove((Object)this.last);
            this.iter.remove();
        }
    }

    private final class Entry
    implements Map.Entry {
        private final ClientLeaseWrapper key;

        public Entry(ClientLeaseWrapper clientLeaseWrapper) {
            this.key = clientLeaseWrapper;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return ClientLeaseMapWrapper.this.clientLeaseMap.get((Object)this.key.getClientLease());
        }

        public Object setValue(Object object) {
            ClientLeaseMapWrapper.checkValue(object);
            return ClientLeaseMapWrapper.this.clientLeaseMap.put((Object)this.key.getClientLease(), object);
        }

        public boolean equals(Object object) {
            if (object instanceof Entry) {
                Entry entry = (Entry)object;
                return entry.key.equals(this.key);
            }
            return false;
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }

    private final class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return new EntryIterator();
        }

        private Lease getClientLease(Object object) {
            if (!(object instanceof Map.Entry)) {
                return null;
            }
            Map.Entry entry = (Map.Entry)object;
            Object v = entry.getValue();
            if (!(entry.getKey() instanceof ClientLeaseWrapper) || !(v instanceof Long) || v == null) {
                return null;
            }
            ClientLeaseWrapper clientLeaseWrapper = (ClientLeaseWrapper)entry.getKey();
            return clientLeaseWrapper.getClientLease();
        }

        public boolean contains(Object object) {
            Lease lease = this.getClientLease(object);
            if (lease == null) {
                return false;
            }
            Object v = ((Map.Entry)object).getValue();
            Object object2 = ClientLeaseMapWrapper.this.clientLeaseMap.get((Object)lease);
            if (object2 == null) {
                return false;
            }
            return object2.equals(v);
        }

        public boolean remove(Object object) {
            Lease lease = this.getClientLease(object);
            if (lease == null) {
                return false;
            }
            Object v = ((Map.Entry)object).getValue();
            Object object2 = ClientLeaseMapWrapper.this.clientLeaseMap.get((Object)lease);
            if (object2 == null || !object2.equals(v)) {
                return false;
            }
            ClientLeaseMapWrapper.this.clientLeaseMap.remove((Object)lease);
            ClientLeaseMapWrapper.this.wrapperMap.remove(lease);
            return true;
        }

        public int size() {
            return ClientLeaseMapWrapper.this.clientLeaseMap.size();
        }

        public void clear() {
            ClientLeaseMapWrapper.this.wrapperMap.clear();
            ClientLeaseMapWrapper.this.clientLeaseMap.clear();
        }
    }
}

