/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html;

import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.html.HTMLSyntax;
import org.netbeans.editor.ext.html.HTMLSyntaxSupport;
import org.netbeans.editor.ext.html.HTMLTokenContext;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.modules.editor.structure.formatting.TagBasedFormatter;

public class HTMLFormatter
extends TagBasedFormatter {
    private static final String[] UNFORMATTABLE_TAGS = new String[]{"pre", "script", "code"};

    public HTMLFormatter(Class clazz) {
        super(clazz);
    }

    @Override
    protected boolean acceptSyntax(Syntax syntax) {
        return syntax instanceof HTMLSyntax;
    }

    @Override
    protected ExtSyntaxSupport getSyntaxSupport(BaseDocument baseDocument) {
        return (HTMLSyntaxSupport)baseDocument.getSyntaxSupport().get(HTMLSyntaxSupport.class);
    }

    @Override
    protected TokenItem getTagTokenEndingAtPosition(BaseDocument baseDocument, int n) throws BadLocationException {
        HTMLSyntaxSupport hTMLSyntaxSupport;
        TokenItem tokenItem;
        if (n >= 0 && (tokenItem = (hTMLSyntaxSupport = (HTMLSyntaxSupport)this.getSyntaxSupport(baseDocument)).getTokenChain(n, n + 1)).getTokenID() == HTMLTokenContext.TAG_CLOSE_SYMBOL && !tokenItem.getImage().endsWith("/>")) {
            while ((tokenItem = tokenItem.getPrevious()) != null) {
                if (!HTMLSyntaxSupport.isTag(tokenItem)) continue;
            }
            return tokenItem;
        }
        return null;
    }

    @Override
    protected int getTagEndOffset(TokenItem tokenItem) {
        TokenItem tokenItem2;
        for (tokenItem2 = tokenItem.getNext(); tokenItem2 != null && tokenItem2.getTokenID() != HTMLTokenContext.TAG_CLOSE_SYMBOL; tokenItem2 = tokenItem2.getNext()) {
        }
        return tokenItem2 == null ? -1 : tokenItem2.getOffset();
    }

    @Override
    protected boolean isJustBeforeClosingTag(BaseDocument baseDocument, int n) throws BadLocationException {
        return super.isJustBeforeClosingTag(baseDocument, n + "</".length());
    }

    @Override
    protected boolean isClosingTag(TokenItem tokenItem) {
        return tokenItem != null && tokenItem.getTokenID() == HTMLTokenContext.TAG_CLOSE;
    }

    @Override
    protected boolean isOpeningTag(TokenItem tokenItem) {
        return tokenItem != null && tokenItem.getTokenID() == HTMLTokenContext.TAG_OPEN;
    }

    @Override
    protected String extractTagName(TokenItem tokenItem) {
        return tokenItem.getImage().trim();
    }

    @Override
    protected boolean areTagNamesEqual(String string, String string2) {
        return string.equalsIgnoreCase(string2);
    }

    @Override
    protected int getOpeningSymbolOffset(TokenItem tokenItem) {
        TokenItem tokenItem2 = tokenItem;
        while ((tokenItem2 = tokenItem2.getPrevious()) != null && tokenItem2.getTokenID() != HTMLTokenContext.TAG_OPEN_SYMBOL) {
        }
        if (tokenItem2 != null) {
            return tokenItem2.getOffset();
        }
        return -1;
    }

    @Override
    protected boolean isClosingTagRequired(BaseDocument baseDocument, String string) {
        HTMLSyntaxSupport hTMLSyntaxSupport = (HTMLSyntaxSupport)baseDocument.getSyntaxSupport().get(HTMLSyntaxSupport.class);
        DTD dTD = hTMLSyntaxSupport.getDTD();
        if (dTD == null) {
            return false;
        }
        DTD.Element element = dTD.getElement(string.toUpperCase());
        if (element == null) {
            return true;
        }
        return !element.isEmpty();
    }

    @Override
    protected boolean isUnformattableToken(TokenItem tokenItem) {
        return tokenItem.getTokenID() == HTMLTokenContext.BLOCK_COMMENT;
    }

    @Override
    protected boolean isUnformattableTag(String string) {
        for (int i = 0; i < UNFORMATTABLE_TAGS.length; ++i) {
            if (!string.equalsIgnoreCase(UNFORMATTABLE_TAGS[i])) continue;
            return true;
        }
        return false;
    }
}

