/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;

public class DialogSupport {
    private static DialogFactory factory;

    private DialogSupport() {
    }

    public static Dialog createDialog(String string, JPanel jPanel, boolean bl, JButton[] jButtonArray, boolean bl2, int n, int n2, ActionListener actionListener) {
        if (factory == null) {
            factory = new DefaultDialogFactory();
        }
        return factory.createDialog(string, jPanel, bl, jButtonArray, bl2, n, n2, actionListener);
    }

    public static void setDialogFactory(DialogFactory dialogFactory) {
        factory = dialogFactory;
    }

    private static class DefaultDialogFactory
    extends WindowAdapter
    implements DialogFactory,
    ActionListener {
        private JButton cancelButton;

        private DefaultDialogFactory() {
        }

        JPanel createButtonPanel(JButton[] jButtonArray, boolean bl) {
            int n = jButtonArray.length;
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(new EmptyBorder(new Insets(bl ? 5 : 0, bl ? 0 : 5, 5, 5)));
            GridLayout gridLayout = new GridLayout(bl ? n : 1, bl ? 1 : n, 5, 5);
            JPanel jPanel2 = new JPanel(gridLayout);
            for (int i = 0; i < n; ++i) {
                jPanel2.add(jButtonArray[i]);
            }
            jPanel.add((Component)jPanel2, bl ? "North" : "East");
            return jPanel;
        }

        @Override
        public Dialog createDialog(String string, JPanel jPanel, boolean bl, JButton[] jButtonArray, boolean bl2, int n, int n2, ActionListener actionListener) {
            JDialog jDialog = new JDialog((Frame)null, string, bl);
            jDialog.setDefaultCloseOperation(0);
            jDialog.getContentPane().add((Component)jPanel, "Center");
            JPanel jPanel2 = this.createButtonPanel(jButtonArray, bl2);
            String string2 = bl2 ? "East" : "South";
            jDialog.getContentPane().add((Component)jPanel2, string2);
            if (actionListener != null) {
                for (int i = 0; i < jButtonArray.length; ++i) {
                    jButtonArray[i].addActionListener(actionListener);
                }
            }
            if (n >= 0) {
                jDialog.getRootPane().setDefaultButton(jButtonArray[n]);
            }
            if (n2 >= 0) {
                this.cancelButton = jButtonArray[n2];
                jDialog.getRootPane().registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0, true), 2);
                jDialog.addWindowListener(this);
            }
            jDialog.pack();
            return jDialog;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.cancelButton.doClick(10);
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            this.cancelButton.doClick(10);
        }
    }

    public static interface DialogFactory {
        public Dialog createDialog(String var1, JPanel var2, boolean var3, JButton[] var4, boolean var5, int var6, int var7, ActionListener var8);
    }
}

