/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mvm;

import com.mathworks.mvm.MVM;
import com.mathworks.mvm.MvmFactory;
import com.mathworks.mvm.MvmWrapper;
import com.mathworks.mvm.eventmgr.DefaultEventMgr;
import com.mathworks.mvm.eventmgr.EventMgr;
import com.mathworks.mvm.exec.FutureEvalResult;
import com.mathworks.mvm.exec.FutureFevalResult;
import com.mathworks.mvm.exec.MatlabEvalRequest;
import com.mathworks.mvm.exec.MatlabExecutor;
import com.mathworks.mvm.exec.MatlabFevalRequest;
import com.mathworks.util.Log;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class MvmImpl
implements MVM {
    private volatile EventMgr fEventMgr;
    private volatile MatlabExecutor fExecutor;
    private final long fHandle;
    private static final AtomicBoolean LIB_LOADED = new AtomicBoolean(false);
    private static volatile boolean sSpecialJUnitTest = false;

    @Override
    public long getHandle() {
        return this.fHandle;
    }

    MvmImpl(long l) {
        MvmImpl.loadLibrary();
        this.fHandle = l;
    }

    private static void noLoadLibrary() {
        LIB_LOADED.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSpecialJUnitTest() {
        Class<MvmImpl> clazz = MvmImpl.class;
        synchronized (MvmImpl.class) {
            assert (!LIB_LOADED.get());
            sSpecialJUnitTest = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLibrary() {
        if (LIB_LOADED.get()) {
            assert (!sSpecialJUnitTest);
            return;
        }
        Class<MvmImpl> clazz = MvmImpl.class;
        synchronized (MvmImpl.class) {
            if (LIB_LOADED.get()) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            try {
                System.loadLibrary("nativemvm");
                sSpecialJUnitTest = false;
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane jOptionPane = new JOptionPane("Failed to load nativemvm library: " + throwable.getMessage(), 0, -1){

                            @Override
                            public int getMaxCharactersPerLineCount() {
                                return 100;
                            }
                        };
                        jOptionPane.createDialog("ERROR").setVisible(true);
                    }
                });
                Log.logThrowable((Throwable)throwable);
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
            }
            finally {
                LIB_LOADED.set(true);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Override
    public <V> FutureFevalResult<V> feval(String string, Object ... objectArray) {
        return this.getExecutor().submit(new MatlabFevalRequest(string, objectArray));
    }

    @Override
    public FutureEvalResult eval(String string, @Nullable Writer writer, @Nullable Writer writer2) {
        return this.getExecutor().submit(new MatlabEvalRequest(string, writer, writer2));
    }

    @Override
    public FutureEvalResult eval(String string) {
        return this.getExecutor().submit(new MatlabEvalRequest(string, MatlabEvalRequest.NULL_WRITER, MatlabEvalRequest.NULL_WRITER));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventMgr getEventMgr() {
        if (this.fEventMgr == null) {
            MvmImpl mvmImpl = this;
            synchronized (mvmImpl) {
                if (this.fEventMgr == null) {
                    this.fEventMgr = new DefaultEventMgr(new MvmWrapper(this));
                }
            }
        }
        return this.fEventMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MatlabExecutor getExecutor() {
        if (this.fExecutor == null) {
            MvmImpl mvmImpl = this;
            synchronized (mvmImpl) {
                if (this.fExecutor == null) {
                    this.fExecutor = new MatlabExecutor(new MvmWrapper(this));
                }
            }
        }
        return this.fExecutor;
    }

    @Override
    public boolean isTerminated() {
        return MvmFactory.nativeIsMvmTerminated(this.fHandle);
    }

    @Override
    public void terminate() throws IllegalStateException {
        if (!MvmFactory.nativeTerminateMVM(this.fHandle)) {
            throw new IllegalStateException("Cannot terminate current MVM or desktop MATLAB");
        }
    }
}

