/*
 * Decompiled with CFR 0.152.
 */
package net.jini.lookup;

import com.sun.jini.logging.Levels;
import com.sun.jini.lookup.entry.LookupAttributes;
import com.sun.jini.proxy.BasicProxyTrustVerifier;
import com.sun.jini.thread.TaskManager;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.EmptyConfiguration;
import net.jini.core.entry.Entry;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lease.Lease;
import net.jini.core.lookup.ServiceEvent;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceMatches;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.export.Exporter;
import net.jini.io.MarshalledInstance;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.tcp.TcpServerEndpoint;
import net.jini.lease.LeaseListener;
import net.jini.lease.LeaseRenewalEvent;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.LookupCache;
import net.jini.lookup.ServiceDiscoveryEvent;
import net.jini.lookup.ServiceDiscoveryListener;
import net.jini.lookup.ServiceItemFilter;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ServerProxyTrust;

public class ServiceDiscoveryManager {
    private static final String COMPONENT_NAME = "net.jini.lookup.ServiceDiscoveryManager";
    private static final Logger logger = Logger.getLogger("net.jini.lookup.ServiceDiscoveryManager");
    private DiscoveryManagement discMgr;
    private boolean discMgrInternal = false;
    private DiscMgrListener discMgrListener = new DiscMgrListener();
    private LeaseRenewalManager leaseRenewalMgr;
    private final ArrayList proxyRegSet = new ArrayList(1);
    private final ArrayList listeners = new ArrayList(1);
    private final Random random = new Random();
    private final ArrayList caches = new ArrayList(1);
    private boolean bTerminated = false;
    private Configuration thisConfig;
    private ProxyPreparer registrarPreparer;
    private ProxyPreparer eventLeasePreparer;
    private long discardWait = 600000L;
    static /* synthetic */ Class class$net$jini$export$Exporter;
    static /* synthetic */ Class class$com$sun$jini$thread$TaskManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheAddProxy(ProxyReg proxyReg) {
        ArrayList arrayList = this.caches;
        synchronized (arrayList) {
            Iterator iterator = this.caches.iterator();
            while (iterator.hasNext()) {
                LookupCacheImpl lookupCacheImpl = (LookupCacheImpl)iterator.next();
                lookupCacheImpl.addProxyReg(proxyReg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropProxy(ProxyReg proxyReg) {
        ArrayList arrayList = this.caches;
        synchronized (arrayList) {
            Iterator iterator = this.caches.iterator();
            while (iterator.hasNext()) {
                LookupCacheImpl lookupCacheImpl = (LookupCacheImpl)iterator.next();
                lookupCacheImpl.removeProxyReg(proxyReg);
            }
        }
    }

    public ServiceDiscoveryManager(DiscoveryManagement discoveryManagement, LeaseRenewalManager leaseRenewalManager) throws IOException {
        try {
            this.init(discoveryManagement, leaseRenewalManager, EmptyConfiguration.INSTANCE);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    public ServiceDiscoveryManager(DiscoveryManagement discoveryManagement, LeaseRenewalManager leaseRenewalManager, Configuration configuration) throws IOException, ConfigurationException {
        this.init(discoveryManagement, leaseRenewalManager, configuration);
    }

    private void listenerDropped(ArrayList arrayList, ArrayList arrayList2) {
        ServiceRegistrar[] serviceRegistrarArray = new ServiceRegistrar[arrayList.size()];
        arrayList.toArray(serviceRegistrarArray);
        this.listenerDropped(serviceRegistrarArray, arrayList2);
    }

    private void listenerDropped(ServiceRegistrar[] serviceRegistrarArray, ArrayList arrayList) {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            DiscoveryEvent discoveryEvent = new DiscoveryEvent((Object)this, (ServiceRegistrar[])serviceRegistrarArray.clone());
            ((DiscoveryListener)iterator.next()).discarded(discoveryEvent);
        }
    }

    private void listenerDiscovered(ServiceRegistrar serviceRegistrar, ArrayList arrayList) {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            DiscoveryEvent discoveryEvent = new DiscoveryEvent((Object)this, new ServiceRegistrar[]{serviceRegistrar});
            ((DiscoveryListener)iterator.next()).discovered(discoveryEvent);
        }
    }

    private ServiceRegistrar[] buildServiceRegistrar() {
        int n = 0;
        ServiceRegistrar[] serviceRegistrarArray = new ServiceRegistrar[this.proxyRegSet.size()];
        Iterator iterator = this.proxyRegSet.iterator();
        while (iterator.hasNext()) {
            ProxyReg proxyReg = (ProxyReg)iterator.next();
            serviceRegistrarArray[n++] = proxyReg.proxy;
        }
        return serviceRegistrarArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceItem lookup(ServiceTemplate serviceTemplate, ServiceItemFilter serviceItemFilter) {
        ServiceRegistrar[] serviceRegistrarArray;
        this.checkTerminated();
        ArrayList arrayList = this.proxyRegSet;
        synchronized (arrayList) {
            serviceRegistrarArray = this.buildServiceRegistrar();
        }
        int n = serviceRegistrarArray.length;
        if (n == 0) {
            return null;
        }
        int n2 = Math.abs(this.random.nextInt()) % n;
        for (int i = 0; i < n; ++i) {
            ServiceRegistrar serviceRegistrar = serviceRegistrarArray[(i + n2) % n];
            ServiceItem serviceItem = null;
            try {
                int n3 = serviceItemFilter != null ? Integer.MAX_VALUE : 1;
                ServiceMatches serviceMatches = serviceRegistrar.lookup(serviceTemplate, n3);
                serviceItem = this.getMatchedServiceItem(serviceMatches, serviceItemFilter);
            }
            catch (Exception exception) {
                logger.log(Level.INFO, "Exception occurred during query, discarding proxy", exception);
                this.discard(serviceRegistrar);
            }
            if (serviceItem == null) continue;
            return serviceItem;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServiceItem lookup(ServiceTemplate serviceTemplate, ServiceItemFilter serviceItemFilter, long l) throws InterruptedException, RemoteException {
        Object object;
        ServiceItem serviceItem = this.lookup(serviceTemplate, serviceItemFilter);
        if (serviceItem != null) {
            return serviceItem;
        }
        ServiceDiscoveryListenerImpl serviceDiscoveryListenerImpl = new ServiceDiscoveryListenerImpl();
        LookupCacheImpl lookupCacheImpl = null;
        try {
            object = serviceDiscoveryListenerImpl;
            synchronized (object) {
                lookupCacheImpl = this.createLookupCache(serviceTemplate, serviceItemFilter, serviceDiscoveryListenerImpl, l);
                long l2 = lookupCacheImpl.getLeaseDuration();
                while (l2 > 0L) {
                    serviceDiscoveryListenerImpl.wait(l2);
                    serviceItem = lookupCacheImpl.lookup(null);
                    if (serviceItem != null) {
                        ServiceItem serviceItem2 = serviceItem;
                        // MONITOREXIT @DISABLED, blocks:[0, 3, 5, 6] lbl16 : MonitorExitStatement: MONITOREXIT : var8_7
                        Object var14_10 = null;
                        if (lookupCacheImpl == null) return serviceItem2;
                        lookupCacheImpl.terminate();
                        return serviceItem2;
                    }
                    l2 = lookupCacheImpl.getLeaseDuration();
                }
            }
            object = serviceItem;
        }
        catch (Throwable throwable) {
            Object var14_12 = null;
            if (lookupCacheImpl == null) throw throwable;
            lookupCacheImpl.terminate();
            throw throwable;
        }
        Object var14_11 = null;
        if (lookupCacheImpl == null) return object;
        lookupCacheImpl.terminate();
        return object;
    }

    public LookupCache createLookupCache(ServiceTemplate serviceTemplate, ServiceItemFilter serviceItemFilter, ServiceDiscoveryListener serviceDiscoveryListener) throws RemoteException {
        this.checkTerminated();
        return this.createLookupCache(serviceTemplate, serviceItemFilter, serviceDiscoveryListener, Long.MAX_VALUE);
    }

    public DiscoveryManagement getDiscoveryManager() {
        this.checkTerminated();
        return this.discMgr;
    }

    public LeaseRenewalManager getLeaseRenewalManager() {
        this.checkTerminated();
        return this.leaseRenewalMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        ServiceDiscoveryManager serviceDiscoveryManager = this;
        synchronized (serviceDiscoveryManager) {
            if (this.bTerminated) {
                return;
            }
            this.bTerminated = true;
            this.discMgr.removeDiscoveryListener(this.discMgrListener);
            if (this.discMgrInternal) {
                this.discMgr.terminate();
            }
        }
        boolean bl = false;
        ArrayList arrayList = null;
        Object object = this.caches;
        synchronized (object) {
            if (!this.caches.isEmpty()) {
                bl = true;
                arrayList = (ArrayList)this.caches.clone();
            }
        }
        if (bl) {
            object = arrayList.iterator();
            while (object.hasNext()) {
                LookupCacheImpl lookupCacheImpl = (LookupCacheImpl)object.next();
                lookupCacheImpl.terminate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceItem[] lookup(ServiceTemplate serviceTemplate, int n, ServiceItemFilter serviceItemFilter) {
        ServiceRegistrar[] serviceRegistrarArray;
        this.checkTerminated();
        if (n < 1) {
            throw new IllegalArgumentException("maxMatches must be > 0");
        }
        ArrayList arrayList = this.proxyRegSet;
        synchronized (arrayList) {
            serviceRegistrarArray = this.buildServiceRegistrar();
        }
        int n2 = serviceRegistrarArray.length;
        ArrayList<ServiceItem> arrayList2 = new ArrayList<ServiceItem>(n2);
        if (n2 > 0) {
            int n3 = Math.abs(this.random.nextInt()) % n2;
            for (int i = 0; i < n2; ++i) {
                int n4 = n;
                ServiceRegistrar serviceRegistrar = serviceRegistrarArray[(i + n3) % n2];
                try {
                    if (serviceItemFilter != null) {
                        n4 = Integer.MAX_VALUE;
                    }
                    ServiceMatches serviceMatches = serviceRegistrar.lookup(serviceTemplate, n4);
                    int n5 = serviceMatches.items.length;
                    if (n5 == 0) continue;
                    int n6 = Math.abs(this.random.nextInt()) % n5;
                    for (int j = 0; j < n5; ++j) {
                        ServiceItem serviceItem = serviceMatches.items[(j + n6) % n5];
                        if (serviceItem == null || !this.filterPassFail(serviceItem, serviceItemFilter)) continue;
                        if (!ServiceDiscoveryManager.isArrayContainsServiceItem(arrayList2, serviceItem)) {
                            arrayList2.add(serviceItem);
                        }
                        if (arrayList2.size() < n) continue;
                        return arrayList2.toArray(new ServiceItem[arrayList2.size()]);
                    }
                    continue;
                }
                catch (Exception exception) {
                    logger.log(Level.INFO, "Exception occurred during query, discarding proxy", exception);
                    this.discard(serviceRegistrar);
                }
            }
        }
        return arrayList2.toArray(new ServiceItem[arrayList2.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceItem[] lookup(ServiceTemplate serviceTemplate, int n, int n2, ServiceItemFilter serviceItemFilter, long l) throws InterruptedException, RemoteException {
        this.checkTerminated();
        if (n < 1) {
            throw new IllegalArgumentException("minMatches must be > 0");
        }
        if (n2 < n) {
            throw new IllegalArgumentException("maxMatches must be > minMatches");
        }
        ServiceItem[] serviceItemArray = this.lookup(serviceTemplate, n2, serviceItemFilter);
        if (serviceItemArray.length >= n) {
            return serviceItemArray;
        }
        ArrayList<ServiceItem> arrayList = new ArrayList<ServiceItem>(serviceItemArray.length);
        for (int i = 0; i < serviceItemArray.length; ++i) {
            arrayList.add(serviceItemArray[i]);
        }
        ServiceItem[] serviceItemArray2 = new ServiceDiscoveryListenerImpl();
        LookupCacheImpl lookupCacheImpl = null;
        ServiceItem[] serviceItemArray3 = serviceItemArray2;
        synchronized (serviceItemArray2) {
            lookupCacheImpl = this.createLookupCache(serviceTemplate, serviceItemFilter, (ServiceDiscoveryListener)serviceItemArray2, l);
            long l2 = lookupCacheImpl.getLeaseDuration();
            while (l2 > 0L) {
                serviceItemArray2.wait(l2);
                ServiceItem[] serviceItemArray4 = serviceItemArray2.getServiceItem();
                for (int i = 0; i < serviceItemArray4.length; ++i) {
                    if (ServiceDiscoveryManager.isArrayContainsServiceItem(arrayList, serviceItemArray4[i])) continue;
                    arrayList.add(serviceItemArray4[i]);
                }
                if (arrayList.size() == n) break;
                l2 = lookupCacheImpl.getLeaseDuration();
            }
            // ** MonitorExit[var11_11] (shouldn't be in output)
            lookupCacheImpl.terminate();
            serviceItemArray3 = new ServiceItem[arrayList.size()];
            arrayList.toArray(serviceItemArray3);
            return serviceItemArray3;
        }
    }

    private ServiceItem getMatchedServiceItem(ServiceMatches serviceMatches, ServiceItemFilter serviceItemFilter) {
        int n = serviceMatches.items.length;
        if (n > 0) {
            int n2 = Math.abs(this.random.nextInt()) % n;
            for (int i = 0; i < n; ++i) {
                ServiceItem serviceItem = serviceMatches.items[(i + n2) % n];
                if (serviceItem == null || !this.filterPassFail(serviceItem, serviceItemFilter)) continue;
                return serviceItem;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LookupCacheImpl createLookupCache(ServiceTemplate serviceTemplate, ServiceItemFilter serviceItemFilter, ServiceDiscoveryListener serviceDiscoveryListener, long l) throws RemoteException {
        if (serviceTemplate == null) {
            serviceTemplate = new ServiceTemplate(null, null, null);
        }
        LookupCacheImpl lookupCacheImpl = new LookupCacheImpl(serviceTemplate, serviceItemFilter, serviceDiscoveryListener, l);
        ArrayList arrayList = this.caches;
        synchronized (arrayList) {
            this.caches.add(lookupCacheImpl);
        }
        logger.finest("ServiceDiscoveryManager - LookupCache created");
        return lookupCacheImpl;
    }

    private ProxyReg findReg(ServiceRegistrar serviceRegistrar) {
        Iterator iterator = this.proxyRegSet.iterator();
        while (iterator.hasNext()) {
            ProxyReg proxyReg = (ProxyReg)iterator.next();
            if (!proxyReg.proxy.equals(serviceRegistrar)) continue;
            return proxyReg;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fail(Throwable throwable, ServiceRegistrar serviceRegistrar, String string, String string2, String string3, boolean bl) {
        block8: {
            Level level = Level.INFO;
            boolean bl2 = true;
            ServiceDiscoveryManager serviceDiscoveryManager = this;
            synchronized (serviceDiscoveryManager) {
                if (this.bTerminated || bl) {
                    level = Levels.HANDLED;
                    bl2 = false;
                }
            }
            if (throwable != null && logger.isLoggable(level)) {
                logger.logp(level, string, string2, string3, throwable);
            }
            try {
                if (bl2) {
                    this.discard(serviceRegistrar);
                }
            }
            catch (IllegalStateException illegalStateException) {
                if (!logger.isLoggable(level)) break block8;
                logger.logp(level, string, string2, "failure discarding lookup service proxy, discovery manager already terminated", illegalStateException);
            }
        }
    }

    private void discard(ServiceRegistrar serviceRegistrar) {
        this.discMgr.discard(serviceRegistrar);
    }

    private void cancelLease(Lease lease) {
        try {
            this.leaseRenewalMgr.cancel(lease);
        }
        catch (Exception exception) {
            logger.log(Level.FINER, "exception occurred while cancelling an event registration lease", exception);
        }
    }

    private EventReg registerListener(ServiceRegistrar serviceRegistrar, ServiceTemplate serviceTemplate, RemoteEventListener remoteEventListener, long l) throws RemoteException {
        EventRegistration eventRegistration = null;
        int n = 7;
        eventRegistration = serviceRegistrar.notify(serviceTemplate, n, remoteEventListener, null, l);
        Lease lease = eventRegistration.getLease();
        lease = (Lease)this.eventLeasePreparer.prepareProxy(lease);
        logger.log(Level.FINEST, "ServiceDiscoveryManager - proxy to event registration lease prepared: {0}", lease);
        this.leaseRenewalMgr.renewFor(lease, l, new LeaseListenerImpl(serviceRegistrar));
        return new EventReg(lease, eventRegistration.getSequenceNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTerminated() {
        ServiceDiscoveryManager serviceDiscoveryManager = this;
        synchronized (serviceDiscoveryManager) {
            if (this.bTerminated) {
                throw new IllegalStateException("service discovery manager was terminated");
            }
        }
    }

    private static ServiceTemplate copyServiceTemplate(ServiceTemplate serviceTemplate) {
        int n;
        Class[] classArray = null;
        Entry[] entryArray = null;
        if (serviceTemplate.serviceTypes != null) {
            n = serviceTemplate.serviceTypes.length;
            classArray = new Class[n];
            System.arraycopy(serviceTemplate.serviceTypes, 0, classArray, 0, n);
        }
        if (serviceTemplate.attributeSetTemplates != null) {
            n = serviceTemplate.attributeSetTemplates.length;
            entryArray = new Entry[n];
            System.arraycopy(serviceTemplate.attributeSetTemplates, 0, entryArray, 0, n);
        }
        return new ServiceTemplate(serviceTemplate.serviceID, classArray, entryArray);
    }

    private static boolean isArrayContainsServiceItem(ArrayList arrayList, ServiceItem serviceItem) {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof ServiceItem)) continue;
            ServiceItem serviceItem2 = (ServiceItem)e;
            if (!serviceItem2.serviceID.equals(serviceItem.serviceID) || !LookupAttributes.equal(serviceItem2.attributeSets, serviceItem.attributeSets) || !serviceItem2.service.equals(serviceItem.service)) continue;
            return true;
        }
        return false;
    }

    private void init(DiscoveryManagement discoveryManagement, LeaseRenewalManager leaseRenewalManager, Configuration configuration) throws IOException, ConfigurationException {
        if (configuration == null) {
            throw new NullPointerException("config is null");
        }
        this.thisConfig = configuration;
        this.registrarPreparer = (ProxyPreparer)this.thisConfig.getEntry(COMPONENT_NAME, "registrarPreparer", ProxyPreparer.class, new BasicProxyPreparer());
        this.eventLeasePreparer = (ProxyPreparer)this.thisConfig.getEntry(COMPONENT_NAME, "eventLeasePreparer", ProxyPreparer.class, new BasicProxyPreparer());
        this.leaseRenewalMgr = leaseRenewalManager;
        if (this.leaseRenewalMgr == null) {
            this.leaseRenewalMgr = new LeaseRenewalManager(this.thisConfig);
            try {
                this.leaseRenewalMgr = (LeaseRenewalManager)this.thisConfig.getEntry(COMPONENT_NAME, "leaseManager", LeaseRenewalManager.class, this.leaseRenewalMgr);
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
        this.discardWait = (Long)this.thisConfig.getEntry(COMPONENT_NAME, "discardWait", Long.TYPE, new Long(this.discardWait));
        this.discMgr = discoveryManagement;
        if (this.discMgr == null) {
            this.discMgrInternal = true;
            this.discMgr = new LookupDiscoveryManager(new String[]{""}, null, null, this.thisConfig);
            try {
                this.discMgr = (DiscoveryManagement)this.thisConfig.getEntry(COMPONENT_NAME, "discoveryManager", DiscoveryManagement.class, this.discMgr);
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
        this.discMgr.addDiscoveryListener(this.discMgrListener);
    }

    private boolean filterPassFail(ServiceItem serviceItem, ServiceItemFilter serviceItemFilter) {
        if (serviceItem == null || serviceItem.service == null) {
            return false;
        }
        if (serviceItemFilter == null) {
            return true;
        }
        boolean bl = serviceItemFilter.check(serviceItem);
        return bl && serviceItem.service != null;
    }

    private class DiscMgrListener
    implements DiscoveryListener {
        private DiscMgrListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void discovered(DiscoveryEvent discoveryEvent) {
            ProxyReg proxyReg;
            ServiceRegistrar[] serviceRegistrarArray = discoveryEvent.getRegistrars();
            ArrayList<ProxyReg> arrayList = new ArrayList<ProxyReg>(1);
            ArrayList arrayList2 = null;
            for (int i = 0; i < serviceRegistrarArray.length; ++i) {
                try {
                    serviceRegistrarArray[i] = (ServiceRegistrar)ServiceDiscoveryManager.this.registrarPreparer.prepareProxy(serviceRegistrarArray[i]);
                    logger.log(Level.FINEST, "ServiceDiscoveryManager - discovered lookup service proxy prepared: {0}", serviceRegistrarArray[i]);
                }
                catch (Exception exception) {
                    logger.log(Level.INFO, "failure preparing discovered ServiceRegistrar proxy, discarding the proxy", exception);
                    ServiceDiscoveryManager.this.discard(serviceRegistrarArray[i]);
                    continue;
                }
                proxyReg = new ProxyReg(serviceRegistrarArray[i]);
                ArrayList arrayList3 = ServiceDiscoveryManager.this.proxyRegSet;
                synchronized (arrayList3) {
                    ServiceDiscoveryManager.this.proxyRegSet.add(proxyReg);
                    arrayList.add(proxyReg);
                    continue;
                }
            }
            Object object = ServiceDiscoveryManager.this.listeners;
            synchronized (object) {
                if (!ServiceDiscoveryManager.this.listeners.isEmpty()) {
                    arrayList2 = (ArrayList)ServiceDiscoveryManager.this.listeners.clone();
                }
            }
            object = arrayList.iterator();
            while (object.hasNext()) {
                proxyReg = (ProxyReg)object.next();
                ServiceDiscoveryManager.this.cacheAddProxy(proxyReg);
                if (arrayList2 == null) continue;
                ServiceDiscoveryManager.this.listenerDiscovered(proxyReg.proxy, arrayList2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void discarded(DiscoveryEvent discoveryEvent) {
            ArrayList arrayList;
            ServiceRegistrar[] serviceRegistrarArray = discoveryEvent.getRegistrars();
            ArrayList<ProxyReg> arrayList2 = new ArrayList<ProxyReg>(1);
            Object object = ServiceDiscoveryManager.this.proxyRegSet;
            synchronized (object) {
                for (int i = 0; i < serviceRegistrarArray.length; ++i) {
                    ProxyReg proxyReg = ServiceDiscoveryManager.this.findReg(serviceRegistrarArray[i]);
                    if (proxyReg == null) {
                        throw new RuntimeException("discard error");
                    }
                    ServiceDiscoveryManager.this.proxyRegSet.remove(ServiceDiscoveryManager.this.proxyRegSet.indexOf(proxyReg));
                    arrayList2.add(proxyReg);
                }
            }
            object = arrayList2.iterator();
            while (object.hasNext()) {
                ServiceDiscoveryManager.this.dropProxy((ProxyReg)object.next());
            }
            ArrayList arrayList3 = ServiceDiscoveryManager.this.listeners;
            synchronized (arrayList3) {
                if (ServiceDiscoveryManager.this.listeners.isEmpty()) {
                    return;
                }
                arrayList = (ArrayList)ServiceDiscoveryManager.this.listeners.clone();
            }
            ServiceDiscoveryManager.this.listenerDropped(arrayList2, arrayList);
        }
    }

    private final class LookupCacheImpl
    implements LookupCache {
        private static final int ITEM_ADDED = 0;
        private static final int ITEM_REMOVED = 2;
        private static final int ITEM_CHANGED = 3;
        private LookupListener lookupListener;
        private Exporter lookupListenerExporter;
        private RemoteEventListener lookupListenerProxy;
        private TaskManager cacheTaskMgr;
        private boolean bCacheTerminated = false;
        private final ArrayList sItemListeners = new ArrayList(1);
        private final HashMap serviceIdMap = new HashMap();
        private final HashMap eventRegMap = new HashMap();
        private ServiceTemplate tmpl;
        private ServiceItemFilter filter = null;
        private long leaseDuration;
        private final long startTime = System.currentTimeMillis();
        private TaskManager serviceDiscardTimerTaskMgr;
        private Object serviceDiscardMutex = new Object();
        private int taskSeqN = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LookupCacheImpl(ServiceTemplate serviceTemplate, ServiceItemFilter serviceItemFilter, ServiceDiscoveryListener serviceDiscoveryListener, long l) throws RemoteException {
            this.tmpl = ServiceDiscoveryManager.copyServiceTemplate(serviceTemplate);
            this.leaseDuration = l;
            this.filter = serviceItemFilter;
            this.initCache();
            this.lookupListener = new LookupListener();
            ArrayList arrayList = this.sItemListeners;
            synchronized (arrayList) {
                if (serviceDiscoveryListener != null) {
                    this.sItemListeners.add(serviceDiscoveryListener);
                }
            }
            ArrayList arrayList2 = ServiceDiscoveryManager.this.proxyRegSet;
            synchronized (arrayList2) {
                arrayList = (ArrayList)ServiceDiscoveryManager.this.proxyRegSet.clone();
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                ProxyReg proxyReg = (ProxyReg)arrayList.get(i);
                this.addProxyReg(proxyReg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void terminate() {
            Object object = this.serviceIdMap;
            synchronized (object) {
                if (this.bCacheTerminated) {
                    return;
                }
                this.bCacheTerminated = true;
            }
            object = ServiceDiscoveryManager.this.caches;
            synchronized (object) {
                int n = ServiceDiscoveryManager.this.caches.indexOf(this);
                if (n != -1) {
                    ServiceDiscoveryManager.this.caches.remove(n);
                }
            }
            this.terminateTaskMgr(this.cacheTaskMgr);
            object = this.serviceDiscardMutex;
            synchronized (object) {
                this.terminateTaskMgr(this.serviceDiscardTimerTaskMgr);
            }
            object = this.serviceIdMap;
            synchronized (object) {
                Set set = this.eventRegMap.entrySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    EventReg eventReg = (EventReg)entry.getValue();
                    ServiceDiscoveryManager.this.cancelLease(eventReg.lease);
                }
            }
            try {
                this.lookupListenerExporter.unexport(true);
            }
            catch (IllegalStateException illegalStateException) {
                logger.log(Level.FINEST, "IllegalStateException occurred while unexporting the cache's remote event listener", illegalStateException);
            }
            logger.finest("ServiceDiscoveryManager - LookupCache terminated");
        }

        public ServiceItem lookup(ServiceItemFilter serviceItemFilter) {
            this.checkCacheTerminated();
            ServiceItem[] serviceItemArray = this.getServiceItems(serviceItemFilter);
            if (serviceItemArray.length == 0) {
                return null;
            }
            int n = Math.abs(ServiceDiscoveryManager.this.random.nextInt()) % serviceItemArray.length;
            return serviceItemArray[n];
        }

        public ServiceItem[] lookup(ServiceItemFilter serviceItemFilter, int n) {
            this.checkCacheTerminated();
            if (n < 1) {
                throw new IllegalArgumentException("maxMatches must be > 0");
            }
            ArrayList<ServiceItem> arrayList = new ArrayList<ServiceItem>(1);
            ServiceItem[] serviceItemArray = this.getServiceItems(serviceItemFilter);
            int n2 = serviceItemArray.length;
            if (n2 == 0) {
                return new ServiceItem[0];
            }
            int n3 = Math.abs(ServiceDiscoveryManager.this.random.nextInt()) % n2;
            for (int i = 0; i < n2; ++i) {
                arrayList.add(serviceItemArray[(i + n3) % n2]);
                if (arrayList.size() == n) break;
            }
            ServiceItem[] serviceItemArray2 = new ServiceItem[arrayList.size()];
            arrayList.toArray(serviceItemArray2);
            return serviceItemArray2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void discard(Object object) {
            Object object2;
            this.checkCacheTerminated();
            boolean bl = false;
            Iterator iterator = this.getServiceIdMapEntrySetIterator();
            while (iterator.hasNext()) {
                ServiceItemReg serviceItemReg;
                object2 = (Map.Entry)iterator.next();
                ServiceItemReg serviceItemReg2 = serviceItemReg = (ServiceItemReg)object2.getValue();
                synchronized (serviceItemReg2) {
                    if (serviceItemReg.filteredItem.service.equals(object)) {
                        if (serviceItemReg.isDiscarded()) {
                            return;
                        }
                        serviceItemReg.setDiscarded(true);
                        bl = true;
                        break;
                    }
                }
            }
            if (bl) {
                object2 = new DiscardServiceTask(object);
                this.cacheTaskMgr.add((TaskManager.Task)object2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Iterator getServiceIdMapEntrySetIterator() {
            HashMap hashMap;
            Object object = this.serviceIdMap;
            synchronized (object) {
                hashMap = (HashMap)this.serviceIdMap.clone();
            }
            object = hashMap.entrySet();
            return object.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ServiceItem[] getServiceItems(ServiceItemFilter serviceItemFilter) {
            ServiceItem[] serviceItemArray;
            ArrayList<ServiceItem> arrayList = new ArrayList<ServiceItem>(1);
            Iterator iterator = this.getServiceIdMapEntrySetIterator();
            while (iterator.hasNext()) {
                ServiceItem serviceItem;
                serviceItemArray = (ServiceItem[])iterator.next();
                ServiceItemReg serviceItemReg = (ServiceItemReg)serviceItemArray.getValue();
                Object object = serviceItemReg;
                synchronized (object) {
                    if (serviceItemReg.isDiscarded() || serviceItemReg.filteredItem == null) {
                        continue;
                    }
                    serviceItem = new ServiceItem(serviceItemReg.filteredItem.serviceID, serviceItemReg.filteredItem.service, serviceItemReg.filteredItem.attributeSets);
                }
                object = serviceItem.service;
                boolean bl = serviceItemFilter == null || serviceItemFilter.check(serviceItem);
                if (!bl) continue;
                if (serviceItem.service != null) {
                    arrayList.add(serviceItem);
                    continue;
                }
                this.discard(object);
            }
            serviceItemArray = new ServiceItem[arrayList.size()];
            arrayList.toArray(serviceItemArray);
            return serviceItemArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(ServiceDiscoveryListener serviceDiscoveryListener) {
            this.checkCacheTerminated();
            if (serviceDiscoveryListener == null) {
                throw new NullPointerException("can't add null listener");
            }
            ServiceItem[] serviceItemArray = this.sItemListeners;
            synchronized (this.sItemListeners) {
                this.sItemListeners.add(serviceDiscoveryListener);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                serviceItemArray = this.getServiceItems(null);
                for (int i = 0; i < serviceItemArray.length; ++i) {
                    this.addServiceNotify(serviceItemArray[i], serviceDiscoveryListener);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListener(ServiceDiscoveryListener serviceDiscoveryListener) {
            this.checkCacheTerminated();
            if (serviceDiscoveryListener == null) {
                return;
            }
            ArrayList arrayList = this.sItemListeners;
            synchronized (arrayList) {
                int n = this.sItemListeners.indexOf(serviceDiscoveryListener);
                if (n != -1) {
                    this.sItemListeners.remove(serviceDiscoveryListener);
                }
            }
        }

        public void addProxyReg(ProxyReg proxyReg) {
            RegisterListenerTask registerListenerTask = new RegisterListenerTask(proxyReg);
            this.cacheTaskMgr.add(registerListenerTask);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeProxyReg(ProxyReg proxyReg) {
            EventReg eventReg;
            Object object = this.serviceIdMap;
            synchronized (object) {
                eventReg = (EventReg)this.eventRegMap.get(proxyReg);
            }
            if (eventReg != null) {
                ServiceDiscoveryManager.this.cancelLease(eventReg.lease);
            }
            object = new ProxyRegDropTask(proxyReg);
            this.removeUselessTask(proxyReg);
            this.cacheTaskMgr.add((TaskManager.Task)object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkCacheTerminated() {
            ServiceDiscoveryManager.this.checkTerminated();
            HashMap hashMap = this.serviceIdMap;
            synchronized (hashMap) {
                if (this.bCacheTerminated) {
                    throw new IllegalStateException("this lookup cache was terminated");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyServiceMap(ServiceRegistrar serviceRegistrar, ServiceID serviceID, ServiceItem serviceItem, int n, long l) {
            ProxyReg proxyReg;
            ArrayList arrayList = ServiceDiscoveryManager.this.proxyRegSet;
            synchronized (arrayList) {
                proxyReg = ServiceDiscoveryManager.this.findReg(serviceRegistrar);
            }
            if (proxyReg == null) {
                return;
            }
            HashMap hashMap = this.serviceIdMap;
            synchronized (hashMap) {
                EventReg eventReg = (EventReg)this.eventRegMap.get(proxyReg);
                if (eventReg == null) {
                    return;
                }
                long l2 = eventReg.seqNo;
                eventReg.seqNo = l;
                CacheTask cacheTask = l == l2 + 1L ? new NotifyEventTask(proxyReg, serviceID, serviceItem, n, this.taskSeqN++) : new LookupTask(proxyReg);
                this.cacheTaskMgr.add(cacheTask);
            }
        }

        private void removeUselessTask(ProxyReg proxyReg) {
            ArrayList arrayList = this.cacheTaskMgr.getPending();
            for (int i = 0; i < arrayList.size(); ++i) {
                CacheTask cacheTask = (CacheTask)arrayList.get(i);
                if (!cacheTask.isFromProxy(proxyReg)) continue;
                this.cacheTaskMgr.remove(cacheTask);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void terminateTaskMgr(TaskManager taskManager) {
            TaskManager taskManager2 = taskManager;
            synchronized (taskManager2) {
                ArrayList arrayList = taskManager.getPending();
                for (int i = 0; i < arrayList.size(); ++i) {
                    taskManager.remove((TaskManager.Task)arrayList.get(i));
                }
                taskManager.terminate();
                taskManager = null;
            }
        }

        private void removeServiceIdMap(ServiceID serviceID, ServiceItem serviceItem) {
            this.removeServiceIdMapSendNoEvent(serviceID);
            this.removeServiceNotify(serviceItem);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeServiceIdMapSendNoEvent(ServiceID serviceID) {
            HashMap hashMap = this.serviceIdMap;
            synchronized (hashMap) {
                this.serviceIdMap.remove(serviceID);
            }
        }

        private ServiceItem findItem(ServiceID serviceID, ServiceItem[] serviceItemArray) {
            if (serviceItemArray != null) {
                for (int i = 0; i < serviceItemArray.length; ++i) {
                    if (!serviceItemArray[i].serviceID.equals(serviceID)) continue;
                    return serviceItemArray[i];
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void itemMatchMatchChange(ServiceRegistrar serviceRegistrar, ServiceItem serviceItem, ServiceItemReg serviceItemReg, boolean bl) {
            ServiceItem serviceItem2;
            ServiceItem serviceItem3;
            ServiceItem serviceItem4;
            ServiceItemReg serviceItemReg2 = serviceItemReg;
            synchronized (serviceItemReg2) {
                serviceItem4 = serviceItemReg.item;
                serviceItem3 = serviceItemReg.filteredItem;
                if (serviceItemReg.isDiscarded()) {
                    serviceItemReg.item = serviceItem;
                    serviceItemReg.filteredItem = null;
                    return;
                }
                serviceItemReg.addProxy(serviceRegistrar);
            }
            boolean bl2 = false;
            boolean bl3 = false;
            if (bl || this.sameVersion(serviceItem, serviceItem4)) {
                serviceItem.service = serviceItem4.service;
                boolean bl4 = bl2 = !LookupAttributes.equal(serviceItem.attributeSets, serviceItem4.attributeSets);
                if (!bl2) {
                    return;
                }
            } else {
                bl3 = true;
            }
            if ((serviceItem2 = this.filterMaybeDiscard(serviceItem, serviceRegistrar, true)) != null) {
                if (bl2) {
                    this.changeServiceNotify(serviceItem2, serviceItem3);
                }
                if (bl3) {
                    this.removeServiceNotify(serviceItem3);
                    this.addServiceNotify(serviceItem2);
                }
            }
        }

        private boolean sameVersion(ServiceItem serviceItem, ServiceItem serviceItem2) {
            boolean bl = false;
            try {
                MarshalledInstance marshalledInstance = new MarshalledInstance(serviceItem.service);
                MarshalledInstance marshalledInstance2 = new MarshalledInstance(serviceItem2.service);
                bl = marshalledInstance.fullyEquals(marshalledInstance2);
            }
            catch (IOException iOException) {
                logger.log(Level.INFO, "failure marshalling old and new services for equality check", iOException);
            }
            return bl;
        }

        public long getLeaseDuration() {
            if (this.leaseDuration == Long.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            return this.leaseDuration + this.startTime - System.currentTimeMillis();
        }

        private void addServiceNotify(ServiceItem serviceItem) {
            this.serviceNotifyDo(null, serviceItem, 0);
        }

        private void addServiceNotify(ServiceItem serviceItem, ServiceDiscoveryListener serviceDiscoveryListener) {
            this.serviceNotifyDo(null, serviceItem, 0, serviceDiscoveryListener);
        }

        private void removeServiceNotify(ServiceItem serviceItem) {
            this.serviceNotifyDo(serviceItem, null, 2);
        }

        private void changeServiceNotify(ServiceItem serviceItem, ServiceItem serviceItem2) {
            this.serviceNotifyDo(serviceItem2, serviceItem, 3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void serviceNotifyDo(ServiceItem serviceItem, ServiceItem serviceItem2, int n) {
            ArrayList arrayList;
            Object object = this.sItemListeners;
            synchronized (object) {
                if (this.sItemListeners.isEmpty()) {
                    return;
                }
                arrayList = (ArrayList)this.sItemListeners.clone();
            }
            object = arrayList.iterator();
            while (object.hasNext()) {
                ServiceDiscoveryListener serviceDiscoveryListener = (ServiceDiscoveryListener)object.next();
                this.serviceNotifyDo(serviceItem, serviceItem2, n, serviceDiscoveryListener);
            }
        }

        private void serviceNotifyDo(ServiceItem serviceItem, ServiceItem serviceItem2, int n, ServiceDiscoveryListener serviceDiscoveryListener) {
            ServiceDiscoveryEvent serviceDiscoveryEvent = new ServiceDiscoveryEvent(this, serviceItem, serviceItem2);
            switch (n) {
                case 0: {
                    serviceDiscoveryListener.serviceAdded(serviceDiscoveryEvent);
                    break;
                }
                case 2: {
                    serviceDiscoveryListener.serviceRemoved(serviceDiscoveryEvent);
                    break;
                }
                case 3: {
                    serviceDiscoveryListener.serviceChanged(serviceDiscoveryEvent);
                }
            }
        }

        private void initCache() throws RemoteException {
            try {
                BasicJeriExporter basicJeriExporter = new BasicJeriExporter(TcpServerEndpoint.getInstance(0), new BasicILFactory(), false, false);
                this.lookupListenerExporter = (Exporter)ServiceDiscoveryManager.this.thisConfig.getEntry(ServiceDiscoveryManager.COMPONENT_NAME, "eventListenerExporter", class$net$jini$export$Exporter == null ? (class$net$jini$export$Exporter = ServiceDiscoveryManager.class$("net.jini.export.Exporter")) : class$net$jini$export$Exporter, basicJeriExporter);
            }
            catch (ConfigurationException configurationException) {
                ExportException exportException = new ExportException("Configuration exception while retrieving exporter for cache's remote event listener", configurationException);
                throw exportException;
            }
            this.cacheTaskMgr = new TaskManager(10, 15000L, 1.0f);
            try {
                this.cacheTaskMgr = (TaskManager)ServiceDiscoveryManager.this.thisConfig.getEntry(ServiceDiscoveryManager.COMPONENT_NAME, "cacheTaskManager", class$com$sun$jini$thread$TaskManager == null ? (class$com$sun$jini$thread$TaskManager = ServiceDiscoveryManager.class$("com.sun.jini.thread.TaskManager")) : class$com$sun$jini$thread$TaskManager, this.cacheTaskMgr);
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
            this.serviceDiscardTimerTaskMgr = new TaskManager(10, 15000L, 1.0f);
            try {
                this.serviceDiscardTimerTaskMgr = (TaskManager)ServiceDiscoveryManager.this.thisConfig.getEntry(ServiceDiscoveryManager.COMPONENT_NAME, "discardTaskManager", class$com$sun$jini$thread$TaskManager == null ? (class$com$sun$jini$thread$TaskManager = ServiceDiscoveryManager.class$("com.sun.jini.thread.TaskManager")) : class$com$sun$jini$thread$TaskManager, this.serviceDiscardTimerTaskMgr);
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ServiceItem filterMaybeDiscard(ServiceItem serviceItem, ServiceRegistrar serviceRegistrar, boolean bl) {
            if (serviceItem == null || serviceItem.service == null) {
                return null;
            }
            if (this.filter == null) {
                this.addFilteredItemToMap(serviceItem, serviceItem);
                return serviceItem;
            }
            ServiceItem serviceItem2 = new ServiceItem(serviceItem.serviceID, serviceItem.service, serviceItem.attributeSets);
            boolean bl2 = this.filter.check(serviceItem2);
            if (!bl2) {
                ServiceID serviceID = serviceItem.serviceID;
                ServiceItemReg serviceItemReg = null;
                Serializable serializable = this.serviceIdMap;
                synchronized (serializable) {
                    serviceItemReg = (ServiceItemReg)this.serviceIdMap.get(serviceID);
                }
                if (serviceItemReg != null) {
                    if (bl) {
                        ServiceItemReg serviceItemReg2 = serviceItemReg;
                        synchronized (serviceItemReg2) {
                            serializable = serviceItemReg.filteredItem;
                        }
                        this.removeServiceIdMap(serviceID, (ServiceItem)serializable);
                    } else {
                        this.removeServiceIdMapSendNoEvent(serviceID);
                    }
                }
                return null;
            }
            if (serviceItem2.service != null) {
                this.addFilteredItemToMap(serviceItem, serviceItem2);
                return serviceItem2;
            }
            this.discardRetryLater(serviceItem, serviceRegistrar, bl);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addFilteredItemToMap(ServiceItem serviceItem, ServiceItem serviceItem2) {
            ServiceItemReg serviceItemReg = null;
            Object object = this.serviceIdMap;
            synchronized (object) {
                serviceItemReg = (ServiceItemReg)this.serviceIdMap.get(serviceItem.serviceID);
            }
            if (serviceItemReg == null) {
                return;
            }
            object = serviceItemReg;
            synchronized (object) {
                serviceItemReg.item = serviceItem;
                serviceItemReg.filteredItem = serviceItem2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void discardRetryLater(ServiceItem serviceItem, ServiceRegistrar serviceRegistrar, boolean bl) {
            ServiceItemReg serviceItemReg = null;
            Serializable serializable = this.serviceIdMap;
            synchronized (serializable) {
                serviceItemReg = (ServiceItemReg)this.serviceIdMap.get(serviceItem.serviceID);
            }
            if (serviceItemReg == null) {
                return;
            }
            ServiceItemReg serviceItemReg2 = serviceItemReg;
            synchronized (serviceItemReg2) {
                serializable = serviceItemReg.filteredItem;
                if (serviceItemReg.item != serviceItem) {
                    serviceItemReg.item = serviceItem;
                    serviceItemReg.filteredItem = null;
                }
                serviceItemReg.setDiscarded(true);
            }
            if (bl) {
                this.removeServiceNotify((ServiceItem)serializable);
            }
            this.serviceDiscardTimerTaskMgr.add(new ServiceDiscardTimerTask(serviceItem.serviceID));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleMatchNoMatch(ServiceRegistrar serviceRegistrar, ServiceID serviceID, ServiceItem serviceItem) {
            ServiceItemReg serviceItemReg = null;
            HashMap hashMap = this.serviceIdMap;
            synchronized (hashMap) {
                serviceItemReg = (ServiceItemReg)this.serviceIdMap.get(serviceID);
            }
            if (serviceItemReg != null) {
                ServiceItem serviceItem2;
                boolean bl;
                boolean bl2;
                Object object = serviceItemReg;
                synchronized (object) {
                    serviceItemReg.removeProxy(serviceRegistrar);
                    bl2 = serviceItemReg.hasNoProxys();
                    bl = serviceItemReg.isDiscarded();
                    serviceItem2 = serviceItemReg.filteredItem;
                }
                if (bl2) {
                    if (bl) {
                        this.removeServiceIdMapSendNoEvent(serviceID);
                        object = this.serviceDiscardMutex;
                        synchronized (object) {
                            this.serviceDiscardMutex.notifyAll();
                        }
                    } else {
                        this.removeServiceIdMap(serviceID, serviceItem2);
                    }
                }
            }
        }

        private final class UnmapProxyTask
        extends ServiceIdTask {
            private ServiceItemReg itemReg;

            public UnmapProxyTask(ProxyReg proxyReg, ServiceItemReg serviceItemReg, ServiceID serviceID, int n) {
                super(serviceID, proxyReg, n);
                this.itemReg = serviceItemReg;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                logger.finest("ServiceDiscoveryManager - UnmapProxyTask started");
                ServiceItem serviceItem = null;
                ServiceItemReg serviceItemReg = this.itemReg;
                synchronized (serviceItemReg) {
                    this.itemReg.removeProxy(this.reg.proxy);
                    if (this.itemReg.hasNoProxys()) {
                        serviceItem = this.itemReg.filteredItem;
                    }
                }
                if (serviceItem != null) {
                    LookupCacheImpl.this.removeServiceIdMap(this.thisTaskSid, serviceItem);
                }
                logger.finest("ServiceDiscoveryManager - UnmapProxyTask completed");
            }
        }

        private final class NewOldServiceTask
        extends ServiceIdTask {
            private ServiceItem srvcItem;
            private boolean matchMatchEvent;

            public NewOldServiceTask(ProxyReg proxyReg, ServiceItem serviceItem, boolean bl, int n) {
                super(serviceItem.serviceID, proxyReg, n);
                this.srvcItem = serviceItem;
                this.matchMatchEvent = bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ServiceItemReg serviceItemReg;
                logger.finest("ServiceDiscoveryManager - NewOldServiceTask started");
                Serializable serializable = LookupCacheImpl.this.serviceIdMap;
                synchronized (serializable) {
                    serviceItemReg = (ServiceItemReg)LookupCacheImpl.this.serviceIdMap.get(this.thisTaskSid);
                }
                if (serviceItemReg != null) {
                    LookupCacheImpl.this.itemMatchMatchChange(this.reg.proxy, this.srvcItem, serviceItemReg, this.matchMatchEvent);
                } else {
                    serializable = LookupCacheImpl.this.serviceIdMap;
                    synchronized (serializable) {
                        if (!LookupCacheImpl.this.eventRegMap.containsKey(this.reg)) {
                            logger.finest("ServiceDiscoveryManager - NewOldServiceTask completed");
                            return;
                        }
                        serviceItemReg = new ServiceItemReg(this.reg.proxy, this.srvcItem);
                        LookupCacheImpl.this.serviceIdMap.put(this.thisTaskSid, serviceItemReg);
                    }
                    serializable = LookupCacheImpl.this.filterMaybeDiscard(this.srvcItem, this.reg.proxy, false);
                    if (serializable != null) {
                        LookupCacheImpl.this.addServiceNotify((ServiceItem)serializable);
                    }
                }
                logger.finest("ServiceDiscoveryManager - NewOldServiceTask completed");
            }
        }

        private final class ServiceDiscardTimerTask
        implements TaskManager.Task {
            private ServiceID serviceID;

            public ServiceDiscardTimerTask(ServiceID serviceID) {
                this.serviceID = serviceID;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Serializable serializable;
                logger.finest("ServiceDiscoveryManager - ServiceDiscardTimerTask started");
                HashMap hashMap = LookupCacheImpl.this.serviceIdMap;
                synchronized (hashMap) {
                    if (LookupCacheImpl.this.bCacheTerminated) {
                        return;
                    }
                }
                hashMap = LookupCacheImpl.this.serviceIdMap;
                synchronized (hashMap) {
                    if (!LookupCacheImpl.this.serviceIdMap.containsKey(this.serviceID)) {
                        return;
                    }
                }
                long l = ServiceDiscoveryManager.this.discardWait;
                long l2 = l + System.currentTimeMillis();
                Object object = LookupCacheImpl.this.serviceDiscardMutex;
                synchronized (object) {
                    while (l > 0L) {
                        try {
                            LookupCacheImpl.this.serviceDiscardMutex.wait(l);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        serializable = LookupCacheImpl.this.serviceIdMap;
                        synchronized (serializable) {
                            if (LookupCacheImpl.this.bCacheTerminated) {
                                return;
                            }
                        }
                        serializable = LookupCacheImpl.this.serviceIdMap;
                        synchronized (serializable) {
                            if (!LookupCacheImpl.this.serviceIdMap.containsKey(this.serviceID)) {
                                return;
                            }
                        }
                        l = l2 - System.currentTimeMillis();
                    }
                }
                object = null;
                serializable = LookupCacheImpl.this.serviceIdMap;
                synchronized (serializable) {
                    object = (ServiceItemReg)LookupCacheImpl.this.serviceIdMap.get(this.serviceID);
                }
                if (object != null) {
                    serializable = null;
                    ServiceItem serviceItem = null;
                    Object object2 = object;
                    synchronized (object2) {
                        if (((ServiceItemReg)object).filteredItem == null) {
                            serializable = new ServiceItem(((ServiceItemReg)object).item.serviceID, ((ServiceItemReg)object).item.service, ((ServiceItemReg)object).item.attributeSets);
                            serviceItem = new ServiceItem(((ServiceItemReg)object).item.serviceID, ((ServiceItemReg)object).item.service, ((ServiceItemReg)object).item.attributeSets);
                        }
                    }
                    if (serviceItem != null) {
                        if (ServiceDiscoveryManager.this.filterPassFail(serviceItem, LookupCacheImpl.this.filter)) {
                            LookupCacheImpl.this.addFilteredItemToMap((ServiceItem)serializable, serviceItem);
                        } else {
                            LookupCacheImpl.this.removeServiceIdMapSendNoEvent(this.serviceID);
                            return;
                        }
                    }
                    Object object3 = object;
                    synchronized (object3) {
                        ((ServiceItemReg)object).setDiscarded(false);
                        object2 = ((ServiceItemReg)object).filteredItem;
                    }
                    LookupCacheImpl.this.addServiceNotify((ServiceItem)object2);
                }
                logger.finest("ServiceDiscoveryManager - ServiceDiscardTimerTask completed");
            }

            public boolean runAfter(List list, int n) {
                return false;
            }
        }

        private final class NotifyEventTask
        extends ServiceIdTask {
            private ServiceID sid;
            private ServiceItem item;
            private int transition;

            public NotifyEventTask(ProxyReg proxyReg, ServiceID serviceID, ServiceItem serviceItem, int n, int n2) {
                super(serviceID, proxyReg, n2);
                this.sid = serviceID;
                this.item = serviceItem;
                this.transition = n;
            }

            public void run() {
                logger.finest("ServiceDiscoveryManager - NotifyEventTask started");
                if (this.item != null && this.item.service == null) {
                    return;
                }
                if (this.transition == 1) {
                    LookupCacheImpl.this.handleMatchNoMatch(this.reg.proxy, this.sid, this.item);
                } else {
                    new NewOldServiceTask(this.reg, this.item, this.transition == 4, this.thisTaskSeqN).run();
                }
                logger.finest("ServiceDiscoveryManager - NotifyEventTask completed");
            }
        }

        private final class DiscardServiceTask
        extends CacheTask {
            private Object service;

            public DiscardServiceTask(Object object) {
                super(null);
                this.service = object;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                logger.finest("ServiceDiscoveryManager - DiscardServiceTask started");
                Iterator iterator = LookupCacheImpl.this.getServiceIdMapEntrySetIterator();
                while (iterator.hasNext()) {
                    ServiceItem serviceItem;
                    Map.Entry entry = (Map.Entry)iterator.next();
                    ServiceItemReg serviceItemReg = (ServiceItemReg)entry.getValue();
                    Object object = serviceItemReg;
                    synchronized (object) {
                        serviceItem = serviceItemReg.filteredItem;
                    }
                    if (!serviceItem.service.equals(this.service)) continue;
                    object = (ServiceID)entry.getKey();
                    LookupCacheImpl.this.removeServiceNotify(serviceItem);
                    LookupCacheImpl.this.serviceDiscardTimerTaskMgr.add(new ServiceDiscardTimerTask((ServiceID)object));
                    return;
                }
                logger.finest("ServiceDiscoveryManager - DiscardServiceTask completed");
            }
        }

        private final class ProxyRegDropTask
        extends CacheTask {
            public ProxyRegDropTask(ProxyReg proxyReg) {
                super(proxyReg);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                logger.finest("ServiceDiscoveryManager - ProxyRegDropTask started");
                HashMap hashMap = LookupCacheImpl.this.serviceIdMap;
                synchronized (hashMap) {
                    if (LookupCacheImpl.this.eventRegMap.containsKey(this.reg)) {
                        LookupCacheImpl.this.eventRegMap.remove(this.reg);
                    }
                }
                hashMap = LookupCacheImpl.this.serviceIdMap;
                synchronized (hashMap) {
                    Iterator iterator = LookupCacheImpl.this.serviceIdMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        ServiceID serviceID = (ServiceID)entry.getKey();
                        ServiceItemReg serviceItemReg = (ServiceItemReg)entry.getValue();
                        UnmapProxyTask unmapProxyTask = new UnmapProxyTask(this.reg, serviceItemReg, serviceID, LookupCacheImpl.this.taskSeqN++);
                        LookupCacheImpl.this.cacheTaskMgr.add(unmapProxyTask);
                    }
                }
                logger.finest("ServiceDiscoveryManager - ProxyRegDropTask completed");
            }
        }

        private final class LookupTask
        extends CacheTask {
            public LookupTask(ProxyReg proxyReg) {
                super(proxyReg);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ServiceMatches serviceMatches;
                logger.finest("ServiceDiscoveryManager - LookupTask started");
                ServiceRegistrar serviceRegistrar = this.reg.proxy;
                try {
                    serviceMatches = serviceRegistrar.lookup(LookupCacheImpl.this.tmpl, Integer.MAX_VALUE);
                }
                catch (Exception exception) {
                    boolean bl;
                    HashMap hashMap = LookupCacheImpl.this.serviceIdMap;
                    synchronized (hashMap) {
                        bl = LookupCacheImpl.this.bCacheTerminated;
                    }
                    ServiceDiscoveryManager.this.fail(exception, serviceRegistrar, this.getClass().getName(), "run", "Exception occurred during call to lookup", bl);
                    return;
                }
                if (serviceMatches.items == null) {
                    throw new AssertionError((Object)"spec violation in queried lookup service: ServicesMatches instance returned by call to lookup() method contains null 'items' field");
                }
                HashMap hashMap = LookupCacheImpl.this.serviceIdMap;
                synchronized (hashMap) {
                    Object object;
                    Iterator iterator = LookupCacheImpl.this.serviceIdMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        object = (ServiceID)entry.getKey();
                        ServiceItem serviceItem = LookupCacheImpl.this.findItem((ServiceID)object, serviceMatches.items);
                        if (serviceItem != null) continue;
                        ServiceItemReg serviceItemReg = (ServiceItemReg)entry.getValue();
                        UnmapProxyTask unmapProxyTask = new UnmapProxyTask(this.reg, serviceItemReg, (ServiceID)object, LookupCacheImpl.this.taskSeqN++);
                        LookupCacheImpl.this.cacheTaskMgr.add(unmapProxyTask);
                    }
                    for (int i = 0; i < serviceMatches.items.length; ++i) {
                        if (serviceMatches.items[i].service == null) continue;
                        object = new NewOldServiceTask(this.reg, serviceMatches.items[i], false, LookupCacheImpl.this.taskSeqN++);
                        LookupCacheImpl.this.cacheTaskMgr.add((TaskManager.Task)object);
                    }
                }
                logger.finest("ServiceDiscoveryManager - LookupTask completed");
            }
        }

        private final class RegisterListenerTask
        extends CacheTask {
            public RegisterListenerTask(ProxyReg proxyReg) {
                super(proxyReg);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                logger.finest("ServiceDiscoveryManager - RegisterListenerTask started");
                long l = LookupCacheImpl.this.getLeaseDuration();
                if (l < 0L) {
                    return;
                }
                try {
                    EventReg eventReg = ServiceDiscoveryManager.this.registerListener(this.reg.proxy, LookupCacheImpl.this.tmpl, LookupCacheImpl.this.lookupListenerProxy, l);
                    HashMap hashMap = LookupCacheImpl.this.serviceIdMap;
                    synchronized (hashMap) {
                        if (LookupCacheImpl.this.bCacheTerminated) {
                            ServiceDiscoveryManager.this.cancelLease(eventReg.lease);
                        } else {
                            LookupCacheImpl.this.eventRegMap.put(this.reg, eventReg);
                        }
                    }
                    new LookupTask(this.reg).run();
                }
                catch (Exception exception) {
                    boolean bl;
                    HashMap hashMap = LookupCacheImpl.this.serviceIdMap;
                    synchronized (hashMap) {
                        bl = LookupCacheImpl.this.bCacheTerminated;
                    }
                    ServiceDiscoveryManager.this.fail(exception, this.reg.proxy, this.getClass().getName(), "run", "Exception occurred while attempting to register with the lookup service event mechanism", bl);
                }
                logger.finest("ServiceDiscoveryManager - RegisterListenerTask completed");
            }
        }

        private final class LookupListener
        implements RemoteEventListener,
        ServerProxyTrust {
            public LookupListener() throws ExportException {
                LookupCacheImpl.this.lookupListenerProxy = (RemoteEventListener)LookupCacheImpl.this.lookupListenerExporter.export(this);
            }

            public void notify(RemoteEvent remoteEvent) {
                ServiceEvent serviceEvent = (ServiceEvent)remoteEvent;
                LookupCacheImpl.this.notifyServiceMap((ServiceRegistrar)serviceEvent.getSource(), serviceEvent.getServiceID(), serviceEvent.getServiceItem(), serviceEvent.getTransition(), serviceEvent.getSequenceNumber());
            }

            public TrustVerifier getProxyVerifier() {
                return new BasicProxyTrustVerifier(LookupCacheImpl.this.lookupListenerProxy);
            }
        }
    }

    private final class LeaseListenerImpl
    implements LeaseListener {
        private ServiceRegistrar proxy;

        public LeaseListenerImpl(ServiceRegistrar serviceRegistrar) {
            this.proxy = serviceRegistrar;
        }

        public void notify(LeaseRenewalEvent leaseRenewalEvent) {
            ServiceDiscoveryManager.this.fail(leaseRenewalEvent.getException(), this.proxy, this.getClass().getName(), "notify", "failure occurred while renewing an event lease", false);
        }
    }

    private static final class ProxyReg {
        public ServiceRegistrar proxy;

        public ProxyReg(ServiceRegistrar serviceRegistrar) {
            if (serviceRegistrar == null) {
                throw new IllegalArgumentException("proxy cannot be null");
            }
            this.proxy = serviceRegistrar;
        }

        public boolean equals(Object object) {
            if (object instanceof ProxyReg) {
                return this.proxy.equals(((ProxyReg)object).proxy);
            }
            return false;
        }

        public int hashCode() {
            return this.proxy.hashCode();
        }
    }

    private static final class ServiceItemReg {
        private final ArrayList proxys = new ArrayList(1);
        private boolean bDiscarded = false;
        public ServiceItem item;
        public ServiceItem filteredItem;

        public ServiceItemReg(ServiceRegistrar serviceRegistrar, ServiceItem serviceItem) {
            this.addProxy(serviceRegistrar);
            this.item = serviceItem;
        }

        public void addProxy(ServiceRegistrar serviceRegistrar) {
            if (!this.proxys.contains(serviceRegistrar)) {
                this.proxys.add(serviceRegistrar);
            }
        }

        public void removeProxy(ServiceRegistrar serviceRegistrar) {
            int n = this.proxys.indexOf(serviceRegistrar);
            if (n != -1) {
                this.proxys.remove(n);
            }
        }

        public boolean hasNoProxys() {
            return this.proxys.isEmpty();
        }

        public void setDiscarded(boolean bl) {
            this.bDiscarded = bl;
        }

        public boolean isDiscarded() {
            return this.bDiscarded;
        }
    }

    private static final class EventReg {
        public Lease lease;
        public long seqNo;

        public EventReg(Lease lease, long l) {
            this.lease = lease;
            this.seqNo = l;
        }
    }

    private static final class ServiceDiscoveryListenerImpl
    implements ServiceDiscoveryListener {
        ArrayList items = new ArrayList(1);

        private ServiceDiscoveryListenerImpl() {
        }

        public synchronized void serviceAdded(ServiceDiscoveryEvent serviceDiscoveryEvent) {
            this.items.add(serviceDiscoveryEvent.getPostEventServiceItem());
            this.notifyAll();
        }

        public void serviceRemoved(ServiceDiscoveryEvent serviceDiscoveryEvent) {
        }

        public void serviceChanged(ServiceDiscoveryEvent serviceDiscoveryEvent) {
        }

        public synchronized ServiceItem[] getServiceItem() {
            ServiceItem[] serviceItemArray = new ServiceItem[this.items.size()];
            this.items.toArray(serviceItemArray);
            this.items.clear();
            return serviceItemArray;
        }
    }

    private static abstract class ServiceIdTask
    extends CacheTask {
        protected ServiceID thisTaskSid;
        protected int thisTaskSeqN;

        ServiceIdTask(ServiceID serviceID, ProxyReg proxyReg, int n) {
            super(proxyReg);
            this.thisTaskSid = serviceID;
            this.thisTaskSeqN = n;
        }

        public boolean runAfter(List list, int n) {
            for (int i = 0; i < n; ++i) {
                ServiceID serviceID;
                TaskManager.Task task = (TaskManager.Task)list.get(i);
                if (!(task instanceof ServiceIdTask) || !this.thisTaskSid.equals(serviceID = ((ServiceIdTask)task).getServiceID()) || this.thisTaskSeqN <= ((ServiceIdTask)task).getSeqN()) continue;
                return true;
            }
            return false;
        }

        public ServiceID getServiceID() {
            return this.thisTaskSid;
        }

        public int getSeqN() {
            return this.thisTaskSeqN;
        }
    }

    private static abstract class CacheTask
    implements TaskManager.Task {
        protected ProxyReg reg;

        public CacheTask(ProxyReg proxyReg) {
            this.reg = proxyReg;
        }

        public boolean isFromProxy(ProxyReg proxyReg) {
            if (this.reg == null) {
                return false;
            }
            return this.reg.equals(proxyReg);
        }

        public boolean runAfter(List list, int n) {
            return false;
        }

        public abstract void run();
    }
}

