/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.kerberos;

import com.sun.jini.action.GetIntegerAction;
import com.sun.jini.jeri.internal.connection.BasicServerConnManager;
import com.sun.jini.jeri.internal.connection.ServerConnManager;
import com.sun.jini.jeri.internal.runtime.Util;
import com.sun.jini.logging.Levels;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import com.sun.security.jgss.GSSUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import net.jini.core.constraint.Integrity;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.Endpoint;
import net.jini.jeri.RequestDispatcher;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.connection.InboundRequestHandle;
import net.jini.jeri.connection.ServerConnection;
import net.jini.jeri.kerberos.KerberosEndpoint;
import net.jini.jeri.kerberos.KerberosUtil;
import net.jini.security.Security;
import net.jini.security.SecurityContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;

public final class KerberosServerEndpoint
implements ServerEndpoint {
    private static final Logger logger = Logger.getLogger("net.jini.jeri.kerberos.server");
    private static final Executor systemThreadPool = (Executor)Security.doPrivileged(new GetThreadPoolAction(false));
    private Subject serverSubject;
    private static final GSSManager gssManager = GSSManager.getInstance();
    private static final int maxCacheSize = (Integer)Security.doPrivileged(new GetIntegerAction("com.sun.jini.jeri.kerberos.KerberosServerEndpoint.maxCacheSize", 256));
    private final KerberosUtil.SoftCache softCache;
    private KerberosPrincipal serverPrincipal;
    private String serverHost;
    private final int port;
    private final SocketFactory csf;
    private final ServerSocketFactory ssf;
    private final ServerEndpoint.ListenEndpoint listenEndpoint;
    ServerConnManager serverConnManager = new BasicServerConnManager();
    private static final InvocationConstraints INTEGRITY_REQUIRED_CONSTRAINTS = new InvocationConstraints(Integrity.YES, null);
    private static final InvocationConstraints INTEGRITY_PREFERRED_CONSTRAINTS = new InvocationConstraints(null, Integrity.YES);

    private KerberosServerEndpoint(Subject subject, KerberosPrincipal kerberosPrincipal, String string, int n, SocketFactory socketFactory, ServerSocketFactory serverSocketFactory) throws UnsupportedConstraintException {
        Object object;
        boolean bl;
        boolean bl2 = subject == null;
        boolean bl3 = bl = kerberosPrincipal == null;
        if (bl2) {
            object = AccessController.getContext();
            subject = (Subject)AccessController.doPrivileged(new PrivilegedAction((AccessControlContext)object){
                private final /* synthetic */ AccessControlContext val$acc;
                {
                    this.val$acc = accessControlContext;
                }

                public Object run() {
                    return Subject.getSubject(this.val$acc);
                }
            });
        }
        object = null;
        if (bl) {
            if (subject == null) {
                object = new UnsupportedConstraintException("Forgot JAAS login?  Using default serverSubject but no subject is associated with the current access control context.");
            } else {
                try {
                    kerberosPrincipal = KerberosServerEndpoint.findServerPrincipal(subject);
                }
                catch (Exception exception) {
                    object = exception;
                }
            }
        } else if (bl2) {
            try {
                KerberosUtil.checkAuthPermission(kerberosPrincipal, null, "listen");
                if (subject == null) {
                    object = new UnsupportedConstraintException("Forgot JAAS login?  Using default serverSubject but no subject is associated with the current access control context.");
                }
            }
            catch (SecurityException securityException) {
                subject = null;
            }
        }
        if (object != null) {
            if (logger.isLoggable(Levels.FAILED)) {
                KerberosUtil.logThrow(logger, Levels.FAILED, this.getClass(), "constructor", "construction failed", null, (Throwable)object);
            }
            KerberosUtil.secureThrow((Exception)object, new UnsupportedConstraintException("Either the caller has not been granted the right AuthenticationPermission, or there is no default server subject (<code>Subject.getSubject(AccessController.getContext())</code> returns <code>null</code>), or no appropriate Kerberos principal and its corresponding key can be found in the current subject."));
        }
        this.serverSubject = subject;
        this.serverPrincipal = kerberosPrincipal;
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("port number out of range 0-65535: port = " + n);
        }
        this.serverHost = string;
        this.port = n;
        this.csf = socketFactory;
        this.ssf = serverSocketFactory;
        this.softCache = new KerberosUtil.SoftCache(maxCacheSize);
        this.listenEndpoint = new ListenEndpointImpl();
        logger.log(Level.FINE, "created {0}", this);
    }

    public static KerberosServerEndpoint getInstance(int n) throws UnsupportedConstraintException {
        return new KerberosServerEndpoint(null, null, null, n, null, null);
    }

    public static KerberosServerEndpoint getInstance(String string, int n) throws UnsupportedConstraintException {
        return new KerberosServerEndpoint(null, null, string, n, null, null);
    }

    public static KerberosServerEndpoint getInstance(String string, int n, SocketFactory socketFactory, ServerSocketFactory serverSocketFactory) throws UnsupportedConstraintException {
        return new KerberosServerEndpoint(null, null, string, n, socketFactory, serverSocketFactory);
    }

    public static KerberosServerEndpoint getInstance(Subject subject, KerberosPrincipal kerberosPrincipal, String string, int n) throws UnsupportedConstraintException {
        return new KerberosServerEndpoint(subject, kerberosPrincipal, string, n, null, null);
    }

    public static KerberosServerEndpoint getInstance(Subject subject, KerberosPrincipal kerberosPrincipal, String string, int n, SocketFactory socketFactory, ServerSocketFactory serverSocketFactory) throws UnsupportedConstraintException {
        return new KerberosServerEndpoint(subject, kerberosPrincipal, string, n, socketFactory, serverSocketFactory);
    }

    public String getHost() {
        return this.serverHost;
    }

    public int getPort() {
        return this.port;
    }

    public KerberosPrincipal getPrincipal() {
        return this.serverPrincipal;
    }

    public SocketFactory getSocketFactory() {
        return this.csf;
    }

    public ServerSocketFactory getServerSocketFactory() {
        return this.ssf;
    }

    public InvocationConstraints checkConstraints(InvocationConstraints invocationConstraints) throws UnsupportedConstraintException {
        InvocationConstraints invocationConstraints2;
        if (invocationConstraints == null) {
            throw new NullPointerException();
        }
        try {
            Object object;
            Object object2 = invocationConstraints.requirements().iterator();
            while (object2.hasNext()) {
                object = (InvocationConstraint)object2.next();
                if (KerberosUtil.isSupportableConstraint((InvocationConstraint)object)) continue;
                throw new UnsupportedConstraintException("A constraint unsupportable by this endpoint has been required: " + object);
            }
            if (KerberosServerEndpoint.getKey(this.serverSubject, this.serverPrincipal) == null) {
                throw new UnsupportedConstraintException("Failed to find a valid Kerberos key corresponding to serverPrincipal (" + this.serverPrincipal + ") in serverSubject.");
            }
            object2 = new HashSet();
            object = invocationConstraints.requirements().iterator();
            while (object.hasNext()) {
                if (KerberosUtil.collectCpCandidates((InvocationConstraint)object.next(), (Set)object2)) continue;
                throw new UnsupportedConstraintException("Client principal constraint related conflicts found in the given set of constraints: " + invocationConstraints);
            }
            if (((HashSet)object2).size() == 0) {
                ((HashSet)object2).add(new KerberosPrincipal("anyone"));
            }
            boolean bl = false;
            KerberosUtil.ConfigIter configIter = new KerberosUtil.ConfigIter((Set)object2, this.serverPrincipal, true);
            block5: while (configIter.hasNext()) {
                KerberosUtil.Config config = configIter.next();
                Iterator iterator = invocationConstraints.requirements().iterator();
                while (iterator.hasNext()) {
                    InvocationConstraint invocationConstraint = (InvocationConstraint)iterator.next();
                    if (KerberosUtil.isSatisfiable(config, invocationConstraint)) continue;
                    continue block5;
                }
                bl = true;
                break;
            }
            if (!bl) {
                throw new UnsupportedConstraintException("Conflicts found in the given set of constraints: " + invocationConstraints);
            }
            invocationConstraints2 = InvocationConstraints.EMPTY;
            if (KerberosUtil.containsConstraint(invocationConstraints.requirements(), Integrity.YES)) {
                invocationConstraints2 = KerberosUtil.INTEGRITY_REQUIRED_CONSTRAINTS;
            } else if (KerberosUtil.containsConstraint(invocationConstraints.preferences(), Integrity.YES)) {
                invocationConstraints2 = KerberosUtil.INTEGRITY_PREFERRED_CONSTRAINTS;
            }
        }
        catch (UnsupportedConstraintException unsupportedConstraintException) {
            if (logger.isLoggable(Levels.FAILED)) {
                KerberosUtil.logThrow(logger, Levels.FAILED, this.getClass(), "checkConstraints", "check constraints for {0}\nwith {1}\nthrows", new Object[]{this, invocationConstraints}, unsupportedConstraintException);
            }
            throw unsupportedConstraintException;
        }
        catch (SecurityException securityException) {
            if (logger.isLoggable(Levels.FAILED)) {
                KerberosUtil.logThrow(logger, Levels.FAILED, this.getClass(), "checkConstraints", "check constraints for {0}\nwith {1}\nthrows", new Object[]{this, invocationConstraints}, securityException);
            }
            throw securityException;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "checkConstraints() has determined that this endpoint can support the given constraints:\n{0}.\nWhile assistances are needed from upper layers to satisfy constraints:\n{1}", new Object[]{invocationConstraints, invocationConstraints2});
        }
        return invocationConstraints2;
    }

    public Endpoint enumerateListenEndpoints(ServerEndpoint.ListenContext listenContext) throws IOException {
        Object object;
        if (this.serverHost == null) {
            try {
                object = (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws UnknownHostException {
                        return InetAddress.getLocalHost();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                UnknownHostException unknownHostException = (UnknownHostException)privilegedActionException.getCause();
                if (logger.isLoggable(Levels.FAILED)) {
                    KerberosUtil.logThrow(logger, Levels.FAILED, this.getClass(), "enumerateListenEndpoints", "InetAddress.getLocalHost() throws", null, unknownHostException);
                }
                throw unknownHostException;
            }
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    securityManager.checkConnect(((InetAddress)object).getHostName(), -1);
                }
                catch (SecurityException securityException) {
                    SecurityException securityException2 = new SecurityException("Access to resolve local host denied");
                    if (logger.isLoggable(Levels.FAILED)) {
                        KerberosUtil.logThrow(logger, Levels.FAILED, this.getClass(), "enumerateListenEndpoints", "caller does not have permission to resolve local host", null, securityException2);
                    }
                    throw securityException2;
                }
            }
            this.serverHost = ((InetAddress)object).getHostAddress();
        }
        object = this.checkListenCookie(listenContext.addListenEndpoint(this.listenEndpoint));
        return KerberosEndpoint.getInstance(this.serverHost, ((ListenCookieImpl)object).getLocalPort(), this.serverPrincipal, this.csf);
    }

    public int hashCode() {
        return this.getClass().getName().hashCode() ^ System.identityHashCode(this.serverSubject) ^ this.serverPrincipal.hashCode() ^ (this.serverHost != null ? this.serverHost.hashCode() : 0) ^ this.port ^ (this.ssf != null ? this.ssf.hashCode() : 0) ^ (this.csf != null ? this.csf.hashCode() : 0);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof KerberosServerEndpoint)) {
            return false;
        }
        KerberosServerEndpoint kerberosServerEndpoint = (KerberosServerEndpoint)object;
        return this.serverSubject == kerberosServerEndpoint.serverSubject && this.serverPrincipal.equals(kerberosServerEndpoint.serverPrincipal) && Util.equals(this.serverHost, kerberosServerEndpoint.serverHost) && this.port == kerberosServerEndpoint.port && Util.sameClassAndEquals(this.csf, kerberosServerEndpoint.csf) && Util.sameClassAndEquals(this.ssf, kerberosServerEndpoint.ssf);
    }

    public String toString() {
        return "KerberosServerEndpoint[serverPrincipal=" + this.serverPrincipal + " serverHost= " + this.serverHost + " serverPort= " + this.port + (this.ssf == null ? "" : " ssf = " + this.ssf.toString()) + (this.csf == null ? "" : " csf = " + this.csf.toString()) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KerberosPrincipal findServerPrincipal(Subject subject) throws UnsupportedConstraintException {
        Principal principal;
        Iterator<Principal> iterator;
        Set<Principal> set = subject.getPrincipals();
        HashSet<Principal> hashSet = new HashSet<Principal>(set.size());
        Set<Principal> set2 = set;
        synchronized (set2) {
            iterator = set.iterator();
            while (iterator.hasNext()) {
                principal = iterator.next();
                if (!(principal instanceof KerberosPrincipal)) continue;
                hashSet.add(principal);
            }
        }
        if (hashSet.isEmpty()) {
            throw new UnsupportedConstraintException("No KerberosPrincipal found in the serverSubject.");
        }
        boolean bl = false;
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            principal = (KerberosPrincipal)iterator.next();
            try {
                if (KerberosServerEndpoint.getKey(subject, (KerberosPrincipal)principal) != null) {
                    return principal;
                }
                bl = true;
            }
            catch (SecurityException securityException) {}
        }
        if (bl) {
            throw new UnsupportedConstraintException("Cannot find any Kerberos key in the serverSubject corresponding to one of its principals.");
        }
        throw new SecurityException("Caller does not have AuthenticationPermission to access Kerberos keys of any principal in the serverSubject.");
    }

    private static KerberosKey getKey(final Subject subject, final KerberosPrincipal kerberosPrincipal) {
        KerberosUtil.checkAuthPermission(kerberosPrincipal, null, "listen");
        if (subject == null) {
            return null;
        }
        return (KerberosKey)AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                Set<Object> set;
                Set<Object> set2 = set = subject.getPrivateCredentials();
                synchronized (set2) {
                    Iterator<Object> iterator = set.iterator();
                    while (iterator.hasNext()) {
                        KerberosKey kerberosKey;
                        Object object = iterator.next();
                        if (!(object instanceof KerberosKey) || (kerberosKey = (KerberosKey)object).isDestroyed() || !kerberosKey.getPrincipal().equals(kerberosPrincipal)) continue;
                        return kerberosKey;
                    }
                }
                return null;
            }
        });
    }

    private ListenCookieImpl checkListenCookie(Object object) {
        if (!(object instanceof ListenCookieImpl)) {
            throw new IllegalArgumentException("Cookie with unexpected type: " + object);
        }
        ListenCookieImpl listenCookieImpl = (ListenCookieImpl)object;
        if (!this.equals(listenCookieImpl.getServerEndpoint())) {
            throw new IllegalArgumentException("Server endpoint mis-match, enclosing sep is:\n" + this + "\nwhile cookie's enclosing sep is:\n" + listenCookieImpl.getServerEndpoint());
        }
        return listenCookieImpl;
    }

    private final class ServerConnectionImpl
    extends KerberosUtil.Connection
    implements ServerConnection {
        private final ListenHandleImpl listenHandle;
        private GSSCredential clientCred;
        private Subject clientSubject;
        private InputStream istream;
        private OutputStream ostream;
        private InboundRequestHandleImpl handleWithEncryption;
        private InboundRequestHandleImpl handleWithoutEncryption;
        private final Object lock;
        private boolean closed;

        ServerConnectionImpl(Socket socket, ListenHandleImpl listenHandleImpl) throws IOException {
            block5: {
                block4: {
                    super(socket);
                    this.lock = new Object();
                    this.listenHandle = listenHandleImpl;
                    this.connectionLogger = logger;
                    try {
                        socket.setTcpNoDelay(true);
                    }
                    catch (SocketException socketException) {
                        if (!logger.isLoggable(Levels.HANDLED)) break block4;
                        KerberosUtil.logThrow(logger, Levels.HANDLED, this.getClass(), "constructor", "failed to setTcpNoDelay option for {0}", new Object[]{socket}, socketException);
                    }
                }
                try {
                    socket.setKeepAlive(true);
                }
                catch (SocketException socketException) {
                    if (!logger.isLoggable(Levels.HANDLED)) break block5;
                    KerberosUtil.logThrow(logger, Levels.HANDLED, this.getClass(), "constructor", "failed to setKeepAlive option for {0}", new Object[]{socket}, socketException);
                }
            }
            this.istream = new KerberosUtil.ConnectionInputStream(this);
            this.ostream = new KerberosUtil.ConnectionOutputStream(this);
        }

        public InputStream getInputStream() throws IOException {
            return this.istream;
        }

        public OutputStream getOutputStream() throws IOException {
            return this.ostream;
        }

        public SocketChannel getChannel() {
            return null;
        }

        public InboundRequestHandle processRequestData(InputStream inputStream, OutputStream outputStream) throws IOException {
            try {
                if (this.clientCred != null) {
                    try {
                        if (this.clientCred.getRemainingLifetime() <= 0) {
                            this.close();
                            throw new SecurityException("Delegated client credential expired.");
                        }
                    }
                    catch (GSSException gSSException) {
                        this.close();
                        SecurityException securityException = new SecurityException("Failed to getRemainingLifetime from the delegated client credential.");
                        securityException.initCause(gSSException);
                        throw securityException;
                    }
                }
                if (!KerberosServerEndpoint.this.serverSubject.getPrincipals().contains(KerberosServerEndpoint.this.serverPrincipal)) {
                    throw new SecurityException("serverSubject no longer contains serverPrincipal: " + KerberosServerEndpoint.this.serverPrincipal + ", failing the connection...");
                }
                if (!this.listenHandle.checkKey()) {
                    throw new SecurityException("serverSubject no longer contains the server key or the server key has been destroyed, failing the connection...");
                }
                return this.doEncryption ? this.handleWithEncryption : this.handleWithoutEncryption;
            }
            catch (SecurityException securityException) {
                if (logger.isLoggable(Levels.FAILED)) {
                    KerberosUtil.logThrow(logger, Levels.FAILED, this.getClass(), "processRequestData", "connection {0} throws", new Object[]{this}, securityException);
                }
                this.close();
                throw securityException;
            }
        }

        public void checkPermissions(InboundRequestHandle inboundRequestHandle) {
            this.checkRequestHandle(inboundRequestHandle);
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkAccept(this.peerHost, this.peerPort);
                KerberosUtil.checkAuthPermission(KerberosServerEndpoint.this.serverPrincipal, this.clientPrincipal, "accept");
            }
        }

        public InvocationConstraints checkConstraints(InboundRequestHandle inboundRequestHandle, InvocationConstraints invocationConstraints) throws UnsupportedConstraintException {
            InboundRequestHandleImpl inboundRequestHandleImpl = this.checkRequestHandle(inboundRequestHandle);
            if (invocationConstraints == null) {
                throw new NullPointerException("constraints can not be null");
            }
            CacheKey cacheKey = new CacheKey(inboundRequestHandleImpl, invocationConstraints);
            Object object = KerberosServerEndpoint.this.softCache.get(cacheKey);
            if (object != null) {
                if (object instanceof UnsupportedConstraintException) {
                    throw (UnsupportedConstraintException)object;
                }
                return (InvocationConstraints)object;
            }
            Object object2 = invocationConstraints.requirements().iterator();
            while (object2.hasNext()) {
                try {
                    InvocationConstraint invocationConstraint = (InvocationConstraint)object2.next();
                    if (!KerberosUtil.isSupportableConstraint(invocationConstraint)) {
                        UnsupportedConstraintException unsupportedConstraintException = new UnsupportedConstraintException("A constraint unsupportable by this endpoint has been required: " + invocationConstraint);
                        KerberosServerEndpoint.this.softCache.put(cacheKey, unsupportedConstraintException);
                        throw unsupportedConstraintException;
                    }
                    if (KerberosUtil.isSatisfiable(inboundRequestHandleImpl.config, invocationConstraint)) continue;
                    UnsupportedConstraintException unsupportedConstraintException = new UnsupportedConstraintException("A required constraint (" + invocationConstraint + ") is not " + "satisfied by this connection: " + this);
                    KerberosServerEndpoint.this.softCache.put(cacheKey, unsupportedConstraintException);
                    throw unsupportedConstraintException;
                }
                catch (UnsupportedConstraintException unsupportedConstraintException) {
                    if (logger.isLoggable(Levels.FAILED)) {
                        KerberosUtil.logThrow(logger, Levels.FAILED, this.getClass(), "checkConstraints", "connection {0}\ndoes not satisfies {1},\nthrows", new Object[]{this, invocationConstraints}, unsupportedConstraintException);
                    }
                    throw unsupportedConstraintException;
                }
            }
            object2 = InvocationConstraints.EMPTY;
            if (KerberosUtil.containsConstraint(invocationConstraints.requirements(), Integrity.YES)) {
                object2 = KerberosUtil.INTEGRITY_REQUIRED_CONSTRAINTS;
            } else if (KerberosUtil.containsConstraint(invocationConstraints.preferences(), Integrity.YES)) {
                object2 = KerberosUtil.INTEGRITY_PREFERRED_CONSTRAINTS;
            }
            KerberosServerEndpoint.this.softCache.put(cacheKey, object2);
            return object2;
        }

        public void populateContext(InboundRequestHandle inboundRequestHandle, Collection collection) {
            this.checkRequestHandle(inboundRequestHandle);
            Util.populateContext(collection, this.sock.getInetAddress());
            Util.populateContext(collection, this.clientSubject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.lock;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            this.listenHandle.remove(this);
            super.close();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("KerberosServerEndpoint.ServerConnectionImpl[");
            stringBuffer.append("clientPrincipal=" + this.clientPrincipal);
            stringBuffer.append(" serverPrincipal=" + KerberosServerEndpoint.this.serverPrincipal);
            stringBuffer.append(" doEncryption=" + this.doEncryption);
            stringBuffer.append(" doDelegation=" + this.doDelegation);
            stringBuffer.append(" client=" + this.sock.getInetAddress().getHostName());
            stringBuffer.append(":" + this.sock.getPort());
            stringBuffer.append(" server=" + this.sock.getLocalAddress().getHostName());
            stringBuffer.append(":" + this.sock.getLocalPort());
            stringBuffer.append(']');
            return stringBuffer.toString();
        }

        void establishContext() throws IOException, GSSException {
            this.gssContext = gssManager.createContext(this.listenHandle.serverCred);
            byte[] byArray = null;
            while (!this.gssContext.isEstablished()) {
                byArray = new byte[this.dis.readInt()];
                this.dis.readFully(byArray);
                if ((byArray = this.gssContext.acceptSecContext(byArray, 0, byArray.length)) == null) continue;
                this.dos.writeInt(byArray.length);
                this.dos.write(byArray);
                this.dos.flush();
            }
            if (!this.gssContext.getIntegState()) {
                throw new IOException("Established GSSContext does not support integrity.");
            }
            this.doEncryption = this.gssContext.getConfState();
            this.doDelegation = this.gssContext.getCredDelegState();
            GSSName gSSName = this.gssContext.getSrcName();
            this.clientPrincipal = new KerberosPrincipal(gSSName.toString());
            if (this.gssContext.getCredDelegState()) {
                this.clientCred = this.gssContext.getDelegCred();
            }
            this.clientSubject = GSSUtil.createSubject(gSSName, this.clientCred);
            this.clientSubject.setReadOnly();
            this.handleWithEncryption = new InboundRequestHandleImpl(true);
            this.handleWithoutEncryption = new InboundRequestHandleImpl(false);
        }

        private InboundRequestHandleImpl checkRequestHandle(Object object) {
            if (object != this.handleWithEncryption && object != this.handleWithoutEncryption) {
                throw new IllegalArgumentException("Unknown InboundRequestHandle: " + object);
            }
            return (InboundRequestHandleImpl)object;
        }

        private final class CacheKey {
            private final InboundRequestHandleImpl handle;
            private final InvocationConstraints constraints;

            CacheKey(InboundRequestHandleImpl inboundRequestHandleImpl, InvocationConstraints invocationConstraints) {
                this.handle = inboundRequestHandleImpl;
                this.constraints = invocationConstraints;
            }

            public int hashCode() {
                return this.handle.hashCode() ^ System.identityHashCode(this.constraints);
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (!(object instanceof CacheKey)) {
                    return false;
                }
                CacheKey cacheKey = (CacheKey)object;
                return this.handle == cacheKey.handle && this.constraints == cacheKey.constraints;
            }
        }

        private final class InboundRequestHandleImpl
        implements InboundRequestHandle {
            final KerberosUtil.Config config;

            InboundRequestHandleImpl(boolean bl) {
                this.config = new KerberosUtil.Config(ServerConnectionImpl.this.clientPrincipal, KerberosServerEndpoint.this.serverPrincipal, bl, ServerConnectionImpl.this.doDelegation);
            }
        }
    }

    private final class ConnectionHandler
    implements Runnable {
        private final ServerConnectionImpl connection;
        private final RequestDispatcher dispatcher;
        private final SecurityContext securityContext;

        ConnectionHandler(ServerConnectionImpl serverConnectionImpl, RequestDispatcher requestDispatcher, SecurityContext securityContext) {
            this.connection = serverConnectionImpl;
            this.dispatcher = requestDispatcher;
            this.securityContext = securityContext;
        }

        public void run() {
            Throwable throwable = null;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        try {
                            Subject.doAs(KerberosServerEndpoint.this.serverSubject, new PrivilegedExceptionAction(){

                                public Object run() throws IOException, GSSException {
                                    ConnectionHandler.this.connection.establishContext();
                                    return null;
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw privilegedActionException.getException();
                        }
                        logger.log(Level.FINE, "established GSSContext for {0}", ConnectionHandler.this.connection);
                        return null;
                    }
                });
                AccessController.doPrivileged(this.securityContext.wrap(new PrivilegedAction(){

                    public Object run() {
                        ((ConnectionHandler)ConnectionHandler.this).KerberosServerEndpoint.this.serverConnManager.handleConnection(ConnectionHandler.this.connection, ConnectionHandler.this.dispatcher);
                        return null;
                    }
                }), this.securityContext.getAccessControlContext());
            }
            catch (PrivilegedActionException privilegedActionException) {
                throwable = privilegedActionException.getException();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
            if (throwable != null) {
                if (logger.isLoggable(Levels.HANDLED)) {
                    KerberosUtil.logThrow(logger, Levels.HANDLED, this.getClass(), "run", "connection handling thread {0} throws", new Object[]{this}, throwable);
                }
                this.connection.close();
            }
        }

        public String toString() {
            return "KerberosServerEndpoint.ConnectionHandler[serverPrincipal=" + KerberosServerEndpoint.this.serverPrincipal + " localPort=" + this.connection.sock.getLocalPort() + " remotePort=" + this.connection.sock.getPort() + "]";
        }
    }

    private final class ListenHandleImpl
    implements ServerEndpoint.ListenHandle {
        private final RequestDispatcher dispatcher;
        private final SecurityContext securityContext;
        private KerberosKey serverKey;
        final GSSCredential serverCred;
        ListenCookieImpl listenCookie;
        private final ServerSocket serverSocket;
        private final Set connections = new HashSet();
        private final Object lock = new Object();
        private boolean closed = false;
        private long acceptFailureTime = 0L;
        private int acceptFailureCount;

        ListenHandleImpl(RequestDispatcher requestDispatcher, KerberosKey kerberosKey, GSSCredential gSSCredential, ServerSocket serverSocket, SecurityContext securityContext) {
            this.dispatcher = requestDispatcher;
            this.serverKey = kerberosKey;
            this.serverCred = gSSCredential;
            this.serverSocket = serverSocket;
            this.securityContext = securityContext;
            this.listenCookie = new ListenCookieImpl(serverSocket.getLocalPort());
        }

        void startAccepting() {
            systemThreadPool.execute(new Runnable(){

                public void run() {
                    ListenHandleImpl.this.executeAcceptLoop();
                }
            }, this.toString() + " accept loop");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void executeAcceptLoop() {
            while (true) {
                block33: {
                    block32: {
                        var1_1 = null;
                        var2_2 = null;
                        var3_3 = false;
                        try {
                            try {
                                var1_1 = this.serverSocket.accept();
                                var4_4 = this.lock;
                                synchronized (var4_4) {
                                    if (this.closed) {
                                        // MONITOREXIT @DISABLED, blocks:[0, 1, 19, 8, 31] lbl11 : MonitorExitStatement: MONITOREXIT : var4_4
                                        var8_8 = null;
                                        if (var3_3 != false) return;
                                        if (var2_2 != null) {
                                            var2_2.close();
                                            return;
                                        }
                                        if (var1_1 == null) return;
                                        break block32;
                                    }
                                    var2_2 = new ServerConnectionImpl(var1_1, this);
                                    this.connections.add(var2_2);
                                }
                                KerberosServerEndpoint.access$300().log(Level.FINE, "{0} accepted", var2_2);
                                var4_4 = new ConnectionHandler(var2_2, this.dispatcher, this.securityContext);
                                KerberosServerEndpoint.access$1100().execute((Runnable)var4_4, var4_4.toString());
                                var3_3 = true;
                                break block33;
                            }
                            catch (Throwable var4_5) {
                                if (KerberosServerEndpoint.access$300().isLoggable(Levels.HANDLED)) {
                                    KerberosUtil.logThrow(KerberosServerEndpoint.access$300(), Levels.HANDLED, this.getClass(), "executeAcceptLoop", "accept loop for {0} throws", new Object[]{this}, var4_5);
                                }
                                var5_6 = this.lock;
                                synchronized (var5_6) {
                                    if (this.closed) {
                                        // MONITOREXIT @DISABLED, blocks:[0, 19, 9, 25, 12] lbl35 : MonitorExitStatement: MONITOREXIT : var5_6
                                        var8_8 = null;
                                        if (var3_3 != false) return;
                                        if (var2_2 != null) {
                                            var2_2.close();
                                            return;
                                        }
                                        if (var1_1 == null) return;
                                        try {
                                            var1_1.close();
                                            return;
                                        }
                                        catch (IOException var9_9) {
                                            return;
                                        }
                                    }
                                    ** if (!(var4_5 instanceof Exception) && !(var4_5 instanceof OutOfMemoryError) && !(var4_5 instanceof NoClassDefFoundError)) goto lbl-1000
                                }
lbl-1000:
                                // 1 sources

                                {
                                    if (!this.continueAfterAcceptFailure(var4_5)) {
                                        var8_8 = null;
                                        if (var3_3 != false) return;
                                        if (var2_2 != null) {
                                            var2_2.close();
                                            return;
                                        }
                                        if (var1_1 == null) return;
                                        ** try [egrp 7[TRYBLOCK] [15 : 303->310)] { 
lbl57:
                                        // 1 sources

                                        var1_1.close();
                                        return;
lbl59:
                                        // 1 sources

                                        catch (IOException var9_9) {
                                            // empty catch block
                                        }
                                        return;
                                    }
                                    ** GOTO lbl69
                                }
lbl-1000:
                                // 1 sources

                                {
                                    try {
                                        this.serverSocket.close();
                                        throw (Error)var4_5;
                                    }
                                    catch (IOException var5_7) {
                                        // empty catch block
                                    }
                                    throw (Error)var4_5;
                                }
lbl69:
                                // 1 sources

                                var8_8 = null;
                                if (var3_3) continue;
                                if (var2_2 != null) {
                                    var2_2.close();
                                    continue;
                                }
                                if (var1_1 == null) continue;
                                try {}
                                catch (IOException var9_9) {}
                                var1_1.close();
                                continue;
                            }
                        }
                        catch (Throwable var7_10) {
                            var8_8 = null;
                            if (var3_3 != false) throw var7_10;
                            if (var2_2 != null) {
                                var2_2.close();
                                throw var7_10;
                            }
                            if (var1_1 == null) throw var7_10;
                            ** try [egrp 7[TRYBLOCK] [15 : 303->310)] { 
lbl89:
                            // 1 sources

                            var1_1.close();
                            throw var7_10;
lbl91:
                            // 1 sources

                            catch (IOException var9_9) {
                                // empty catch block
                            }
                            throw var7_10;
                        }
                    }
                    try {}
                    catch (IOException var9_9) {
                        return;
                    }
                    var1_1.close();
                    return;
                }
                var8_8 = null;
                if (var3_3) continue;
                if (var2_2 != null) {
                    var2_2.close();
                    continue;
                }
                if (var1_1 == null) continue;
                try {}
                catch (IOException var9_9) {}
                var1_1.close();
            }
        }

        public ServerEndpoint.ListenCookie getCookie() {
            return this.listenCookie;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Iterator iterator = this.lock;
            synchronized (iterator) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                ((ServerConnectionImpl)iterator.next()).close();
            }
            this.connections.clear();
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.serverCred.dispose();
            }
            catch (GSSException gSSException) {
                // empty catch block
            }
            logger.log(Level.FINE, "Listen operation {0} has been closed", this);
        }

        public String toString() {
            return "KerberosServerEndpoint.ListenHandleImpl[serverPrincipal=" + KerberosServerEndpoint.this.serverPrincipal + " portListening = " + this.serverSocket.getLocalPort() + (KerberosServerEndpoint.this.ssf == null ? "" : " ssf = " + KerberosServerEndpoint.this.ssf.toString()) + (KerberosServerEndpoint.this.csf == null ? "" : " csf = " + KerberosServerEndpoint.this.csf.toString()) + "]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(ServerConnectionImpl serverConnectionImpl) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.closed) {
                    this.connections.remove(serverConnectionImpl);
                }
            }
        }

        private boolean checkKey() {
            if (this.serverKey.isDestroyed()) {
                return false;
            }
            return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() {
                    Set<Object> set;
                    Set<Object> set2 = set = KerberosServerEndpoint.this.serverSubject.getPrivateCredentials();
                    synchronized (set2) {
                        Iterator<Object> iterator = set.iterator();
                        while (iterator.hasNext()) {
                            if (ListenHandleImpl.this.serverKey != iterator.next()) continue;
                            return Boolean.TRUE;
                        }
                    }
                    return Boolean.FALSE;
                }
            });
        }

        private boolean continueAfterAcceptFailure(Throwable throwable) {
            long l = System.currentTimeMillis();
            if (this.acceptFailureTime == 0L || l - this.acceptFailureTime > 5000L) {
                this.acceptFailureTime = l;
                this.acceptFailureCount = 0;
            } else {
                ++this.acceptFailureCount;
                if (this.acceptFailureCount >= 10) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            return true;
        }
    }

    private final class ListenCookieImpl
    implements ServerEndpoint.ListenCookie {
        int localPort;

        ListenCookieImpl(int n) {
            this.localPort = n;
        }

        KerberosServerEndpoint getServerEndpoint() {
            return KerberosServerEndpoint.this;
        }

        int getLocalPort() {
            return this.localPort;
        }
    }

    private final class ListenEndpointImpl
    implements ServerEndpoint.ListenEndpoint {
        private ListenEndpointImpl() {
        }

        public void checkPermissions() {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    securityManager.checkListen(KerberosServerEndpoint.this.port);
                    KerberosUtil.checkAuthPermission(KerberosServerEndpoint.this.serverPrincipal, null, "listen");
                }
                catch (SecurityException securityException) {
                    if (logger.isLoggable(Levels.FAILED)) {
                        KerberosUtil.logThrow(logger, Levels.FAILED, this.getClass(), "checkPermissions", "check permissions for {0}\nthrows", new Object[]{this}, securityException);
                    }
                    throw securityException;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ServerEndpoint.ListenHandle listen(RequestDispatcher requestDispatcher) throws IOException {
            ServerSocket serverSocket;
            GSSCredential gSSCredential;
            KerberosKey kerberosKey;
            block17: {
                if (requestDispatcher == null) {
                    throw new NullPointerException("null dispatcher is passed in");
                }
                try {
                    if (KerberosServerEndpoint.this.serverSubject != null && !KerberosServerEndpoint.this.serverSubject.getPrincipals().contains(KerberosServerEndpoint.this.serverPrincipal)) {
                        throw new UnsupportedConstraintException("Failed to find serverPrincipal " + KerberosServerEndpoint.this.serverPrincipal + "in serverSubject's principal set, cannot listen.");
                    }
                    kerberosKey = KerberosServerEndpoint.getKey(KerberosServerEndpoint.this.serverSubject, KerberosServerEndpoint.this.serverPrincipal);
                    if (kerberosKey == null) {
                        throw new UnsupportedConstraintException("No valid Kerberos key in the server subject for " + KerberosServerEndpoint.this.serverPrincipal + ", cannot listen.");
                    }
                    try {
                        gSSCredential = (GSSCredential)Security.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws GSSException {
                                return KerberosUtil.getGSSCredential(KerberosServerEndpoint.this.serverSubject, KerberosServerEndpoint.this.serverPrincipal, gssManager, 2);
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        GSSException gSSException = (GSSException)privilegedActionException.getException();
                        throw new UnsupportedConstraintException("Failed to get GSSCredential for server principal: " + KerberosServerEndpoint.this.serverPrincipal, gSSException);
                    }
                }
                catch (UnsupportedConstraintException unsupportedConstraintException) {
                    if (!logger.isLoggable(Levels.FAILED)) throw unsupportedConstraintException;
                    KerberosUtil.logThrow(logger, Levels.FAILED, this.getClass(), "listen", "listen for {0}\nthrows", new Object[]{this}, unsupportedConstraintException);
                    throw unsupportedConstraintException;
                }
                catch (SecurityException securityException) {
                    if (!logger.isLoggable(Levels.FAILED)) throw securityException;
                    KerberosUtil.logThrow(logger, Levels.FAILED, this.getClass(), "listen", "listen for {0}\nthrows", new Object[]{this}, securityException);
                    throw securityException;
                }
                boolean bl = false;
                try {
                    if (KerberosServerEndpoint.this.ssf != null) {
                        serverSocket = KerberosServerEndpoint.this.ssf.createServerSocket(KerberosServerEndpoint.this.port);
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "created {0} using factory {1}", new Object[]{serverSocket, KerberosServerEndpoint.this.ssf});
                        }
                    } else {
                        serverSocket = new ServerSocket(KerberosServerEndpoint.this.port);
                        logger.log(Level.FINE, "created {0}", serverSocket);
                    }
                    bl = true;
                    Object var7_10 = null;
                    if (bl) break block17;
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    if (bl) throw throwable;
                    try {
                        gSSCredential.dispose();
                        throw throwable;
                    }
                    catch (GSSException gSSException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (GSSException gSSException) {}
                gSSCredential.dispose();
            }
            ListenHandleImpl listenHandleImpl = new ListenHandleImpl(requestDispatcher, kerberosKey, gSSCredential, serverSocket, Security.getContext());
            listenHandleImpl.startAccepting();
            return listenHandleImpl;
        }

        public int hashCode() {
            int n = this.getClass().getName().hashCode() ^ System.identityHashCode(KerberosServerEndpoint.this.serverSubject) ^ KerberosServerEndpoint.this.serverPrincipal.hashCode() ^ KerberosServerEndpoint.this.port;
            if (KerberosServerEndpoint.this.ssf != null) {
                n ^= KerberosServerEndpoint.this.ssf.hashCode();
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ListenEndpointImpl)) {
                return false;
            }
            ListenEndpointImpl listenEndpointImpl = (ListenEndpointImpl)object;
            KerberosServerEndpoint kerberosServerEndpoint = listenEndpointImpl.getServerEndpoint();
            return KerberosServerEndpoint.this.serverSubject == kerberosServerEndpoint.serverSubject && KerberosServerEndpoint.this.serverPrincipal.equals(kerberosServerEndpoint.serverPrincipal) && KerberosServerEndpoint.this.port == kerberosServerEndpoint.port && Util.sameClassAndEquals(KerberosServerEndpoint.this.ssf, kerberosServerEndpoint.ssf);
        }

        public String toString() {
            return "KerberosServerEndpoint.ListenEndpointImpl[serverPrincipal=" + KerberosServerEndpoint.this.serverPrincipal + " serverPort = " + KerberosServerEndpoint.this.port + (KerberosServerEndpoint.this.ssf == null ? "" : " ssf = " + KerberosServerEndpoint.this.ssf.toString()) + (KerberosServerEndpoint.this.csf == null ? "" : " csf = " + KerberosServerEndpoint.this.csf.toString()) + "]";
        }

        private KerberosServerEndpoint getServerEndpoint() {
            return KerberosServerEndpoint.this;
        }
    }
}

