/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri;

import java.lang.reflect.InvocationHandler;
import java.rmi.Remote;
import java.rmi.server.ExportException;
import java.util.Collection;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.jeri.AbstractILFactory;
import net.jini.jeri.BasicInvocationDispatcher;
import net.jini.jeri.BasicInvocationHandler;
import net.jini.jeri.InvocationDispatcher;
import net.jini.jeri.ObjectEndpoint;
import net.jini.jeri.ServerCapabilities;
import net.jini.security.proxytrust.TrustEquivalence;

public class BasicILFactory
extends AbstractILFactory {
    private final MethodConstraints serverConstraints;
    private final Class permissionClass;

    public BasicILFactory() {
        this.serverConstraints = null;
        this.permissionClass = null;
    }

    public BasicILFactory(MethodConstraints methodConstraints, Class clazz) {
        this(methodConstraints, clazz, null);
    }

    public BasicILFactory(MethodConstraints methodConstraints, Class clazz, ClassLoader classLoader) {
        super(classLoader);
        BasicInvocationDispatcher.checkPermissionClass(clazz);
        this.serverConstraints = methodConstraints;
        this.permissionClass = clazz;
    }

    protected InvocationHandler createInvocationHandler(Class[] classArray, Remote remote, ObjectEndpoint objectEndpoint) throws ExportException {
        int n = classArray.length;
        while (--n >= 0) {
            if (classArray[n] != null) continue;
            throw new NullPointerException();
        }
        if (remote == null) {
            throw new NullPointerException();
        }
        return new BasicInvocationHandler(objectEndpoint, this.serverConstraints);
    }

    protected Class[] getExtraProxyInterfaces(Remote remote) {
        if (remote == null) {
            throw new NullPointerException();
        }
        return new Class[]{RemoteMethodControl.class, TrustEquivalence.class};
    }

    protected InvocationDispatcher createInvocationDispatcher(Collection collection, Remote remote, ServerCapabilities serverCapabilities) throws ExportException {
        if (remote == null) {
            throw new NullPointerException("impl is null");
        }
        return new BasicInvocationDispatcher(collection, serverCapabilities, this.serverConstraints, this.permissionClass, this.getClassLoader());
    }

    public final MethodConstraints getServerConstraints() {
        return this.serverConstraints;
    }

    public final Class getPermissionClass() {
        return this.permissionClass;
    }

    public int hashCode() {
        int n = super.hashCode();
        if (this.serverConstraints != null) {
            n += this.serverConstraints.hashCode();
        }
        if (this.permissionClass != null) {
            n += this.permissionClass.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        BasicILFactory basicILFactory = (BasicILFactory)object;
        return this.permissionClass == basicILFactory.permissionClass && (this.serverConstraints == basicILFactory.serverConstraints || this.serverConstraints != null && this.serverConstraints.equals(basicILFactory.serverConstraints));
    }

    public String toString() {
        return super.toString() + "[" + this.serverConstraints + (this.permissionClass != null ? ", " + this.permissionClass.getName() : "") + "]";
    }
}

