/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.runtime;

import com.sun.jini.logging.Levels;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.Pipe;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.security.AccessController;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Logger;

public final class SelectionManager {
    private static final int concurrency = 1;
    private static final Logger logger;
    private static final Executor systemThreadPool;
    private final Selector selector;
    private final Pipe.SinkChannel wakeupPipeSink;
    private final Pipe.SourceChannel wakeupPipeSource;
    private final SelectionKey wakeupPipeKey;
    private final ByteBuffer wakeupBuffer = ByteBuffer.allocate(2);
    private final Map registeredChannels = Collections.synchronizedMap(new WeakHashMap());
    private final Object lock = new Object();
    private Thread selectingThread = null;
    private boolean wakeupPending = false;
    private Key renewQueue = null;
    private Key readyQueue = null;
    private final int[] renewMaskRef = new int[1];
    static final /* synthetic */ boolean $assertionsDisabled;

    public SelectionManager() throws IOException {
        this.selector = Selector.open();
        Pipe pipe = Pipe.open();
        this.wakeupPipeSink = pipe.sink();
        this.wakeupPipeSource = pipe.source();
        this.wakeupPipeSource.configureBlocking(false);
        this.wakeupPipeKey = this.wakeupPipeSource.register(this.selector, 1);
        for (int i = 0; i < 1; ++i) {
            systemThreadPool.execute(new SelectLoop(), "I/O SelectionManager-" + i);
        }
    }

    public Key register(SelectableChannel selectableChannel, SelectionHandler selectionHandler) {
        if (this.registeredChannels.containsKey(selectableChannel)) {
            throw new IllegalStateException("channel already registered");
        }
        Key key = new Key(selectableChannel, selectionHandler);
        this.registeredChannels.put(selectableChannel, null);
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Key waitForReadyKey(int[] nArray) throws InterruptedException {
        Object object;
        Set<SelectionKey> set;
        boolean bl;
        block37: {
            Object object2;
            Key key;
            block36: {
                if (!$assertionsDisabled && Thread.holdsLock(this.lock)) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled) {
                    if (nArray == null) throw new AssertionError();
                    if (nArray.length != 1) {
                        throw new AssertionError();
                    }
                }
                bl = false;
                set = this.selector.selectedKeys();
                try {
                    Object object3 = this.lock;
                    synchronized (object3) {
                        while (this.isReadyQueueEmpty() && this.selectingThread != null) {
                            this.lock.wait();
                        }
                        if (!this.isReadyQueueEmpty()) {
                            Key key2 = this.removeFromReadyQueue(nArray);
                            this.lock.notify();
                            key = key2;
                            // MONITOREXIT @DISABLED, blocks:[0, 35, 7] lbl19 : MonitorExitStatement: MONITOREXIT : var4_4
                            Object var12_14 = null;
                            if (!bl) return key;
                            object2 = this.lock;
                            break block36;
                        }
                        if (!$assertionsDisabled && this.selectingThread != null) {
                            throw new AssertionError();
                        }
                        if (!$assertionsDisabled && this.wakeupPending) {
                            throw new AssertionError();
                        }
                        this.selectingThread = Thread.currentThread();
                        bl = true;
                        this.processRenewQueue();
                    }
                    while (true) {
                        try {
                            int n = this.selector.select();
                            if (Thread.interrupted()) {
                                throw new InterruptedException();
                            }
                        }
                        catch (Error error) {
                            if (!error.getMessage().startsWith("POLLNVAL")) throw error;
                            Thread.yield();
                            continue;
                        }
                        catch (CancelledKeyException cancelledKeyException) {
                            continue;
                        }
                        catch (NullPointerException nullPointerException) {
                            continue;
                        }
                        catch (IOException iOException) {
                            logger.log(Levels.HANDLED, "thrown by select, continuing", iOException);
                            continue;
                        }
                        object3 = this.lock;
                        synchronized (object3) {
                            if (this.wakeupPending) {
                                this.drainWakeupPipe();
                                this.wakeupPending = false;
                                set.remove(this.wakeupPipeKey);
                            }
                            if (!set.isEmpty()) break;
                            this.processRenewQueue();
                        }
                    }
                    {
                        this.selectingThread = null;
                        bl = false;
                        this.lock.notify();
                        Iterator<SelectionKey> iterator = set.iterator();
                        if (!$assertionsDisabled && !iterator.hasNext()) {
                            throw new AssertionError();
                        }
                        while (iterator.hasNext()) {
                            object = iterator.next();
                            Key key3 = (Key)((SelectionKey)object).attachment();
                            int n = 0;
                            try {
                                n = ((SelectionKey)object).readyOps();
                                if (!$assertionsDisabled && n == 0) {
                                    throw new AssertionError();
                                }
                                if (!$assertionsDisabled && (key3.interestMask & n) != n) {
                                    throw new AssertionError();
                                }
                                int n2 = key3.interestMask & ~n;
                                if (!$assertionsDisabled && key3.interestMask != ((SelectionKey)object).interestOps()) {
                                    throw new AssertionError();
                                }
                                key3.selectionKey.interestOps(n2);
                                key3.interestMask = n2;
                            }
                            catch (CancelledKeyException cancelledKeyException) {
                                n |= key3.interestMask;
                                key3.interestMask = 0;
                            }
                            this.addOrUpdateReadyQueue(key3, n);
                            iterator.remove();
                        }
                        object = this.removeFromReadyQueue(nArray);
                    }
                    break block37;
                }
                catch (Throwable throwable) {
                    Object var12_16 = null;
                    if (!bl) throw throwable;
                    Object object4 = this.lock;
                    synchronized (object4) {
                        if (this.wakeupPending) {
                            this.drainWakeupPipe();
                            this.wakeupPending = false;
                            set.remove(this.wakeupPipeKey);
                        }
                        this.selectingThread = null;
                        bl = false;
                        this.lock.notify();
                        throw throwable;
                    }
                }
            }
            synchronized (object2) {
                if (this.wakeupPending) {
                    this.drainWakeupPipe();
                    this.wakeupPending = false;
                    set.remove(this.wakeupPipeKey);
                }
                this.selectingThread = null;
                bl = false;
                this.lock.notify();
                return key;
            }
        }
        Object var12_15 = null;
        if (!bl) return object;
        Object object5 = this.lock;
        synchronized (object5) {
            if (this.wakeupPending) {
                this.drainWakeupPipe();
                this.wakeupPending = false;
                set.remove(this.wakeupPipeKey);
            }
            this.selectingThread = null;
            bl = false;
            this.lock.notify();
            return object;
        }
    }

    private void wakeupSelector() {
        if (!$assertionsDisabled && !Thread.holdsLock(this.lock)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.wakeupPending) {
            throw new AssertionError();
        }
        this.wakeupBuffer.clear().limit(1);
        try {
            this.wakeupPipeSink.write(this.wakeupBuffer);
        }
        catch (IOException iOException) {
            AssertionError assertionError = new AssertionError((Object)"unexpected I/O exception");
            ((Throwable)((Object)assertionError)).initCause(iOException);
            throw assertionError;
        }
    }

    private void drainWakeupPipe() {
        if (!$assertionsDisabled && !Thread.holdsLock(this.lock)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.selectingThread == null) {
            throw new AssertionError();
        }
        do {
            this.wakeupBuffer.clear();
            try {
                this.wakeupPipeSource.read(this.wakeupBuffer);
            }
            catch (IOException iOException) {
                AssertionError assertionError = new AssertionError((Object)"unexpected I/O exception");
                ((Throwable)((Object)assertionError)).initCause(iOException);
                throw assertionError;
            }
        } while (!this.wakeupBuffer.hasRemaining());
    }

    private void processRenewQueue() {
        if (!$assertionsDisabled && !Thread.holdsLock(this.lock)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.selectingThread == null) {
            throw new AssertionError();
        }
        while (!this.isRenewQueueEmpty()) {
            Key key = this.removeFromRenewQueue(this.renewMaskRef);
            int n = this.renewMaskRef[0];
            if (!$assertionsDisabled && n == 0) {
                throw new AssertionError();
            }
            if (key.selectionKey == null) {
                if (!($assertionsDisabled || key.interestMask == 0 && key.readyMask == 0)) {
                    throw new AssertionError();
                }
                try {
                    key.selectionKey = key.channel.register(this.selector, n);
                    key.selectionKey.attach(key);
                    key.interestMask = n;
                }
                catch (ClosedChannelException closedChannelException) {
                    this.addOrUpdateReadyQueue(key, n);
                }
                catch (IllegalBlockingModeException illegalBlockingModeException) {
                    this.addOrUpdateReadyQueue(key, n);
                }
                continue;
            }
            if (!$assertionsDisabled && (key.interestMask & n) != 0) {
                throw new AssertionError();
            }
            int n2 = key.interestMask | n;
            try {
                if (!$assertionsDisabled && key.interestMask != key.selectionKey.interestOps()) {
                    throw new AssertionError();
                }
                key.selectionKey.interestOps(n2);
                key.interestMask = n2;
            }
            catch (CancelledKeyException cancelledKeyException) {
                this.addOrUpdateReadyQueue(key, n2);
                key.interestMask = 0;
            }
            if (!$assertionsDisabled && (key.interestMask & key.readyMask) != 0) {
                throw new AssertionError();
            }
        }
    }

    private boolean isRenewQueueEmpty() {
        if (!$assertionsDisabled && !Thread.holdsLock(this.lock)) {
            throw new AssertionError();
        }
        return this.renewQueue == null;
    }

    private Key removeFromRenewQueue(int[] nArray) {
        if (!($assertionsDisabled || nArray != null && nArray.length == 1)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !Thread.holdsLock(this.lock)) {
            throw new AssertionError();
        }
        Key key = this.renewQueue;
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !key.onRenewQueue) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && key.renewMask == 0) {
            throw new AssertionError();
        }
        nArray[0] = key.renewMask;
        key.renewMask = 0;
        this.renewQueue = key.renewQueueNext;
        key.renewQueueNext = null;
        key.onRenewQueue = false;
        return key;
    }

    private void addOrUpdateRenewQueue(Key key, int n) {
        if (!$assertionsDisabled && n == 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !Thread.holdsLock(this.lock)) {
            throw new AssertionError();
        }
        if (!key.onRenewQueue) {
            if (!$assertionsDisabled && key.renewMask != 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && key.renewQueueNext != null) {
                throw new AssertionError();
            }
            key.renewMask = n;
            key.renewQueueNext = this.renewQueue;
            this.renewQueue = key;
            key.onRenewQueue = true;
        } else {
            if (!$assertionsDisabled && key.renewMask == 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && (key.renewMask & n) != 0) {
                throw new AssertionError();
            }
            key.renewMask |= n;
        }
    }

    private boolean isReadyQueueEmpty() {
        if (!$assertionsDisabled && !Thread.holdsLock(this.lock)) {
            throw new AssertionError();
        }
        return this.readyQueue == null;
    }

    private Key removeFromReadyQueue(int[] nArray) {
        if (!($assertionsDisabled || nArray != null && nArray.length == 1)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !Thread.holdsLock(this.lock)) {
            throw new AssertionError();
        }
        Key key = this.readyQueue;
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !key.onReadyQueue) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && key.readyMask == 0) {
            throw new AssertionError();
        }
        nArray[0] = key.readyMask;
        key.readyMask = 0;
        this.readyQueue = key.readyQueueNext;
        key.readyQueueNext = null;
        key.onReadyQueue = false;
        return key;
    }

    private void addOrUpdateReadyQueue(Key key, int n) {
        if (!$assertionsDisabled && n == 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !Thread.holdsLock(this.lock)) {
            throw new AssertionError();
        }
        if (!key.onReadyQueue) {
            if (!$assertionsDisabled && key.readyMask != 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && key.readyQueueNext != null) {
                throw new AssertionError();
            }
            key.readyMask = n;
            key.readyQueueNext = this.readyQueue;
            this.readyQueue = key;
            key.onReadyQueue = true;
        } else {
            if (!$assertionsDisabled && key.readyMask == 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && (key.readyMask & n) != 0) {
                throw new AssertionError();
            }
            key.readyMask |= n;
        }
    }

    static {
        $assertionsDisabled = !SelectionManager.class.desiredAssertionStatus();
        logger = Logger.getLogger("com.sun.jini.jeri.internal.runtime.SelectionManager");
        systemThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(false));
    }

    private class SelectLoop
    implements Runnable {
        private SelectLoop() {
        }

        public void run() {
            try {
                int[] nArray = new int[1];
                while (true) {
                    Key key;
                    try {
                        key = SelectionManager.this.waitForReadyKey(nArray);
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    try {
                        key.handler.handleSelection(nArray[0], key);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Error error) {
                throw error;
            }
        }
    }

    public final class Key {
        final SelectableChannel channel;
        final SelectionHandler handler;
        SelectionKey selectionKey = null;
        int interestMask = 0;
        boolean onRenewQueue = false;
        Key renewQueueNext = null;
        int renewMask = 0;
        boolean onReadyQueue = false;
        Key readyQueueNext = null;
        int readyMask = 0;

        Key(SelectableChannel selectableChannel, SelectionHandler selectionHandler) {
            this.channel = selectableChannel;
            this.handler = selectionHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void renewInterestMask(int n) throws ClosedChannelException {
            if (!this.channel.isOpen()) {
                throw new ClosedChannelException();
            }
            if ((n & ~this.channel.validOps()) != 0) {
                throw new IllegalArgumentException("invalid mask " + n + " (valid mask " + this.channel.validOps() + ")");
            }
            if (this.channel.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            Object object = SelectionManager.this.lock;
            synchronized (object) {
                int n2 = n & ~(this.renewMask | this.interestMask | this.readyMask);
                if (n2 != 0) {
                    SelectionManager.this.addOrUpdateRenewQueue(this, n2);
                    if (SelectionManager.this.selectingThread != null && !SelectionManager.this.wakeupPending) {
                        SelectionManager.this.wakeupSelector();
                        SelectionManager.this.wakeupPending = true;
                    }
                }
            }
        }
    }

    public static interface SelectionHandler {
        public void handleSelection(int var1, Key var2);
    }
}

