/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.runtime;

import com.sun.jini.jeri.internal.runtime.DgcServer;
import com.sun.jini.jeri.internal.runtime.ImplRefManager;
import com.sun.jini.jeri.internal.runtime.Jeri;
import com.sun.jini.logging.Levels;
import com.sun.jini.thread.NewThreadAction;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.server.ExportException;
import java.rmi.server.Unreferenced;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.export.ServerContext;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.io.MarshalInputStream;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.BasicInvocationDispatcher;
import net.jini.jeri.InboundRequest;
import net.jini.jeri.InvocationDispatcher;
import net.jini.jeri.RequestDispatcher;
import net.jini.jeri.ServerCapabilities;
import net.jini.security.Security;
import net.jini.security.SecurityContext;

final class ObjectTable {
    private static final Logger logger;
    private static final Collection dgcDispatcherMethods;
    private static final ServerCapabilities dgcServerCapabilities;
    private final Object requestDispatchersLock = new Object();
    private final ImplRefManager implRefManager = new ImplRefManager();
    private final Object keepAliveLock = new Object();
    private int keepAliveCount = 0;
    private Thread keeper = null;
    private final Map leaseTable = new HashMap();
    private Thread leaseChecker = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    ObjectTable() {
    }

    RequestDispatcher createRequestDispatcher(Unreferenced unreferenced) {
        return new RD(unreferenced);
    }

    boolean isReferenced(RequestDispatcher requestDispatcher) {
        return this.getRD(requestDispatcher).isReferenced();
    }

    Target export(Remote remote, RequestDispatcher[] requestDispatcherArray, boolean bl, boolean bl2, Uuid uuid) throws ExportException {
        RD[] rDArray = new RD[requestDispatcherArray.length];
        for (int i = 0; i < requestDispatcherArray.length; ++i) {
            rDArray[i] = this.getRD(requestDispatcherArray[i]);
        }
        return new Target(remote, uuid, rDArray, bl, bl2);
    }

    private RD getRD(RequestDispatcher requestDispatcher) {
        RD rD = (RD)requestDispatcher;
        if (!rD.forTable(this)) {
            throw new IllegalArgumentException("request dispatcher for different object table");
        }
        return rD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementKeepAliveCount() {
        Object object = this.keepAliveLock;
        synchronized (object) {
            ++this.keepAliveCount;
            if (this.keeper == null) {
                this.keeper = (Thread)AccessController.doPrivileged(new NewThreadAction(new Runnable(){

                    public void run() {
                        try {
                            while (true) {
                                Thread.sleep(Long.MAX_VALUE);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                }, "KeepAlive", false));
                this.keeper.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementKeepAliveCount() {
        Object object = this.keepAliveLock;
        synchronized (object) {
            --this.keepAliveCount;
            if (this.keepAliveCount == 0) {
                if (!$assertionsDisabled && this.keeper == null) {
                    throw new AssertionError();
                }
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        ObjectTable.this.keeper.interrupt();
                        return null;
                    }
                });
                this.keeper = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerTarget(Target target, Uuid uuid) {
        Map map = this.leaseTable;
        synchronized (map) {
            Lease lease = (Lease)this.leaseTable.get(uuid);
            if (lease == null) {
                target.leaseExpired(uuid);
            } else {
                Set set = lease.notifySet;
                synchronized (set) {
                    lease.notifySet.add(target);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterTarget(Target target, Uuid uuid) {
        Map map = this.leaseTable;
        synchronized (map) {
            Lease lease = (Lease)this.leaseTable.get(uuid);
            if (lease != null) {
                Set set = lease.notifySet;
                synchronized (set) {
                    lease.notifySet.remove(target);
                }
            }
        }
    }

    static {
        $assertionsDisabled = !ObjectTable.class.desiredAssertionStatus();
        logger = Logger.getLogger("net.jini.jeri.BasicJeriExporter");
        dgcDispatcherMethods = new ArrayList(2);
        Method[] methodArray = DgcServer.class.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            final Method method = methodArray[i];
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    method.setAccessible(true);
                    return null;
                }
            });
            dgcDispatcherMethods.add(method);
        }
        dgcServerCapabilities = new ServerCapabilities(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public InvocationConstraints checkConstraints(InvocationConstraints invocationConstraints) throws UnsupportedConstraintException {
                if (!$assertionsDisabled && !invocationConstraints.equals(InvocationConstraints.EMPTY)) {
                    throw new AssertionError();
                }
                return InvocationConstraints.EMPTY;
            }

            static {
                $assertionsDisabled = !(class$com$sun$jini$jeri$internal$runtime$ObjectTable == null ? (class$com$sun$jini$jeri$internal$runtime$ObjectTable = ObjectTable.class$("com.sun.jini.jeri.internal.runtime.ObjectTable")) : class$com$sun$jini$jeri$internal$runtime$ObjectTable).desiredAssertionStatus();
            }
        };
    }

    private static class NoSuchObject
    extends Exception {
        private NoSuchObject() {
        }
    }

    private static class Lease {
        private final Uuid clientID;
        final Set notifySet = new HashSet(3);
        private long expiration;

        Lease(Uuid uuid, long l) {
            this.clientID = uuid;
            this.expiration = System.currentTimeMillis() + l;
        }

        Uuid getClientID() {
            return this.clientID;
        }

        void renew(long l) {
            long l2 = System.currentTimeMillis() + l;
            if (l2 > this.expiration) {
                this.expiration = l2;
            }
        }

        boolean hasExpired(long l) {
            return this.expiration < l;
        }
    }

    private class LeaseChecker
    implements Runnable {
        private LeaseChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bl = false;
            do {
                Object object;
                Object object2;
                try {
                    Thread.sleep(Jeri.leaseCheckInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                long l = System.currentTimeMillis();
                ArrayList<Lease> arrayList = new ArrayList<Lease>();
                Object object3 = ObjectTable.this.leaseTable;
                synchronized (object3) {
                    object2 = ObjectTable.this.leaseTable.values().iterator();
                    while (object2.hasNext()) {
                        object = (Lease)object2.next();
                        if (!((Lease)object).hasExpired(l)) continue;
                        arrayList.add((Lease)object);
                        object2.remove();
                    }
                    if (ObjectTable.this.leaseTable.isEmpty()) {
                        ObjectTable.this.leaseChecker = null;
                        bl = true;
                    }
                }
                if (arrayList.isEmpty()) continue;
                object3 = arrayList.iterator();
                while (object3.hasNext()) {
                    object2 = (Lease)object3.next();
                    if (((Lease)object2).notifySet.isEmpty()) continue;
                    object = ((Lease)object2).notifySet.iterator();
                    while (object.hasNext()) {
                        Target target = (Target)object.next();
                        target.leaseExpired(((Lease)object2).getClientID());
                    }
                }
            } while (!bl);
        }
    }

    private class RD
    implements RequestDispatcher {
        private final Unreferenced unrefCallback;
        private final Map idTable = new HashMap();
        private final InvocationDispatcher dgcDispatcher;
        private final DgcServerImpl dgcServerImpl;
        static final /* synthetic */ boolean $assertionsDisabled;

        RD(Unreferenced unreferenced) {
            this.unrefCallback = unreferenced;
            try {
                this.dgcDispatcher = new BasicInvocationDispatcher(dgcDispatcherMethods, dgcServerCapabilities, null, null, this.getClass().getClassLoader()){

                    protected ObjectInputStream createMarshalInputStream(Object object, InboundRequest inboundRequest, boolean bl, Collection collection) throws IOException {
                        ClassLoader classLoader = this.getClassLoader();
                        return new MarshalInputStream(inboundRequest.getRequestInputStream(), classLoader, bl, classLoader, Collections.unmodifiableCollection(collection));
                    }
                };
            }
            catch (ExportException exportException) {
                throw new AssertionError();
            }
            this.dgcServerImpl = new DgcServerImpl();
        }

        boolean forTable(ObjectTable objectTable) {
            return ObjectTable.this == objectTable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isReferenced() {
            Map map = this.idTable;
            synchronized (map) {
                return !this.idTable.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Target get(Uuid uuid) {
            Map map = this.idTable;
            synchronized (map) {
                return (Target)this.idTable.get(uuid);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void put(Target target) throws ExportException {
            Map map = this.idTable;
            synchronized (map) {
                Uuid uuid = target.getObjectIdentifier();
                if (this.idTable.containsKey(uuid) || uuid.equals(Jeri.DGC_ID)) {
                    throw new ExportException("Uuid already in use");
                }
                this.idTable.put(uuid, target);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(Target target, boolean bl) {
            boolean bl2 = false;
            Map map = this.idTable;
            synchronized (map) {
                Uuid uuid = target.getObjectIdentifier();
                if (!$assertionsDisabled && this.idTable.get(uuid) != target) {
                    throw new AssertionError();
                }
                this.idTable.remove(uuid);
                if (this.idTable.isEmpty()) {
                    bl2 = true;
                }
            }
            if (bl && bl2) {
                this.unrefCallback.unreferenced();
            }
        }

        public void dispatch(final InboundRequest inboundRequest) {
            block8: {
                InputStream inputStream = inboundRequest.getRequestInputStream();
                OutputStream outputStream = inboundRequest.getResponseOutputStream();
                try {
                    Uuid uuid = UuidFactory.read(inputStream);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "id={0}", uuid);
                    }
                    if (uuid.equals(Jeri.DGC_ID)) {
                        outputStream.write(1);
                        final ArrayList arrayList = new ArrayList(5);
                        inboundRequest.populateContext(arrayList);
                        ServerContext.doWithServerContext(new Runnable(){

                            public void run() {
                                RD.this.dgcDispatcher.dispatch(RD.this.dgcServerImpl, inboundRequest, arrayList);
                            }
                        }, Collections.unmodifiableCollection(arrayList));
                        return;
                    }
                    Target target = this.get(uuid);
                    try {
                        if (target == null) {
                            logger.log(Level.FINEST, "id not in table");
                            throw new NoSuchObject();
                        }
                        target.dispatch(inboundRequest);
                    }
                    catch (NoSuchObject noSuchObject) {
                        inputStream.close();
                        outputStream.write(0);
                        outputStream.close();
                        if (logger.isLoggable(Levels.FAILED)) {
                            logger.log(Levels.FAILED, "no such object: {0}", uuid);
                        }
                    }
                }
                catch (IOException iOException) {
                    inboundRequest.abort();
                    if (!logger.isLoggable(Levels.FAILED)) break block8;
                    logger.log(Levels.FAILED, "I/O exception dispatching request", iOException);
                }
            }
        }

        static {
            $assertionsDisabled = !(class$com$sun$jini$jeri$internal$runtime$ObjectTable == null ? (class$com$sun$jini$jeri$internal$runtime$ObjectTable = ObjectTable.class$("com.sun.jini.jeri.internal.runtime.ObjectTable")) : class$com$sun$jini$jeri$internal$runtime$ObjectTable).desiredAssertionStatus();
        }

        private class DgcServerImpl
        implements DgcServer {
            private DgcServerImpl() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public long dirty(Uuid uuid, long l, Uuid[] uuidArray) {
                Object object;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "clientID={0}, sequenceNum={1}, ids={2}", new Object[]{uuid, new Long(l), Arrays.asList(uuidArray)});
                }
                long l2 = Jeri.leaseValue;
                Map map = ObjectTable.this.leaseTable;
                synchronized (map) {
                    object = (Lease)ObjectTable.this.leaseTable.get(uuid);
                    if (object == null) {
                        ObjectTable.this.leaseTable.put(uuid, new Lease(uuid, l2));
                        if (ObjectTable.this.leaseChecker == null) {
                            ObjectTable.this.leaseChecker = (Thread)AccessController.doPrivileged(new NewThreadAction(new LeaseChecker(), "DGC Lease Checker", true));
                            ObjectTable.this.leaseChecker.start();
                        }
                    } else {
                        ((Lease)object).renew(l2);
                    }
                }
                for (int i = 0; i < uuidArray.length; ++i) {
                    object = RD.this.get(uuidArray[i]);
                    if (object == null) continue;
                    ((Target)object).referenced(uuid, l);
                }
                return l2;
            }

            public void clean(Uuid uuid, long l, Uuid[] uuidArray, boolean bl) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "clientID={0}, sequenceNum={1}, ids={2}, strong={3}", new Object[]{uuid, new Long(l), Arrays.asList(uuidArray), bl});
                }
                for (int i = 0; i < uuidArray.length; ++i) {
                    Target target = RD.this.get(uuidArray[i]);
                    if (target == null) continue;
                    target.unreferenced(uuid, l, bl);
                }
            }
        }
    }

    private static final class SequenceEntry {
        long sequenceNum;
        boolean keep;

        SequenceEntry(long l) {
            this.sequenceNum = l;
        }
    }

    final class Target {
        private final ImplRefManager.ImplRef implRef;
        private final Uuid id;
        private final RD[] requestDispatchers;
        private final boolean allowDGC;
        private final boolean keepAlive;
        private final SecurityContext securityContext;
        private final ClassLoader ccl;
        private final Object lock;
        private InvocationDispatcher invocationDispatcher;
        private boolean exported;
        private int callsInProgress;
        private final Set referencedSet;
        private final Map sequenceTable;
        static final /* synthetic */ boolean $assertionsDisabled;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        Target(Remote remote, Uuid uuid, RD[] rDArray, boolean bl, boolean bl2) throws ExportException {
            Object object;
            block12: {
                this.lock = new Object();
                this.exported = false;
                this.callsInProgress = 0;
                this.id = uuid;
                this.requestDispatchers = rDArray;
                this.allowDGC = bl;
                this.keepAlive = bl2;
                this.securityContext = Security.getContext();
                this.ccl = Thread.currentThread().getContextClassLoader();
                object = ObjectTable.this.requestDispatchersLock;
                synchronized (object) {
                    boolean bl3 = false;
                    int n = 0;
                    try {
                        for (n = 0; n < rDArray.length; ++n) {
                            rDArray[n].put(this);
                        }
                        bl3 = true;
                        Object var11_10 = null;
                        if (bl3) break block12;
                    }
                    catch (Throwable throwable) {
                        Object var11_11 = null;
                        if (bl3) throw throwable;
                        int n2 = 0;
                        while (n2 < n) {
                            rDArray[n].remove(this, false);
                            ++n2;
                        }
                        throw throwable;
                    }
                    for (int i = 0; i < n; ++i) {
                        rDArray[n].remove(this, false);
                    }
                }
            }
            this.implRef = ObjectTable.this.implRefManager.getImplRef(remote, this);
            if (bl) {
                this.referencedSet = new HashSet(3);
                this.sequenceTable = new HashMap(3);
            } else {
                this.referencedSet = null;
                this.sequenceTable = null;
            }
            if (bl2) {
                ObjectTable.this.incrementKeepAliveCount();
            }
            object = this.lock;
            synchronized (object) {
                this.exported = true;
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setInvocationDispatcher(InvocationDispatcher invocationDispatcher) {
            if (!$assertionsDisabled && invocationDispatcher == null) {
                throw new AssertionError();
            }
            Object object = this.lock;
            synchronized (object) {
                if (!$assertionsDisabled && this.invocationDispatcher != null) {
                    throw new AssertionError();
                }
                this.invocationDispatcher = invocationDispatcher;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean unexport(boolean bl) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.exported) {
                    return true;
                }
                if (!bl && this.callsInProgress > 0) {
                    return false;
                }
                this.exported = false;
                if (this.keepAlive && this.callsInProgress == 0) {
                    ObjectTable.this.decrementKeepAliveCount();
                }
                if (this.allowDGC) {
                    if (!this.referencedSet.isEmpty()) {
                        Iterator iterator = this.referencedSet.iterator();
                        while (iterator.hasNext()) {
                            Uuid uuid = (Uuid)iterator.next();
                            ObjectTable.this.unregisterTarget(this, uuid);
                        }
                        this.referencedSet.clear();
                    }
                    this.sequenceTable.clear();
                }
            }
            this.implRef.release(this);
            for (int i = 0; i < this.requestDispatchers.length; ++i) {
                this.requestDispatchers[i].remove(this, false);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void collect() {
            Object object = this.lock;
            synchronized (object) {
                if (!this.exported) {
                    return;
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "garbage collection of object with id {0}", this.id);
                }
                this.exported = false;
                if (this.keepAlive && this.callsInProgress == 0) {
                    ObjectTable.this.decrementKeepAliveCount();
                }
                if (this.allowDGC) {
                    if (!$assertionsDisabled && !this.referencedSet.isEmpty()) {
                        throw new AssertionError();
                    }
                    this.sequenceTable.clear();
                }
            }
            for (int i = 0; i < this.requestDispatchers.length; ++i) {
                this.requestDispatchers[i].remove(this, true);
            }
        }

        Uuid getObjectIdentifier() {
            return this.id;
        }

        boolean getEnableDGC() {
            return this.allowDGC;
        }

        SecurityContext getSecurityContext() {
            return this.securityContext;
        }

        ClassLoader getContextClassLoader() {
            return this.ccl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void referenced(Uuid uuid, long l) {
            if (!this.allowDGC) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                SequenceEntry sequenceEntry;
                if (!this.exported) {
                    return;
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "this={0}, clientID={1}, sequenceNum={2}", new Object[]{this, uuid, new Long(l)});
                }
                if ((sequenceEntry = (SequenceEntry)this.sequenceTable.get(uuid)) == null) {
                    sequenceEntry = new SequenceEntry(l);
                    this.sequenceTable.put(uuid, sequenceEntry);
                } else {
                    if (l < sequenceEntry.sequenceNum) {
                        return;
                    }
                    sequenceEntry.sequenceNum = l;
                }
                if (!this.referencedSet.contains(uuid)) {
                    if (this.referencedSet.isEmpty()) {
                        Remote remote = this.implRef.getImpl();
                        if (remote == null) {
                            return;
                        }
                        this.implRef.pin(this);
                    }
                    this.referencedSet.add(uuid);
                    ObjectTable.this.registerTarget(this, uuid);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unreferenced(Uuid uuid, long l, boolean bl) {
            if (!this.allowDGC) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                SequenceEntry sequenceEntry;
                if (!this.exported) {
                    return;
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "this={0}, clientID={1}, sequenceNum={2}, strong={3}", new Object[]{this, uuid, new Long(l), bl});
                }
                if ((sequenceEntry = (SequenceEntry)this.sequenceTable.get(uuid)) == null) {
                    if (bl) {
                        sequenceEntry = new SequenceEntry(l);
                        this.sequenceTable.put(uuid, sequenceEntry);
                        sequenceEntry.keep = true;
                    }
                } else {
                    if (l < sequenceEntry.sequenceNum) {
                        return;
                    }
                    if (bl) {
                        sequenceEntry.sequenceNum = l;
                        sequenceEntry.keep = true;
                    } else if (!sequenceEntry.keep) {
                        this.sequenceTable.remove(uuid);
                    }
                }
                ObjectTable.this.unregisterTarget(this, uuid);
                if (this.referencedSet.remove(uuid) && this.referencedSet.isEmpty()) {
                    this.implRef.unpin(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void leaseExpired(Uuid uuid) {
            if (!$assertionsDisabled && !this.allowDGC) {
                throw new AssertionError();
            }
            Object object = this.lock;
            synchronized (object) {
                SequenceEntry sequenceEntry;
                if (!this.exported) {
                    return;
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "this={0}, clientID={1}", new Object[]{this, uuid});
                }
                if ((sequenceEntry = (SequenceEntry)this.sequenceTable.get(uuid)) != null && !sequenceEntry.keep) {
                    this.sequenceTable.remove(uuid);
                }
                if (this.referencedSet.remove(uuid) && this.referencedSet.isEmpty()) {
                    this.implRef.unpin(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispatch(InboundRequest inboundRequest) throws IOException, NoSuchObject {
            Object object;
            InvocationDispatcher invocationDispatcher;
            Object object2 = this.lock;
            synchronized (object2) {
                if (!this.exported || this.invocationDispatcher == null) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "this={0}, not exported", this);
                    }
                    throw new NoSuchObject();
                }
                invocationDispatcher = this.invocationDispatcher;
                ++this.callsInProgress;
            }
            try {
                object2 = this.implRef.getImpl();
                if (object2 == null) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "this={0}, garbage collected", this);
                    }
                    throw new NoSuchObject();
                }
                this.dispatch(inboundRequest, invocationDispatcher, (Remote)object2);
                Object var6_5 = null;
                object = this.lock;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                Object object3 = this.lock;
                synchronized (object3) {
                    if (!$assertionsDisabled && this.callsInProgress <= 0) {
                        throw new AssertionError();
                    }
                    --this.callsInProgress;
                    if (this.keepAlive && !this.exported && this.callsInProgress == 0) {
                        ObjectTable.this.decrementKeepAliveCount();
                    }
                }
                throw throwable;
            }
            synchronized (object) {
                if (!$assertionsDisabled && this.callsInProgress <= 0) {
                    throw new AssertionError();
                }
                --this.callsInProgress;
                if (this.keepAlive && !this.exported && this.callsInProgress == 0) {
                    ObjectTable.this.decrementKeepAliveCount();
                }
            }
        }

        private void dispatch(final InboundRequest inboundRequest, final InvocationDispatcher invocationDispatcher, final Remote remote) throws IOException, NoSuchObject {
            Thread thread = Thread.currentThread();
            ClassLoader classLoader = thread.getContextClassLoader();
            try {
                try {
                    thread.setContextClassLoader(this.ccl);
                    AccessController.doPrivileged(this.securityContext.wrap(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            Target.this.dispatch0(inboundRequest, invocationDispatcher, remote);
                            return null;
                        }
                    }), this.securityContext.getAccessControlContext());
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (IOException)privilegedActionException.getException();
                }
                Object var8_6 = null;
                thread.setContextClassLoader(classLoader);
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                thread.setContextClassLoader(classLoader);
                throw throwable;
            }
        }

        private void dispatch0(final InboundRequest inboundRequest, final InvocationDispatcher invocationDispatcher, final Remote remote) throws IOException {
            inboundRequest.checkPermissions();
            OutputStream outputStream = inboundRequest.getResponseOutputStream();
            outputStream.write(1);
            final ArrayList arrayList = new ArrayList(5);
            inboundRequest.populateContext(arrayList);
            ServerContext.doWithServerContext(new Runnable(){

                public void run() {
                    invocationDispatcher.dispatch(remote, inboundRequest, arrayList);
                }
            }, Collections.unmodifiableCollection(arrayList));
        }

        public String toString() {
            return "Target@" + Integer.toHexString(this.hashCode()) + "[" + this.id + "]";
        }

        static {
            $assertionsDisabled = !(class$com$sun$jini$jeri$internal$runtime$ObjectTable == null ? (class$com$sun$jini$jeri$internal$runtime$ObjectTable = ObjectTable.class$("com.sun.jini.jeri.internal.runtime.ObjectTable")) : class$com$sun$jini$jeri$internal$runtime$ObjectTable).desiredAssertionStatus();
        }
    }
}

