/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery;

import java.util.Arrays;
import net.jini.core.lookup.ServiceID;

public class MulticastAnnouncement {
    protected long sequenceNumber;
    protected String host;
    protected int port;
    protected String[] groups;
    protected ServiceID serviceID;

    public MulticastAnnouncement(long l, String string, int n, String[] stringArray, ServiceID serviceID) {
        String[] stringArray2 = stringArray = stringArray != null ? (String[])stringArray.clone() : new String[]{};
        if (string == null || serviceID == null || Arrays.asList(stringArray).contains(null)) {
            throw new NullPointerException();
        }
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("port out of range: " + n);
        }
        this.sequenceNumber = l;
        this.host = string;
        this.port = n;
        this.groups = stringArray;
        this.serviceID = serviceID;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String[] getGroups() {
        return (String[])this.groups.clone();
    }

    public ServiceID getServiceID() {
        return this.serviceID;
    }

    public String toString() {
        return "MulticastAnnouncement[" + this.sequenceNumber + ", " + this.host + ":" + this.port + ", " + Arrays.asList(this.groups) + ", " + this.serviceID + "]";
    }
}

