/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil.wizard;

import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.instutil.wizard.ComponentName;
import com.mathworks.instutil.wizard.InstutilComponentName;
import com.mathworks.instutil.wizard.TextComponentFactory;
import com.mathworks.webproxy.ProxyAuthenticationUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.PasswordAuthentication;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public abstract class AbstractProxyAuthenticationUI
implements ProxyAuthenticationUI {
    private JTextComponent userTextField;
    private JTextComponent passwordTextField;
    private final TextComponentFactory componentFactory;

    public AbstractProxyAuthenticationUI(TextComponentFactory textComponentFactory) {
        this.componentFactory = textComponentFactory;
    }

    public final PasswordAuthentication promptForPasswordAuthentication(String string, String string2, PasswordAuthentication passwordAuthentication) {
        Component component = this.createPanel(string, string2, passwordAuthentication);
        if (this.showPanel(InstutilResourceKeys.PROXY_AUTHENTICATION_TITLE.getString(new Object[0]), component)) {
            return new PasswordAuthentication(this.getUserName(), this.getPassword().toCharArray());
        }
        return null;
    }

    protected abstract boolean showPanel(String var1, Component var2);

    private Component createPanel(String string, String string2, PasswordAuthentication passwordAuthentication) {
        JPanel jPanel = this.createPanelFromFactory();
        String string3 = "";
        String string4 = "";
        if (passwordAuthentication != null) {
            string3 = passwordAuthentication.getUserName();
            string4 = new String(passwordAuthentication.getPassword());
        }
        JComponent jComponent = this.createLabelFromFactory(InstutilResourceKeys.PROXY_AUTHENTICATION_TOP_LABEL.getString(string, string2), InstutilComponentName.PROXY_AUTHENTICATION_TOP_LABEL);
        JComponent jComponent2 = this.createLabelFromFactory(InstutilResourceKeys.PROXY_USER_LABEL.getString(new Object[0]), InstutilComponentName.PROXY_USER_LABEL);
        this.userTextField = this.componentFactory.createTextField(InstutilComponentName.PROXY_USER_TEXT, InstutilResourceKeys.PROXY_USER_LABEL.getString(new Object[0]));
        this.userTextField.setText(string3);
        JComponent jComponent3 = this.createLabelFromFactory(InstutilResourceKeys.PROXY_PASSWORD_LABEL.getString(new Object[0]), InstutilComponentName.PROXY_PASSWORD_LABEL);
        this.passwordTextField = this.componentFactory.createPasswordField(InstutilComponentName.PROXY_PASSWORD_TEXT);
        this.passwordTextField.setText(string4);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)jComponent, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)jComponent2, gridBagConstraints);
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.gridwidth = 3;
        this.userTextField.setMargin(insets);
        jPanel.add((Component)this.userTextField, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jComponent3, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 3;
        this.passwordTextField.setMargin(insets);
        jPanel.add((Component)this.passwordTextField, gridBagConstraints);
        AbstractProxyAuthenticationUI.setInitialFocus(this.userTextField);
        return jPanel;
    }

    protected abstract JComponent createLabelFromFactory(String var1, ComponentName var2);

    protected abstract JPanel createPanelFromFactory();

    private static void setInitialFocus(Component component) {
        component.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                final Component component = hierarchyEvent.getComponent();
                if (component.isShowing() && (hierarchyEvent.getChangeFlags() & 4L) != 0L) {
                    Window window = SwingUtilities.getWindowAncestor(component);
                    window.addWindowFocusListener(new WindowAdapter(){

                        @Override
                        public void windowGainedFocus(WindowEvent windowEvent) {
                            component.requestFocus();
                        }
                    });
                }
            }
        });
    }

    private String getUserName() {
        return this.userTextField.getText().trim();
    }

    private String getPassword() {
        return this.passwordTextField.getText().trim();
    }
}

