/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil.services;

import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.instutil.PlatformImpl;
import com.mathworks.instutil.WaitObject;
import com.mathworks.instutil.WaitObjectInterface;
import com.mathworks.instutil.services.ServiceThread;
import com.mathworks.instutil.services.ServiceThreadState;
import com.mathworks.instutil.services.ServiceThreadView;
import com.mathworks.instutil.services.Status;
import com.mathworks.internal.mwaws.client.v5.MWMessage;
import java.text.MessageFormat;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;

public abstract class AbstractServiceThread<T>
implements ServiceThread<T> {
    private final ServiceThreadView serviceThreadView;
    private final String dialogTitle;
    private final String dialogMessage;
    private final boolean background;
    private final Status status = new Status();
    private Future<?> task;
    private boolean cancellable = true;
    private WaitObjectInterface fWaitObject = new WaitObject();

    public AbstractServiceThread(ServiceThreadView serviceThreadView, String string, String string2, boolean bl) {
        this.dialogTitle = serviceThreadView.intlString(string);
        this.dialogMessage = serviceThreadView.intlString(string2);
        this.serviceThreadView = serviceThreadView;
        this.background = bl;
    }

    @Override
    public void startAndWait() {
        try {
            this.task = this.getExecutor().submit(this);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.retry();
        }
        if (!this.background) {
            this.serviceThreadView.serviceCallStarted(this, this.dialogTitle, this.dialogMessage);
        }
        this.fWaitObject.waitUntilNotifiedofCompletion();
    }

    private void retry() {
        try {
            this.task = this.getExecutor().submit(this);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.serviceThreadView.exception(rejectedExecutionException, false);
        }
    }

    protected ExecutorService getExecutor() {
        return this.serviceThreadView.getExecutor();
    }

    @Override
    public boolean cancel() {
        if (this.isCancellable()) {
            this.setStatus(ServiceThreadState.CANCELLED);
            this.finish();
            return this.task.cancel(true);
        }
        return false;
    }

    @Override
    public final ServiceThreadState getStatus() {
        return this.status.get();
    }

    @Override
    public final void setStatus(ServiceThreadState serviceThreadState) {
        this.status.set(serviceThreadState);
    }

    @Override
    public boolean isCancelled() {
        return this.status.get() == ServiceThreadState.CANCELLED;
    }

    protected void finish() {
        this.serviceThreadView.serviceCallDone();
        this.fWaitObject.stopwaiting();
    }

    void showError(MWMessage mWMessage) {
        String string = this.serviceThreadView.intlString("error");
        MessageFormat messageFormat = new MessageFormat(string);
        Object[] objectArray = new Object[]{mWMessage.getCode(), mWMessage.getDescription()};
        String string2 = messageFormat.format(objectArray);
        String string3 = this.serviceThreadView.intlString("error.title");
        this.serviceThreadView.error(string3, string2);
    }

    void showError(com.mathworks.mlwebservices.loginws.MWMessage mWMessage) {
        String string = this.serviceThreadView.intlString("error");
        MessageFormat messageFormat = new MessageFormat(string);
        Object[] objectArray = new Object[]{mWMessage.getCode(), mWMessage.getDescription()};
        String string2 = messageFormat.format(objectArray);
        String string3 = this.serviceThreadView.intlString("error.title");
        this.serviceThreadView.error(string3, string2);
    }

    ServiceThreadView getView() {
        return this.serviceThreadView;
    }

    String getClientString() {
        return this.serviceThreadView.getClientString();
    }

    protected void handleThrowable(Throwable throwable) {
        if (!this.isCancelled()) {
            this.serviceThreadView.exception(throwable, true);
            if (!this.background) {
                this.showConnectionError();
            }
        }
    }

    @Override
    public void showConnectionError() {
        String string = this.serviceThreadView.intlString("error.connection");
        MessageFormat messageFormat = new MessageFormat(string);
        String string2 = messageFormat.format(new String[]{InstutilResourceKeys.RELEASE.getString(new Object[0]), new PlatformImpl().getArchString()});
        String string3 = this.serviceThreadView.intlString("error.connect.title");
        this.serviceThreadView.error(string3, string2);
    }

    @Override
    public void setCancellable(boolean bl) {
        this.cancellable = bl;
    }

    @Override
    public boolean isCancellable() {
        return this.cancellable;
    }

    protected void setWaitObject(WaitObjectInterface waitObjectInterface) {
        this.fWaitObject = waitObjectInterface;
    }

    @Override
    public T getResult() {
        return null;
    }
}

