/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.cls.attribute.stackmap;

import com.vladium.jcd.cls.attribute.stackmap.StackMapFrame_info;
import com.vladium.jcd.cls.attribute.stackmap.VerificationTypeFactory;
import com.vladium.jcd.lib.UDataInputStream;
import com.vladium.jcd.lib.UDataOutputStream;
import java.io.IOException;
import java.util.List;

public class FullFrame
extends StackMapFrame_info {
    public FullFrame(UDataInputStream bytes) throws IOException {
        this.setFrameType(255);
        this.setOffsetDelta(bytes.readU2());
        int m_number_of_locals = bytes.readU2();
        for (int i = 0; i < m_number_of_locals; ++i) {
            this.getLocal().add(VerificationTypeFactory.getVerificationType(bytes));
        }
        int m_number_of_stack = bytes.readU2();
        for (int i = 0; i < m_number_of_stack; ++i) {
            this.getStack().add(VerificationTypeFactory.getVerificationType(bytes));
        }
    }

    public FullFrame(int offsetDelta, List v_locals, List v_stack) {
        this.setFrameType(255);
        this.setOffsetDelta(offsetDelta);
        this.getLocal().addAll(v_locals);
        this.getStack().addAll(v_stack);
    }

    public void writeInClassFormat(UDataOutputStream out) throws IOException {
        super.writeInClassFormat(out);
        out.writeU2(this.getOffsetDelta());
        out.writeU2(this.getLocal().size());
        this.verificationTypeWriting(this.getLocal(), out);
        out.writeU2(this.getStack().size());
        this.verificationTypeWriting(this.getStack(), out);
    }

    public int getLength() {
        return 7 + FullFrame.computeVerificationTypeLength(this.getLocal()) + FullFrame.computeVerificationTypeLength(this.getStack());
    }

    public String toString() {
        return "frame_type = " + this.getFrameType() + "/* full_frame */";
    }
}

