/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.widgets;

import com.mathworks.mwswing.FontUtils;
import com.mathworks.util.LanguageUtils;
import com.mathworks.util.PlatformInfo;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class GuiDefaults {
    private static final Font PLATFORM_FONT = GuiDefaults.determineDefaultFont();

    private GuiDefaults() {
    }

    public static Font getCoderFont() {
        return PLATFORM_FONT;
    }

    private static Font determineDefaultFont() {
        Font font = FontUtils.getSystemUIFont();
        int n = 12;
        if (LanguageUtils.isEnglish()) {
            if (PlatformInfo.isMacintosh()) {
                font = new Font("Lucida Grande", 0, n);
                n = 14;
            } else if (PlatformInfo.isWindows()) {
                // empty if block
            }
        }
        return font.deriveFont(n);
    }

    public static Icon createCloseIcon(int n) {
        return GuiDefaults.createCloseIcon(n, new Color(50, 50, 50));
    }

    public static Icon createCloseIcon(int n, Color color) {
        int n2 = n;
        int n3 = n;
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(color);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setStroke(new BasicStroke(1.4f));
        graphics2D.draw(new Line2D.Double(n2 / 2 - 3, n3 / 2 - 3, n2 / 2 + 3, n3 / 2 + 3));
        graphics2D.draw(new Line2D.Double(n2 / 2 + 3, n3 / 2 - 3, n2 / 2 - 3, n3 / 2 + 3));
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }
}

