/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.widgets;

import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJList;
import com.mathworks.toolbox.coder.widgets.CustomComboModelContext;
import com.mathworks.toolbox.coder.widgets.CustomComboRenderer;
import com.mathworks.util.Pair;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JList;

public final class CustomComboBox<T>
extends MJComboBox {
    private final CustomComboModelContext<T> fModelContext;
    private final JList fListDelegate;
    private Icon fIconPlaceholder;
    private boolean fLayingOut = false;

    public CustomComboBox(CustomComboModelContext<T> customComboModelContext) {
        this.fModelContext = this.createNullSafeContext(customComboModelContext);
        this.fListDelegate = new MJList();
        this.setIconAllowance(null);
        this.setRenderer(new CustomComboRenderer((JComboBox<?>)((Object)this), this.fModelContext));
    }

    public CustomComboBox(CustomComboModelContext<T> customComboModelContext, ComboBoxModel<T> comboBoxModel) {
        this(customComboModelContext);
        this.setModel(comboBoxModel);
    }

    public void setIconAllowance(Dimension dimension) {
        dimension = dimension != null ? new Dimension(dimension) : new Dimension(0, 0);
        this.fIconPlaceholder = CustomComboBox.createPlaceHolderIcon(dimension);
        this.revalidate();
        this.repaint();
    }

    private CustomComboModelContext<T> createNullSafeContext(final CustomComboModelContext customComboModelContext) {
        return new CustomComboModelContext(){

            @Override
            public String getName(Object object) {
                return this.nullSafeString(customComboModelContext.getName(object));
            }

            @Override
            public String getShortName(Object object) {
                return this.nullSafeString(customComboModelContext.getShortName(object));
            }

            @Override
            public Icon getIcon(Object object) {
                Icon icon = customComboModelContext.getIcon(object);
                return icon != null ? icon : CustomComboBox.this.fIconPlaceholder;
            }

            @Override
            public String getDescription(Object object) {
                return this.nullSafeString(customComboModelContext.getDescription(object));
            }

            private String nullSafeString(String string) {
                return string != null ? string : "";
            }
        };
    }

    public Dimension getExpandedPreferredSize() {
        return new Dimension(this.getItemSizeWithDescription().width, super.getPreferredSize().height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLayout() {
        try {
            this.fLayingOut = true;
            super.doLayout();
        }
        finally {
            this.fLayingOut = false;
        }
    }

    public Dimension getSize() {
        Dimension dimension = super.getSize();
        if (!this.fLayingOut) {
            dimension = new Dimension(this.getExpandedPreferredSize().width, dimension.height);
        }
        return dimension;
    }

    public Rectangle getBounds() {
        return new Rectangle(super.getBounds().getLocation(), this.getSize());
    }

    private Dimension getItemSizeWithDescription() {
        Pair<Object, Integer> pair = this.getWidestItem();
        Component component = ((CustomComboRenderer)this.getRenderer()).getListCellRendererComponent(this.fListDelegate, pair.getFirst(), (Integer)pair.getSecond(), true, this.hasFocus(), true);
        Dimension dimension = component.getPreferredSize();
        dimension.width = dimension.width + (PlatformInfo.isMacintosh() ? 32 : 20);
        dimension.height = this.getPreferredSize().height;
        return dimension;
    }

    private Pair<Object, Integer> getWidestItem() {
        int n = 0;
        int n2 = 0;
        Object object = null;
        for (int i = 0; i < this.getItemCount(); ++i) {
            Object object2 = this.getItemAt(i);
            int n3 = this.fModelContext.getName(object2).length() + this.fModelContext.getDescription(object2).length();
            if (object != null && n3 <= n2) continue;
            object = object2;
            n2 = n3;
            n = i;
        }
        return new Pair(object, (Object)n);
    }

    private static Icon createPlaceHolderIcon(final Dimension dimension) {
        return new Icon(){

            @Override
            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            }

            @Override
            public int getIconWidth() {
                return dimension.width;
            }

            @Override
            public int getIconHeight() {
                return dimension.height;
            }
        };
    }
}

