/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.toolbar;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.wfa.WorkflowAdvisor;
import com.mathworks.toolbox.coder.wfa.core.Step;
import com.mathworks.toolbox.coder.wfa.core.StepModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;

public final class OverviewButton
extends MJPanel {
    private final WorkflowAdvisor fAdvisor;
    private String fText;
    private int fTextWidth;
    private boolean fShowing;
    private boolean fEnabled;
    private Timer fHoverWatcher;
    private static final Font FONT = CoderApp.getFont().deriveFont(0, 22.0f);
    private static final int STEP_BAR_WIDTH = 8;

    public OverviewButton(WorkflowAdvisor workflowAdvisor) {
        this.fAdvisor = workflowAdvisor;
        this.setName("wfa.button.overview");
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (OverviewButton.this.fEnabled && mouseEvent.getY() < OverviewButton.this.getHeight() - 4) {
                    OverviewButton.this.setSelected(true);
                }
            }
        });
        workflowAdvisor.getApp().getModel().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == "generic-artifact") {
                    OverviewButton.this.fAdvisor.getSelectedView().updateSheetSize(OverviewButton.this.fAdvisor.getOverview().getComponent());
                }
            }
        });
    }

    public void setNavigationEnabled(boolean bl) {
        this.fEnabled = bl;
        this.setCursor(Cursor.getPredefinedCursor(bl ? 12 : 0));
    }

    public void setSelected(boolean bl) {
        if (bl && !this.fShowing && this.fAdvisor.getSelectedStep() != StepModel.OVERVIEW && !this.fAdvisor.showOverview()) {
            this.fAdvisor.getSelectedView().displaySheet((Component)this.fAdvisor.getOverview().getComponent(), 2, true, false, new Runnable(){

                @Override
                public void run() {
                    OverviewButton.this.setSelected(false);
                }
            });
            this.fShowing = true;
            this.startHoverWatcher();
        } else if (!bl && this.fShowing) {
            this.fAdvisor.getSelectedView().closeSheet(this.fAdvisor.getOverview().getComponent());
            this.fShowing = false;
            if (this.fHoverWatcher != null) {
                this.fHoverWatcher.stop();
                this.fHoverWatcher = null;
            }
        }
    }

    private void startHoverWatcher() {
        if (this.fHoverWatcher == null) {
            this.fHoverWatcher = new Timer(50, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Point point;
                    PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                    if (pointerInfo != null && (point = pointerInfo.getLocation()) != null) {
                        JComponent jComponent = OverviewButton.this.fAdvisor.getToolbar().getComponent();
                        SwingUtilities.convertPointFromScreen(point, jComponent);
                        if (jComponent.contains(point) && point.getX() < (double)(OverviewButton.this.getWidth() + 8)) {
                            return;
                        }
                        JComponent jComponent2 = OverviewButton.this.fAdvisor.getOverview().getComponent();
                        if (!jComponent2.contains(point = SwingUtilities.convertPoint(jComponent, point, jComponent2))) {
                            OverviewButton.this.setSelected(false);
                        }
                    }
                }
            });
            this.fHoverWatcher.setRepeats(true);
            this.fHoverWatcher.start();
        }
    }

    public void setText(String string) {
        this.fText = string;
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setFont(FONT);
        this.fTextWidth = (int)FONT.getStringBounds(this.fText, graphics2D.getFontRenderContext()).getWidth();
        graphics2D.dispose();
        this.revalidate();
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(new Color(0, 0, 0, 0));
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics2D.setColor(Color.WHITE);
        this.paintContent(graphics2D);
        graphics2D.dispose();
    }

    private void paintContent(Graphics2D graphics2D) {
        List<Step> list = this.fAdvisor.getModel().getSteps();
        Step step = this.fAdvisor.getSelectedStep();
        int n = 10 * list.size() - 1 - 2;
        for (int i = list.size() - 1; i >= 0; --i) {
            Area area;
            GeneralPath generalPath = this.getPiece(n, i == 0, 0);
            if (step == list.get(i)) {
                area = new Area(this.getPiece(n, i == 0, 1));
                if (i > 0) {
                    area.subtract(new Area(this.getPiece(n - 8, false, 0)));
                }
                graphics2D.fill(area);
            }
            area = new Area(generalPath);
            area.subtract(new Area(this.getPiece(n - 8, i - 1 == 0, 1)));
            if (step == list.get(i)) {
                graphics2D.setColor(Color.WHITE);
            } else {
                graphics2D.setColor(new Color(158, 184, 209));
            }
            graphics2D.fill(area);
            n -= 10;
        }
        n = 10 * list.size() + 12;
        graphics2D.setColor(Color.WHITE);
        graphics2D.setFont(FONT);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        graphics2D.drawString(this.fText, (float)n, (float)(this.getHeight() / 2 - (fontMetrics.getAscent() + fontMetrics.getDescent()) / 2 + fontMetrics.getAscent()));
    }

    private GeneralPath getPiece(int n, boolean bl, int n2) {
        GeneralPath generalPath = new GeneralPath();
        int n3 = bl ? n : n - 4;
        generalPath.append(new Line2D.Double(n3, 4.0, n + 4, 4.0), true);
        generalPath.append(new Line2D.Double(n + 4, 4.0, n + 8, this.getHeight() / 2), true);
        generalPath.append(new Line2D.Double(n + 8, this.getHeight() / 2, n + 4 + n2, this.getHeight() - 4), true);
        generalPath.append(new Line2D.Double(n + 4 + n2, this.getHeight() - 4, n3, this.getHeight() - 4), true);
        generalPath.append(new Line2D.Double(n3, this.getHeight() - 4, n3, 4.0), true);
        return generalPath;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.fTextWidth + 16 + this.fAdvisor.getModel().getSteps().size() * 10, 24);
    }
}

