/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.screener;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.FunctionScopedEntityLocator;
import com.mathworks.toolbox.coder.app.OutputPane;
import com.mathworks.toolbox.coder.app.ide.EditorView;
import com.mathworks.toolbox.coder.app.ide.FileSelectionEvent;
import com.mathworks.toolbox.coder.app.ide.IDEContext;
import com.mathworks.toolbox.coder.app.ide.IDEFileSidebar;
import com.mathworks.toolbox.coder.app.ide.IDELayout;
import com.mathworks.toolbox.coder.fixedpoint.CodePopupController;
import com.mathworks.toolbox.coder.model.BuildError;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.FunctionUtils;
import com.mathworks.toolbox.coder.model.UnifiedModel;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.screener.ScreenerReportModel;
import com.mathworks.toolbox.coder.util.LRUMap;
import com.mathworks.toolbox.coder.wfa.AbstractCoderStepView;
import com.mathworks.toolbox.coder.wfa.core.Step;
import com.mathworks.toolbox.coder.wfa.core.StepModel;
import com.mathworks.toolbox.coder.wfa.toolbar.SaveButton;
import com.mathworks.toolbox.coder.wfa.toolbar.ToolbarContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class ScreenerView
extends AbstractCoderStepView {
    private final List<Component> fToolbarComponents;
    private final ChangeListener fScreenerListener;
    private final Context fContext = new Context();
    private final UnifiedModel fStubModel;
    private final Map<File, List<Function>> funcsByFile;
    private boolean fActive;

    public ScreenerView(CoderApp coderApp, StepModel stepModel, Step step) {
        super(coderApp, stepModel, step);
        this.fContext.setVisibleFileSetKeys("input-files");
        this.fToolbarComponents = new ArrayList<Component>();
        this.fScreenerListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ScreenerView.this.updateForScreener();
            }
        };
        this.getApp().getModel().getScreenerModel().addChangeListener(this.fScreenerListener);
        this.updateTable();
        this.fToolbarComponents.add((Component)((Object)new SaveButton(coderApp)));
        this.fStubModel = new ScreenerUnifiedModel();
        this.funcsByFile = new HashMap<File, List<Function>>();
    }

    @Override
    public void activate(ToolbarContext toolbarContext, boolean bl) {
        toolbarContext.setStepComponents(this.fToolbarComponents);
        this.installIDEView(this.fContext);
        this.updateForScreener();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getApp().getModel().getScreenerModel().removeChangeListener(this.fScreenerListener);
    }

    @Override
    public boolean shouldStretch() {
        return true;
    }

    @Override
    protected String getHelpKey() {
        return "help_button_review_compatibility";
    }

    private void updateForScreener() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ScreenerReportModel screenerReportModel = ScreenerView.this.getApp().getModel().getScreenerModel().getReportModel();
                if (screenerReportModel == null) {
                    return;
                }
                ScreenerView.this.updateTable();
                ScreenerView.this.funcsByFile.clear();
                for (File file : screenerReportModel.getRootFiles()) {
                    LinkedList<Function> linkedList = (LinkedList<Function>)ScreenerView.this.funcsByFile.get(file);
                    if (linkedList == null) {
                        linkedList = new LinkedList<Function>();
                        ScreenerView.this.funcsByFile.put(file, linkedList);
                    }
                    Set<String> set = screenerReportModel.getFunctionsByImpact(file).keySet();
                    for (String string : set) {
                        linkedList.add(new Function(file, string));
                    }
                }
            }
        });
    }

    private void updateTable() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ScreenerReportModel screenerReportModel = ScreenerView.this.getApp().getModel().getScreenerModel().getReportModel();
                if (screenerReportModel != null) {
                    if (!ScreenerView.this.getApp().getModel().isSuppressScreenerUpdate()) {
                        ScreenerView.this.getApp().getModel().getActiveInputSourceSet().setFiles(screenerReportModel.getNonMathWorksFiles());
                    }
                    if (screenerReportModel.getErrors().isEmpty()) {
                        ScreenerView.this.getModel().setAutoSkip(ScreenerView.this.getStep(), true);
                        if (ScreenerView.this.fActive) {
                            MJLabel mJLabel = new MJLabel(CoderResources.getString("wfa.screener.empty"));
                            mJLabel.setFont(CoderApp.getFont().deriveFont(14.0f));
                            mJLabel.setForeground(new Color(100, 100, 100));
                            MJPanel mJPanel = new MJPanel((LayoutManager)new FormLayout("0dlu:grow, fill:d, 0dlu:grow", "0dlu:grow, fill:d, 0dlu:grow"));
                            CellConstraints cellConstraints = new CellConstraints();
                            mJPanel.add((Component)mJLabel, (Object)cellConstraints.xy(2, 2));
                            ScreenerView.this.fContext.showBanner((Component)mJPanel);
                            ScreenerView.this.getApp().getIDEView().getCodeInfoView().getEditorView().setBuildErrors(null, false);
                        }
                    } else {
                        ScreenerView.this.getModel().setAutoSkip(ScreenerView.this.getStep(), false);
                        if (ScreenerView.this.fActive) {
                            ScreenerView.this.fContext.clearBanner();
                            List<BuildError> list = screenerReportModel.getErrors();
                            ScreenerView.this.fContext.showErrors("screener", "screener-output", CoderResources.getString("wfa.tab.screener"), true, true, null, list);
                        }
                    }
                }
            }
        });
    }

    private static class ScreenerUnifiedModel
    extends UnifiedModel {
        private final Map<File, Function> fEntryPoints = new LRUMap<File, Function>(new LRUMap.LRUPredicate<File, Function>(){

            @Override
            public boolean evictEldestEntry(Map.Entry<File, Function> entry, Map<File, Function> map) {
                return true;
            }
        });

        private ScreenerUnifiedModel() {
        }

        @Override
        public Function getEntryPointFunction(File file) {
            Function function = this.fEntryPoints.get(file);
            if (function == null && file != null) {
                function = new Function(file, FunctionUtils.getFunctionName(file));
                this.fEntryPoints.put(file, function);
            }
            return function;
        }
    }

    private class Context
    extends IDEContext {
        private Context() {
        }

        @Override
        public void activate(IDEFileSidebar iDEFileSidebar, IDELayout iDELayout, OutputPane outputPane, EditorView editorView) {
            ScreenerView.this.fActive = true;
            iDEFileSidebar.setCurrentUnifiedModel(ScreenerView.this.fStubModel);
            super.activate(iDEFileSidebar, iDELayout, outputPane, editorView);
            iDEFileSidebar.toggleInputFlatViewState(false);
            this.setLocator(new FunctionScopedEntityLocator(null, null, ScreenerView.this.fStubModel));
            if (ScreenerView.this.getApp().getModel().getEntryPoint() != null) {
                this.select(new FileSelectionEvent(null, ScreenerView.this.getApp().getModel().getEntryPoint()));
            }
        }

        @Override
        public void deactivate() {
            ScreenerView.this.fActive = false;
            this.getSidebar().setCurrentUnifiedModel(null);
        }

        @Override
        public CodePopupController createCodePopupController(Window window, EditorView editorView) {
            return null;
        }
    }
}

